/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class ReplaceNote
extends AbstractNote
implements IObjectsBufferNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 10;
    byte[] m_scratchBuffer = new byte[8];
    long m_dbkey;
    boolean m_noUndoData;
    boolean m_lead;
    boolean m_last;
    int m_classType;
    long m_totalObjectLength;
    byte[] m_oldValue;
    int m_oldOffset;
    short m_oldLength;
    byte[] m_newValue;
    int m_newOffset;
    short m_newLength;

    ReplaceNote() {
    }

    public String toString() {
        return this.getClass().getName() + " dbk " + this.m_dbkey + " lead " + this.m_lead;
    }

    @Override
    public long getDbkey() {
        return this.m_dbkey;
    }

    @Override
    public long getPageNum() {
        return Dbkey.getPageNumber(this.m_dbkey);
    }

    @Override
    public byte getSlotNum() {
        return Dbkey.getSlot(this.m_dbkey);
    }

    long getObjectOldLength() {
        if (!this.m_lead) {
            throw new Error("Only the leading fragment can return the object's length.");
        }
        if (this.m_lead && !this.m_last) {
            return this.m_totalObjectLength;
        }
        return this.m_oldLength;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)10);
        writer.write((byte)(this.m_noUndoData ? 1 : 0));
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_dbkey);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putShort(this.m_scratchBuffer, 0, this.m_oldLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        if (!this.m_noUndoData) {
            writer.write(this.m_oldValue, this.m_oldOffset, this.m_oldLength);
        }
        writer.write((byte)(this.m_lead ? 1 : 0));
        writer.write((byte)(this.m_last ? 1 : 0));
        int noteLength = 14 + (this.m_noUndoData ? (short)0 : this.m_oldLength);
        BitUtil.putShort(this.m_scratchBuffer, 0, this.m_newLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        noteLength += 2;
        writer.write(this.m_newValue, this.m_newOffset, this.m_newLength);
        noteLength += this.m_newLength;
        if (this.m_lead) {
            BitUtil.putInt(this.m_scratchBuffer, 0, this.m_classType);
            writer.write(this.m_scratchBuffer, 0, 4);
            noteLength += 4;
        }
        if (this.m_lead && !this.m_last) {
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_totalObjectLength);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
        }
        return noteLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_noUndoData = buffer[currentOffset++] == 1;
        this.m_dbkey = BitUtil.getLong(buffer, currentOffset);
        this.m_oldLength = BitUtil.getShort(buffer, currentOffset += 8);
        this.m_oldValue = buffer;
        this.m_oldOffset = currentOffset += 2;
        if (!this.m_noUndoData) {
            currentOffset += this.m_oldLength;
        }
        this.m_lead = buffer[currentOffset++] == 1;
        this.m_last = buffer[currentOffset++] == 1;
        this.m_newLength = BitUtil.getShort(buffer, currentOffset);
        this.m_newValue = buffer;
        this.m_newOffset = currentOffset += 2;
        currentOffset += this.m_newLength;
        if (this.m_lead) {
            this.m_classType = BitUtil.getInt(buffer, currentOffset);
            currentOffset += 4;
        }
        if (this.m_lead && !this.m_last) {
            this.m_totalObjectLength = BitUtil.getLong(buffer, currentOffset);
            currentOffset += 8;
        }
    }

    void initNote(long dbkey, boolean lead, boolean last, int classType, long totalObjectLength, byte[] oldValue, int oldOffset, short oldLength, byte[] newValue, int newOffset, short newLength) {
        this.m_dbkey = dbkey;
        this.m_lead = lead;
        this.m_last = last;
        this.m_classType = classType;
        this.m_totalObjectLength = totalObjectLength;
        this.m_oldValue = oldValue;
        this.m_oldOffset = oldOffset;
        this.m_oldLength = oldLength;
        this.m_newValue = newValue;
        this.m_newOffset = newOffset;
        this.m_newLength = newLength;
        this.m_noUndoData = this.m_oldValue == null;
    }
}

