/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.IObjectInfo;
import com.sonicsw.mtstorage.impl.DeleteAction;
import com.sonicsw.mtstorage.impl.IAction;
import com.sonicsw.mtstorage.impl.ObjectInfo;
import com.sonicsw.mtstorage.impl.Storage;
import java.io.IOException;

final class UpdateAction
implements IAction {
    private long m_dbkey;
    boolean m_noData;
    private byte[] m_modifiedData;
    private long m_dataLength;
    private int m_classType;
    private long m_transID;

    UpdateAction() {
    }

    @Override
    public long getTransactionID() {
        return this.m_transID;
    }

    @Override
    public IObjectInfo getObject(byte[] destination, int offset) {
        System.arraycopy(this.m_modifiedData, 0, destination, offset, (int)this.m_dataLength);
        return new ObjectInfo(this.m_classType, (int)this.m_dataLength);
    }

    @Override
    public IObjectInfo getObjectInfo() {
        return new ObjectInfo(this.m_classType, (int)this.m_dataLength);
    }

    long getDbkey() {
        return this.m_dbkey;
    }

    byte[] getModifiedData() {
        if (this.m_noData) {
            throw new Error("The data is not available since this action replaced uninitialized data");
        }
        return this.m_modifiedData;
    }

    long getDataLength() {
        return this.m_dataLength;
    }

    boolean noData() {
        return this.m_noData;
    }

    void init(long transID, long dbkey, boolean noData, int classType, byte[] modifiedData, long dataLength) {
        this.m_transID = transID;
        this.m_dbkey = dbkey;
        this.m_noData = noData;
        this.m_classType = classType;
        this.m_modifiedData = modifiedData;
        this.m_dataLength = dataLength;
    }

    void init(long transID, DeleteAction deleteAction) {
        this.m_transID = transID;
        this.m_dbkey = deleteAction.getDbkey();
        this.m_noData = false;
        this.m_classType = deleteAction.getClassType();
        this.m_modifiedData = deleteAction.getDeletedData();
        this.m_dataLength = deleteAction.getDataLength();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_dbkey + " length: " + this.m_dataLength + " class type: " + this.m_classType + " no data: " + this.m_noData;
    }

    @Override
    public void undoAction(Storage storage) throws IOException {
        if (!this.m_noData) {
            storage.update(new Long(this.m_transID), this.m_dbkey, this.m_modifiedData, 0, (int)this.m_dataLength);
        }
    }
}

