/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.replication.AbstractCommunicationManager;
import com.sonicsw.mtstorage.replication.IReplicatedStorage;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import com.sonicsw.mtstorage.replication.StateManager;
import com.sonicsw.mtstorage.replication.util.BitUtil;
import com.sonicsw.mtstorage.replication.util.Tracer;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IDiagnosticsHistoryTracker;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.HashMap;

final class StandbyStorageManager {
    private StateManager m_stateManager;
    private AbstractCommunicationManager m_commManager;
    private IReplicatedStorage m_standbyStorage;
    private long m_pendingRequestID;
    private DataHandler m_dataHandler;
    private IDiagnosticsContext m_diagnosticsContext;
    private IDiagnosticsHistoryTracker m_requestHistory;
    private IDiagnosticsHistoryTracker m_responseHistory;

    StandbyStorageManager(IDiagnosticsContext diagnosticsContext) {
        this.m_diagnosticsContext = diagnosticsContext;
        this.m_dataHandler = new DataHandler();
    }

    synchronized void open(String dbName, HashMap storageParameters, StateManager stateManager, AbstractCommunicationManager commManager) throws IOException {
        Tracer.TRACE("StandbyStorageManager try to open storage: " + dbName + " ...");
        this.m_requestHistory = this.m_diagnosticsContext.createHistoryTrackerObject("StandbyStorageManager Request History", (Object[])ReplicationManager.SDFRequestTracker.getCache());
        this.m_responseHistory = this.m_diagnosticsContext.createHistoryTrackerObject("StandbyStorageManager Response History", (Object[])ReplicationManager.SDFResponseTracker.getCache());
        this.m_stateManager = stateManager;
        Storage storage = new Storage();
        storage.open(dbName, storageParameters, true, stateManager.inDeepSyncState(), stateManager.getPeerDbTimestamp());
        this.m_standbyStorage = storage;
        this.m_commManager = commManager;
        this.m_dataHandler.openned();
        Tracer.TRACE("StandbyStorageManager Open storage: " + dbName + " done");
    }

    synchronized void close() throws IOException {
        this.m_dataHandler.close();
        try {
            if (this.m_standbyStorage != null) {
                this.m_standbyStorage.close();
            }
        }
        catch (Throwable t) {
            Tracer.TRACE(t);
        }
        this.m_standbyStorage = null;
    }

    private void setStandbyState(ReplicationManager.ReplicationDataIndicator indicator) {
        int newState = 4;
        if (!indicator.m_logData || indicator.m_deepSyncLogData) {
            newState = 517;
        } else if (indicator.m_dirtyFlag) {
            newState = 5;
        }
        this.m_stateManager.setStandbyState((short)newState);
    }

    void sendInitialRequest() throws IOException {
        Tracer.TRACE("StandbyStorageManager.sendInitialRequest");
        boolean deepSync = this.m_standbyStorage.requiresDeepSync();
        HashMap request = this.createRequest(!deepSync, deepSync ? 0L : this.m_standbyStorage.getLogEndID(), -1L, -1L);
        this.sendRequest(request);
    }

    void setData(HashMap dataMap, byte[] buffer, int dataOffset, int dataLength) {
        this.m_dataHandler.setData(dataMap, buffer, dataOffset, dataLength);
    }

    void handleData(HashMap dataMap, byte[] buffer, int dataOffset, int dataLength) throws IOException {
        long dataID;
        ReplicationManager.SDFResponseTracker responseTracker = (ReplicationManager.SDFResponseTracker)this.m_responseHistory.getHistoryItem();
        responseTracker.setResponse(dataMap, 0, null, this.m_pendingRequestID, null);
        ReplicationManager.ReplicationDataIndicator indicator = new ReplicationManager.ReplicationDataIndicator(dataMap);
        if (indicator.m_requestID != this.m_pendingRequestID) {
            return;
        }
        this.m_standbyStorage.applyLogOrPage(indicator, buffer, dataOffset, dataLength);
        this.setStandbyState(indicator);
        if (indicator.m_logData) {
            dataID = indicator.m_dataID + (long)dataLength;
        } else {
            short numPages = BitUtil.getShort(buffer, dataOffset);
            dataID = indicator.m_dataID + (long)numPages;
        }
        this.sendRequest(this.createRequest(indicator.m_logData, dataID, indicator.m_deepSyncOldestNeededNote, indicator.m_deepSyncLastNoteWrittenAfterPageReplication));
    }

    private HashMap createRequest(boolean logData, long dataID, long deepSyncOldestNeededNote, long deepSyncLastNoteWrittenAfterPageReplication) {
        HashMap<String, Constable> request = new HashMap<String, Constable>();
        this.m_pendingRequestID = System.currentTimeMillis();
        request.put("REQUEST_ID", new Long(this.m_pendingRequestID));
        request.put("REQUEST_LOG_DATA", new Boolean(logData));
        request.put("REQUEST_DATAID", new Long(dataID));
        request.put("REQUEST_DEEPSYNC_OLDEST_NEEDED_NOTE", new Long(deepSyncOldestNeededNote));
        request.put("REQUEST_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION", new Long(deepSyncLastNoteWrittenAfterPageReplication));
        return request;
    }

    private void sendRequest(HashMap request) {
        try {
            this.m_commManager.sendReplicationMessage(request);
            ReplicationManager.SDFRequestTracker requestTracker = (ReplicationManager.SDFRequestTracker)this.m_requestHistory.getHistoryItem();
            requestTracker.setRequest(request, Boolean.TRUE, null);
        }
        catch (IOException e) {
            ReplicationManager.SDFRequestTracker requestTracker = (ReplicationManager.SDFRequestTracker)this.m_requestHistory.getHistoryItem();
            requestTracker.setRequest(request, Boolean.FALSE, e.toString());
            Tracer.TRACE(e);
        }
    }

    void printState(StringBuffer buffer) {
        this.m_requestHistory.appendHistory(buffer);
        this.m_responseHistory.appendHistory(buffer);
    }

    private class DataHandler
    extends Thread {
        HashMap m_dataMap;
        byte[] m_data;
        int m_offset;
        int m_length;
        boolean m_closing;
        boolean m_closed;
        boolean m_open;

        DataHandler() {
            super("StandbyStorageManager.DataHandler Thread");
            this.m_dataMap = null;
            this.m_closing = false;
            this.m_closed = false;
            this.m_open = false;
            this.setDaemon(true);
            this.start();
        }

        synchronized void openned() {
            this.m_open = true;
            this.notifyAll();
        }

        synchronized void setData(HashMap dataMap, byte[] data, int offset, int length) {
            this.m_dataMap = dataMap;
            this.m_data = data;
            this.m_offset = offset;
            this.m_length = length;
            this.notifyAll();
        }

        private synchronized void resetData() {
            this.m_dataMap = null;
            this.m_data = null;
        }

        private synchronized void waitForData() {
            while (this.m_dataMap == null && !this.m_closing || !this.m_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Tracer.TRACE(e);
                }
            }
        }

        private synchronized void close() {
            this.m_closing = true;
            this.notifyAll();
            while (!this.m_closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Tracer.TRACE(e);
                }
            }
        }

        private synchronized void closed() {
            this.m_closed = true;
            this.notifyAll();
        }

        @Override
        public void run() {
            while (!this.m_closing) {
                this.waitForData();
                if (this.m_closing) break;
                try {
                    HashMap dataMap = this.m_dataMap;
                    byte[] data = this.m_data;
                    this.resetData();
                    StandbyStorageManager.this.handleData(dataMap, data, this.m_offset, this.m_length);
                }
                catch (Exception e) {
                    Tracer.TRACE(e);
                    if (this.m_closing) continue;
                    StandbyStorageManager.this.m_stateManager.shutdownState(e);
                }
                catch (Throwable t) {
                    Tracer.TRACE(t);
                    if (this.m_closing) continue;
                    StandbyStorageManager.this.m_stateManager.shutdownState(new Exception(t.toString()));
                }
            }
            this.closed();
        }
    }
}

