/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Tracer {
    private static SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat();
    private static boolean VERBOSE_TRACE;
    private static boolean TRACE;
    private static final boolean PROP_TRACE;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String NEWLINE;

    public static void setTrace(boolean trace, boolean verbose_trace) {
        if (PROP_TRACE) {
            return;
        }
        TRACE = trace;
        VERBOSE_TRACE = verbose_trace;
    }

    public static void VERBOSE_TRACE(String message) {
        if (VERBOSE_TRACE) {
            System.out.println(Tracer.createLogMessage(message));
        }
    }

    public static void TRACE(String message) {
        if (TRACE) {
            System.out.println(Tracer.createLogMessage(message));
        }
    }

    public static void TRACE(Exception e) {
        if (VERBOSE_TRACE) {
            System.out.println(Tracer.createLogMessage(Tracer.stackToString(e, "")));
        }
    }

    public static void TRACE(Throwable t) {
        if (VERBOSE_TRACE) {
            System.out.println(Tracer.createLogMessage(Tracer.stackToString(t, "")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createLogMessage(String message) {
        StringBuffer timestampedMessage = new StringBuffer();
        timestampedMessage.append('[');
        SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            timestampedMessage.append(SIMPLE_DATE_FORMAT.format(new Date(System.currentTimeMillis())));
        }
        timestampedMessage.append("]");
        timestampedMessage.append(" Replicated Storage: ");
        timestampedMessage.append(" (TRACE) ");
        timestampedMessage.append(message);
        return timestampedMessage.toString();
    }

    private static String stackToString(Throwable exception, String message) {
        StringBuffer buffer = null;
        if (message != null && message.length() > 0) {
            buffer = new StringBuffer(message);
            buffer.append(NEWLINE);
        } else {
            buffer = new StringBuffer();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        exception.printStackTrace(writer);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        buffer.append(new String(data));
        return buffer.toString();
    }

    static {
        SIMPLE_DATE_FORMAT.applyPattern("yy/MM/dd HH:mm:ss");
        VERBOSE_TRACE = System.getProperty("_TEST_pse_replication_verbose_trace") != null;
        TRACE = System.getProperty("_TEST_pse_replication_trace") != null;
        PROP_TRACE = VERBOSE_TRACE || TRACE;
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        NEWLINE = System.getProperty("line.separator");
        if (VERBOSE_TRACE) {
            TRACE = true;
        }
    }
}

