/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassControl;
import com.odi.filter.FieldMap;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.TypeSummaryBuilder;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.util.ClassFileSource;
import com.odi.filter.util.ClassPath;
import com.odi.filter.util.FilePath;
import com.odi.filter.util.ZipFileRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OSCFP {
    private FilterEnv filterEnv = new FilterEnv();

    public int filter(String[] argv) {
        argv = this.preprocess(argv);
        Vector<String> ccNames = new Vector<String>();
        Vector<String> pcNames = new Vector<String>();
        Vector<String> paNames = new Vector<String>();
        int classMode = 1;
        String classpath = System.getProperty("java.class.path");
        String sysClasspath = System.getProperty("sun.boot.class.path", "");
        for (int i = 0; i < argv.length; ++i) {
            String summaryName;
            String fullFieldName;
            String arg = argv[i];
            if (arg.equals("-cc") || arg.equals("-copyclass")) {
                classMode = 0;
                continue;
            }
            if (arg.equals("-pa") || arg.equals("-persistaware")) {
                classMode = 2;
                continue;
            }
            if (arg.equals("-pc") || arg.equals("-persistcapable")) {
                classMode = 1;
                continue;
            }
            if (arg.equals("-v") || arg.equals("-verbose")) {
                this.filterEnv.setVerbose(true);
                this.filterEnv.setQuiet(false);
                continue;
            }
            if (arg.equals("-q") || arg.equals("-quiet")) {
                this.filterEnv.setQuiet(true);
                this.filterEnv.setVerbose(false);
                continue;
            }
            if (arg.equals("-f") || arg.equals("-force")) {
                this.filterEnv.setForceOverwrite(true);
                continue;
            }
            if (arg.equals("-inplace")) {
                this.filterEnv.setUpdateInPlace(true);
                continue;
            }
            if (arg.equals("-ndhc") || arg.equals("-nodefaulthashcode")) {
                this.filterEnv.setAddDefaultHashCode(false);
                continue;
            }
            if (arg.equals("-qf") || arg.equals("-quietfield")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -quietfield option");
                    continue;
                }
                if ((fullFieldName = argv[++i]).indexOf(46) == -1) {
                    this.filterEnv.error("Field name specifications must include a fully qualified class name.  " + fullFieldName + " does not include one.");
                    continue;
                }
                this.filterEnv.suppressFieldWarnings(fullFieldName);
                continue;
            }
            if (arg.equals("-qc") || arg.equals("-quietclass")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -quietclass option");
                    continue;
                }
                this.filterEnv.suppressClassWarnings(argv[++i]);
                continue;
            }
            if (arg.equals("-index") || arg.equals("-indexablefield")) {
                if ((fullFieldName = this.getFieldArgument(argv, i++)) == null) continue;
                this.filterEnv.makeFieldIndexable(fullFieldName);
                continue;
            }
            if (arg.equals("-it") || arg.equals("-ignoretransient")) {
                if ((fullFieldName = this.getFieldArgument(argv, i++)) == null) continue;
                this.filterEnv.addIgnoreTransientField(fullFieldName);
                continue;
            }
            if (arg.equals("-tf") || arg.equals("-transientfield")) {
                if ((fullFieldName = this.getFieldArgument(argv, i++)) == null) continue;
                this.filterEnv.addTransientField(fullFieldName);
                continue;
            }
            if (arg.equals("-natf") || arg.equals("-noannotatetransientfields")) {
                this.filterEnv.setAnnotateTransientFields(false);
                continue;
            }
            if (arg.equals("-emlf") || arg.equals("-embeddedmaxlengthfield")) {
                int maxSize;
                if ((fullFieldName = this.getFieldArgument(argv, i++)) == null) continue;
                if ((maxSize = this.getIntArgument(argv, i++, arg)) <= 0 || maxSize > Short.MAX_VALUE) {
                    this.filterEnv.error("Illegal size argument:" + maxSize + " The size must be in the range 0.." + Short.MAX_VALUE);
                }
                this.filterEnv.addEmbeddedField(fullFieldName, maxSize);
                continue;
            }
            if (arg.equals("-naf") || arg.equals("-noannotatefield")) {
                if ((fullFieldName = this.getFieldArgument(argv, i++)) == null) continue;
                this.filterEnv.addNoAnnotateField(fullFieldName);
                continue;
            }
            if (arg.equals("-af") || arg.equals("-annotatefield")) {
                if ((fullFieldName = this.getFieldArgument(argv, i++)) == null) continue;
                this.filterEnv.addAnnotateField(fullFieldName);
                continue;
            }
            if (arg.equals("-hashcode")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -hashcode option");
                    continue;
                }
                this.filterEnv.addHashCode(argv[++i]);
                continue;
            }
            if (arg.equals("-optimizeclassinfo") || arg.equals("-oci")) {
                this.filterEnv.setOptimizeClassInfo(true);
                continue;
            }
            if (arg.equals("-nooptimizeclassinfo") || arg.equals("-noci")) {
                this.filterEnv.setOptimizeClassInfo(false);
                continue;
            }
            if (arg.equals("-summary")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -summary option");
                    continue;
                }
                summaryName = argv[++i];
                this.filterEnv.setSummary(ClassControl.vmClassFromUserClass(summaryName));
                continue;
            }
            if (arg.equals("-includesummary")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -includesummary option");
                    continue;
                }
                summaryName = argv[++i];
                this.filterEnv.addIncludedSummary(ClassControl.vmClassFromUserClass(summaryName));
                continue;
            }
            if (arg.equals("-nowrite")) {
                this.filterEnv.setNoWrite(true);
                continue;
            }
            if (arg.equals("-modifyjava")) {
                this.filterEnv.setModifyJavaClasses(true);
                continue;
            }
            if (arg.equals("-modifyfinals")) {
                this.filterEnv.setAllowFinalModifications(true);
                continue;
            }
            if (arg.equals("-noarrayopt")) {
                this.filterEnv.setNoArrayOptimization(true);
                continue;
            }
            if (arg.equals("-nothisopt")) {
                this.filterEnv.setNoThisOptimization(true);
                continue;
            }
            if (arg.equals("-noinitializeropt")) {
                this.filterEnv.setNoInitializerOptimization(true);
                continue;
            }
            if (arg.equals("-noopt")) {
                this.filterEnv.setNoOptimization(true);
                continue;
            }
            if (arg.equals("-jdk12cc") || arg.equals("-jdk12compilercompatibility")) {
                this.filterEnv.setJDK12CompilerCompatibility(true);
                continue;
            }
            if (arg.equals("-d") || arg.equals("-dest")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -dest option");
                }
                this.filterEnv.setDestinationDirectory(argv[++i]);
                continue;
            }
            if (arg.equals("-classpath") || arg.equals("-cpath")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -classpath option");
                }
                classpath = argv[++i];
                continue;
            }
            if (arg.equals("-sysclasspath") || arg.equals("-syscpath")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -sysclasspath option");
                }
                sysClasspath = argv[++i];
                continue;
            }
            if (arg.equals("-tp") || arg.equals("-translatepackage")) {
                if (argv.length - i < 3) {
                    this.usage();
                    this.filterEnv.error("Missing arguments to the -translatepackage option");
                }
                this.filterEnv.setPackageTranslation(argv[i + 1], argv[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("-classinfosuffix") || arg.equals("-cis")) {
                if (argv.length - i < 2) {
                    this.usage();
                    this.filterEnv.error("Missing argument to the -classinfosuffix option");
                }
                this.filterEnv.setClassInfoSuffix(argv[++i]);
                continue;
            }
            if (arg.length() > 0 && arg.charAt(0) == '-') {
                this.usage();
                this.filterEnv.error("Unrecognized option:" + arg);
                continue;
            }
            if (arg.length() == 0) {
                this.filterEnv.warning("Empty file name encountered on the command line.");
                continue;
            }
            if (arg.equals("java.lang.Object")) {
                this.filterEnv.error("java.lang.Object may not be postprocessed");
                continue;
            }
            if (classMode == 1) {
                pcNames.addElement(arg);
                continue;
            }
            if (classMode == 2) {
                paNames.addElement(arg);
                continue;
            }
            if (classMode == 0) {
                ccNames.addElement(arg);
                continue;
            }
            throw new FilterError("invalid class mode");
        }
        if (this.filterEnv.errorCount() > 0) {
            return 1;
        }
        this.filterEnv.setClassPath(classpath + File.pathSeparator + sysClasspath);
        if (this.filterEnv.destinationDirectory == null) {
            this.usage();
            if (argv.length > 0) {
                this.filterEnv.error("No -dest output directory was specified");
            }
            return 1;
        }
        if (this.filterEnv.updateInPlace() && this.filterEnv.translations.size() > 0) {
            this.filterEnv.error("The -translatepackage option cannot be used in conjunction with the -inplace option.");
            return 1;
        }
        if (this.filterEnv.getSummary() == null && this.filterEnv.getIncludedSummaries().size() > 0) {
            this.filterEnv.error("You must specify a -summary option if you specify any  -includesummary options");
            return 1;
        }
        if (!this.checkTransientOverrides()) {
            return 1;
        }
        if (this.filterEnv.updateInPlace()) {
            this.filterEnv.moveDestinationDirectoryToEnd();
        } else {
            this.filterEnv.excludeDestinationDirectory();
        }
        this.computeClasses(pcNames, paNames, ccNames, this.filterEnv);
        this.checkSummaryClasses();
        if (this.filterEnv.errorCount() > 0) {
            return 1;
        }
        this.modifyClasses();
        if (this.filterEnv.errorCount() > 0) {
            return 1;
        }
        this.checkIndexableFields();
        this.checkEmbeddableFields();
        if (this.filterEnv.writeClasses()) {
            this.writeClasses();
        }
        return 0;
    }

    public static void main(String[] argv) {
        try {
            System.exit(new OSCFP().filter(argv));
        }
        catch (Throwable tt) {
            System.out.println("Exception occurred while postprocessing:");
            tt.printStackTrace(System.out);
            System.exit(1);
        }
    }

    private String getFieldArgument(String[] argv, int index) {
        String fullFieldName;
        if (argv.length - index < 2) {
            this.usage();
            this.filterEnv.error("Missing argument to the " + argv[index] + " option");
        } else if ((fullFieldName = argv[++index]).indexOf(46) == -1) {
            this.filterEnv.error("Field name specifications must include a fully qualified class name.  " + fullFieldName + " does not include one.");
        } else {
            return fullFieldName;
        }
        return null;
    }

    private int getIntArgument(String[] argv, int index, String option) {
        if (argv.length - index < 2) {
            this.usage();
            this.filterEnv.error("Missing argument to the " + argv[index] + " option");
        } else {
            try {
                return Integer.parseInt(argv[++index]);
            }
            catch (NumberFormatException e) {
                this.filterEnv.error("Argument to the " + argv[index] + " option must be an integer");
            }
        }
        return 0;
    }

    private String[] preprocess(String[] args) {
        Vector<String> argVec = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() > 0 && args[i].charAt(0) == '@') {
                String filename = null;
                if (args[i].length() == 1) {
                    if (i + 1 < args.length) {
                        filename = args[++i];
                    }
                } else {
                    filename = args[i].substring(1);
                }
                if (filename == null) {
                    this.filterEnv.error("missing file name argument to @.");
                    continue;
                }
                this.appendFileContents(filename, argVec);
                continue;
            }
            argVec.addElement(args[i]);
        }
        Object[] newArgs = new String[argVec.size()];
        argVec.copyInto(newArgs);
        return newArgs;
    }

    private void appendFileContents(String filename, Vector argVec) {
        try {
            FileReader inputFile = new FileReader(filename);
            try {
                BufferedReader input = new BufferedReader(inputFile);
                String s = null;
                block4: while ((s = input.readLine()) != null) {
                    StringTokenizer parser = new StringTokenizer(s, " \t", false);
                    while (parser.hasMoreElements()) {
                        String token = parser.nextToken();
                        if (token.length() > 0 && token.charAt(0) == '@') {
                            this.filterEnv.error("The included file \"" + filename + "\" contains a recursive include.  " + "Recursive includes are not supported.");
                        }
                        if (token.charAt(0) == '#') continue block4;
                        argVec.addElement(token);
                    }
                }
            }
            catch (IOException e) {
                this.filterEnv.error("IO exception reading file " + filename + ".", e);
            }
        }
        catch (FileNotFoundException e) {
            this.filterEnv.error("file " + filename + " not found.", e);
        }
    }

    private boolean checkTransientOverrides() {
        int errors = 0;
        FieldMap.Enumerator e = this.filterEnv.ignoreTransientFields.entries();
        while (e.hasMoreElements()) {
            String fieldName;
            String className = e.className();
            if (this.filterEnv.isAddedTransientField(className, fieldName = e.fieldName())) {
                this.filterEnv.error("Field " + e.userFieldName() + " was specified as both -ignoretransientfield" + " and -transientfield.");
                ++errors;
            }
            e.nextField();
        }
        return errors == 0;
    }

    private void checkSummaryClasses() {
        ClassControl genCC;
        String genSum = this.filterEnv.getSummary();
        Vector incSums = this.filterEnv.getIncludedSummaries();
        if (genSum != null && (genCC = this.filterEnv.findClass(genSum)) != null && !genCC.inherits("com/odi/PersistentTypeSummary", this.filterEnv)) {
            this.filterEnv.error("The summary class to be generated (" + ClassControl.userClassFromVMClass(genSum) + ") already exists and does not extend " + "com.odi.PersistentTypeSummary.");
        }
        Enumeration e = incSums.elements();
        while (e.hasMoreElements()) {
            String incSum = (String)e.nextElement();
            ClassControl incSumCC = this.filterEnv.findClass(incSum);
            if (incSumCC == null) {
                this.filterEnv.error("The included summary class " + ClassControl.userClassFromVMClass(incSum) + " was not found.");
                continue;
            }
            if (incSumCC.inherits("com/odi/PersistentTypeSummary", this.filterEnv)) continue;
            this.filterEnv.error("The included summary class " + ClassControl.userClassFromVMClass(incSum) + " does not extend com.odi.PersistentTypeSummary.");
        }
    }

    private void computeClasses(Vector pcNames, Vector paNames, Vector ccNames, FilterEnv filterEnv) {
        this.computeClasses(pcNames, 1, filterEnv);
        this.computeClasses(paNames, 2, filterEnv);
        this.computeClasses(ccNames, 0, filterEnv);
        this.augmentClasses();
    }

    private void computeClasses(Vector names, int persistMode, FilterEnv filterEnv) {
        Enumeration e = names.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            int nameLen = name.length();
            if (nameLen > 6 && name.regionMatches(true, nameLen - 6, ".class", 0, 6)) {
                this.getClassFile(name, persistMode, filterEnv);
                continue;
            }
            if (nameLen > 4 && (name.regionMatches(true, nameLen - 4, ".zip", 0, 4) || name.regionMatches(true, nameLen - 4, ".jar", 0, 4))) {
                this.getZipFile(name, persistMode, filterEnv);
                continue;
            }
            this.getClassInPath(name, persistMode);
        }
    }

    private void getClassFile(String classFileName, int persistMode, FilterEnv filterEnv) {
        File f = new File(classFileName);
        if (!f.isFile()) {
            filterEnv.error(classFileName + " is not a file.");
        } else {
            ClassFileSource source = new ClassFileSource(null, f);
            try {
                ClassControl control = new ClassControl(source, filterEnv);
                control.setInitialPersistType(persistMode);
                control.setExplicitlyNamed(true);
                this.addClass(control);
            }
            catch (ClassFormatError e) {
                filterEnv.error(classFileName + " is not a valid class file.  " + e.getMessage(), e);
            }
        }
    }

    private void getZipFile(String zipFileName, int persistMode, FilterEnv filterEnv) {
        File f = new File(zipFileName);
        if (!f.isFile()) {
            filterEnv.error(zipFileName + " is not a file.");
        } else {
            try {
                ZipFile zf = ZipFileRegistry.openZipFile(f);
                Enumeration<? extends ZipEntry> zfe = zf.entries();
                while (zfe.hasMoreElements()) {
                    ZipEntry ze = zfe.nextElement();
                    String mName = ze.getName();
                    String vmClassName = ClassPath.classNameOf(mName);
                    if (vmClassName == null) continue;
                    ClassFileSource source = new ClassFileSource(vmClassName, zf);
                    try {
                        ClassControl control = new ClassControl(source, filterEnv);
                        control.setInitialPersistType(persistMode);
                        control.setExplicitlyNamed(true);
                        this.addClass(control);
                    }
                    catch (ClassFormatError e) {
                        filterEnv.error(mName + " within " + zipFileName + " is not a valid class file.", e);
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                filterEnv.error("File not found:" + zipFileName, fnfe);
            }
            catch (IOException ioe) {
                filterEnv.error("IO error occurred while reading " + zipFileName, ioe);
            }
        }
    }

    private void getClassInPath(String className, int persistMode) {
        String vmClassName = ClassControl.vmClassFromUserClass(className);
        ClassControl control = this.filterEnv.lookupClass(vmClassName);
        if (control == null) {
            this.filterEnv.error("The class " + className + " was not found.");
        } else {
            control.setInitialPersistType(persistMode);
            control.setExplicitlyNamed(true);
            this.addClass(control);
        }
    }

    private void addClass(ClassControl control) {
        String className = control.className();
        ClassControl existControl = (ClassControl)this.filterEnv.classMap.get(className);
        if (existControl != null) {
            if (!existControl.source().sameAs(control.source())) {
                this.filterEnv.error("The class " + control.userClassName() + " from " + control.sourceName() + " is already entered from " + existControl.sourceName() + ".");
                return;
            }
            if (control.persistType() == 0 || existControl.persistType() == 1 || existControl.persistType() == 2 && control.persistType() != 1) {
                return;
            }
        }
        if (existControl == null && control.sourceName() != null) {
            this.filterEnv.message("Adding class " + control.userClassName() + " from " + control.sourceName());
        }
        this.filterEnv.classMap.put(className, control);
    }

    private void augmentClasses() {
        Vector v = this.filterEnv.collectClasses(1);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ClassControl cc = (ClassControl)e.nextElement();
            this.augmentClass(cc);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void augmentClass(ClassControl startCC) {
        String className = startCC.classFile().className().asString();
        String baseClassName = startCC.classFile().superName().asString();
        while (true) {
            ClassControl cc;
            if ((cc = this.filterEnv.findClass(baseClassName)) == null) {
                this.filterEnv.error("Unable to locate class " + ClassControl.userClassFromVMClass(baseClassName));
                return;
            }
            if (baseClassName.equals("java/lang/Object")) {
                return;
            }
            String ccPkg = cc.pkg();
            if (ccPkg.equals("com/odi") || ccPkg.startsWith("com/odi/imp") || ccPkg.startsWith("com/odi/jcpp") || ccPkg.startsWith("com/odi/coll") || ccPkg.startsWith("com/odi/filter") || ccPkg.startsWith("com/odi/odmg") || ccPkg.startsWith("com/odi/osji") || ccPkg.startsWith("com/odi/tools") || ccPkg.startsWith("com/odi/util")) {
                if (!cc.implementsIPersistent(this.filterEnv)) {
                    this.filterEnv.error("Sorry, " + ClassControl.userClassFromVMClass(className) + " extends " + ClassControl.userClassFromVMClass(baseClassName) + " which can not be made persistent.");
                    return;
                }
            } else {
                if (baseClassName.startsWith("java/") && !cc.implementsIPersistent(this.filterEnv) && !this.filterEnv.modifyJavaClasses()) {
                    this.filterEnv.error("Sorry, java types can not be made persistent.  Class " + ClassControl.userClassFromVMClass(className) + " extends " + ClassControl.userClassFromVMClass(baseClassName) + ".  See the -modifyjava option if you really " + "want to do this.");
                    return;
                }
                if (baseClassName.startsWith("com/ms/com/")) {
                    this.filterEnv.error("Sorry, Microsoft COM types can not be made persistent.  Class " + ClassControl.userClassFromVMClass(className) + " extends " + ClassControl.userClassFromVMClass(baseClassName) + ".");
                    return;
                }
                if (baseClassName.equals("com/odi/jcpp/CPlusPlus")) {
                    this.filterEnv.error("Class " + ClassControl.userClassFromVMClass(className) + " extends com.odi.jcpp.CPlusPlus but " + "Java peer classes may not be postprocessed or " + "manually extended.");
                    return;
                }
                if (cc.persistType() == 1) {
                    return;
                }
                if (cc.implementsIPersistent(this.filterEnv)) {
                    this.filterEnv.message("Promoting " + cc.userClassName() + " to persistence-capable.");
                    cc.setPersistType(1);
                    cc.setImplicitlyPersistent(true);
                } else {
                    if (cc.persistType() != 0) {
                        this.filterEnv.error("Class " + cc.userClassName() + " must be persistent to allow " + startCC.userClassName() + " to be persistent.");
                        return;
                    }
                    if (!cc.pkg().equals(startCC.pkg())) {
                        this.filterEnv.error("Class " + cc.userClassName() + " must be persistent to allow " + startCC.userClassName() + " to be persistent.");
                        return;
                    }
                    this.filterEnv.message("Including class " + cc.userClassName() + " as a persistence capable class.");
                    cc.setPersistType(1);
                    cc.setImplicitlyPersistent(true);
                }
            }
            baseClassName = cc.classFile().superName().asString();
        }
    }

    private void modifyClasses() {
        ClassControl cc;
        this.filterEnv.message("scanning classes");
        Vector classes = this.filterEnv.collectAllClasses();
        Enumeration e = classes.elements();
        while (e.hasMoreElements()) {
            cc = (ClassControl)e.nextElement();
            cc.scan1(this.filterEnv);
        }
        this.retargetClasses();
        if (this.filterEnv.errorCount() > 0) {
            return;
        }
        this.filterEnv.message("computing annotations");
        e = classes.elements();
        while (e.hasMoreElements()) {
            cc = (ClassControl)e.nextElement();
            cc.scan2(this.filterEnv);
        }
        if (this.filterEnv.errorCount() > 0) {
            return;
        }
        this.filterEnv.message("modifying inheritance");
        e = classes.elements();
        while (e.hasMoreElements()) {
            cc = (ClassControl)e.nextElement();
            cc.augmentInterfaces(this.filterEnv);
        }
        if (this.filterEnv.errorCount() > 0) {
            return;
        }
        this.filterEnv.message("annotating classes");
        e = classes.elements();
        while (e.hasMoreElements()) {
            cc = (ClassControl)e.nextElement();
            cc.annotate(this.filterEnv);
        }
        if (this.filterEnv.getSummary() != null) {
            this.filterEnv.message("generating type summary");
            ClassFile summary = TypeSummaryBuilder.makeTypeSummary(this.filterEnv.getSummary(), this.computePersistentClasses(this.filterEnv), this.filterEnv.getIncludedSummaries(), this.filterEnv);
            this.filterEnv.setSummaryClass(this.filterEnv.addClass(summary));
        }
    }

    private Vector computePersistentClasses(FilterEnv filterEnv) {
        Vector<String> v = new Vector<String>();
        Enumeration allClasses = filterEnv.classMap.elements();
        while (allClasses.hasMoreElements()) {
            ClassControl cc = (ClassControl)allClasses.nextElement();
            if (!cc.isExplicitlyNamed() || !cc.persistCapable(filterEnv)) continue;
            v.addElement(cc.userClassName());
        }
        return v;
    }

    private void retargetClasses() {
        if (this.filterEnv.translations.size() == 0) {
            return;
        }
        this.locateTranslatedClasses();
        if (this.filterEnv.classMap.size() > 0) {
            ClassControl cc;
            Vector<ClassControl> translatable = new Vector<ClassControl>();
            Hashtable<String, String> classTranslations = new Hashtable<String, String>();
            Enumeration<Object> e = this.filterEnv.classMap.elements();
            while (e.hasMoreElements()) {
                String newName;
                cc = (ClassControl)e.nextElement();
                String pkg = cc.pkg();
                String xlat = (String)this.filterEnv.translations.get(pkg);
                if (xlat == null && !cc.annotateable(this.filterEnv)) continue;
                translatable.addElement(cc);
                if (xlat == null || (newName = xlat.length() == 0 ? cc.unpackagedName() : xlat + "/" + cc.unpackagedName()).equals(cc.className())) continue;
                ClassControl existingCC = (ClassControl)this.filterEnv.classMap.get(newName);
                if (existingCC != null) {
                    this.filterEnv.error("The package translations specified would cause " + cc.userClassName() + " to be translated to " + existingCC.userClassName() + " which already exists.");
                    continue;
                }
                classTranslations.put(cc.className(), newName);
            }
            if (this.filterEnv.errorCount() > 0) {
                return;
            }
            if (classTranslations.isEmpty()) {
                this.filterEnv.warning("No package name translations are being applied");
            } else {
                this.filterEnv.message("doing package name translations");
                e = translatable.elements();
                while (e.hasMoreElements()) {
                    cc = (ClassControl)e.nextElement();
                    String className = cc.className();
                    cc.retarget(this.filterEnv, classTranslations);
                    String newClassName = cc.className();
                    this.filterEnv.classMap.remove(className);
                    this.filterEnv.renamedMap.put(className, cc);
                    this.filterEnv.classMap.put(newClassName, cc);
                }
            }
        }
    }

    private void locateTranslatedClasses() {
        Enumeration e = this.filterEnv.translations.keys();
        while (e.hasMoreElements()) {
            String pkg = (String)e.nextElement();
            Enumeration pe = this.filterEnv.classPathOption.classesInPackage(pkg);
            while (pe.hasMoreElements()) {
                String className = (String)pe.nextElement();
                this.filterEnv.findClass(className);
            }
        }
    }

    private void checkIndexableFields() {
        this.checkFields(this.filterEnv.indexableFields.entries(), "-indexablefield");
    }

    private void checkEmbeddableFields() {
        this.checkFields(this.filterEnv.addedEmbeddedField.entries(), "-embeddedmaxlengthfield");
    }

    private void checkFields(FieldMap.Enumerator e, String option) {
        while (e.hasMoreElements()) {
            boolean processed = e.isMarked();
            if (!processed) {
                String className = e.className();
                String userClassName = ClassControl.userClassFromVMClass(className);
                String localFieldName = e.fieldName();
                String fullFieldName = e.userFieldName();
                ClassControl cc = this.filterEnv.getClass(className);
                if (cc == null || !cc.annotateable(this.filterEnv)) {
                    this.filterEnv.warning("The " + option + " option was specified for " + fullFieldName + " but " + userClassName + " is not being processed.");
                } else if (cc.classFile().findField(localFieldName) == null) {
                    this.filterEnv.warning("The " + option + " option was specified for " + fullFieldName + " but class " + userClassName + " has no field named " + localFieldName);
                } else if (!cc.action().fieldIsPersistent(localFieldName, this.filterEnv)) {
                    this.filterEnv.warning("The " + option + " option was specified for " + fullFieldName + " but the field is not a persistent field.");
                }
            }
            e.nextField();
        }
    }

    private void writeClasses() {
        File dest;
        ClassControl cc;
        this.filterEnv.message("writing updated classes");
        Hashtable<ClassControl, File> destMap = new Hashtable<ClassControl, File>();
        Hashtable<String, ClassControl> revDestMap = new Hashtable<String, ClassControl>();
        Hashtable zipMap = new Hashtable(11);
        Enumeration cMapElements = this.filterEnv.classMap.elements();
        while (cMapElements.hasMoreElements()) {
            ClassControl cc2 = (ClassControl)cMapElements.nextElement();
            if (!cc2.isExplicitlyNamed() && !cc2.updated() || !cc2.filterRequired(this.filterEnv)) continue;
            try {
                File dest2 = this.filterEnv.updateInPlace() && !cc2.source().isZipped() && !cc2.renamed() ? new File(cc2.source().containingFilePath()) : cc2.source().computeDestination(this.filterEnv.destinationDirectory);
                File canDest = new File(FilePath.canonicalize(dest2));
                destMap.put(cc2, canDest);
                ClassControl otherCC = (ClassControl)revDestMap.get(canDest.getPath());
                if (otherCC != null) {
                    this.filterEnv.error(cc2.userClassName() + " and " + otherCC.userClassName() + " would both be written to " + canDest.getPath());
                    continue;
                }
                revDestMap.put(canDest.getPath(), cc2);
            }
            catch (FileNotFoundException fnfe) {
                this.filterEnv.error("FileNotFoundException occurred", fnfe);
            }
            catch (IOException ioe) {
                this.filterEnv.error("IOException occurred", ioe);
            }
        }
        if (!this.filterEnv.updateInPlace()) {
            Enumeration mape = destMap.keys();
            while (mape.hasMoreElements()) {
                ClassControl mapSourceControl = (ClassControl)mape.nextElement();
                String mapSourceOrig = mapSourceControl.source().containingFilePath();
                if (mapSourceOrig == null) continue;
                File mapSourceFile = new File(mapSourceOrig);
                String mapSource = FilePath.canonicalize(mapSourceFile);
                File mapDestFile = (File)destMap.get(mapSourceControl);
                if (mapDestFile.exists() && (FilePath.canonicalNamesEqual(mapSource, mapDestFile.getPath()) || mapSourceFile.lastModified() == mapDestFile.lastModified())) {
                    this.filterEnv.error("The rewritten version of " + mapSource + " would overwrite itself.");
                    continue;
                }
                if (!mapDestFile.exists() || mapDestFile.delete()) continue;
                this.filterEnv.error("Unable to remove old version of " + mapDestFile.getPath());
            }
        }
        if (this.filterEnv.errorCount() > 0) {
            return;
        }
        Enumeration destMapKeys = destMap.keys();
        while (destMapKeys.hasMoreElements()) {
            cc = (ClassControl)destMapKeys.nextElement();
            dest = (File)destMap.get(cc);
            try {
                this.filterEnv.message("writing class " + cc.userClassName() + " to " + dest.getPath());
                cc.write(dest);
            }
            catch (FileNotFoundException fnfe) {
                this.filterEnv.error("FileNotFoundException occurred", fnfe);
            }
            catch (IOException ioe) {
                this.filterEnv.error("IOException occurred", ioe);
            }
        }
        if (this.filterEnv.getSummaryClass() != null) {
            this.filterEnv.message("writing type summary");
            cc = this.filterEnv.getSummaryClass();
            try {
                dest = cc.source().computeDestination(this.filterEnv.destinationDirectory);
                cc.write(dest);
            }
            catch (IOException ioe) {
                this.filterEnv.error("IOException occurred", ioe);
            }
        }
    }

    private void usage() {
        System.err.println("Usage: osjcfp <options>");
        System.err.println("  { -copyclass | -cc }");
        System.err.println("  { -persistaware | -pa }");
        System.err.println("  { -persistcapable | -pc }");
        System.err.println("  { -verbose | -v }");
        System.err.println("  { -force | -f }");
        System.err.println("  { -quiet | -q }");
        System.err.println("  { -quietfield | -qf } <qualified field name>");
        System.err.println("  { -quietclass | -qc } <qualified class name>");
        System.err.println("  { -indexablefield | -index } <qualified field name>");
        System.err.println("  { -ignoretransient | -it } <qualified field name>");
        System.err.println("  { -transientfield | -tf } <qualified field name>");
        System.err.println("  { -noannotatetransientfields | -natf }");
        System.err.println("  { -embeddedmaxlengthfield | -emlf } <qualified field name> <max length>");
        System.err.println("  { -annotatefield | -af } <qualified field name>");
        System.err.println("  { -noannotatefield | -naf } <qualified field name>");
        System.err.println("  { -nodefaulthashcode | -ndhc}");
        System.err.println("  -hashcode <qualified class name>");
        System.err.println("  -inplace");
        System.err.println("  -noarrayopt");
        System.err.println("  -nothisopt");
        System.err.println("  -noinitializeropt");
        System.err.println("  -noopt");
        System.err.println("  -modifyjava");
        System.err.println("  -nowrite");
        System.err.println("  { -optimizeclassinfo | -oci }");
        System.err.println("  { -nooptimizeclassinfo | -noci }");
        System.err.println("  -summary <generated summary class name>");
        System.err.println("  -includesummary <included summary class name>");
        System.err.println("  { -dest | -d } <destination directory>");
        System.err.println("  { -translatepackage | -tp } <orig pkg name> <new pkg name>");
        System.err.println("  { -classpath | -cpath } <classpath for lookup>");
        System.err.println("  { -sysclasspath | -syscpath } <system classpath for lookup>");
        System.err.println("  { -classinfosuffix | -cis } <suffix for ClassInfo files>");
        System.err.println("  @<cmd-arg-file>");
    }

    private boolean verbose() {
        return this.filterEnv.verbose();
    }
}

