/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.FilterEnv;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.ExceptionTable;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.InsnUtils;
import com.odi.filter.classfile.SourceFileAttribute;
import com.odi.filter.classfile.VMConstants;
import java.util.Vector;

class TypeSummaryBuilder
implements VMConstants {
    TypeSummaryBuilder() {
    }

    static ClassFile makeTypeSummary(String summaryClass, Vector persistentClasses, Vector includedSummaries, FilterEnv filterEnv) {
        ClassFile typeSummary = new ClassFile(summaryClass, "com/odi/PersistentTypeSummary");
        typeSummary.setAccessFlags(17);
        ConstantPool pool = typeSummary.pool();
        typeSummary.addField(new ClassField(10, pool.addUtf8("classes"), pool.addUtf8("[Ljava/lang/String;"), new AttributeVector()));
        typeSummary.addField(new ClassField(10, pool.addUtf8("summaries"), pool.addUtf8("[Ljava/lang/String;"), new AttributeVector()));
        typeSummary.addMethod(TypeSummaryBuilder.buildClinit(pool, summaryClass, persistentClasses, includedSummaries));
        typeSummary.addMethod(TypeSummaryBuilder.buildInit(pool, summaryClass));
        typeSummary.attributes().addElement(new SourceFileAttribute(pool.addUtf8("SourceFile"), pool.addUtf8("Generated.java")));
        return typeSummary;
    }

    private static ClassMethod buildClinit(ConstantPool pool, String className, Vector persistentClasses, Vector includedSummaries) {
        InsnTarget firstInsn;
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod createMethod = new ClassMethod(8, pool.addUtf8("<clinit>"), pool.addUtf8("()V"), methodAttrs);
        InsnTarget insn = firstInsn = new InsnTarget();
        TypeSummaryBuilder.buildStringArray(pool, insn, persistentClasses, className, "classes");
        TypeSummaryBuilder.buildStringArray(pool, insn, includedSummaries, className, "summaries");
        insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 4, 0, firstInsn, new ExceptionTable(), new AttributeVector()));
        return createMethod;
    }

    private static void buildStringArray(ConstantPool pool, Insn insn, Vector strings, String className, String staticField) {
        insn = insn.append(InsnUtils.integerConstant(strings.size(), pool));
        insn = insn.append(Insn.create(189, pool.addClass("java/lang/String")));
        for (int i = 0; i < strings.size(); ++i) {
            String aString = (String)strings.elementAt(i);
            insn = insn.append(Insn.create(89));
            insn = insn.append(InsnUtils.integerConstant(i, pool));
            insn = insn.append(Insn.create(18, pool.addString(aString)));
            insn = insn.append(Insn.create(83));
        }
        insn = insn.append(Insn.create(179, pool.addFieldRef(className, staticField, "[Ljava/lang/String;")));
    }

    private static ClassMethod buildInit(ConstantPool pool, String className) {
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod createMethod = new ClassMethod(1, pool.addUtf8("<init>"), pool.addUtf8("()V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(178, pool.addFieldRef(className, "classes", "[Ljava/lang/String;")));
        insn = insn.append(Insn.create(178, pool.addFieldRef(className, "summaries", "[Ljava/lang/String;")));
        insn = insn.append(Insn.create(183, pool.addMethodRef("com/odi/PersistentTypeSummary", "<init>", "([Ljava/lang/String;[Ljava/lang/String;)V")));
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 3, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return createMethod;
    }
}

