/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.Placement;
import com.odi.imp.HashBucket;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.ObjectReferenceFactory;
import com.odi.imp.Utilities;

public class NonWeakReferenceFactory
extends ObjectReferenceFactory {
    public NonWeakReferenceFactory(ObjectManager om) {
        super(om);
    }

    @Override
    public final ObjectReference create(Object object, Placement place, long location, int AFTypeCode, int arrayElementCount) {
        int arrayDimensions = Utilities.arrayDimensions(AFTypeCode);
        if (arrayDimensions == 0) {
            return new CompactReference(object, place, location, AFTypeCode);
        }
        if (arrayElementCount > 0xFFFFFF) {
            return new GeneralReference(object, place, location, AFTypeCode, arrayElementCount, arrayDimensions);
        }
        if (arrayDimensions == 1) {
            int elementAFTypeCode = Utilities.arrayElementTypeCode(AFTypeCode);
            if (elementAFTypeCode == 15 && arrayElementCount <= 65535) {
                return new StringReference(object, place, location, AFTypeCode, arrayElementCount);
            }
            if (Utilities.isElementValidAsInt(elementAFTypeCode)) {
                return new IntArrayReference(object, place, location, AFTypeCode, arrayElementCount);
            }
            if (Utilities.isElementValidAsLong(elementAFTypeCode)) {
                return new LongArrayReference(object, place, location, AFTypeCode, arrayElementCount);
            }
        }
        return new ObjectArrayReference(object, place, location, AFTypeCode, arrayElementCount);
    }

    @Override
    public boolean supportsWeakReference() {
        return false;
    }

    private static class BucketImpl
    implements HashBucket {
        private Object element;
        private HashBucket next = null;
        private HashBucket next2 = null;
        private HashBucket nextInChain = null;
        private HashBucket prevInChain = null;

        public BucketImpl(Object anElement) {
            this.element = anElement;
        }

        @Override
        public final Object getKey() {
            return this;
        }

        @Override
        public final Object getElement() {
            return this.element;
        }

        public final void setElement(Object e) {
            this.element = e;
        }

        @Override
        public final void makeWritable(HashBucket writableListHead) {
            this.makeChained(writableListHead);
        }

        @Override
        public final void makeReadable(HashBucket readableListHead) {
            this.makeChained(readableListHead);
        }

        @Override
        public final void makeCached(HashBucket cachedListTail) {
            this.makeChainedAtTail(cachedListTail);
        }

        @Override
        public final void makeHollow() {
            this.unchain();
        }

        @Override
        public final HashBucket getNext() {
            return this.next;
        }

        @Override
        public final void setNext(HashBucket n) {
            this.next = n;
        }

        @Override
        public final HashBucket getNext2() {
            return this.next2;
        }

        @Override
        public final void setNext2(HashBucket n) {
            this.next2 = n;
        }

        @Override
        public final void unchain() {
            if (this.prevInChain != null) {
                this.prevInChain.setNextInChain(this.nextInChain);
            }
            if (this.nextInChain != null) {
                this.nextInChain.setPrevInChain(this.prevInChain);
            }
            this.nextInChain = null;
            this.prevInChain = null;
        }

        private void makeChained(HashBucket listHead) {
            this.unchain();
            this.nextInChain = listHead.getNextInChain();
            this.prevInChain = listHead;
            listHead.setNextInChain(this);
            if (this.nextInChain != null) {
                this.nextInChain.setPrevInChain(this);
            }
        }

        private void makeChainedAtTail(HashBucket listTail) {
            this.unchain();
            this.prevInChain = listTail.getPrevInChain();
            this.nextInChain = listTail;
            listTail.setPrevInChain(this);
            if (this.prevInChain != null) {
                this.prevInChain.setNextInChain(this);
            }
        }

        @Override
        public final HashBucket getNextInChain() {
            return this.nextInChain;
        }

        @Override
        public final void setNextInChain(HashBucket n) {
            this.nextInChain = n;
        }

        @Override
        public final HashBucket getPrevInChain() {
            return this.prevInChain;
        }

        @Override
        public final void setPrevInChain(HashBucket n) {
            this.prevInChain = n;
        }

        @Override
        public final void clearWeakReference() {
            this.element = null;
        }
    }

    private static final class GeneralReference
    extends CompactReference {
        private final int arrayDimensions;
        private final int arrayElementCount;
        Object element0;

        @Override
        public int getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public final int getArrayElementCount() {
            return this.arrayElementCount;
        }

        @Override
        public int getAFTypeCode() {
            return this.arrayDimensions == 1 ? super.getAFTypeCode() | ArrayAFTBox : Utilities.makeArrayTypeCode(this.arrayDimensions, super.getAFTypeCode());
        }

        @Override
        public void saveElement0(Object object) {
            this.element0 = Utilities.getElement0AsObject(object, super.getAFTypeCode());
        }

        @Override
        public void restoreElement0(Object object) {
            Utilities.setElement0FromObject(object, super.getAFTypeCode(), this.element0);
        }

        GeneralReference(Object object, Placement place, long location, int AFTypeCode, int arrayElementCount, int arrayDimensions) {
            super(object, place, location, AFTypeCode & 0xFFFF);
            this.arrayElementCount = arrayElementCount;
            this.arrayDimensions = arrayDimensions;
        }
    }

    private static class ObjectArrayReference
    extends ArrayReference {
        protected Object element0;

        ObjectArrayReference(Object object, Placement place, long location, int AFTypeCode, int arrayLength) {
            super(object, place, location, AFTypeCode, arrayLength);
        }

        @Override
        public void saveElement0(Object object) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length != 0) {
                this.element0 = objectArray[0];
                objectArray[0] = null;
            }
        }

        @Override
        public void restoreElement0(Object object) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length != 0) {
                objectArray[0] = this.element0;
                this.element0 = null;
            }
        }
    }

    private static class LongArrayReference
    extends ArrayReference {
        protected long element0;

        LongArrayReference(Object object, Placement place, long location, int AFTypeCode, int arrayLength) {
            super(object, place, location, AFTypeCode, arrayLength);
        }

        @Override
        public void saveElement0(Object object) {
            if (this.getArrayElementCount() != 0) {
                this.element0 = Utilities.getElement0AsLong(object, Utilities.arrayElementTypeCode(this.getAFTypeCode()));
            }
        }

        @Override
        public void restoreElement0(Object object) {
            if (this.getArrayElementCount() != 0) {
                Utilities.setElement0FromLong(object, Utilities.arrayElementTypeCode(this.getAFTypeCode()), this.element0);
            }
        }
    }

    private static class IntArrayReference
    extends ArrayReference {
        protected int element0;

        IntArrayReference(Object object, Placement place, long location, int AFTypeCode, int arrayLength) {
            super(object, place, location, AFTypeCode, arrayLength);
        }

        @Override
        public void saveElement0(Object object) {
            if (this.getArrayElementCount() != 0) {
                this.element0 = Utilities.getElement0AsInt(object, Utilities.arrayElementTypeCode(this.getAFTypeCode()));
            }
        }

        @Override
        public void restoreElement0(Object object) {
            if (this.getArrayElementCount() != 0) {
                Utilities.setElement0FromInt(object, Utilities.arrayElementTypeCode(this.getAFTypeCode()), this.element0);
            }
        }
    }

    private static class ArrayReference
    extends CompactReference {
        protected int ADimsLength;
        static final int ALengthWidth = 24;
        static final int ALengthOffset = 0;
        static final int ALengthMask = 0xFFFFFF;
        static final int ADimsWidth = 8;
        static final int ADimsOffset = 24;
        static final int ADimsMask = -16777216;
        static final int MaximumElementCount = 0xFFFFFF;

        ArrayReference(Object object, Placement place, long location, int AFTypeCode, int arrayLength) {
            super(object, place, location, Utilities.arrayElementTypeCode(AFTypeCode));
            this.ADimsLength = Utilities.arrayDimensions(AFTypeCode) << 24 | arrayLength;
        }

        @Override
        public int getAFTypeCode() {
            int dims = (this.ADimsLength & 0xFF000000) >>> 24;
            return dims == 1 ? super.getAFTypeCode() | ArrayAFTBox : Utilities.makeArrayTypeCode(dims, super.getAFTypeCode());
        }

        @Override
        public int getArrayDimensions() {
            return (this.ADimsLength & 0xFF000000) >>> 24;
        }

        @Override
        public int getArrayElementCount() {
            return this.ADimsLength & 0xFFFFFF;
        }
    }

    private static final class StringReference
    extends CompactReference {
        static final int MaximumElementCount = 65535;

        StringReference(Object object, Placement place, long location, int AFTypeCode, int arrayLength) {
            super(object, place, location, arrayLength);
        }

        @Override
        public int getAFTypeCode() {
            return 12648463;
        }

        @Override
        public int getArrayDimensions() {
            return 1;
        }

        @Override
        public int getArrayElementCount() {
            return super.getAFTypeCode();
        }
    }

    private static class CompactReference
    extends BucketImpl
    implements ObjectReference,
    ObjectReference.Constants {
        protected int TxnFlagsAFT;
        private final Placement place;
        private final long location;
        static final int AFTWidth = 16;
        static final int AFTOffset = 0;
        static final int AFTMask = 65535;
        static final int FlagsWidth = 8;
        static final int FlagsOffset = 16;
        static final int FlagsMask = 0xFF0000;
        static final int TxnWidth = 8;
        static final int TxnOffset = 24;
        static final int TxnMask = -16777216;
        static final int ArrayAFTBox = Utilities.makeArrayTypeCode(1, 0);

        CompactReference(Object object, Placement place, long location, int AFTypeCode) {
            super(object);
            this.place = place;
            this.location = location;
            this.TxnFlagsAFT = AFTypeCode & 0xFFFF;
        }

        @Override
        public final int hashCode() {
            return (int)(this.location ^ (long)this.getAFTypeCode());
        }

        @Override
        public final boolean equals(Object obj) {
            ObjectReference objRef;
            try {
                objRef = (ObjectReference)obj;
            }
            catch (ClassCastException e) {
                return false;
            }
            return objRef.isEqual(this.place, this.location, this.getAFTypeCode());
        }

        @Override
        public final boolean isEqual(Placement place, long location, int AFTypeCode) {
            return this.place == place && this.location == location && this.getAFTypeCode() == AFTypeCode;
        }

        @Override
        public final Placement getPlacement() {
            return this.place;
        }

        @Override
        public int getAFTypeCode() {
            return this.TxnFlagsAFT & 0xFFFF;
        }

        @Override
        public final long getLocation() {
            return this.location;
        }

        @Override
        public int getArrayDimensions() {
            return 0;
        }

        @Override
        public int getArrayElementCount() {
            return -1;
        }

        @Override
        public final short getFlags() {
            return (short)((this.TxnFlagsAFT & 0xFF0000) >>> 16);
        }

        @Override
        public final void setFlags(short flags) {
            this.TxnFlagsAFT = flags << 16 | this.TxnFlagsAFT & 0xFF00FFFF;
        }

        @Override
        public final short getTxnIndex() {
            return (short)((this.TxnFlagsAFT & 0xFF000000) >>> 24);
        }

        @Override
        public final void setTxnIndex(short txn) {
            this.TxnFlagsAFT = txn << 24 | this.TxnFlagsAFT & 0xFFFFFF;
        }

        @Override
        public void saveElement0(Object object) {
        }

        @Override
        public void restoreElement0(Object object) {
        }
    }
}

