/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.ClassNotRegisteredException;
import com.odi.FatalInternalException;
import com.odi.Persistent;
import com.odi.imp.ByteArrayClassLoader;
import com.odi.imp.GenericObject;
import com.odi.imp.JavaBuiltinInfo;
import com.odi.imp.JavaPrimInfo;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ReferenceType;
import com.odi.imp.TypeCodeConstants;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Properties;

public final class Utilities
implements TypeCodeConstants {
    public static Class javaLangObjectType = Object.class;
    public static Class javaLangStringType = String.class;
    public static Class COModiPersistentType = Persistent.class;
    private static int GTS_AFA_typecode = 0x800000;
    static final int GTS_Array_element_typecode_field_width = 16;
    static final int GTS_Array_element_typecode_mask = 65535;
    static final int GTS_Array_dimensions_mask = 63;
    static final int GTS_Array_box = 0xC00000;
    public static final int stringTypeCode = 12648463;
    private static ByteArrayClassLoader cLoader;

    public static boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    static Class getWrapperClassDescriptor(int AFTypeCode) {
        JavaPrimInfo info = JavaPrimInfo.findByWrapperTypeCode(AFTypeCode);
        if (info == null || info.wrapperClass == null) {
            throw new FatalInternalException("Unsupported wrapper type:" + Integer.toString(AFTypeCode));
        }
        return info.wrapperClass;
    }

    static String getPredefinedAFTName(int AFTypeCode) {
        if (AFTypeCode < 100) {
            return primitiveTypeNames[AFTypeCode];
        }
        if (AFTypeCode < 200) {
            return knownObjectNames[AFTypeCode - 100];
        }
        return null;
    }

    public static boolean isPrimitiveTypeCode(int typeCode) {
        return typeCode > 0 && typeCode <= 15;
    }

    static boolean isWrapperTypeCode(int typeCode) {
        return typeCode >= 102 && typeCode <= 116;
    }

    public static boolean isPrimitiveOrWrapperTypeCode(int typeCode) {
        return Utilities.isPrimitiveTypeCode(typeCode) || Utilities.isWrapperTypeCode(typeCode);
    }

    public static boolean isBuiltinTypeCode(int typeCode) {
        return 130 <= typeCode && typeCode <= 132;
    }

    public static boolean isBuiltinTypeName(String typeName) {
        return typeName.equals("java.util.Locale") || typeName.equals("java.math.BigInteger") || typeName.equals("java.math.BigDecimal");
    }

    public static boolean isReferenceTypeCode(int typeCode) {
        return typeCode > 117 && typeCode <= 121;
    }

    public static int referenceLinearRepSize(int typeCode) {
        int enumVal = typeCode - 117;
        return ReferenceType.getReferenceType(enumVal).size();
    }

    static int primitiveLinearRepSize(int typeCode) {
        switch (typeCode) {
            case 1: 
            case 102: {
                return 1;
            }
            case 2: 
            case 103: {
                return 1;
            }
            case 3: 
            case 104: {
                return 2;
            }
            case 4: 
            case 105: {
                return 2;
            }
            case 5: 
            case 106: {
                return 4;
            }
            case 6: 
            case 107: {
                return 4;
            }
            case 7: 
            case 108: {
                return 8;
            }
            case 8: 
            case 109: {
                return 8;
            }
            case 9: 
            case 110: {
                return 16;
            }
            case 10: 
            case 111: {
                return 16;
            }
            case 11: 
            case 112: {
                return 1;
            }
            case 12: 
            case 113: {
                return 2;
            }
            case 13: 
            case 114: {
                return 4;
            }
            case 14: 
            case 115: {
                return 8;
            }
            case 15: 
            case 116: {
                return 1;
            }
        }
        throw new FatalInternalException("Unrecognized AFT typecode:" + Integer.toString(typeCode));
    }

    static int builtinLinearRepSize(int AFTypeCode, int refSize) {
        switch (AFTypeCode) {
            case 130: {
                return 3 * refSize;
            }
            case 131: {
                return refSize;
            }
            case 132: {
                return refSize + 4;
            }
        }
        throw new FatalInternalException("Unrecognized AFT typecode: " + AFTypeCode);
    }

    public static int[] getBuiltinMappingTable(int AFTypeCode, int refSize) {
        switch (AFTypeCode) {
            case 130: {
                int[] map1 = new int[]{3 * refSize, 0, refSize, 2 * refSize};
                return map1;
            }
            case 131: {
                int[] map2 = new int[]{refSize, 0};
                return map2;
            }
            case 132: {
                int[] map3 = new int[]{refSize + 4, 0, refSize};
                return map3;
            }
        }
        throw new FatalInternalException("Unrecognized AFT typecode: " + AFTypeCode);
    }

    public static void encodeWrapperObject(GenericObject genObj, Object object) {
        ObjectAccess objectAccess = genObj.objectManager.objectAccess;
        byte[] buffer = genObj.rep;
        switch (genObj.objRef.getAFTypeCode()) {
            case 109: {
                ObjectAccess.encodeLong(buffer, 0, (Long)object);
                break;
            }
            case 115: {
                ObjectAccess.encodeDouble(buffer, 0, (Double)object);
                break;
            }
            case 113: {
                ObjectAccess.encodeShort(buffer, 0, (short)((Character)object).charValue());
                break;
            }
            case 112: {
                ObjectAccess.encodeBoolean(buffer, 0, (Boolean)object);
                break;
            }
            case 107: {
                ObjectAccess.encodeInt(buffer, 0, (Integer)object);
                break;
            }
            case 114: {
                ObjectAccess.encodeFloat(buffer, 0, ((Float)object).floatValue());
                break;
            }
            case 103: {
                ObjectAccess.encodeByte(buffer, 0, (Byte)object);
                break;
            }
            case 105: {
                ObjectAccess.encodeShort(buffer, 0, (Short)object);
                break;
            }
            default: {
                throw new FatalInternalException("encodeWrapperObject() unexpected object " + object.getClass().getName());
            }
        }
    }

    static void encodeWrapperObject(ObjectAccess objectAccess, byte[] buffer, int offset, Object object) {
        if (object.getClass() == JavaPrimInfo.get((int)2).wrapperClass) {
            objectAccess.encodeImmCharRef(buffer, offset, ((Character)object).charValue());
        } else if (object.getClass() == JavaPrimInfo.get((int)1).wrapperClass) {
            objectAccess.encodeImmByteRef(buffer, offset, (Byte)object);
        } else if (object.getClass() == JavaPrimInfo.get((int)3).wrapperClass) {
            objectAccess.encodeImmShortRef(buffer, offset, (Short)object);
        } else if (object.getClass() == JavaPrimInfo.get((int)4).wrapperClass) {
            objectAccess.encodeImmIntegerRef(buffer, offset, (Integer)object);
        } else if (object.getClass() == JavaPrimInfo.get((int)5).wrapperClass) {
            objectAccess.encodeImmLongRef(buffer, offset, (Long)object);
        } else if (object.getClass() == JavaPrimInfo.get((int)8).wrapperClass) {
            objectAccess.encodeImmBooleanRef(buffer, offset, (Boolean)object);
        } else if (object.getClass() == JavaPrimInfo.get((int)6).wrapperClass) {
            objectAccess.encodeImmFloatRef(buffer, offset, ((Float)object).floatValue());
        } else if (object.getClass() == JavaPrimInfo.get((int)7).wrapperClass) {
            objectAccess.encodeImmDoubleRef(buffer, offset, (Double)object);
        } else {
            throw new FatalInternalException("encodeWrapperObject() unexpected object " + object.getClass().getName());
        }
    }

    static void encodeBuiltinObject(GenericObject genObj, Object obj) {
        switch (genObj.objRef.getAFTypeCode()) {
            case 130: {
                Locale locale = (Locale)obj;
                ClassInfo cinfo = ClassInfo.get("java.util.Locale");
                genObj.setStringField(1, locale.getLanguage(), cinfo);
                genObj.setStringField(2, locale.getCountry(), cinfo);
                genObj.setStringField(3, locale.getVariant(), cinfo);
                break;
            }
            case 131: {
                BigInteger bigInt = (BigInteger)obj;
                ClassInfo cinfo = ClassInfo.get("java.math.BigInteger");
                genObj.setArrayField(1, bigInt.toByteArray(), cinfo);
                break;
            }
            case 132: {
                BigDecimal bd = (BigDecimal)obj;
                ClassInfo cinfo = ClassInfo.get("java.math.BigDecimal");
                genObj.setClassField(1, bd.unscaledValue(), cinfo);
                genObj.setIntField(2, bd.scale(), cinfo);
                break;
            }
            default: {
                throw new FatalInternalException("encodeBuiltinObject() unexpected object " + obj.getClass().getName());
            }
        }
    }

    static Object decodeWrapperObject(GenericObject genObj, int AFTypeCode) {
        ObjectAccess objectAccess = genObj.objectManager.objectAccess;
        byte[] buffer = genObj.rep;
        switch (AFTypeCode) {
            case 109: {
                return new Long(ObjectAccess.decodeLong(buffer, 0));
            }
            case 115: {
                return new Double(ObjectAccess.decodeDouble(buffer, 0));
            }
            case 112: {
                return new Boolean(ObjectAccess.decodeBoolean(buffer, 0));
            }
            case 113: {
                return new Character(ObjectAccess.decodeChar(buffer, 0));
            }
            case 107: {
                return new Integer(ObjectAccess.decodeInt(buffer, 0));
            }
            case 114: {
                return new Float(ObjectAccess.decodeFloat(buffer, 0));
            }
            case 103: {
                return new Byte(ObjectAccess.decodeByte(buffer, 0));
            }
            case 105: {
                return new Short(ObjectAccess.decodeShort(buffer, 0));
            }
        }
        throw new FatalInternalException("decodeWrapperObject() unexpected primitive type code: " + Integer.toString(AFTypeCode, 16));
    }

    static Object decodeWrapperObject(ObjectAccess objectAccess, byte[] buffer, int offset) {
        int AFTypeCode = objectAccess.decodeObjRefTypeCode(buffer, offset);
        switch (AFTypeCode) {
            case 2: {
                return new Byte(objectAccess.decodeImmByteRef(buffer, offset));
            }
            case 12: {
                return new Character(objectAccess.decodeImmCharRef(buffer, offset));
            }
            case 4: {
                return new Short(objectAccess.decodeImmShortRef(buffer, offset));
            }
            case 6: {
                return new Integer(objectAccess.decodeImmIntegerRef(buffer, offset));
            }
            case 8: {
                return new Long(objectAccess.decodeImmLongRef(buffer, offset));
            }
            case 11: {
                return new Boolean(objectAccess.decodeImmBooleanRef(buffer, offset));
            }
            case 13: {
                return new Float(objectAccess.decodeImmFloatRef(buffer, offset));
            }
            case 14: {
                return new Double(objectAccess.decodeImmDoubleRef(buffer, offset));
            }
        }
        throw new FatalInternalException("decodeWrapperObject() unexpected primitive type code: " + Integer.toString(AFTypeCode, 16));
    }

    static Object decodeBuiltinObject(GenericObject genObj, int AFTypeCode) {
        switch (AFTypeCode) {
            case 130: {
                ClassInfo cinfo = ClassInfo.get("java.util.Locale");
                return new Locale(genObj.getStringField(1, cinfo), genObj.getStringField(2, cinfo), genObj.getStringField(3, cinfo));
            }
            case 131: {
                ClassInfo cinfo = ClassInfo.get("java.math.BigInteger");
                byte[] array = (byte[])genObj.getArrayField(1, cinfo);
                genObj.objectManager.fetchObject(array);
                return new BigInteger(array);
            }
            case 132: {
                ClassInfo cinfo = ClassInfo.get("java.math.BigDecimal");
                BigInteger bi = (BigInteger)genObj.getClassField(1, cinfo);
                int scale = genObj.getIntField(2, cinfo);
                return new BigDecimal(bi, scale);
            }
        }
        throw new FatalInternalException("decodeBuiltinObject() unexpected builtin type code: " + AFTypeCode);
    }

    public static int getPrimitiveOrWrapperTypeCode(Class type) {
        return JavaPrimInfo.findTypeCode(type);
    }

    public static int getBuiltinTypeCode(Class type) {
        return JavaBuiltinInfo.findTypeCode(type);
    }

    public static String getBuiltinTypeName(int typecode) {
        switch (typecode) {
            case 130: {
                return "java.util.Locale";
            }
            case 131: {
                return "java.math.BigInteger";
            }
            case 132: {
                return "java.math.BigDecimal";
            }
        }
        return null;
    }

    public static JavaPrimInfo findPrimitiveWrapperInfo(Object object) {
        return JavaPrimInfo.findByWrapperClass(object.getClass());
    }

    public static boolean isPrimitiveWrapperInstance(Object object) {
        if (object == null) {
            return false;
        }
        return JavaPrimInfo.findByWrapperClass(object.getClass()) != null;
    }

    public static boolean isBuiltinInstance(Object object) {
        return Utilities.findBuiltinInfo(object) != null;
    }

    public static JavaBuiltinInfo findBuiltinInfo(Object object) {
        if (object == null) {
            return null;
        }
        return JavaBuiltinInfo.findByClass(object.getClass());
    }

    private static String getPrimitiveElmentTypeName(char typeChar) {
        if (typeChar == 'B') {
            return "byte";
        }
        if (typeChar == 'C') {
            return "char";
        }
        if (typeChar == 'S') {
            return "short";
        }
        if (typeChar == 'I') {
            return "int";
        }
        if (typeChar == 'J') {
            return "long";
        }
        if (typeChar == 'Z') {
            return "boolean";
        }
        if (typeChar == 'F') {
            return "float";
        }
        if (typeChar == 'D') {
            return "double";
        }
        return null;
    }

    public static Class getArrayClassElementType(Class array) {
        Class<?> elementType = array.getComponentType();
        for (Class<?> current = elementType.getComponentType(); current != null; current = current.getComponentType()) {
            elementType = current;
        }
        return elementType;
    }

    public static Class getArrayElementType(Object array) {
        return Utilities.getArrayClassElementType(array.getClass());
    }

    public static int getArrayElementCount(Object array) {
        Class<?> elementType = array.getClass().getComponentType();
        if (!elementType.isPrimitive()) {
            return ((Object[])array).length;
        }
        if (elementType == Byte.TYPE) {
            return ((byte[])array).length;
        }
        if (elementType == Character.TYPE) {
            return ((char[])array).length;
        }
        if (elementType == Short.TYPE) {
            return ((short[])array).length;
        }
        if (elementType == Integer.TYPE) {
            return ((int[])array).length;
        }
        if (elementType == Long.TYPE) {
            return ((long[])array).length;
        }
        if (elementType == Boolean.TYPE) {
            return ((boolean[])array).length;
        }
        if (elementType == Float.TYPE) {
            return ((float[])array).length;
        }
        if (elementType == Double.TYPE) {
            return ((double[])array).length;
        }
        throw new FatalInternalException("Unrecognized Java primitive type: " + elementType);
    }

    public static int getArrayClassDimensions(Class array) {
        int dims = 0;
        for (Class<?> elementType = array.getComponentType(); elementType != null; elementType = elementType.getComponentType()) {
            ++dims;
        }
        return dims;
    }

    public static int getArrayDimensions(Object array) {
        return Utilities.getArrayClassDimensions(array.getClass());
    }

    static void clearArray(Object array) {
        Class<?> elementType = array.getClass().getComponentType();
        if (!elementType.isPrimitive()) {
            Object[] objectArray = (Object[])array;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
            return;
        }
        if (elementType == Byte.TYPE) {
            byte[] byteArray = (byte[])array;
            if (byteArray.length > 0) {
                byteArray[0] = 0;
            }
        } else if (elementType == Character.TYPE) {
            char[] charArray = (char[])array;
            if (charArray.length > 0) {
                charArray[0] = '\u0000';
            }
        } else if (elementType == Short.TYPE) {
            short[] shortArray = (short[])array;
            if (shortArray.length > 0) {
                shortArray[0] = 0;
            }
        } else if (elementType == Integer.TYPE) {
            int[] intArray = (int[])array;
            if (intArray.length > 0) {
                intArray[0] = 0;
            }
        } else if (elementType == Long.TYPE) {
            long[] longArray = (long[])array;
            if (longArray.length > 0) {
                longArray[0] = 0L;
            }
        } else if (elementType == Float.TYPE) {
            float[] floatArray = (float[])array;
            if (floatArray.length > 0) {
                floatArray[0] = 0.0f;
            }
        } else if (elementType == Double.TYPE) {
            double[] doubleArray = (double[])array;
            if (doubleArray.length > 0) {
                doubleArray[0] = 0.0;
            }
        } else if (elementType == Boolean.TYPE) {
            boolean[] booleanArray = (boolean[])array;
            if (booleanArray.length > 0) {
                booleanArray[0] = false;
            }
        } else {
            throw new FatalInternalException("Unrecognized primitive type: " + elementType);
        }
    }

    public static boolean isArrayTypeCode(int typeCode) {
        return (typeCode & GTS_AFA_typecode) != 0;
    }

    public static boolean isStringTypeCode(int typeCode) {
        return typeCode == 12648463;
    }

    public static int arrayDimensions(int arrayTypeCode) {
        return arrayTypeCode >>> 16 & 0x3F;
    }

    public static int arrayElementTypeCode(int arrayTypeCode) {
        return arrayTypeCode & 0xFFFF;
    }

    public static int makeArrayTypeCode(int dimensions, int elementTypeCode) {
        if (elementTypeCode == 12648463) {
            ++dimensions;
            elementTypeCode = 15;
        }
        return 0xC00000 | elementTypeCode | dimensions << 16;
    }

    public static int getStringTypeCode() {
        return 12648463;
    }

    public static String makeArrayClassName(String elementTypeName, int dimensions) {
        if (dimensions == 0) {
            return elementTypeName;
        }
        String arrayName = null;
        arrayName = elementTypeName.equals("boolean") ? "Z" : (elementTypeName.equals("byte") ? "B" : (elementTypeName.equals("char") ? "C" : (elementTypeName.equals("double") ? "D" : (elementTypeName.equals("float") ? "F" : (elementTypeName.equals("int") ? "I" : (elementTypeName.equals("long") ? "J" : (elementTypeName.equals("short") ? "S" : "L" + elementTypeName + ";")))))));
        for (int i = 0; i < dimensions; ++i) {
            arrayName = "[" + arrayName;
        }
        return arrayName;
    }

    public static int getElement0AsInt(Object array, int elementAFTypeCode) {
        switch (elementAFTypeCode) {
            case 15: {
                return 0;
            }
            case 2: {
                byte[] byteArray = (byte[])array;
                byte value = byteArray[0];
                byteArray[0] = 0;
                return value;
            }
            case 4: {
                short[] shortArray = (short[])array;
                short value = shortArray[0];
                shortArray[0] = 0;
                return value;
            }
            case 6: {
                int[] intArray = (int[])array;
                int value = intArray[0];
                intArray[0] = 0;
                return value;
            }
            case 11: {
                boolean[] booleanArray = (boolean[])array;
                int value = booleanArray[0] ? 1 : 0;
                booleanArray[0] = false;
                return value;
            }
            case 12: {
                char[] charArray = (char[])array;
                char value = charArray[0];
                charArray[0] = '\u0000';
                return value;
            }
            case 13: {
                float[] floatArray = (float[])array;
                int value = Float.floatToIntBits(floatArray[0]);
                floatArray[0] = 0.0f;
                return value;
            }
        }
        throw new FatalInternalException("Could not represent element type " + elementAFTypeCode + " as int.");
    }

    public static void setElement0FromInt(Object array, int elementAFTypeCode, int intValue) {
        switch (elementAFTypeCode) {
            case 15: {
                return;
            }
            case 2: {
                byte[] byteArray = (byte[])array;
                byteArray[0] = (byte)intValue;
                break;
            }
            case 4: {
                short[] shortArray = (short[])array;
                shortArray[0] = (short)intValue;
                break;
            }
            case 6: {
                int[] intArray = (int[])array;
                intArray[0] = intValue;
                break;
            }
            case 11: {
                boolean[] booleanArray = (boolean[])array;
                booleanArray[0] = intValue != 0;
                break;
            }
            case 12: {
                char[] charArray = (char[])array;
                charArray[0] = (char)intValue;
                break;
            }
            case 13: {
                float[] floatArray = (float[])array;
                floatArray[0] = Float.intBitsToFloat(intValue);
                break;
            }
            default: {
                throw new FatalInternalException("Could interpret element type " + elementAFTypeCode + " as int.");
            }
        }
    }

    public static boolean isElementValidAsInt(int elementAFTypeCode) {
        switch (elementAFTypeCode) {
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isElementValidAsLong(int elementAFTypeCode) {
        switch (elementAFTypeCode) {
            case 8: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static long getElement0AsLong(Object array, int elementAFTypeCode) {
        switch (elementAFTypeCode) {
            case 8: {
                long[] longArray = (long[])array;
                long value = longArray[0];
                longArray[0] = 0L;
                return value;
            }
            case 14: {
                double[] doubleArray = (double[])array;
                long value = Double.doubleToLongBits(doubleArray[0]);
                doubleArray[0] = 0.0;
                return value;
            }
        }
        throw new FatalInternalException("Could not represent element type " + elementAFTypeCode + " as long.");
    }

    public static void setElement0FromLong(Object array, int elementAFTypeCode, long longValue) {
        switch (elementAFTypeCode) {
            case 8: {
                long[] longArray = (long[])array;
                longArray[0] = longValue;
                break;
            }
            case 14: {
                double[] doubleArray = (double[])array;
                doubleArray[0] = Double.longBitsToDouble(longValue);
                break;
            }
            default: {
                throw new FatalInternalException("Could interpret element type " + elementAFTypeCode + " as long.");
            }
        }
    }

    public static Object getElement0AsObject(Object array, int elementAFTypeCode) {
        switch (elementAFTypeCode) {
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                return new Integer(Utilities.getElement0AsInt(array, elementAFTypeCode));
            }
            case 8: 
            case 14: {
                return new Long(Utilities.getElement0AsLong(array, elementAFTypeCode));
            }
        }
        Object[] objectArray = (Object[])array;
        Object value = objectArray[0];
        objectArray[0] = null;
        return value;
    }

    public static void setElement0FromObject(Object array, int elementAFTypeCode, Object objectValue) {
        switch (elementAFTypeCode) {
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                Utilities.setElement0FromInt(array, elementAFTypeCode, (Integer)objectValue);
                break;
            }
            case 8: 
            case 14: {
                Utilities.setElement0FromLong(array, elementAFTypeCode, (Long)objectValue);
                break;
            }
            default: {
                Object[] objectArray = (Object[])array;
                objectArray[0] = objectValue;
            }
        }
    }

    public static void throwNullArgumentException(String className, String methodName, String argumentName) {
        throw new IllegalArgumentException("The " + argumentName + " argument of " + className + "." + methodName + " was null.");
    }

    public static void parseAndSetProperties(Properties props, String[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            int indx = arg.indexOf("=");
            if (indx == -1) continue;
            String env = arg.substring(0, indx);
            String envVal = arg.substring(indx + 1);
            props.put(env, envVal);
        }
    }

    public static void putIntegerProperty(Properties props, StringBuffer sb, String name, int value) {
        int prefixLength = sb.length();
        sb.append(name);
        props.put(sb.toString(), Integer.toString(value));
        sb.setLength(prefixLength);
    }

    public static String getProperty(Properties plist, String propertyName, String defaultValue) {
        String ret = null;
        String propNameCOM = null;
        if (plist != null) {
            ret = plist.getProperty(propertyName);
            if (ret != null) {
                return ret;
            }
            if (propertyName.startsWith("com.odi") && (ret = plist.getProperty(propNameCOM = "COM" + propertyName.substring(3))) != null) {
                return ret;
            }
        }
        try {
            ret = System.getProperty(propertyName, null);
            if (ret == null) {
                ret = propNameCOM != null ? System.getProperty(propNameCOM, defaultValue) : defaultValue;
            }
            return ret;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    public static boolean getProperty(Properties plist, String propertyName, boolean defaultValue) {
        return Boolean.valueOf(Utilities.getProperty(plist, propertyName, defaultValue ? "true" : "false"));
    }

    public static int getProperty(Properties plist, String propertyName, int defaultValue) {
        String propValue = Utilities.getProperty(plist, propertyName, null);
        return propValue == null ? defaultValue : Integer.parseInt(propValue);
    }

    public static String userClassName(String internalName) {
        if (internalName.charAt(0) != '[') {
            return internalName;
        }
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (internalName.charAt(idx) == '[') {
            buf.append("[]");
            ++idx;
        }
        String baseName = internalName.charAt(idx) == 'L' ? internalName.substring(idx + 1, internalName.length() - 1) : Utilities.getPrimitiveElmentTypeName(internalName.charAt(idx));
        buf.insert(0, baseName);
        return buf.toString();
    }

    public static String getClassVMName(Class cl) {
        if (cl.isPrimitive()) {
            throw new FatalInternalException("Attempt to get VM name for primitive class");
        }
        return cl.getName().replace('.', '/');
    }

    public static String getClassVMName(String className) {
        return className.replace('.', '/');
    }

    public static String getClassSignature(Class cl) {
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl.isArray()) {
            return Utilities.getClassVMName(cl);
        }
        return "L" + Utilities.getClassVMName(cl) + ";";
    }

    public static String getClassNameSignature(String className) {
        if (className.equals(Boolean.TYPE.getName())) {
            return "Z";
        }
        if (className.equals(Byte.TYPE.getName())) {
            return "B";
        }
        if (className.equals(Character.TYPE.getName())) {
            return "C";
        }
        if (className.equals(Short.TYPE.getName())) {
            return "S";
        }
        if (className.equals(Integer.TYPE.getName())) {
            return "I";
        }
        if (className.equals(Long.TYPE.getName())) {
            return "J";
        }
        if (className.equals(Float.TYPE.getName())) {
            return "F";
        }
        if (className.equals(Double.TYPE.getName())) {
            return "D";
        }
        if (className.charAt(0) == '[') {
            return Utilities.getClassVMName(className);
        }
        return "L" + Utilities.getClassVMName(className) + ";";
    }

    public static ByteArrayClassLoader getClassLoader() {
        if (cLoader == null) {
            Utilities.setClassLoader(new ByteArrayClassLoader());
        }
        return cLoader;
    }

    public static void setClassLoader(ByteArrayClassLoader theLoader) {
        cLoader = theLoader;
    }

    public static Class findClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader;
        Class<?> theClass = null;
        try {
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe1) {
            theClass = null;
        }
        if (theClass == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                theClass = Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException cnfe2) {
                theClass = null;
            }
        }
        if (theClass == null) {
            try {
                theClass = Class.forName(className, true, Utilities.getClassLoader());
            }
            catch (ClassNotFoundException cnfe3) {
                theClass = null;
            }
        }
        if (theClass == null) {
            throw new ClassNotFoundException("Class " + className + " not found");
        }
        return theClass;
    }

    public static Class findRegisteredClass(String className) throws ClassNotFoundException {
        Class c = null;
        try {
            c = Utilities.findClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                ClassInfo cInfo = ClassInfo.get(className);
                c = cInfo.getClassDescriptor();
            }
            catch (ClassNotRegisteredException cnre) {
                throw new ClassNotFoundException("Class " + className + " not found in the ClassInfo registry");
            }
        }
        return c;
    }

    static boolean isUserDefinedType(Class type) {
        Class check;
        if (type == String.class) {
            return false;
        }
        Class clazz = check = !type.isArray() ? type : Utilities.getArrayClassElementType(type);
        if (check.isInterface()) {
            return true;
        }
        return Utilities.getPrimitiveOrWrapperTypeCode(check) == 0 && Utilities.getBuiltinTypeCode(check) == 0;
    }
}

