/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.Cluster;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.Utilities;
import com.odi.util.BTree;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeIterator;
import com.odi.util.BTreeIteratorImpl;
import com.odi.util.BTreeLeafNode;
import com.odi.util.BTreeNode;
import com.odi.util.BTreeNodeFactory;
import com.odi.util.KeyType;
import java.io.PrintStream;

public final class BTreeImpl
extends BTree
implements IPersistent,
IPersistentHooks {
    public static boolean debug = false;
    static final short PAGE_SIZE = (short)Utilities.getProperty(null, "com.odi.pageSize", 4096);
    private transient KeyType keyType;
    static final byte[] nullKey = new byte[0];
    private transient byte[] keyBuffer;
    transient Cluster cluster;
    public transient ObjectManager om;
    transient int leafNodeAFTypecode;
    transient int nonLeafNodeAFTypecode;
    transient BTreeNodeFactory nodeFactory = BTreeNodeFactory.instance;
    private transient boolean putFoundEntry;
    private transient Object valueBeforePut;
    private transient Object insertUniqueKeyObject;
    private transient ObjectReference ref;
    public transient byte objectState;
    private static final ClassInfo classInfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.BTreeImpl"));
    private int size;
    private int modifications;
    private BTreeNode top;
    private BTreeNode freeNode;
    private short pageSize;
    private short maxNodeEntries;
    private byte keySize;
    private boolean fixedSizeKeys;
    private boolean duplicateKeys;
    private byte extraByte;
    private static final int DONT_MAINTAIN_SIZE = 2;
    private int extraInt1;
    private int extraInt2;
    private Object extraObject1;
    private Object extraObject2;
    private int inserts;
    private int overflows;
    private int nodesAllocated;
    private int nodesAllocatedFromCache;
    private int heightIncreases;
    private int removes;
    private int underflows;
    private int nodesReturned;
    private int heightDecreases;
    private int keyOverflows;

    KeyType getKeyType() {
        return this.keyType;
    }

    @Override
    public Object get(byte[] key) throws BTreeEntryNotFoundException {
        this.fetch();
        this.checkPersistent();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        BTreeNode node = this.top;
        while (true) {
            int operation;
            int index;
            if ((index = node.find(key, operation = node.getIsLeaf() ? 2 : 1)) < 0) {
                throw new BTreeEntryNotFoundException();
            }
            if (debug) {
                System.out.println("Now getting value at index " + index);
            }
            Object value = node.getValue(index);
            if (node.getIsLeaf()) {
                return value;
            }
            node = (BTreeNode)value;
        }
    }

    @Override
    public boolean containsKey(byte[] key) {
        this.fetch();
        this.checkPersistent();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        BTreeNode node = this.top;
        int operation;
        int index;
        while ((index = node.find(key, operation = node.getIsLeaf() ? 2 : 1)) >= 0) {
            if (node.getIsLeaf()) {
                return true;
            }
            node = node.getChildNode(index);
        }
        return false;
    }

    @Override
    public boolean contains(byte[] key, Object valueObject) {
        ObjectReference value;
        this.fetch();
        this.checkPersistent();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        if (valueObject == null) {
            value = this.om.objRefFactory.getNull();
        } else {
            value = this.om.findObjRef(valueObject, false);
            if (value == null) {
                return false;
            }
        }
        BTreeNode node = this.top;
        int operation;
        int index;
        while ((index = node.find(key, value, operation = node.getIsLeaf() ? 2 : 1)) >= 0) {
            if (node.getIsLeaf()) {
                return true;
            }
            node = node.getChildNode(index);
        }
        return false;
    }

    @Override
    public Object put(byte[] key, Object valueObject) {
        this.fetch();
        return this.put(key, valueObject, this.duplicateKeys, true, false);
    }

    @Override
    public void insertKnownNewValue(byte[] key, Object valueObject) {
        this.fetch();
        this.put(key, valueObject, this.duplicateKeys, false, true);
    }

    @Override
    public Object insertUniqueKey(byte[] key, Object valueObject) {
        this.fetch();
        return this.put(key, valueObject, false, false, false);
    }

    @Override
    public int size() {
        this.fetch();
        this.checkPersistent();
        if (!this.isSizeMaintainedInternal()) {
            this.computeSize();
        }
        return this.size;
    }

    @Override
    public int sizeEstimate() {
        this.fetch();
        this.checkPersistent();
        return this.size;
    }

    @Override
    public boolean isSizeMaintained() {
        this.fetch();
        this.checkPersistent();
        return this.isSizeMaintainedInternal();
    }

    @Override
    public void maintainSize(boolean maintainSize) {
        ObjectStore.dirty(this);
        this.checkPersistent();
        if (!maintainSize) {
            this.extraInt1 |= 2;
        } else if ((this.extraInt1 & 2) != 0) {
            this.extraInt1 &= 0xFFFFFFFD;
            this.computeSize();
        }
    }

    @Override
    public Object remove(byte[] key) throws BTreeEntryNotFoundException {
        this.fetch();
        this.checkPersistent();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        Object removed = this.remove(null, 0, this.top, key, false, null, true);
        if (this.isSizeMaintainedInternal()) {
            ObjectStore.dirty(this);
            ++this.modifications;
            ++this.removes;
            --this.size;
        }
        return removed;
    }

    @Override
    public void remove(byte[] key, Object valueObject) throws BTreeEntryNotFoundException {
        ObjectReference value;
        this.fetch();
        this.checkPersistent();
        if (valueObject == null) {
            value = this.om.objRefFactory.getNull();
        } else {
            value = this.om.findObjRef(valueObject, false);
            if (value == null) {
                throw new BTreeEntryNotFoundException();
            }
        }
        this.removeObjRef(key, value);
    }

    @Override
    public void clear() {
        ObjectStore.dirty(this);
        this.checkPersistent();
        this.clear(this.top);
        if (!this.top.getIsLeaf()) {
            BTreeNode oldTop = this.top;
            this.top = this.allocateNode(true, false);
            this.deallocateNode(oldTop);
        }
        ++this.modifications;
        this.size = 0;
    }

    @Override
    public BTreeIterator iterator() {
        this.checkPersistent();
        return new BTreeIteratorImpl(this, false);
    }

    @Override
    public BTreeIterator reverseIterator() {
        this.checkPersistent();
        return new BTreeIteratorImpl(this, true);
    }

    @Override
    public BTreeIterator iterator(byte[] initialKey) {
        this.checkPersistent();
        return new BTreeIteratorImpl(this, initialKey, false);
    }

    @Override
    public BTreeIterator reverseIterator(byte[] initialKey) {
        this.checkPersistent();
        return new BTreeIteratorImpl(this, initialKey, true);
    }

    @Override
    public byte[] getFirstKey() {
        this.fetch();
        this.checkPersistent();
        BTreeNode node = this.top;
        while (!node.getIsLeaf()) {
            node = node.getChildNode(0);
        }
        if (node.getNumEntries() <= 0) {
            return null;
        }
        return node.getKey(0, null);
    }

    @Override
    public byte[] getLastKey() {
        this.fetch();
        this.checkPersistent();
        BTreeNode node = this.top;
        while (!node.getIsLeaf()) {
            node = node.getChildNode(node.getNumEntries() - 1);
        }
        if (node.getNumEntries() <= 0) {
            return null;
        }
        return node.getKey(node.getNumEntries() - 1, null);
    }

    @Override
    public int getKeySize() {
        this.fetch();
        return this.keySize;
    }

    int getKeySizeInternal() {
        return this.keySize;
    }

    @Override
    public boolean hasFixedSizeKeys() {
        ObjectStore.fetch(this);
        return this.fixedSizeKeys;
    }

    @Override
    public boolean checkValid(PrintStream stream) {
        this.fetch();
        this.checkPersistent();
        return this.top.checkValid(stream, null);
    }

    @Override
    public void printStats(PrintStream stream) {
        this.fetch();
        this.checkPersistent();
        stream.println("Size:                        " + this.size + "\n" + "Modifications:               " + this.modifications + "\n" + "Page size:                   " + this.pageSize + "\n" + "Max node entries:            " + this.maxNodeEntries + "\n" + "Key size:                    " + this.keySize + "\n" + "Fixed size keys:             " + this.fixedSizeKeys + "\n" + "Duplicate keys:              " + this.duplicateKeys + "\n" + "Inserts:                     " + this.inserts + "\n" + "Overflows:                   " + this.overflows + "\n" + "Nodes allocated:             " + this.nodesAllocated + "\n" + "Nodes allocated from cache:  " + this.nodesAllocatedFromCache + "\n" + "Height increases:            " + this.heightIncreases + "\n" + "Removes:                     " + this.removes + "\n" + "Underflows:                  " + this.underflows + "\n" + "Nodes returned:              " + this.nodesReturned + "\n" + "Height decreases:            " + this.heightDecreases + "\n" + "Key overflows:               " + this.keyOverflows + "\n" + "Is size maintained:          " + this.isSizeMaintainedInternal());
    }

    @Override
    public void printContents(PrintStream stream) {
        this.fetch();
        this.checkPersistent();
        this.top.printContents(stream, 0);
    }

    @Override
    public void initializeContents(GenericObject genericObject) {
        this.size = genericObject.getIntField(1, classInfo);
        this.modifications = genericObject.getIntField(2, classInfo);
        this.top = (BTreeNode)genericObject.getClassField(3, classInfo);
        this.freeNode = (BTreeNode)genericObject.getClassField(4, classInfo);
        this.pageSize = genericObject.getShortField(5, classInfo);
        this.maxNodeEntries = genericObject.getShortField(6, classInfo);
        this.keySize = genericObject.getByteField(7, classInfo);
        this.fixedSizeKeys = genericObject.getBooleanField(8, classInfo);
        this.duplicateKeys = genericObject.getBooleanField(9, classInfo);
        this.extraByte = genericObject.getByteField(10, classInfo);
        this.extraInt1 = genericObject.getIntField(11, classInfo);
        this.extraInt2 = genericObject.getIntField(12, classInfo);
        this.extraObject1 = genericObject.getClassField(13, classInfo);
        this.extraObject2 = genericObject.getClassField(14, classInfo);
        this.inserts = genericObject.getIntField(15, classInfo);
        this.overflows = genericObject.getIntField(16, classInfo);
        this.nodesAllocated = genericObject.getIntField(17, classInfo);
        this.nodesAllocatedFromCache = genericObject.getIntField(18, classInfo);
        this.heightIncreases = genericObject.getIntField(19, classInfo);
        this.removes = genericObject.getIntField(20, classInfo);
        this.underflows = genericObject.getIntField(21, classInfo);
        this.nodesReturned = genericObject.getIntField(22, classInfo);
        this.heightDecreases = genericObject.getIntField(23, classInfo);
        this.keyOverflows = genericObject.getIntField(24, classInfo);
    }

    @Override
    public void flushContents(GenericObject genericObject) {
        genericObject.setIntField(1, this.size, classInfo);
        genericObject.setIntField(2, this.modifications, classInfo);
        genericObject.setClassField(3, this.top, classInfo);
        genericObject.setClassField(4, this.freeNode, classInfo);
        genericObject.setShortField(5, this.pageSize, classInfo);
        genericObject.setShortField(6, this.maxNodeEntries, classInfo);
        genericObject.setByteField(7, this.keySize, classInfo);
        genericObject.setBooleanField(8, this.fixedSizeKeys, classInfo);
        genericObject.setBooleanField(9, this.duplicateKeys, classInfo);
        genericObject.setByteField(10, this.extraByte, classInfo);
        genericObject.setIntField(11, this.extraInt1, classInfo);
        genericObject.setIntField(12, this.extraInt2, classInfo);
        genericObject.setClassField(13, this.extraObject1, classInfo);
        genericObject.setClassField(14, this.extraObject2, classInfo);
        genericObject.setIntField(15, this.inserts, classInfo);
        genericObject.setIntField(16, this.overflows, classInfo);
        genericObject.setIntField(17, this.nodesAllocated, classInfo);
        genericObject.setIntField(18, this.nodesAllocatedFromCache, classInfo);
        genericObject.setIntField(19, this.heightIncreases, classInfo);
        genericObject.setIntField(20, this.removes, classInfo);
        genericObject.setIntField(21, this.underflows, classInfo);
        genericObject.setIntField(22, this.nodesReturned, classInfo);
        genericObject.setIntField(23, this.heightDecreases, classInfo);
        genericObject.setIntField(24, this.keyOverflows, classInfo);
    }

    @Override
    public void clearContents() {
        this.size = 0;
        this.modifications = 0;
        this.top = null;
        this.freeNode = null;
        this.pageSize = 0;
        this.maxNodeEntries = 0;
        this.keySize = 0;
        this.fixedSizeKeys = false;
        this.duplicateKeys = false;
        this.extraByte = 0;
        this.extraInt1 = 0;
        this.extraInt2 = 0;
        this.extraObject1 = null;
        this.extraObject2 = null;
        this.inserts = 0;
        this.overflows = 0;
        this.nodesAllocated = 0;
        this.nodesAllocatedFromCache = 0;
        this.heightIncreases = 0;
        this.removes = 0;
        this.underflows = 0;
        this.nodesReturned = 0;
        this.heightDecreases = 0;
        this.keyOverflows = 0;
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public void postInitializeContents() {
        this.maybeSetTransientFields();
    }

    @Override
    public void preDestroyPersistent() {
        this.clear();
        ObjectStore.destroy(this.top);
        ObjectStore.destroy(this.freeNode);
    }

    public BTreeImpl(ClassInfo ignored) {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte value) {
        this.objectState = value;
    }

    private void fetch() {
        if (this.objectState < 0) {
            ObjectManager.fetch(this);
        }
    }

    public BTreeImpl(Placement placement, int keySize, int flags) {
        this(placement, keySize, flags, PAGE_SIZE);
    }

    private BTreeImpl(Placement placement, int keySize, int flags, int pageSize) {
        BTreeNode.odiAssert(pageSize <= Short.MAX_VALUE, "Page size too big");
        this.pageSize = (short)pageSize;
        BTreeNode.odiAssert(keySize <= 127, "Key size too big");
        this.keySize = (byte)keySize;
        this.fixedSizeKeys = (flags & 1) != 0;
        this.duplicateKeys = (flags & 2) != 0;
        this.keyType = this.computeKeyType();
        ObjectStore.migrate(this, placement);
        this.top = BTreeNodeFactory.createTopNode(this);
        this.init(this.top, this.fixedSizeKeys, keySize);
    }

    public BTreeNode getTop() {
        this.fetch();
        return this.top;
    }

    void deallocateNode(BTreeNode node) {
        boolean isSizeMaintained = this.isSizeMaintainedInternal();
        if (isSizeMaintained) {
            ObjectStore.dirty(this);
            ++this.nodesReturned;
        }
        node.setNumEntries((short)-1000);
        if (this.freeNode == null && isSizeMaintained) {
            this.freeNode = node;
        } else {
            ObjectStore.destroy(node);
        }
    }

    void init(BTreeNode top, boolean fixedSizeKeys, int keySize) {
        this.top = top;
        this.fixedSizeKeys = fixedSizeKeys;
        BTreeNode.odiAssert(keySize <= 127, "Key size too big");
        this.keySize = (byte)keySize;
        ObjectManager.migrate(top, Cluster.of(this));
        this.maybeSetTransientFields();
        this.maxNodeEntries = top.maxEntries();
    }

    void removeNoReturn(byte[] key) throws BTreeEntryNotFoundException {
        this.fetch();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        this.remove(null, 0, this.top, key, false, null, false);
        if (this.isSizeMaintainedInternal()) {
            ObjectStore.dirty(this);
            ++this.modifications;
            ++this.removes;
            --this.size;
        }
    }

    void removeObjRef(byte[] key, ObjectReference value) throws BTreeEntryNotFoundException {
        this.fetch();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        this.remove(null, 0, this.top, key, true, value, false);
        if (this.isSizeMaintainedInternal()) {
            ObjectStore.dirty(this);
            ++this.modifications;
            ++this.removes;
            --this.size;
        }
    }

    boolean getDuplicateKeys() {
        this.fetch();
        return this.duplicateKeys;
    }

    @Override
    int getModifications() {
        this.fetch();
        return this.modifications;
    }

    int getPageSize() {
        this.fetch();
        return this.pageSize;
    }

    boolean getFixedSizeKeys() {
        this.fetch();
        return this.fixedSizeKeys;
    }

    void setTop(BTreeNode newTop) {
        ObjectStore.dirty(this);
        this.top = newTop;
    }

    int getMaxNodeEntries() {
        this.fetch();
        return this.maxNodeEntries;
    }

    void incrKeyOverflows() {
        if (this.isSizeMaintainedInternal()) {
            ObjectStore.dirty(this);
            ++this.keyOverflows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object put(byte[] key, Object valueObject, boolean allowDuplicateKeys, boolean replace, boolean knownNewValue) {
        this.checkPersistent();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        BTreeNode newChild = null;
        Object result = null;
        try {
            ObjectReference value;
            if (valueObject == null) {
                value = this.om.objRefFactory.getNull();
            } else {
                value = this.om.findObjRef(valueObject, true);
                if (value == null) {
                    if (replace || allowDuplicateKeys || knownNewValue) {
                        ObjectStore.migrate(valueObject, this.cluster);
                        value = this.om.getObjRef(valueObject);
                    } else {
                        this.insertUniqueKeyObject = valueObject;
                        value = null;
                    }
                }
            }
            this.putFoundEntry = false;
            newChild = this.put(null, 0, this.top, key, value, allowDuplicateKeys, replace, knownNewValue);
            result = this.valueBeforePut;
        }
        finally {
            this.insertUniqueKeyObject = null;
            this.valueBeforePut = null;
        }
        if (this.putFoundEntry) {
            if (!replace) {
                return result;
            }
            if (valueObject == result) {
                return valueObject;
            }
        }
        if (this.isSizeMaintainedInternal()) {
            ObjectStore.dirty(this);
            ++this.modifications;
            ++this.inserts;
            if (!this.putFoundEntry) {
                ++this.size;
            }
        }
        if (newChild != null) {
            ObjectStore.dirty(this);
            BTreeNode oldTop = this.top;
            this.top = this.allocateNode(false, oldTop.getIsLeaf());
            ++this.heightIncreases;
            BTreeNode.odiAssert(this.top.insert(nullKey, this.om.findObjRef(oldTop, true), 0), "Insert failed");
            this.top.updateKey(0, oldTop);
            BTreeNode.odiAssert(this.top.insert(nullKey, this.om.findObjRef(newChild, true), 1), "Insert failed");
            this.top.updateKey(1, newChild);
        }
        return result;
    }

    private BTreeNode put(BTreeNode parent, int nodeIndex, BTreeNode node, byte[] key, ObjectReference value, boolean allowDuplicateKeys, boolean replace, boolean knownNewValue) {
        int childIndex;
        int operation = node.getIsLeaf() ? 3 : 1;
        boolean compareValue = allowDuplicateKeys && !knownNewValue;
        int n = childIndex = compareValue ? node.find(key, value, operation) : node.find(key, operation);
        if (node.getIsLeaf()) {
            boolean present = allowDuplicateKeys && knownNewValue ? false : node.compareLeafEntry(key, allowDuplicateKeys, value, childIndex);
            if (present) {
                this.putFoundEntry = true;
                this.valueBeforePut = node.getValue(childIndex);
                if (replace) {
                    node.setValue(childIndex, value);
                }
                return null;
            }
            if (this.insertUniqueKeyObject != null) {
                ObjectStore.migrate(this.insertUniqueKeyObject, this.cluster);
                value = this.om.getObjRef(this.insertUniqueKeyObject);
            }
        } else {
            if (childIndex < 0) {
                childIndex = 0;
            }
            BTreeNode child = node.getChildNode(childIndex);
            BTreeNode newChild = this.put(node, childIndex, child, key, value, allowDuplicateKeys, replace, knownNewValue);
            if (childIndex == 0 && node.compareKey(key, 0) <= 0) {
                node.updateKey(0, child);
            }
            if (newChild == null) {
                return null;
            }
            key = newChild.getKey(0, null);
            value = this.om.findObjRef(newChild, true);
            ++childIndex;
        }
        if (node.insert(key, value, childIndex)) {
            return null;
        }
        if (this.isSizeMaintainedInternal()) {
            ObjectStore.dirty(this);
            ++this.overflows;
        }
        if (parent != null && this.insertRebalance(parent, nodeIndex, node, key, value, childIndex)) {
            return null;
        }
        return this.insertSplit(parent, nodeIndex, node, key, value, childIndex);
    }

    private boolean insertRebalance(BTreeNode parent, int childIndex, BTreeNode child, byte[] key, ObjectReference value, int valueIndex) {
        ObjectStore.dirty(this);
        BTreeNode left = null;
        int leftEntries = this.maxNodeEntries;
        if (childIndex != 0) {
            left = parent.getChildNode(childIndex - 1);
            leftEntries = left.getNumEntries();
        }
        BTreeNode right = null;
        int rightEntries = this.maxNodeEntries;
        if (childIndex != parent.getNumEntries() - 1) {
            right = parent.getChildNode(childIndex + 1);
            rightEntries = right.getNumEntries();
        }
        if (leftEntries == this.maxNodeEntries && rightEntries == this.maxNodeEntries) {
            return false;
        }
        BTreeNode neighbor = leftEntries < rightEntries ? left : right;
        int move = (1 + this.maxNodeEntries - neighbor.getNumEntries()) / 2;
        if (move == 1 && neighbor == right && valueIndex == this.maxNodeEntries) {
            child = right;
            ++childIndex;
            valueIndex = 0;
        } else if (move == 1 && neighbor == left && valueIndex == 0) {
            child = left;
            --childIndex;
            valueIndex = left.getNumEntries();
        } else if (neighbor == left) {
            child.moveEntries(0, left, left.getNumEntries(), move);
            parent.updateKey(childIndex, child);
            if ((valueIndex -= move) < 0) {
                child = left;
                --childIndex;
                valueIndex += left.getNumEntries();
            }
        } else {
            child.moveEntries(child.getNumEntries() - move, right, 0, move);
            parent.updateKey(childIndex + 1, right);
            if (valueIndex > this.maxNodeEntries - move) {
                child = right;
                ++childIndex;
                valueIndex = valueIndex + move - this.maxNodeEntries;
            }
        }
        BTreeNode.odiAssert(valueIndex >= 0, "Bad index");
        BTreeNode.odiAssert(child.insert(key, value, valueIndex), "Insert failed");
        if (valueIndex == 0) {
            parent.updateKey(childIndex, child);
        }
        return true;
    }

    private BTreeNode insertSplit(BTreeNode parent, int nodeIndex, BTreeNode node, byte[] key, ObjectReference value, int valueIndex) {
        ObjectStore.dirty(this);
        boolean nodeIsLeaf = node.getIsLeaf();
        BTreeNode newNode = this.allocateNode(nodeIsLeaf, nodeIsLeaf ? false : node.getChildNode(0).getIsLeaf());
        int move = this.maxNodeEntries / 2;
        node.moveEntries(this.maxNodeEntries - move, newNode, 0, move);
        int numNodeEntries = node.getNumEntries();
        if (valueIndex >= numNodeEntries) {
            node = newNode;
            ++nodeIndex;
            valueIndex -= numNodeEntries;
        }
        BTreeNode.odiAssert(valueIndex >= 0, "Bad index");
        BTreeNode.odiAssert(node.insert(key, value, valueIndex), "Insert failed");
        if (parent != null && valueIndex == 0 && node != newNode) {
            parent.updateKey(nodeIndex, node);
        }
        return newNode;
    }

    private Object remove(BTreeNode parent, int nodeIndex, BTreeNode node, byte[] key, boolean compareValue, ObjectReference value, boolean returnValue) throws BTreeEntryNotFoundException {
        Object removed;
        int childIndex;
        int operation = node.getIsLeaf() ? 2 : 1;
        int n = childIndex = !compareValue ? node.find(key, operation) : node.find(key, value, operation);
        if (childIndex < 0) {
            if (node.getIsLeaf()) {
                throw new BTreeEntryNotFoundException();
            }
            childIndex = 0;
        }
        if (node.getIsLeaf()) {
            removed = returnValue ? node.getValue(childIndex) : null;
        } else {
            int moveToIndex;
            BTreeNode child = node.getChildNode(childIndex);
            boolean isLeftmost = node.compareKey(key, childIndex) <= 0;
            removed = this.remove(node, childIndex, child, key, compareValue, value, returnValue);
            if (isLeftmost) {
                node.updateKey(childIndex, child);
            }
            if (child.getNumEntries() >= this.maxNodeEntries / 2) {
                return removed;
            }
            if (this.isSizeMaintainedInternal()) {
                ObjectStore.dirty(this);
                ++this.underflows;
            }
            if ((moveToIndex = this.underflowRebalance(node, childIndex, child)) < 0) {
                return removed;
            }
            BTreeNode moveTo = node.getChildNode(moveToIndex);
            boolean moveToLeft = moveToIndex < childIndex;
            child.moveEntries(0, moveTo, moveToIndex < childIndex ? moveTo.getNumEntries() : 0, child.getNumEntries());
            if (!moveToLeft) {
                node.updateKey(moveToIndex, moveTo);
            }
        }
        node.remove(childIndex);
        if (parent != null && childIndex == 0) {
            parent.updateKey(nodeIndex, node);
        }
        if (parent == null && node.getNumEntries() == 1 && !node.getIsLeaf()) {
            ObjectStore.dirty(this);
            ++this.heightDecreases;
            BTreeNode newTop = node.getChildNode(0);
            this.deallocateNode(this.top);
            this.top = newTop;
        }
        return removed;
    }

    private int underflowRebalance(BTreeNode parent, int childIndex, BTreeNode child) {
        int min;
        ObjectStore.dirty(this);
        BTreeNode left = null;
        int leftEntries = 0;
        if (childIndex != 0) {
            left = parent.getChildNode(childIndex - 1);
            leftEntries = left.getNumEntries();
        }
        BTreeNode right = null;
        int rightEntries = 0;
        if (childIndex != parent.getNumEntries() - 1) {
            right = parent.getChildNode(childIndex + 1);
            rightEntries = right.getNumEntries();
        }
        if (leftEntries <= (min = this.maxNodeEntries / 2) && rightEntries <= min) {
            BTreeNode.odiAssert(rightEntries != 0 || leftEntries != 0, "No siblings");
            if (rightEntries == 0) {
                return childIndex - 1;
            }
            if (leftEntries == 0) {
                return childIndex + 1;
            }
            return leftEntries < rightEntries ? childIndex - 1 : childIndex + 1;
        }
        BTreeNode neighbor = leftEntries > rightEntries ? left : right;
        int move = (1 + neighbor.getNumEntries() - child.getNumEntries()) / 2;
        if (neighbor == left) {
            left.moveEntries(left.getNumEntries() - move, child, 0, move);
            parent.updateKey(childIndex, child);
        } else {
            right.moveEntries(0, child, child.getNumEntries(), move);
            parent.updateKey(childIndex + 1, right);
        }
        return -1;
    }

    private void clear(BTreeNode node) {
        ObjectStore.dirty(this);
        if (!node.getIsLeaf()) {
            for (int i = 0; i < node.getNumEntries(); ++i) {
                BTreeNode child = node.getChildNode(i);
                this.clear(child);
                this.deallocateNode(child);
            }
        }
        node.clear();
    }

    private BTreeNode allocateNode(boolean isLeaf, boolean childrenAreLeaves) {
        boolean isSizeMaintained = this.isSizeMaintainedInternal();
        if (isSizeMaintained) {
            ObjectStore.dirty(this);
            ++this.nodesAllocated;
        }
        if (this.freeNode != null && isSizeMaintained && this.freeNode.getIsLeaf() == isLeaf) {
            BTreeNode result = this.freeNode;
            this.freeNode = null;
            result.setNumEntries((short)0);
            result.setChildrenAreLeaves(childrenAreLeaves);
            ++this.nodesAllocatedFromCache;
            return result;
        }
        BTreeNode result = BTreeNodeFactory.createNode(this, this.top, isLeaf);
        ObjectManager.migrate(result, this.cluster);
        return result;
    }

    private void maybeSetTransientFields() {
        if (this.keyBuffer != null) {
            return;
        }
        this.keyBuffer = new byte[this.keySize];
        this.cluster = Cluster.of(this);
        this.keyType = this.computeKeyType();
        this.om = (ObjectManager)this.cluster.getSession();
        this.leafNodeAFTypecode = this.om.getClassAFTypeCode(BTreeNodeFactory.newNodeClassName(this, this.top, true));
        this.nonLeafNodeAFTypecode = this.om.getClassAFTypeCode(BTreeNodeFactory.newNodeClassName(this, this.top, false));
    }

    private void checkPersistent() {
        if (!ObjectStore.isPersistent(this)) {
            throw new ObjectNotFoundException("Attempt to use a B-tree that was created in an aborted transaction or after the database containing it was closed with retainAsTransient set to true.");
        }
    }

    private boolean isSizeMaintainedInternal() {
        return (this.extraInt1 & 2) == 0;
    }

    private KeyType computeKeyType() {
        ReferenceType TOP_NODE_TYPE = this.getTopNodeType();
        if (this.fixedSizeKeys) {
            if (this.keySize == 4) {
                return KeyType.KEY_4BYTE;
            }
            if (this.keySize == 8) {
                return KeyType.KEY_8BYTE;
            }
        } else {
            if (TOP_NODE_TYPE == ReferenceType.REF_4BYTE_LOCAL) {
                return KeyType.VARKEY_4BYTEREF;
            }
            if (TOP_NODE_TYPE == ReferenceType.REF_8BYTE_LOCAL) {
                return KeyType.VARKEY_8BYTEREF;
            }
        }
        throw new UnsupportedOperationException("not implemented for keySize = " + this.keySize);
    }

    ReferenceType getTopNodeType() {
        return ReferenceType.DEFAULT;
    }

    private void computeSize() {
        BTreeNode nonLeafNode = this.top;
        while (!nonLeafNode.getIsLeaf()) {
            nonLeafNode = nonLeafNode.getChildNode(0);
        }
        BTreeLeafNode node = (BTreeLeafNode)nonLeafNode;
        this.size = 0;
        while (true) {
            boolean nodeWasHollow = node.ODIgetState() < 0;
            this.size += node.getNumEntries();
            Reference nextRef = node.getNextLeafRef();
            if (nextRef == node.REFTYPE().NULL()) break;
            if (nodeWasHollow) {
                ObjectStore.evict(node, 2);
            }
            node = (BTreeLeafNode)nextRef.resolve(this.cluster, this.leafNodeAFTypecode);
        }
    }
}

