/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ExternalReference;
import com.odi.ObjectNotFoundException;
import com.odi.StaleEnumeratorException;
import com.odi.Transaction;
import com.odi.imp.ByteIterator;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeIterator;
import com.odi.util.BTreeLeafNode;
import com.odi.util.BTreeNode;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public final class BTreeIteratorImpl
extends BTreeIterator {
    private BTreeImpl btree;
    private ExternalReference btreeRef = new ExternalReference();
    private int modifications;
    private BTreeLeafNode node;
    private ExternalReference nodeRef = new ExternalReference();
    private int index = -1;
    private boolean reverse = false;
    private boolean removed = false;
    private byte[] keyBuffer1;
    private byte[] keyBuffer2;
    private byte[] matchBuffer;
    private Transaction lastTransaction;
    private BTreeNode.KeyByteIterator currentKeyByteIterator;

    @Override
    public boolean hasNext() {
        this.checkStale();
        return this.hasNextInternal();
    }

    @Override
    public Object next() {
        this.advance();
        return this.currentValue();
    }

    @Override
    public byte[] currentKey(byte[] keyBuffer) {
        this.checkValid();
        return this.node.getKey(this.index, keyBuffer);
    }

    @Override
    public int compareKey(byte[] key) {
        this.checkValid();
        return this.node.compareKey(key, this.index);
    }

    @Override
    public ByteIterator currentKeyByteIterator() {
        this.checkValid();
        if (this.currentKeyByteIterator == null) {
            this.currentKeyByteIterator = this.node.keyByteIterator(this.index);
        } else {
            this.currentKeyByteIterator.reset(this.node, this.index);
        }
        return this.currentKeyByteIterator;
    }

    @Override
    public Object currentValue() {
        this.checkValid();
        return this.node.getValue(this.index);
    }

    @Override
    public void advance() {
        this.checkStale();
        if (this.node == null) {
            throw new NoSuchElementException("No next element in iterator.");
        }
        this.removed = false;
        if (this.reverse) {
            --this.index;
            if (this.index >= 0) {
                return;
            }
            if (this.node.getPrevLeafRef().isNull()) {
                throw new NoSuchElementException("No next element in iterator.");
            }
            this.setNode(this.node.getPrevLeaf());
            this.index = this.node.getNumEntries() - 1;
        } else {
            ++this.index;
            if (this.index < this.node.getNumEntries()) {
                return;
            }
            if (this.node.getNextLeafRef().isNull()) {
                throw new NoSuchElementException("No next element in iterator.");
            }
            this.setNode(this.node.getNextLeaf());
            this.index = 0;
        }
    }

    @Override
    public boolean advanceToSubstringMatch(String substring, boolean caseInsensitive) {
        this.checkStale();
        char[] chars = substring.toCharArray();
        int numBytes = ObjectAccess.UTF8Length(chars, chars.length);
        if (this.matchBuffer == null || this.matchBuffer.length <= numBytes) {
            this.matchBuffer = new byte[numBytes];
        }
        ObjectAccess.encodeString(this.matchBuffer, 0, chars, chars.length);
        this.removed = false;
        BTreeLeafNode n = this.node;
        int ix = this.index;
        boolean found = false;
        while (n != null && !found) {
            if ((ix = n.findSubstringMatch(ix + 1, this.matchBuffer, caseInsensitive)) < n.getNumEntries()) {
                found = true;
                continue;
            }
            n = n.getNextLeaf();
            ix = -1;
        }
        this.setNode(n);
        this.index = ix;
        return found;
    }

    @Override
    public void remove() {
        int resetDuplicates;
        Object resetValue;
        byte[] resetKey;
        ObjectReference removalValue;
        int removalIndex;
        BTreeLeafNode removalNode;
        byte[] removalKey;
        block19: {
            this.checkValid();
            if (this.keyBuffer1 == null) {
                this.keyBuffer1 = new byte[this.btree.getKeySize()];
                this.keyBuffer2 = new byte[this.btree.getKeySize()];
            }
            removalKey = this.node.getKey(this.index, this.keyBuffer1);
            removalNode = this.node;
            removalIndex = this.index;
            removalValue = null;
            try {
                removalValue = this.btree.getDuplicateKeys() ? this.btree.om.getObjRef(this.node.getValue(this.index), false) : null;
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            resetKey = null;
            resetValue = null;
            resetDuplicates = 0;
            if (this.hasNextInternal()) {
                this.advance();
                resetKey = this.node.getKey(this.index, this.keyBuffer2);
                if (this.btree.getDuplicateKeys()) {
                    try {
                        resetValue = this.node.getValue(this.index);
                    }
                    catch (ObjectNotFoundException e) {
                        if (this.compareKey(removalKey) != 0) break block19;
                        this.reset(resetKey, false, null);
                        while (this.node != removalNode || this.index != removalIndex) {
                            ++resetDuplicates;
                            this.advance();
                        }
                    }
                }
            }
        }
        try {
            if (this.btree.getDuplicateKeys()) {
                if (removalValue != null) {
                    this.btree.removeObjRef(removalKey, removalValue);
                } else {
                    removalNode.setValue(removalIndex, this.btree.om.getObjRef(this.btree, false));
                    this.btree.remove(removalKey, this.btree);
                }
            } else {
                this.btree.removeNoReturn(removalKey);
            }
        }
        catch (BTreeEntryNotFoundException e) {
            BTreeNode.odiAssert(false, "Entry not found");
        }
        this.removed = true;
        this.modifications = this.btree.getModifications();
        if (resetKey == null) {
            this.setNode(null);
        } else if (resetValue != null) {
            this.reset(resetKey, this.btree.getDuplicateKeys(), resetValue);
        } else {
            this.reset(resetKey, false, null);
            while (resetDuplicates-- > 0) {
                this.advance();
            }
        }
    }

    BTreeIteratorImpl(BTreeImpl btree, boolean inReverse) {
        this.init(btree, inReverse);
        BTreeNode n = btree.getTop();
        while (!n.getIsLeaf()) {
            int childIndex = this.reverse ? n.getNumEntries() - 1 : 0;
            n = n.getChildNode(childIndex);
        }
        this.setNode((BTreeLeafNode)n);
        this.index = this.reverse ? this.node.getNumEntries() : -1;
    }

    BTreeIteratorImpl(BTreeImpl btree, byte[] firstKey, boolean inReverse) {
        this.init(btree, inReverse);
        this.reset(firstKey, false, null);
    }

    private void init(BTreeImpl btree, boolean inReverse) {
        this.setBtree(btree);
        this.reverse = inReverse;
        this.modifications = btree.getModifications();
        this.lastTransaction = Transaction.current();
    }

    private void reset(byte[] firstKey, boolean compareValue, Object value) {
        BTreeNode n = this.btree.getTop();
        while (!n.getIsLeaf()) {
            int childIndex;
            if (this.reverse) {
                childIndex = n.find(firstKey, null, 3);
                if (childIndex < 0) {
                    childIndex = n.getNumEntries() - 1;
                }
            } else {
                childIndex = n.find(firstKey, null, 1);
                if (childIndex < 0) {
                    childIndex = 0;
                }
            }
            n = n.getChildNode(childIndex);
        }
        this.setNode((BTreeLeafNode)n);
        if (compareValue) {
            ObjectReference objRef = this.btree.om.getObjRef(value, false);
            this.index = this.reverse ? this.node.find(firstKey, objRef, 1) : this.node.find(firstKey, objRef, 3);
        } else {
            this.index = this.reverse ? this.node.find(firstKey, 1) : this.node.find(firstKey, 3);
        }
        if (!compareValue && this.btree.getDuplicateKeys()) {
            while (true) {
                if (this.reverse) {
                    if (this.index == this.node.getNumEntries() - 1) {
                        int nextIndex;
                        BTreeLeafNode next = this.node.getNextLeaf();
                        if (next == null || next.compareKey(firstKey, nextIndex = 0) != 0) break;
                        this.setNode(next);
                        this.index = nextIndex;
                        continue;
                    }
                    if (this.node.compareKey(firstKey, this.index + 1) != 0) break;
                    ++this.index;
                    continue;
                }
                if (this.index == 0) {
                    int prevIndex;
                    BTreeLeafNode previous = this.node.getPrevLeaf();
                    if (previous == null || previous.compareKey(firstKey, prevIndex = previous.getNumEntries() - 1) != 0) break;
                    this.setNode(previous);
                    this.index = prevIndex;
                    continue;
                }
                if (this.node.compareKey(firstKey, this.index - 1) != 0) break;
                --this.index;
            }
        }
        this.index = this.reverse ? ++this.index : --this.index;
    }

    private void checkStale() {
        if (this.lastTransaction.isAborted()) {
            throw new StaleEnumeratorException();
        }
        if (!this.lastTransaction.isActive()) {
            this.lastTransaction = Transaction.current();
            this.btree = (BTreeImpl)this.btreeRef.getObject();
            this.node = (BTreeLeafNode)this.nodeRef.getObject();
        }
        if (this.btree.getModifications() != this.modifications) {
            throw new ConcurrentModificationException("The associated collection was modified while iterating.");
        }
    }

    private void checkValid() {
        this.checkStale();
        if (this.removed || this.index < 0 || this.node == null) {
            throw new IllegalStateException("The next method hasn't been called, or this element was removed");
        }
    }

    private boolean hasNextInternal() {
        if (this.node == null) {
            return false;
        }
        if (this.reverse) {
            if (this.index > 0) {
                return true;
            }
            return !this.node.getPrevLeafRef().isNull();
        }
        if (this.index + 1 < this.node.getNumEntries()) {
            return true;
        }
        return !this.node.getNextLeafRef().isNull();
    }

    private void setBtree(BTreeImpl btree) {
        this.btree = btree;
        ObjectManager.setExtRef(btree, this.btreeRef);
    }

    private void setNode(BTreeLeafNode node) {
        this.node = node;
        ObjectManager.setExtRef(node, this.nodeRef);
    }
}

