/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.LazyMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

abstract class LazyMapMap
extends LazyMap {
    LazyMapMap() {
    }

    public Object get(Object pkey, Object skey, Object[] creationParams) {
        LazyMap map = (LazyMap)super.get(pkey, null);
        return map.get(skey, creationParams);
    }

    protected abstract Object createNew(Object var1, Object var2, Object[] var3);

    @Override
    protected final Object createNew(final Object pkey, Object[] creationParams) {
        return new LazyMap(){

            @Override
            public Object createNew(Object skey, Object[] cpms) {
                return LazyMapMap.this.createNew(pkey, skey, cpms);
            }
        };
    }

    @Override
    public int size() {
        if (super.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (Map map : this.values()) {
            count += map.size();
        }
        return count;
    }

    public Iterator allValues() {
        return new LeafIterator(this);
    }

    public void clearValues() {
        for (Map map : this.values()) {
            map.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        if (super.isEmpty()) {
            return true;
        }
        for (Map map : this.values()) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        class TestObject {
            String s;
            int i;

            TestObject(String s, Integer I) {
                this.s = s;
                this.i = I;
            }

            public String toString() {
                return this.s + " = " + this.i;
            }
        }
        LazyMapMap testMap = new LazyMapMap(){

            @Override
            public Object createNew(Object pkey, Object skey, Object[] creationParams) {
                String s = (String)pkey;
                Integer i = (Integer)skey;
                return new TestObject(s, i);
            }
        };
        int N_ENTRIES = 10000;
        if (args.length > 0) {
            N_ENTRIES = Integer.parseInt(args[0]);
        }
        for (int i = 0; i < N_ENTRIES; ++i) {
            TestObject t = (TestObject)testMap.get("" + i, new Integer(i), null);
            System.err.print("Created object " + t + "\r");
        }
        System.err.println("testMap created successfully with " + N_ENTRIES + " elements");
        if (testMap.size() != N_ENTRIES) {
            throw new RuntimeException("Test FAILED: testMap.size() != 100");
        }
        System.err.println("size() test PASSED");
        boolean[] visited = new boolean[N_ENTRIES];
        Iterator itr = testMap.allValues();
        while (itr.hasNext()) {
            TestObject t = (TestObject)itr.next();
            System.err.print("found element " + t + "\r");
            visited[t.i] = true;
        }
        System.err.println();
        for (int i = 0; i < visited.length; ++i) {
            if (visited[i]) continue;
            throw new RuntimeException("TestFailed: Entry " + i + " was not visited during iteration");
        }
        System.err.println("iterator() test PASSED");
        testMap.clearValues();
        if (!testMap.isEmpty()) {
            throw new RuntimeException("Test FAILED: testMap.size() after clearing != 0");
        }
        System.err.println("clearValues() test PASSED");
        if (!testMap.isEmpty()) {
            throw new RuntimeException("Test FAILED: isEmpty() returns false when there are no entries");
        }
        System.err.println("isEmpty() test PASSED");
        System.err.println("TEST SUCCESSFUL");
    }

    class LeafIterator
    implements Iterator {
        Iterator itrOverMaps;
        Iterator itrOverValues;

        public LeafIterator(Map map) {
            this.itrOverMaps = map.values().iterator();
            if (this.itrOverMaps.hasNext()) {
                this.itrOverValues = ((Map)this.itrOverMaps.next()).values().iterator();
            }
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            return this.itrOverValues.next();
        }

        @Override
        public boolean hasNext() {
            if (this.itrOverValues == null) {
                return false;
            }
            if (!this.itrOverValues.hasNext() && this.itrOverMaps.hasNext()) {
                this.itrOverValues = ((Map)this.itrOverMaps.next()).values().iterator();
            }
            return this.itrOverValues.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove on LeafIterator not implemented");
        }
    }
}

