/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.NoSessionException;
import com.odi.imp.ObjectReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class OSAbstractSet
implements IPersistent,
IPersistentHooks,
Set {
    private transient ObjectReference ODIRef;
    public transient byte ODIObjectState;

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ODIRef;
    }

    @Override
    public final void ODIsetRef(ObjectReference objRef) {
        this.ODIRef = objRef;
    }

    @Override
    public final byte ODIgetState() {
        return this.ODIObjectState;
    }

    @Override
    public final void ODIsetState(byte state) {
        this.ODIObjectState = state;
    }

    @Override
    public void initializeContents(GenericObject genObj) {
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void flushContents(GenericObject genObj) {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void clearContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public void preDestroyPersistent() {
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator e = this.iterator();
        int i = 0;
        while (e.hasNext()) {
            result[i] = e.next();
            ++i;
        }
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                modified = this.add(iter.next());
            }
            return modified;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                modified = this.remove(iter.next()) || modified;
            }
            return modified;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set s = (Set)obj;
        return s.size() == this.size() && this.containsAll((Collection)s);
    }

    @Override
    public int hashCode() {
        int hash;
        block3: {
            hash = 0;
            try {
                for (Object obj : this) {
                    if (obj == null) continue;
                    hash += obj.hashCode();
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                throw e;
            }
        }
        return hash;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    static {
        ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSAbstractSet"));
    }
}

