/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysLogger;
import java.io.FileWriter;
import java.io.IOException;

public class SysLoggerDefault
extends SysLogger {
    private boolean init;
    private boolean enabled;
    private FileWriter writer;

    private SysLoggerDefault() {
    }

    private void init() {
        if (!this.init) {
            String string = SysConfig.getConfigValue(SysConfig.getProperties(), "bb.logger.device", "stdout");
            try {
                this.setDevice(string);
            }
            catch (IOException iOException) {
                System.err.println("Blackbird Logger: Failed to open logger trace device '" + string + "' [" + iOException.getMessage() + "]. Defaulting to standard output stream.");
            }
            this.init = true;
        }
    }

    public static SysLoggerDefault create() {
        return new SysLoggerDefault();
    }

    public final void setDevice(String string) throws IOException {
        this.writer = null;
        this.enabled = string.compareToIgnoreCase("null") != 0;
        if (this.enabled && string.compareToIgnoreCase("stdout") != 0) {
            this.writer = new FileWriter(string, true);
        }
    }

    @Override
    public final void out(String string) {
        this.init();
        if (this.enabled) {
            if (this.writer != null) {
                try {
                    this.writer.write(string, 0, string.length());
                    this.writer.flush();
                }
                catch (IOException iOException) {
                    System.err.println("Blackbird Logger: Failed to write trace message to trace device [" + iOException.getMessage() + "]. Trace message sent to standard output stream.");
                    System.out.print(string);
                }
            } else {
                System.out.print(string);
            }
        }
    }
}

