/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

public abstract class SysStatistics {
    private Thread thread;
    private int interval;

    protected abstract void init();

    protected abstract void dump();

    public void startDump(int n) throws IllegalStateException {
        if (this.thread != null) {
            throw new IllegalStateException("Background thread already started");
        }
        this.interval = n;
        this.thread = new Thread(){

            @Override
            public void run() {
                SysStatistics.this.init();
                while (SysStatistics.this.interval > 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(SysStatistics.this.interval * 1000);
                        SysStatistics.this.dump();
                    }
                    catch (InterruptedException interruptedException) {
                        SysStatistics.this.interval = 0;
                    }
                }
                SysStatistics.this.thread = null;
            }
        };
        this.thread.start();
    }

    public void stopDump() {
        if (this.thread != null) {
            this.interval = 0;
            while (true) {
                try {
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

