/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.tools.interactive;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.ObjectArrayList;
import com.progress.blackbird.evs.EEvsObjectBusyException;
import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.nio.EvsDPCPort;
import com.progress.blackbird.evs.nio.EvsDispatcher;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionEventHandler;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IOMultiNetworkConnection;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionEvents;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.multi.IOMultiConnection;
import com.progress.blackbird.io.multi.IOMultiConnectionEvents;
import com.progress.blackbird.io.multi.IOMultiConnectionWeightedFlowBalancer;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketData;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionPacketManager;
import com.progress.blackbird.pdu.PDUPacketNetworkConnectionPingPacketManager;
import com.progress.blackbird.pdu.PDUPacketSerializer;
import com.progress.blackbird.sys.SysTrace;
import com.progress.blackbird.tools.interactive.Base;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class Connection
extends Base {
    private BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private ReaderThread readerThread = new ReaderThread();
    private ObjectArrayList connections = new ObjectArrayList();
    private SysTrace trace = SysTrace.create(0);
    private static int CONNECTION_TYPE_NETWORK = 0;
    private static int CONNECTION_TYPE_MULTI = 1;
    private static int CONNECTION_TYPE_MULTI_NETWORK = 2;
    private static int CONNECTION_TYPE_MULTI_NETWORK_PASSIVE = 3;

    private Connection() throws Exception {
    }

    private void traceOut(String string) {
        this.trace.outln(Thread.currentThread().getName() + ": " + string, 4);
    }

    private void out(String string) {
        System.out.println(string);
    }

    private ManagedConnection getManagedConnection(int n) {
        ManagedConnection managedConnection = null;
        if (n >= 0 && n < this.connections.size()) {
            managedConnection = (ManagedConnection)this.connections.get(n);
        } else {
            this.out("Invalid index [" + n + "]");
        }
        return managedConnection;
    }

    private void processList() {
        this.out("Managed connection list (count=" + this.connections.size() + ")");
        this.connections.forEach(new ObjectProcedure(){

            @Override
            public final boolean apply(Object object) {
                Connection.this.out("\t" + Connection.this.connections.indexOf(object, false) + object.toString());
                return true;
            }
        });
    }

    private void processSSLCiphers() {
        try {
            int n;
            SSLContext sSLContext = SSLContext.getInstance("ssl");
            sSLContext.init(null, null, null);
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            this.out("Supported cipher suites");
            for (n = 0; n < sSLEngine.getSupportedCipherSuites().length; ++n) {
                this.out("...." + sSLEngine.getSupportedCipherSuites()[n]);
            }
            this.out("\nEnabled cipher suites");
            for (n = 0; n < sSLEngine.getEnabledCipherSuites().length; ++n) {
                this.out("...." + sSLEngine.getEnabledCipherSuites()[n]);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.out("SSL protocol not available in default JSSE provider implementation");
        }
        catch (KeyManagementException keyManagementException) {
            this.out("Failed to initialize SSL context [" + keyManagementException.getMessage() + "]");
        }
    }

    private void processSSLProtocols() {
        try {
            int n;
            SSLContext sSLContext = SSLContext.getInstance("ssl");
            sSLContext.init(null, null, null);
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            this.out("Supported protocols");
            for (n = 0; n < sSLEngine.getSupportedProtocols().length; ++n) {
                this.out("...." + sSLEngine.getSupportedProtocols()[n]);
            }
            this.out("\nEnabled protocols");
            for (n = 0; n < sSLEngine.getEnabledProtocols().length; ++n) {
                this.out("...." + sSLEngine.getEnabledProtocols()[n]);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.out("SSL protocol not available in default JSSE provider implementation");
        }
        catch (KeyManagementException keyManagementException) {
            this.out("Failed to initialize SSL context [" + keyManagementException.getMessage() + "]");
        }
    }

    private boolean processConnect(String string) {
        this.out("Establishing connection to " + string + "...");
        IIOConnection iIOConnection = null;
        try {
            iIOConnection = IONetworkConnection.create(true, string, true, (IIOPacketSerializer)PDUPacketSerializer.create(), PDUPacketNetworkConnectionPingPacketManager.create(), null);
            iIOConnection.connect();
            NetworkConnection networkConnection = new NetworkConnection(iIOConnection, string);
            this.connections.add(networkConnection);
            this.out("Connection " + networkConnection + " successfully created.");
            return true;
        }
        catch (EIOException eIOException) {
            this.out("Connection establishment failed [" + eIOException.getMessage() + "].");
            if (iIOConnection != null) {
                try {
                    iIOConnection.close();
                }
                catch (Exception exception) {
                    this.out("Failed to close connection after failed connect attempt [" + exception.getMessage() + "]");
                }
            }
            return false;
        }
    }

    private boolean processMConnect(String[] stringArray) {
        String string = "Establishing connection to [";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + "]...";
        this.out(string);
        MultiNetworkConnection multiNetworkConnection = new MultiNetworkConnection();
        try {
            IIOConnection iIOConnection;
            multiNetworkConnection.ioConnection = iIOConnection = IOMultiNetworkConnection.create(true, stringArray, true, null, PDUPacketSerializer.create(), PDUPacketNetworkConnectionPingPacketManager.create(), multiNetworkConnection, PDUPacketMultiConnectionPacketManager.create(), IOMultiConnectionWeightedFlowBalancer.create(), null);
            multiNetworkConnection.ioConnection.connect();
            this.connections.add(multiNetworkConnection);
            this.out("Connection " + multiNetworkConnection + " successfully created.");
            return true;
        }
        catch (EIOException eIOException) {
            this.out("Connection establishment failed [" + eIOException.getMessage() + "].");
            try {
                multiNetworkConnection.close();
            }
            catch (Exception exception) {
                this.out("Failed to close connection after failed connect attempt [" + exception.getMessage() + "]");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAccept(String string) {
        this.out("Accepting connection through " + string + "...");
        IIOConnection iIOConnection = null;
        try {
            iIOConnection = IONetworkConnection.create(false, string, true, (IIOPacketSerializer)PDUPacketSerializer.create(), PDUPacketNetworkConnectionPingPacketManager.create(), null);
            IIOConnection iIOConnection2 = iIOConnection.accept(30000);
            NetworkConnection networkConnection = new NetworkConnection(iIOConnection2, string);
            this.connections.add(networkConnection);
            this.out("Connection " + networkConnection + " successfully accepted.");
            boolean bl = true;
            return bl;
        }
        catch (EIOException eIOException) {
            this.out("Connection acceptance failed [" + eIOException.getMessage() + "].");
        }
        finally {
            if (iIOConnection != null) {
                try {
                    iIOConnection.close();
                }
                catch (Exception exception) {
                    this.out("Failed to close passive connection upon completion of accept [" + exception + "]");
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMAccept(boolean bl, String[] stringArray) {
        String string = "Accepting multi-connection through [";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + "] (keepOpen=" + bl + ")";
        this.out(string);
        MultiNetworkConnectionPassive multiNetworkConnectionPassive = new MultiNetworkConnectionPassive();
        MultiNetworkConnection multiNetworkConnection = new MultiNetworkConnection();
        try {
            IIOConnection iIOConnection;
            IIOConnection iIOConnection2;
            multiNetworkConnectionPassive.ioConnection = iIOConnection2 = IOMultiNetworkConnection.create(false, stringArray, true, null, PDUPacketSerializer.create(), PDUPacketNetworkConnectionPingPacketManager.create(), multiNetworkConnection, PDUPacketMultiConnectionPacketManager.create(), IOMultiConnectionWeightedFlowBalancer.create(), null);
            multiNetworkConnection.ioConnection = iIOConnection = multiNetworkConnectionPassive.ioConnection.accept(30000);
            this.connections.add(multiNetworkConnection);
            this.out("Connection " + multiNetworkConnection + " successfully accepted.");
            boolean bl2 = true;
            return bl2;
        }
        catch (EIOException eIOException) {
            this.out("Connection acceptance failed [" + eIOException.getMessage() + "].");
        }
        finally {
            if (!bl) {
                try {
                    multiNetworkConnectionPassive.close();
                }
                catch (Exception exception) {
                    this.out("Failed to close passive multi connection upon completion of accept [" + exception + "]");
                }
            } else {
                this.out("Keeping passive multi network connection open.");
                this.connections.add(multiNetworkConnectionPassive);
            }
        }
        return false;
    }

    private void processMulti(int[] nArray) {
        Object object;
        ObjectArrayList objectArrayList = new ObjectArrayList();
        ObjectArrayList objectArrayList2 = new ObjectArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            object = this.getManagedConnection(nArray[i]);
            if (object == null) continue;
            if (!((ManagedConnection)object).isStarted()) {
                objectArrayList.add(object);
                objectArrayList2.add(((ManagedConnection)object).ioConnection);
                continue;
            }
            this.out("Connection #" + nArray[i] + "-" + object + "- is already started. Multi-connection needs stopped connections. Ignoring connection.");
        }
        if (objectArrayList2.size() > 0) {
            MultiConnection multiConnection = new MultiConnection();
            try {
                multiConnection.ioConnection = object = IOMultiConnection.create((IIOConnection[])objectArrayList2.toArray(new IIOConnection[objectArrayList2.size()]), multiConnection, PDUPacketMultiConnectionPacketManager.create(), IOMultiConnectionWeightedFlowBalancer.create(), true, null);
                this.connections.add(multiConnection);
                this.out("Multi-connection created successfully. Removing individual connections from list");
                objectArrayList.forEach(new ObjectProcedure(){

                    @Override
                    public final boolean apply(Object object) {
                        ManagedConnection managedConnection = (ManagedConnection)object;
                        Connection.this.connections.delete(managedConnection, false);
                        return true;
                    }
                });
                this.out("Individual connections removed successfully. Multi-connection creation complete.");
            }
            catch (Exception exception) {
                this.out("Failed to create multi-connection [" + exception.getMessage() + "]");
            }
        } else {
            this.out("None of the specified managed connections are valid. Cannot create multi-connection");
        }
    }

    private void processAdd(int n, int n2) {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        ManagedConnection managedConnection2 = this.getManagedConnection(n2);
        if (managedConnection != null && managedConnection2 != null) {
            if (managedConnection2 instanceof MultiConnection) {
                try {
                    this.readerThread.addManagedConnectionToMultiConnection(managedConnection, (MultiConnection)managedConnection2);
                    this.out("Connection" + managedConnection + " successfully added to" + managedConnection2 + "Removing src from list");
                    this.connections.delete(managedConnection, false);
                }
                catch (Exception exception) {
                    this.out("Failed to add connection [" + exception.getMessage() + "]");
                }
            } else {
                this.out("Destination connection is not a multi-connection");
            }
        }
    }

    private void processStart(int n) {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        if (managedConnection != null) {
            this.out("Starting connection" + managedConnection + "...");
            try {
                this.readerThread.startManagedConnection(managedConnection);
                this.out("Connection" + managedConnection + " successfully started.");
            }
            catch (Exception exception) {
                this.out("Failed to start connection [" + exception + "]");
            }
        }
    }

    private void processRawWrite(int n, int n2, String string, int n3, boolean bl) throws Exception {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        if (managedConnection != null) {
            PDUPacket pDUPacket = this.createPacket(string, this.reader);
            pDUPacket.getHeader().setFlow(n2);
            this.out("Writing " + n3 + " copies of the packet through connection" + managedConnection + "...");
            try {
                managedConnection.write(pDUPacket, n3, bl);
                this.out("Packets written successfully");
            }
            catch (Exception exception) {
                this.out("Failed to write all packets through connection [" + exception.getMessage() + "]");
            }
        }
    }

    private void processWrite(int n, int n2, int n3, int n4, boolean bl) throws Exception {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        if (managedConnection != null) {
            PDUPacketData pDUPacketData = PDUPacketData.create(new byte[n3], n3);
            pDUPacketData.getHeader().setFlow(n2);
            this.out("Writing " + n4 + " copies of the data packet (datalen=" + n3 + ") through connection" + managedConnection + "...");
            try {
                managedConnection.write(pDUPacketData, n4, bl);
                this.out("Packets written successfully");
                if (managedConnection instanceof MultiNetworkConnection) {
                    this.out("In doubt packet list...");
                    List list = ((IOMultiNetworkConnection)managedConnection.ioConnection).getInDoubtPackets();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.out("\t" + (IIOPacket)iterator.next());
                    }
                }
            }
            catch (Exception exception) {
                this.out("Failed to write all packets through connection [" + exception.getMessage() + "]");
            }
        }
    }

    private void processFlush(int n) {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        if (managedConnection != null) {
            this.out("Flushing connection" + managedConnection + "...");
            try {
                managedConnection.flush();
                this.out("Connection" + managedConnection + " successfully flushed.");
                if (managedConnection instanceof MultiNetworkConnection) {
                    this.out("In doubt packet list...");
                    List list = ((IOMultiNetworkConnection)managedConnection.ioConnection).getInDoubtPackets();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.out("\t" + (IIOPacket)iterator.next());
                    }
                }
            }
            catch (Exception exception) {
                this.out("Failed to flush connection [" + exception.getMessage() + "]");
            }
        }
    }

    private void processStop(int n) {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        if (managedConnection != null) {
            this.out("Stopping connection" + managedConnection + "...");
            try {
                this.readerThread.stopManagedConnection(managedConnection);
                this.out("Connection" + managedConnection + " successfully stopped.");
            }
            catch (Exception exception) {
                this.out("Failed to stop connection [" + exception.getMessage() + "]");
            }
        }
    }

    private void processClose(int n) {
        ManagedConnection managedConnection = this.getManagedConnection(n);
        if (managedConnection != null) {
            this.out("Closing connection" + managedConnection + "...");
            try {
                managedConnection.close();
                this.out("Connection" + managedConnection + " successfully closed.");
                this.connections.delete(managedConnection, false);
                this.out("Connection" + managedConnection + " successfully deleted from list.");
            }
            catch (Exception exception) {
                this.out("Failed to close connection [" + exception.getMessage() + "]");
            }
        }
    }

    private void processBye() {
        this.out("Closing managed connections...");
        this.connections.forEach(new ObjectProcedure(){

            @Override
            public final boolean apply(Object object) {
                ManagedConnection managedConnection = (ManagedConnection)object;
                try {
                    managedConnection.close();
                }
                catch (Exception exception) {
                    Connection.this.out("Failed to close connection" + managedConnection + "[" + exception.getMessage() + "]");
                }
                return true;
            }
        });
        this.out("Goodbye");
    }

    final void run() {
        try {
            Thread.currentThread().setName("Main");
            this.readerThread.start();
            System.out.println("Type 'help' for the list of supported commands");
            while (true) {
                int n;
                String[] stringArray;
                System.out.print("> ");
                String string = this.reader.readLine();
                if (string == null) break;
                if (string.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                String string2 = stringTokenizer.nextToken();
                if (stringTokenizer.countTokens() > 0) {
                    stringArray = new String[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        stringArray[n2++] = stringTokenizer.nextToken();
                    }
                } else {
                    stringArray = new String[]{};
                }
                if (string2.compareToIgnoreCase("bye") == 0 || string2.compareToIgnoreCase("exit") == 0) {
                    this.processBye();
                    break;
                }
                if (string2.compareToIgnoreCase("list") == 0) {
                    this.processList();
                    continue;
                }
                if (string2.compareToIgnoreCase("sslciphers") == 0) {
                    this.processSSLCiphers();
                    continue;
                }
                if (string2.compareToIgnoreCase("sslprotocols") == 0) {
                    this.processSSLProtocols();
                    continue;
                }
                if (string2.compareToIgnoreCase("connect") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: connect <url>");
                        continue;
                    }
                    this.processConnect(stringArray[0]);
                    continue;
                }
                if (string2.compareToIgnoreCase("mconnect") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: mconnect <url1> <url2> ... <urlN>");
                        continue;
                    }
                    this.processMConnect(stringArray);
                    continue;
                }
                if (string2.compareToIgnoreCase("accept") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: accept <url>");
                        continue;
                    }
                    this.processAccept(stringArray[0]);
                    continue;
                }
                if (string2.compareToIgnoreCase("maccept") == 0) {
                    if (stringArray.length < 2) {
                        System.out.println("Syntax error: maccept <keepOpen> <url1> <url2> ... <urlN>");
                        continue;
                    }
                    String[] stringArray2 = new String[stringArray.length - 1];
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray2[n] = stringArray[n + 1];
                    }
                    this.processMAccept(new Boolean(stringArray[0]), stringArray2);
                    continue;
                }
                if (string2.compareToIgnoreCase("multi") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: multi <index1> <index2> ... <indexN>");
                        continue;
                    }
                    int[] nArray = new int[stringArray.length];
                    for (n = 0; n < nArray.length; ++n) {
                        nArray[n] = new Integer(stringArray[n]);
                    }
                    this.processMulti(nArray);
                    continue;
                }
                if (string2.compareToIgnoreCase("add") == 0) {
                    if (stringArray.length < 2) {
                        System.out.println("Syntax error: add <srcIndex> <destIndex>");
                        continue;
                    }
                    this.processAdd(new Integer(stringArray[0]), new Integer(stringArray[1]));
                    continue;
                }
                if (string2.compareToIgnoreCase("start") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: start <mamaged connection index>");
                        continue;
                    }
                    this.processStart(new Integer(stringArray[0]));
                    continue;
                }
                if (string2.compareToIgnoreCase("rawwrite") == 0) {
                    if (stringArray.length < 5) {
                        System.out.println("Syntax error: rawwrite <index> <flow> <type name> <count> <copy>");
                        continue;
                    }
                    this.processRawWrite(new Integer(stringArray[0]), new Integer(stringArray[1]), stringArray[2], new Integer(stringArray[3]), new Boolean(stringArray[4]));
                    continue;
                }
                if (string2.compareToIgnoreCase("write") == 0) {
                    if (stringArray.length < 5) {
                        System.out.println("Syntax error: write <index> <flow> <dataLength> <count> <copy>");
                        continue;
                    }
                    this.processWrite(new Integer(stringArray[0]), new Integer(stringArray[1]), new Integer(stringArray[2]), new Integer(stringArray[3]), new Boolean(stringArray[4]));
                    continue;
                }
                if (string2.compareToIgnoreCase("flush") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: flush <index>");
                        continue;
                    }
                    this.processFlush(new Integer(stringArray[0]));
                    continue;
                }
                if (string2.compareToIgnoreCase("stop") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: stop <mamaged connection index>");
                        continue;
                    }
                    this.processStop(new Integer(stringArray[0]));
                    continue;
                }
                if (string2.compareToIgnoreCase("close") == 0) {
                    if (stringArray.length < 1) {
                        System.out.println("Syntax error: close <mamaged connection index>");
                        continue;
                    }
                    this.processClose(new Integer(stringArray[0]));
                    continue;
                }
                if (string2.compareToIgnoreCase("level") == 0) {
                    if (stringArray.length < 2) {
                        System.out.println("Syntax error: level <module> <level>");
                        continue;
                    }
                    this.processLevel(stringArray[0], stringArray[1]);
                    continue;
                }
                if (string2.compareToIgnoreCase("dumplog") == 0) {
                    this.processDumpLog();
                    continue;
                }
                if (string2.compareToIgnoreCase("help") == 0) {
                    if (stringArray.length != 0) continue;
                    String string3 = "";
                    string3 = string3 + "List of supported commands:";
                    string3 = string3 + "\n";
                    string3 = string3 + "list                                                  Display managed connection list";
                    string3 = string3 + "\n";
                    string3 = string3 + "ciphers                                               Displays supported and default enabled SSL cipher suites";
                    string3 = string3 + "\n";
                    string3 = string3 + "connect <url>                                         Establish a single network connection to a specified URL";
                    string3 = string3 + "\n";
                    string3 = string3 + "mconnect <url1> <url2> ... <urlN>                     Establish a multi network connection to a specified set of URLs";
                    string3 = string3 + "\n";
                    string3 = string3 + "accept <url>                                          Accept a single network connection through a specified URL";
                    string3 = string3 + "\n";
                    string3 = string3 + "maccept <keepOpen> <url1> <url2> ... <urlN>           Accept a multi network connection through a specified set of URLs. <keepOpen> specifies whether the passive multi-network connection used to accept the mc is kept open after the accept completes (successfully or failed)";
                    string3 = string3 + "\n";
                    string3 = string3 + "multi <index1> ... <indexN>                           Create a multi-connection using a set of network connection (specified by connection indices - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "add <srcIndex> <destIndex>                            Add a managed connection (specified by srcIndex) to a multi-connection (specified by destIndex). (list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "start <index>                                         Start a managed connection (specified by connection index - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "rawwrite <index> <flow> <packet type> <count> <copy>  Interactively create and write a set of packets of a specified type through a managed connection (specified by connection index - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "write <index> <flow> <datalength> <count> <copy>      Write a set of data packets of specified length through a managed connection (specified by connection index - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "flush <index>                                         Flush a managed connection (specified by connection index - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "stop <index>                                          Stop a managed connection (specified by connection index - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "close <index>                                         Close a managed connection (specified by connection index - list connections to obtain index)";
                    string3 = string3 + "\n";
                    string3 = string3 + "dumplog                                               Dumps trace log history to standard output stream";
                    string3 = string3 + "\n";
                    string3 = string3 + "level <package> <level>                               Set package traceOut level. Valid package names are:";
                    string3 = string3 + "                                                      Valid package names are:\n";
                    string3 = string3 + "                                                          'link'    -  com.progress.blackbird.nwlink package (includes all protocol specific links)\n";
                    string3 = string3 + "                                                          'evs'     -  com.progress.blackbird.evs.nio package\n";
                    string3 = string3 + "                                                          'io'      -  com.progress.blackbird.io.evs package\n";
                    string3 = string3 + "                                                          'multi'   -  com.progress.blackbird.io.multi package\n";
                    string3 = string3 + "                                                          'pdu'     -  com.progress.blackbird.pdu\n";
                    string3 = string3 + "                                                          'clkrnl'  -  com.progress.blackbird.client.kernel\n";
                    string3 = string3 + "                                                          'client'  -  com.progress.blackbird.client\n";
                    string3 = string3 + "                                                          'all'     -  all above packages\n";
                    string3 = string3 + "                                                      Valid levels are:\n";
                    string3 = string3 + "                                                          'err','error','1'        - Puts out only error messages\n";
                    string3 = string3 + "                                                          'warn','warning','2'     - Puts out error + warning messages\n";
                    string3 = string3 + "                                                          'info','information','3' - Puts out error + warning + informational messages\n";
                    string3 = string3 + "                                                          'verbose','4'            - Puts out error + warning + informational + verbose messages\n";
                    string3 = string3 + "                                                          'dbg','debug','9'        - Puts out error + warning + informational + verbose + debug messages";
                    string3 = string3 + "\n";
                    string3 = string3 + "bye/exit                                              Exits this program";
                    System.out.println(string3);
                    continue;
                }
                System.out.println("Unknown command [" + string2 + "]");
            }
            this.readerThread.stop();
        }
        catch (Exception exception) {
            System.out.println("Unhandled exception [" + exception + ", " + exception.getMessage() + "]");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new Connection().run();
    }

    private class MultiConnection
    extends ManagedConnection
    implements IIOConnectionEventHandler {
        MultiConnection() {
            super(CONNECTION_TYPE_MULTI, null, null);
        }

        final void add(IIOConnection iIOConnection) throws Exception {
            ((IOMultiConnection)this.ioConnection).add(iIOConnection);
        }

        @Override
        public final void handleEvent(int n, Object object) {
            switch (n) {
                case 100: {
                    IOMultiConnectionEvents.ConnectionAddEventData connectionAddEventData = (IOMultiConnectionEvents.ConnectionAddEventData)object;
                    Connection.this.out("MultiConnection event [CONNECTION ADD, " + connectionAddEventData.connection + "]");
                    break;
                }
                case 101: {
                    IOMultiConnectionEvents.ConnectionRemoveEventData connectionRemoveEventData = (IOMultiConnectionEvents.ConnectionRemoveEventData)object;
                    Connection.this.out("MultiConnection event [CONNECTION REMOVE, " + connectionRemoveEventData.connection + ", " + connectionRemoveEventData.cause + "]");
                }
            }
        }

        public final String toString() {
            return " [multi, count=" + ((IOMultiConnection)this.ioConnection).getConnectionCount() + ", " + (this.isStarted() ? "started" : "stopped") + ", " + (this.isClosed() ? "closed" : "open") + "] ";
        }
    }

    private class MultiNetworkConnectionPassive
    extends ManagedConnection {
        MultiNetworkConnectionPassive() {
            super(CONNECTION_TYPE_MULTI_NETWORK_PASSIVE, null, null);
        }

        public final String toString() {
            return " [multinwp, " + (this.isClosed() ? "closed" : "open") + "] ";
        }
    }

    private class MultiNetworkConnection
    extends ManagedConnection
    implements IIOConnectionEventHandler {
        MultiNetworkConnection() {
            super(CONNECTION_TYPE_MULTI_NETWORK, null, null);
        }

        @Override
        public final void handleEvent(int n, Object object) {
            switch (n) {
                case 300: {
                    IOMultiNetworkConnectionEvents.ConnectionConnectFailEventData connectionConnectFailEventData = (IOMultiNetworkConnectionEvents.ConnectionConnectFailEventData)object;
                    Connection.this.out("MultiNetworkConnection event [CONNECTION CONNECT FAIL, " + connectionConnectFailEventData.descriptor + ", " + connectionConnectFailEventData.cause + "]");
                    break;
                }
                case 301: {
                    IOMultiNetworkConnectionEvents.ConnectionUpEventData connectionUpEventData = (IOMultiNetworkConnectionEvents.ConnectionUpEventData)object;
                    Connection.this.out("MultiNetworkConnection event [CONNECTION  UP, " + connectionUpEventData.descriptor + "]");
                    break;
                }
                case 302: {
                    IOMultiNetworkConnectionEvents.ConnectionDownEventData connectionDownEventData = (IOMultiNetworkConnectionEvents.ConnectionDownEventData)object;
                    Connection.this.out("MultiNetworkConnection event [CONNECTION  DOWN, " + connectionDownEventData.descriptor + ", " + connectionDownEventData.cause + "]");
                }
            }
        }

        public final String toString() {
            return " [multinw, " + (this.isStarted() ? "started" : "stopped") + ", " + (this.isClosed() ? "closed" : "open") + "] ";
        }
    }

    private class NetworkConnection
    extends ManagedConnection {
        NetworkConnection(IIOConnection iIOConnection, String string) {
            super(CONNECTION_TYPE_NETWORK, iIOConnection, string);
        }

        public final String toString() {
            return " [nw, " + (String)this.data + ", " + (this.isStarted() ? "started" : "stopped") + ", " + (this.isClosed() ? "closed" : "open") + "] ";
        }
    }

    private class ManagedConnection
    implements IIOConnectionPacketHandler {
        final int type;
        final Object data;
        IIOConnection ioConnection;
        volatile boolean closed;

        ManagedConnection(int n, IIOConnection iIOConnection, Object object) {
            this.type = n;
            this.ioConnection = iIOConnection;
            this.data = object;
        }

        final void start(IEvsDispatcher iEvsDispatcher) throws Exception {
            try {
                this.ioConnection.read(iEvsDispatcher, this);
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new Exception("Connection is closed");
            }
            catch (EIOConnectionFailedException eIOConnectionFailedException) {
                throw new Exception("Connection has failed");
            }
            catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
                throw new Exception("Connection already started");
            }
            catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
                throw new InternalError("'Stream closed' exception thrown when trying to open stream!");
            }
        }

        final boolean isStarted() {
            try {
                return this.ioConnection.isInboundStreamOpen();
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                return false;
            }
            catch (EIOException eIOException) {
                Connection.this.traceOut("Received exception while checking if connection is started [" + eIOException.getMessage() + "]");
                return false;
            }
        }

        final void write(IIOPacket iIOPacket, int n, boolean bl) throws Exception {
            try {
                for (int i = 0; i < n; ++i) {
                    this.ioConnection.write(bl ? (IIOPacket)iIOPacket.clone() : iIOPacket, null, bl ? 1 : 0);
                }
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new Exception("Connection is closed");
            }
            catch (EIOConnectionFailedException eIOConnectionFailedException) {
                throw new Exception("Connection has failed");
            }
            catch (EIOFlushPendingException eIOFlushPendingException) {
                throw new InternalError("Flush pending async completion when no async flush has been submitted!");
            }
        }

        final void flush() throws Exception {
            try {
                this.ioConnection.flush(null);
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new Exception("Connection is closed");
            }
            catch (EIOConnectionFailedException eIOConnectionFailedException) {
                throw new Exception("Connection has failed");
            }
            catch (EIOFlushPendingException eIOFlushPendingException) {
                throw new InternalError("Flush pending async completion when no async flush has been submitted!");
            }
        }

        final void stop() throws Exception {
            try {
                this.ioConnection.read(null, null);
            }
            catch (EIOConnectionClosedException eIOConnectionClosedException) {
                throw new Exception("Connection is closed");
            }
            catch (EIOConnectionFailedException eIOConnectionFailedException) {
                throw new Exception("Connection has failed");
            }
            catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
                throw new Exception("Connection not started");
            }
            catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
                throw new InternalError("'Stream open' exception thrown when trying to close stream!");
            }
        }

        final void close() throws Exception {
            try {
                if (this.ioConnection != null) {
                    this.ioConnection.close();
                }
                this.closed = true;
            }
            catch (EIOInboundStreamOpenException eIOInboundStreamOpenException) {
                throw new Exception("Connection is currently started (needs to be stopped before it can be closed)");
            }
            catch (EIOFlushPendingException eIOFlushPendingException) {
                throw new Exception("Async flush pending completion on connection");
            }
        }

        final boolean isClosed() {
            return this.closed;
        }

        @Override
        public final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
            if (eIOException == null) {
                Connection.this.out("Received packet " + iIOPacket);
            } else {
                Connection.this.out("Connection " + this + " failed [" + eIOException.getMessage() + "]");
                try {
                    this.close();
                }
                catch (Exception exception) {
                    Connection.this.traceOut("Failed to close connection on failure [" + exception.getMessage() + "]");
                }
            }
        }
    }

    private class ReaderThread
    implements IEvsPortEventHandler,
    Runnable {
        private volatile boolean flgRunning;
        private Thread thread;
        private IEvsDispatcher dispatcher = EvsDispatcher.create("Reader", true, null);
        private final int DPC_ACTION_OPCODE_MC_START = 0;
        private final int DPC_ACTION_OPCODE_MC_STOP = 1;
        private final int DPC_ACTION_OPCODE_MULTI_ADD = 2;

        ReaderThread() throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeDPCAction(int n, Object object, boolean bl) throws Exception {
            Connection.this.traceOut("Executing DPC action {opcode=" + n + ", sync=" + bl + ")...");
            DPCAction dPCAction = new DPCAction(n, object, bl);
            EvsDPCPort.create(true).post(this.dispatcher, (byte)15, this, dPCAction);
            if (bl) {
                DPCAction dPCAction2 = dPCAction;
                synchronized (dPCAction2) {
                    while (!dPCAction.complete) {
                        try {
                            dPCAction.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (dPCAction.status != null) {
                    throw dPCAction.status;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeDPCAction(DPCAction dPCAction, Exception exception) {
            Connection.this.traceOut("Completing DPC action {opcode=" + dPCAction.opcode + ", sync=" + dPCAction.sync + ")...");
            DPCAction dPCAction2 = dPCAction;
            synchronized (dPCAction2) {
                dPCAction.complete = true;
                dPCAction.status = exception;
                if (dPCAction.sync) {
                    dPCAction.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void start() {
            if (this.thread == null) {
                Connection.this.traceOut("Starting reader thread...");
                this.thread = new Thread((Runnable)this, "Reader");
                this.thread.start();
                ReaderThread readerThread = this;
                synchronized (readerThread) {
                    while (!this.flgRunning) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        final void startManagedConnection(ManagedConnection managedConnection) throws Exception {
            if (this.thread != Thread.currentThread()) {
                Connection.this.traceOut("Executing DPC action to start managed connection" + managedConnection);
                this.executeDPCAction(0, managedConnection, true);
            } else {
                managedConnection.start(this.dispatcher);
            }
        }

        final void stopManagedConnection(ManagedConnection managedConnection) throws Exception {
            if (this.thread != Thread.currentThread()) {
                Connection.this.traceOut("Executing DPC action to stop managed connection" + managedConnection);
                this.executeDPCAction(1, managedConnection, true);
                do {
                    Connection.this.traceOut("Waiting for managed connection to actually stop" + managedConnection);
                    Thread.currentThread();
                    Thread.sleep(100L);
                } while (managedConnection.isStarted());
            } else {
                managedConnection.stop();
            }
        }

        final void addManagedConnectionToMultiConnection(ManagedConnection managedConnection, MultiConnection multiConnection) throws Exception {
            if (this.thread != Thread.currentThread()) {
                Connection.this.traceOut("Executing DPC action to add managed connection" + managedConnection + "to multi connection" + multiConnection);
                this.executeDPCAction(2, new MultiAddDPCData(managedConnection, multiConnection), true);
            } else {
                multiConnection.add(managedConnection.ioConnection);
            }
        }

        final void stop() {
            if (this.thread != null) {
                Connection.this.traceOut("Stopping...");
                this.flgRunning = false;
                if (this.thread != Thread.currentThread()) {
                    EvsDPCPort.create(true).post(this.dispatcher, (byte)15, this, null);
                    while (true) {
                        try {
                            this.thread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                this.thread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Connection.this.traceOut("Started...");
            try {
                this.dispatcher.acquire();
            }
            catch (EEvsObjectHotException eEvsObjectHotException) {
                throw new InternalError("Failed to acquire dispatcher [" + eEvsObjectHotException.getMessage() + "]");
            }
            catch (EEvsObjectBusyException eEvsObjectBusyException) {
                throw new InternalError("Failed to acquire dispatcher [" + eEvsObjectBusyException.getMessage() + "]");
            }
            ReaderThread readerThread = this;
            synchronized (readerThread) {
                this.flgRunning = true;
                this.notify();
            }
            while (this.flgRunning) {
                try {
                    this.dispatcher.dispatch(-1);
                }
                catch (Exception exception) {
                    Connection.this.traceOut("Received exception from dispatch [" + exception.getMessage() + "] Ignoring...");
                }
            }
            Connection.this.traceOut("Stopped...");
        }

        @Override
        public final void handleEvent(IEvsPortEvent iEvsPortEvent) {
            if (iEvsPortEvent.getData() instanceof DPCAction) {
                DPCAction dPCAction = (DPCAction)iEvsPortEvent.getData();
                Connection.this.traceOut("Received DPC action {opcode=" + dPCAction.opcode + ", sync=" + dPCAction.sync + ")...");
                Exception exception = null;
                try {
                    switch (dPCAction.opcode) {
                        case 0: {
                            this.startManagedConnection((ManagedConnection)dPCAction.opdata);
                            break;
                        }
                        case 1: {
                            this.stopManagedConnection((ManagedConnection)dPCAction.opdata);
                            break;
                        }
                        case 2: {
                            this.addManagedConnectionToMultiConnection(((MultiAddDPCData)dPCAction.opdata).srcMc, ((MultiAddDPCData)dPCAction.opdata).destMc);
                            break;
                        }
                        default: {
                            throw new InternalError("INVALID DPC action opcode!");
                        }
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                this.completeDPCAction(dPCAction, exception);
            }
        }

        private class MultiAddDPCData {
            ManagedConnection srcMc;
            MultiConnection destMc;

            MultiAddDPCData(ManagedConnection managedConnection, MultiConnection multiConnection) {
                this.srcMc = managedConnection;
                this.destMc = multiConnection;
            }
        }

        private class DPCAction {
            int opcode;
            Object opdata;
            boolean sync;
            boolean complete;
            Exception status;

            DPCAction(int n, Object object, boolean bl) {
                this.opcode = n;
                this.opdata = object;
                this.sync = bl;
                this.complete = false;
            }
        }
    }
}

