/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.EncryptionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class PBE {
    private static Class m_pbeClass;
    private static Method m_encryptMethod;
    private static Method m_decryptMethod;

    public static byte[] encrypt(byte[] bytes, String password) throws EncryptionException {
        try {
            return (byte[])m_encryptMethod.invoke(null, bytes, password);
        }
        catch (InvocationTargetException e) {
            PBE.logMessage("Encryption failure, trace follows...", e.getTargetException(), 1);
            throw new EncryptionException("Failed to encrypt data");
        }
        catch (IllegalAccessException e) {
            PBE.logMessage("Encryption failure, trace follows...", e, 1);
            throw new EncryptionException("Failed to encrypt data");
        }
    }

    public static byte[] decrypt(byte[] bytes, String password) throws EncryptionException {
        try {
            return (byte[])m_decryptMethod.invoke(null, bytes, password);
        }
        catch (InvocationTargetException e) {
            PBE.logMessage("Decryption failure, trace follows...", e.getTargetException(), 1);
            throw new EncryptionException("Failed to decrypt data");
        }
        catch (IllegalAccessException e) {
            PBE.logMessage("Decryption failure, trace follows...", e, 1);
            throw new EncryptionException("Failed to decrypt data");
        }
    }

    public static byte[] decrypt(byte[] bytes) throws EncryptionException {
        Object pbeString = null;
        try {
            pbeString = Class.forName("com.sonicsw.mf.framework.agent.PBEString").newInstance();
        }
        catch (ClassNotFoundException e) {
            PBE.logMessage("Encryption classes not found on classpath", e, 1);
            PBE.shutdown(2);
        }
        catch (InstantiationException e) {
            PBE.logMessage("Decryption failure, trace follows...", e, 1);
            throw new EncryptionException("Failed to decrypt data");
        }
        catch (IllegalAccessException e) {
            PBE.logMessage("Decryption failure, trace follows...", e, 1);
            throw new EncryptionException("Failed to decrypt data");
        }
        Method decryptMethod = null;
        try {
            decryptMethod = pbeString.getClass().getDeclaredMethod("decrypt", byte[].class);
        }
        catch (NoSuchMethodException e) {
            PBE.logMessage("Failed to determine crypto routines", e, 1);
            PBE.shutdown(2);
        }
        try {
            return (byte[])decryptMethod.invoke(pbeString, new Object[]{bytes});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException || e.getTargetException() instanceof OutOfMemoryError) {
                return bytes;
            }
            PBE.logMessage("Decryption failure, trace follows...", e.getTargetException(), 1);
            throw new EncryptionException("Failed to decrypt data");
        }
        catch (IllegalAccessException e) {
            PBE.logMessage("Decryption failure, trace follows...", e, 1);
            throw new EncryptionException("Failed to decrypt data");
        }
    }

    private static void logMessage(String message, int severity) {
        PBE.logMessage(message, null, severity);
    }

    private static void logMessage(String message, Throwable e, int severity) {
        IContainer container = null;
        try {
            container = ContainerImpl.getContainer();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (container == null) {
            System.out.println('(' + Level.LEVEL_TEXT[severity] + ')' + message);
            e.printStackTrace(System.out);
        } else {
            container.logMessage(null, message, e, severity);
        }
    }

    private static void shutdown(int exitCode) {
        IContainer container = ContainerImpl.getContainer();
        if (container == null) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            container.shutdown(exitCode);
        }
    }

    static {
        try {
            m_pbeClass = Class.forName("progress.message.crypto.PBETool");
        }
        catch (ClassNotFoundException e) {
            PBE.logMessage("Encryption classes not found on classpath", e, 1);
            ContainerImpl.getContainer().shutdown(2);
        }
        try {
            m_encryptMethod = m_pbeClass.getMethod("readStream", byte[].class, String.class);
            m_decryptMethod = m_pbeClass.getMethod("readPBEStream", byte[].class, String.class);
        }
        catch (NoSuchMethodException e) {
            PBE.logMessage("Failed to determine crypto routines", e, 1);
            PBE.shutdown(2);
        }
    }
}

