/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import java.io.InputStream;
import java.util.Hashtable;

public final class LocalDirectoryServiceProxy
implements IDirectoryAdminService {
    private IDirectoryAdminService m_ds;

    public LocalDirectoryServiceProxy(String xmlData) throws Exception {
        IDirElement dsConfig = ElementFactory.importElementFromXML((String)xmlData, null, (String)"MF_DIRECTORY_SERVICE");
        if (dsConfig == null) {
            dsConfig = ElementFactory.importElementFromXML((String)xmlData, null, (String)"MF_BACKUP_DIRECTORY_SERVICE");
        }
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        String hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        Object tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE");
        if (domainName == null || tmp == null) {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }
        if (!(tmp instanceof IAttributeSet)) {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        IAttributeSet fsStorage = (IAttributeSet)tmp;
        String hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
        String password = (String)fsStorage.getAttribute("PASSWORD");
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDirDepricated != null) {
            directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", hostDirDepricated);
        }
        if (hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        this.m_ds = new DirectoryServiceFactory(directoryEnv).createDirectoryService(domainName);
    }

    public void registerElementChangeHandler(IElementChangeHandler handler) {
        this.checkDS();
        this.m_ds.registerElementChangeHandler(handler);
    }

    public void registerElementChangeHandler(String elementName, IElementChangeHandler handler) {
        this.checkDS();
        this.m_ds.registerElementChangeHandler(elementName, handler);
    }

    private void checkDS() {
        if (this.m_ds == null) {
            throw new RuntimeException("The DS is closed.");
        }
    }

    public void unregisterElementChangeHandler(IElementChangeHandler handler) {
        if (this.m_ds == null) {
            return;
        }
        this.m_ds.unregisterElementChangeHandler(handler);
    }

    public void unregisterElementChangeHandler(String elementName, IElementChangeHandler handler) {
        if (this.m_ds == null) {
            return;
        }
        this.m_ds.unregisterElementChangeHandler(elementName, handler);
    }

    public void close() {
        try {
            if (this.m_ds != null) {
                ((IDirectoryService)this.m_ds).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_ds = null;
    }

    public String getDomain() {
        return null;
    }

    public int getDirectoryServiceVersion() {
        return this.m_ds.getDirectoryServiceVersion();
    }

    public String getDirectoryServiceReleaseVersion() {
        return this.m_ds.getDirectoryServiceReleaseVersion();
    }

    public IView getView() throws DirectoryServiceException {
        return this.m_ds.getView();
    }

    public IView setView(IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.m_ds.setView(view);
    }

    public INextVersionToken setViewGetToken(IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.m_ds.setViewGetToken(view);
    }

    public IDirElement[] getElementIfUpdated(long callerBackupVersion, String elementName, IElementIdentity id) throws DirectoryServiceException {
        return this.m_ds.getElementIfUpdated(callerBackupVersion, elementName, id);
    }

    public IDirElement getElement(String elementName, boolean forUpdate) throws DirectoryServiceException {
        return this.m_ds.getElement(elementName, forUpdate);
    }

    public IDirElement getElement(String elementName, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        return this.m_ds.getElement(elementName, forUpdate, getSubclassingDelta);
    }

    public IDirElement[] getElements(Query query, boolean forUpdate) throws DirectoryServiceException {
        return this.m_ds.getElements(query, forUpdate);
    }

    public IDirElement[] getElements(Query query, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        return this.m_ds.getElements(query, forUpdate, getSubclassingDelta);
    }

    public IBlob getBlob(String elementName, boolean forUpdate) throws DirectoryServiceException {
        return this.m_ds.getBlob(elementName, forUpdate);
    }

    public void detachBlob(IDeltaDirElement delta, IDeltaView view) throws DirectoryServiceException {
        this.m_ds.detachBlob(delta, view);
    }

    public IDirElement[] getAllElements(String dirName, boolean forUpdate) throws DirectoryServiceException {
        return this.m_ds.getAllElements(dirName, forUpdate);
    }

    public IDirElement[] getAllElementsCompressed(String dirName, boolean forUpdate) throws DirectoryServiceException {
        return this.m_ds.getAllElementsCompressed(dirName, forUpdate);
    }

    public void setElementReleaseVersion(String elementName, String newVersion) throws DirectoryServiceException {
        this.m_ds.setElementReleaseVersion(elementName, newVersion);
    }

    public INextVersionToken setElement(IBasicElement element, IDeltaView view) throws DirectoryServiceException {
        return this.m_ds.setElement(element, view);
    }

    public INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view) throws DirectoryServiceException {
        return this.m_ds.setElements(elements, deleteList, view);
    }

    public void attachBlob(IBasicElement element, InputStream blobStream, IDeltaView view) throws DirectoryServiceException {
    }

    public void attachBlob(IBasicElement element, byte[] blob, IDeltaView view) throws DirectoryServiceException {
        if (blob == null) {
            throw new DirectoryServiceException("The blob object cannot be null.");
        }
        this.m_ds.attachBlob(element, blob, view);
    }

    public IElementIdentity deleteElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.m_ds.deleteElement(elementName, view);
    }

    public void unSubclassElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        this.m_ds.unSubclassElement(elementName, view);
    }

    public IDirElement cloneElement(String elementName, String newName, IDeltaView view) throws DirectoryServiceException {
        return this.m_ds.cloneElement(elementName, newName, view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.m_ds.cloneElement(delta, newName, view);
    }

    public IDirElement cloneElement(String elementName, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException {
        return this.m_ds.cloneElement(elementName, newName, createTemplate, view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.m_ds.cloneElement(delta, newName, createTemplate, view);
    }

    public IDirElement subclassElement(IBasicElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.m_ds.subclassElement(delta, newName, view);
    }

    public IIdentity getIdentity(String name) throws DirectoryServiceException {
        return this.m_ds.getIdentity(name);
    }

    public IIdentity lookupIdentity(String name) throws DirectoryServiceException {
        return this.m_ds.lookupIdentity(name);
    }

    public IIdentity[] listAll(String dirName) throws DirectoryServiceException {
        return this.m_ds.listAll(dirName);
    }

    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException {
        return this.m_ds.listDirectories(dirName);
    }

    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException {
        return this.m_ds.listElements(dirName);
    }

    public void createDirectory(String dirName) throws DirectoryServiceException {
        this.m_ds.createDirectory(dirName);
    }

    public void deleteDirectory(String dirName) throws DirectoryServiceException {
        this.m_ds.deleteDirectory(dirName);
    }

    public void deleteDirectory(String dirName, IDeltaView view) throws DirectoryServiceException {
        this.m_ds.deleteDirectory(dirName, view);
    }

    public String exportElementToXML(String elementName) throws DirectoryServiceException {
        return this.m_ds.exportElementToXML(elementName);
    }

    public String exportDSBootFileString(String elementName) throws DirectoryServiceException {
        return this.m_ds.exportDSBootFileString(elementName);
    }

    public String exportDirectoryToXML(String directoryName) throws DirectoryServiceException {
        return this.m_ds.exportDirectoryToXML(directoryName);
    }

    public void dumpContentsToXML() {
        this.m_ds.dumpContentsToXML();
    }

    public void importFromXML(String XMLDocument) throws DirectoryServiceException, InvalidXMLException {
        this.m_ds.importFromXML(XMLDocument);
    }

    public String[] listExternalDomainWithManagementSPI() throws DirectoryServiceException {
        return this.m_ds.listExternalDomainWithManagementSPI();
    }

    public Boolean reloadExternalAuthenticationDomain(String mfDomainDescriptor) throws DirectoryServiceException {
        return this.m_ds.reloadExternalAuthenticationDomain(mfDomainDescriptor);
    }

    public void upgrade5to6(String configType, String configLogicalPath) throws DirectoryServiceException {
        this.m_ds.upgrade5to6(configType, configLogicalPath);
    }

    public IElement[] getElementsByLogicalNames(String[] logicalNames) throws DirectoryServiceException {
        return this.m_ds.getElementsByLogicalNames(logicalNames);
    }

    public IBlob getBlobByLogicalName(String logicalName) throws DirectoryServiceException {
        return this.m_ds.getBlobByLogicalName(logicalName);
    }

    public IBlob getBlobByLogicalName(String unusedSubscriber, String logicalName) throws DirectoryServiceException {
        return this.m_ds.getBlobByLogicalName(logicalName);
    }

    public void startBackup(String backupDir, boolean overwrite) throws DirectoryServiceException {
        this.m_ds.startBackup(backupDir, overwrite);
    }

    public IBackupStatus getBackupStatus() throws DirectoryServiceException {
        return this.m_ds.getBackupStatus();
    }
}

