/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.BTreeKeyNotFoundException;
import com.sonicsw.mtstorage.BTreeValueNotFoundException;
import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeAbstractNode;
import com.sonicsw.mtstorage.impl.BTreeIteratorState;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeLeafNode;
import com.sonicsw.mtstorage.impl.BTreeNode;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;
import java.util.ArrayList;

final class BTree {
    private long m_rootDbk;
    private Logger m_logger;
    private BTreeAbstractBufferSupply m_bufferSupply;
    private boolean m_noDuplicates;
    private BTreeSecondary m_secondary;

    public BTree(Logger logger, BTreeSecondary secondary, boolean noDuplicates, BTreeAbstractBufferSupply bufferSupply, long transactionNum, long useThisDbk) throws IOException {
        this.m_logger = logger;
        this.m_noDuplicates = noDuplicates;
        this.m_bufferSupply = bufferSupply;
        this.m_secondary = secondary;
        AllocatedNode allocatedRoot = this.allocateLeaf(transactionNum, useThisDbk);
        BTreeAbstractNode root = allocatedRoot.m_node;
        this.m_rootDbk = allocatedRoot.m_buffer.m_dbk;
        root.initializeRoot(true);
        allocatedRoot.m_buffer.m_cachedState = root;
        bufferSupply.doneUpdateBuffer(allocatedRoot.m_buffer, transactionNum);
    }

    public BTree(Logger logger, BTreeSecondary secondary, long dbk, BTreeAbstractBufferSupply bufferSupply) throws IOException {
        this.m_logger = logger;
        this.m_bufferSupply = bufferSupply;
        this.m_secondary = secondary;
        this.m_rootDbk = dbk;
        BTreeAbstractNode root = this.nodeFromDbk((long)dbk, (boolean)false).m_node;
        this.m_noDuplicates = root.getUniqueIndex();
    }

    boolean isUnique() {
        return this.m_noDuplicates;
    }

    long getTreeDbk() {
        return this.m_rootDbk;
    }

    byte[] get(byte[] key, byte[] valueBuffer) throws IOException {
        BTreeAbstractNode subTree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        while (!(subTree instanceof BTreeLeafNode)) {
            long dbk = ((BTreeNode)subTree).getNextLevelDbk(key);
            subTree = this.nodeFromDbk((long)dbk, (boolean)false).m_node;
        }
        return subTree.getValue(key, valueBuffer);
    }

    void advance(BTreeIteratorState iterator) throws IOException {
        if (iterator.getAfterLast()) {
            throw new IOException("Tried to advance the iterator over the edge.");
        }
        if (!iterator.isInitialized()) {
            if (iterator.isReverse()) {
                if (iterator.hasInitialKey()) {
                    this.initIteratorBackward(iterator.getInitialKey(), iterator, true);
                } else {
                    this.initIteratorBackward(iterator);
                }
            } else if (iterator.hasInitialKey()) {
                this.initIteratorForward(iterator.getInitialKey(), iterator, true);
            } else {
                this.initIteratorForward(iterator);
            }
        } else if (this.m_noDuplicates) {
            if (iterator.isReverse()) {
                this.initIteratorBackward(iterator.getCurrentKey(), iterator, false);
            } else {
                this.initIteratorForward(iterator.getCurrentKey(), iterator, false);
            }
        } else if (iterator.isReverse()) {
            this.advanceIteratorBackward(iterator);
        } else {
            this.advanceIteratorForward(iterator);
        }
    }

    private void advanceIteratorForward(BTreeIteratorState iterator) throws IOException {
        byte[] currentKey = iterator.getCurrentKey();
        BTreeAbstractNode tree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        iterator.m_keyBuffer.m_buffer = currentKey;
        iterator.m_keyBuffer.m_length = currentKey != null ? currentKey.length : 0;
        iterator.m_keyBuffer.m_offset = 0;
        iterator.m_keyBuffer.m_isNull = currentKey == null;
        iterator.m_keyBuffer.m_isInfinite = false;
        KeyLocation keyLocation = this.findGreaterKeyLocation(tree, iterator.m_keyBuffer, true);
        if (keyLocation == null) {
            iterator.setAfterLast();
            return;
        }
        BTreeLeafNode leaf = (BTreeLeafNode)this.nodeFromDbk((long)keyLocation.m_dbk, (boolean)false).m_node;
        byte[] nextKey = BTree.keyFromBuffer(leaf.getKey(keyLocation.m_position));
        if (!BTreeKeyBuffer.keysEqual(nextKey, currentKey)) {
            iterator.setCurrentKey(nextKey);
            iterator.setCurrentValue(leaf.getFirstEntryValue(keyLocation.m_position, new byte[8]));
        } else {
            try {
                iterator.setCurrentValue(leaf.getNextValue(keyLocation.m_position, iterator.getCurrentValue(), new byte[8]));
            }
            catch (BTreeValueNotFoundException e) {
                this.initIteratorForward(currentKey, iterator, false);
            }
        }
    }

    private void advanceIteratorBackward(BTreeIteratorState iterator) throws IOException {
        byte[] currentKey = iterator.getCurrentKey();
        BTreeAbstractNode tree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        iterator.m_keyBuffer.m_buffer = currentKey;
        iterator.m_keyBuffer.m_length = currentKey != null ? currentKey.length : 0;
        iterator.m_keyBuffer.m_offset = 0;
        iterator.m_keyBuffer.m_isNull = currentKey == null;
        iterator.m_keyBuffer.m_isInfinite = false;
        KeyLocation keyLocation = this.findSmallerKeyLocation(tree, iterator.m_keyBuffer, true);
        if (keyLocation == null) {
            iterator.setAfterLast();
            return;
        }
        BTreeLeafNode leaf = (BTreeLeafNode)this.nodeFromDbk((long)keyLocation.m_dbk, (boolean)false).m_node;
        byte[] prevKey = BTree.keyFromBuffer(leaf.getKey(keyLocation.m_position));
        if (!BTreeKeyBuffer.keysEqual(prevKey, currentKey)) {
            iterator.setCurrentKey(prevKey);
            iterator.setCurrentValue(leaf.getLastEntryValue(keyLocation.m_position, new byte[8]));
        } else {
            try {
                iterator.setCurrentValue(leaf.getPrevValue(keyLocation.m_position, iterator.getCurrentValue(), new byte[8]));
            }
            catch (BTreeValueNotFoundException e) {
                this.initIteratorBackward(currentKey, iterator, false);
            }
        }
    }

    private void initIteratorBackward(byte[] key, BTreeIteratorState iterator, boolean equalOk) throws IOException {
        BTreeAbstractNode tree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        iterator.m_keyBuffer.m_buffer = key;
        iterator.m_keyBuffer.m_length = key != null ? key.length : 0;
        iterator.m_keyBuffer.m_offset = 0;
        iterator.m_keyBuffer.m_isNull = key == null;
        iterator.m_keyBuffer.m_isInfinite = false;
        KeyLocation keyLocation = this.findSmallerKeyLocation(tree, iterator.m_keyBuffer, equalOk);
        if (keyLocation == null) {
            iterator.setAfterLast();
        } else {
            BTreeLeafNode leaf = (BTreeLeafNode)this.nodeFromDbk((long)keyLocation.m_dbk, (boolean)false).m_node;
            iterator.setCurrentKey(BTree.keyFromBuffer(leaf.getKey(keyLocation.m_position)));
            iterator.setCurrentValue(leaf.getLastEntryValue(keyLocation.m_position, new byte[8]));
        }
    }

    private void initIteratorForward(byte[] key, BTreeIteratorState iterator, boolean equalOk) throws IOException {
        BTreeAbstractNode tree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        iterator.m_keyBuffer.m_buffer = key;
        iterator.m_keyBuffer.m_length = key != null ? key.length : 0;
        iterator.m_keyBuffer.m_offset = 0;
        iterator.m_keyBuffer.m_isNull = key == null;
        iterator.m_keyBuffer.m_isInfinite = false;
        KeyLocation keyLocation = this.findGreaterKeyLocation(tree, iterator.m_keyBuffer, equalOk);
        if (keyLocation == null) {
            iterator.setAfterLast();
        } else {
            BTreeLeafNode leaf = (BTreeLeafNode)this.nodeFromDbk((long)keyLocation.m_dbk, (boolean)false).m_node;
            BTreeKeyBuffer.BufferKey keyBuffer = leaf.getKey(keyLocation.m_position);
            if (!keyBuffer.m_isInfinite) {
                iterator.setCurrentKey(BTree.keyFromBuffer(keyBuffer));
                iterator.setCurrentValue(leaf.getFirstEntryValue(keyLocation.m_position, new byte[8]));
            } else {
                iterator.setAfterLast();
            }
        }
    }

    private KeyLocation findSmallerKeyLocation(BTreeAbstractNode tree, BTreeKeyBuffer.BufferKey key, boolean equalOk) throws IOException {
        if (tree instanceof BTreeLeafNode) {
            int position = equalOk ? tree.getKeySmallerEqualPosition(key) : tree.getKeySmallerPosition(key);
            if (position != -1) {
                return new KeyLocation(position, tree.m_dbk);
            }
            return null;
        }
        int nextLevelPosition = ((BTreeNode)tree).getNextLevelPosition(key);
        long dbk = ((BTreeNode)tree).getNextLevelDbk(nextLevelPosition);
        KeyLocation keyLocation = this.findSmallerKeyLocation(this.nodeFromDbk((long)dbk, (boolean)false).m_node, key, equalOk);
        if (keyLocation != null) {
            return keyLocation;
        }
        if (nextLevelPosition > 0) {
            dbk = ((BTreeNode)tree).getNextLevelDbk(nextLevelPosition - 1);
            return this.findLastKeyLocation(this.nodeFromDbk((long)dbk, (boolean)false).m_node);
        }
        return null;
    }

    private KeyLocation findGreaterKeyLocation(BTreeAbstractNode tree, BTreeKeyBuffer.BufferKey key, boolean equalOk) throws IOException {
        if (tree instanceof BTreeLeafNode) {
            int position = equalOk ? tree.getKeyGreaterEqualPosition(key) : tree.getKeyGreaterPosition(key);
            if (position != -1) {
                BTreeKeyBuffer.BufferKey keyFound = tree.getKey(position);
                if (keyFound.m_isInfinite) {
                    return null;
                }
                return new KeyLocation(position, tree.m_dbk);
            }
            return null;
        }
        int nextLevelPosition = ((BTreeNode)tree).getNextLevelPosition(key);
        long dbk = ((BTreeNode)tree).getNextLevelDbk(nextLevelPosition);
        KeyLocation keyLocation = this.findGreaterKeyLocation(this.nodeFromDbk((long)dbk, (boolean)false).m_node, key, equalOk);
        if (keyLocation != null) {
            return keyLocation;
        }
        if (nextLevelPosition + 1 < tree.getNumEntries()) {
            dbk = ((BTreeNode)tree).getNextLevelDbk(nextLevelPosition + 1);
            return this.findFirstKeyLocation(this.nodeFromDbk((long)dbk, (boolean)false).m_node);
        }
        return null;
    }

    private KeyLocation findLastKeyLocation(BTreeAbstractNode tree) throws IOException {
        if (tree instanceof BTreeLeafNode) {
            return new KeyLocation(tree.getNumEntries() - 1, tree.m_dbk);
        }
        int nextLevelPosition = tree.getNumEntries() - 1;
        long dbk = ((BTreeNode)tree).getNextLevelDbk(nextLevelPosition);
        return this.findLastKeyLocation(this.nodeFromDbk((long)dbk, (boolean)false).m_node);
    }

    private KeyLocation findFirstKeyLocation(BTreeAbstractNode tree) throws IOException {
        if (tree instanceof BTreeLeafNode) {
            return new KeyLocation(0, tree.m_dbk);
        }
        long dbk = ((BTreeNode)tree).getNextLevelDbk(0);
        return this.findFirstKeyLocation(this.nodeFromDbk((long)dbk, (boolean)false).m_node);
    }

    private boolean isEmpty(BTreeAbstractNode tree) throws IOException {
        if (tree.getNumEntries() > 1) {
            return false;
        }
        if (tree instanceof BTreeLeafNode) {
            return true;
        }
        long dbk = ((BTreeNode)tree).getNextLevelDbk(0);
        return this.isEmpty(this.nodeFromDbk((long)dbk, (boolean)false).m_node);
    }

    private void initIteratorForward(BTreeIteratorState iterator) throws IOException {
        BTreeAbstractNode tree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        KeyLocation keyLocation = this.findFirstKeyLocation(tree);
        BTreeLeafNode leaf = (BTreeLeafNode)this.nodeFromDbk((long)keyLocation.m_dbk, (boolean)false).m_node;
        BTreeKeyBuffer.BufferKey firstKey = leaf.getKey(keyLocation.m_position);
        if (firstKey.m_isInfinite) {
            iterator.setAfterLast();
        } else {
            iterator.setCurrentKey(BTree.keyFromBuffer(firstKey));
            iterator.setCurrentValue(leaf.getFirstEntryValue(keyLocation.m_position, new byte[8]));
        }
    }

    private void initIteratorBackward(BTreeIteratorState iterator) throws IOException {
        BTreeAbstractNode tree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        iterator.m_keyBuffer.m_isInfinite = true;
        KeyLocation keyLocation = this.findSmallerKeyLocation(tree, iterator.m_keyBuffer, false);
        if (keyLocation == null) {
            iterator.setAfterLast();
            return;
        }
        BTreeLeafNode leaf = (BTreeLeafNode)this.nodeFromDbk((long)keyLocation.m_dbk, (boolean)false).m_node;
        iterator.setCurrentKey(BTree.keyFromBuffer(leaf.getKey(keyLocation.m_position)));
        iterator.setCurrentValue(leaf.getLastEntryValue(keyLocation.m_position, new byte[8]));
    }

    private static byte[] keyFromBuffer(BTreeKeyBuffer.BufferKey key) {
        if (key.m_isNull) {
            return null;
        }
        byte[] retKey = new byte[key.m_length];
        System.arraycopy(key.m_buffer, key.m_offset, retKey, 0, key.m_length);
        return retKey;
    }

    byte[] put(byte[] key, byte[] value, long transactionNum, ArrayList alreadyExists) throws IOException {
        if (this.m_secondary != null) {
            this.m_secondary.setTransNum(transactionNum);
        }
        Object[] oldValue = new Object[1];
        BTreeKeyBuffer.BufferKey bufferKey = new BTreeKeyBuffer.BufferKey(key, 0, key != null ? key.length : 0, false, key == null);
        this.insert(bufferKey, value, oldValue, transactionNum, alreadyExists);
        return (byte[])oldValue[0];
    }

    boolean containsKey(byte[] key) throws IOException {
        BTreeAbstractNode subTree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        while (!(subTree instanceof BTreeLeafNode)) {
            long dbk = ((BTreeNode)subTree).getNextLevelDbk(key);
            subTree = this.nodeFromDbk((long)dbk, (boolean)false).m_node;
        }
        return ((BTreeLeafNode)subTree).containsKey(key);
    }

    boolean isEmpty() throws IOException {
        return this.isEmpty(this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node);
    }

    boolean contains(byte[] key, byte[] value) throws IOException {
        BTreeAbstractNode subTree = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
        while (!(subTree instanceof BTreeLeafNode)) {
            long dbk = ((BTreeNode)subTree).getNextLevelDbk(key);
            subTree = this.nodeFromDbk((long)dbk, (boolean)false).m_node;
        }
        return ((BTreeLeafNode)subTree).containsValue(key, value);
    }

    byte[] remove(byte[] key, long transactionNum, ArrayList alreadyRemoved) throws IOException {
        if (this.m_secondary != null) {
            this.m_secondary.setTransNum(transactionNum);
        }
        BTreeKeyBuffer.BufferKey bufferKey = new BTreeKeyBuffer.BufferKey(key, 0, key != null ? key.length : 0, false, key == null);
        Object[] oldValue = new Object[1];
        this.remove(this.nodeFromDbk(this.m_rootDbk, false), bufferKey, null, transactionNum, oldValue, alreadyRemoved);
        return (byte[])oldValue[0];
    }

    void remove(byte[] key, byte[] value, long transactionNum, ArrayList alreadyRemoved) throws IOException {
        if (this.m_secondary != null) {
            this.m_secondary.setTransNum(transactionNum);
        }
        BTreeKeyBuffer.BufferKey bufferKey = new BTreeKeyBuffer.BufferKey(key, 0, key != null ? key.length : 0, false, key == null);
        this.remove(this.nodeFromDbk(this.m_rootDbk, false), bufferKey, value, transactionNum, null, alreadyRemoved);
    }

    private NodeRemoveState remove(AllocatedNode targetReadonly, BTreeKeyBuffer.BufferKey key, byte[] value, long transactionNum, Object[] oldValue, ArrayList alreadyRemoved) throws IOException {
        BTreeAbstractNode node = targetReadonly.m_node;
        if (node instanceof BTreeLeafNode) {
            boolean thisEmpty;
            int position = node.getKeyPosition(key);
            if (position == -1) {
                if (oldValue != null) {
                    oldValue[0] = null;
                }
                if (alreadyRemoved != null) {
                    alreadyRemoved.add("alreadyRemoved");
                }
                return new NodeRemoveState(false, false);
            }
            boolean lastKeyInNode = position + 1 == node.getNumEntries();
            AllocatedNode target = this.nodeFromDbk(node.m_dbk, true);
            if (oldValue == null) {
                boolean entryWasThere = ((BTreeLeafNode)target.m_node).remove(key, position, value);
                if (!entryWasThere && alreadyRemoved != null) {
                    alreadyRemoved.add("alreadyRemoved");
                }
            } else {
                oldValue[0] = ((BTreeLeafNode)target.m_node).remove(key, position);
            }
            boolean lastKeyRemoved = lastKeyInNode && target.m_node.getKeyPosition(key) == -1;
            boolean bl = thisEmpty = target.m_node.getNumEntries() == 0;
            if (thisEmpty) {
                this.releaseNode(target, transactionNum);
            } else {
                target.m_buffer.m_cachedState = target.m_node;
                this.m_bufferSupply.doneUpdateBuffer(target.m_buffer, transactionNum);
            }
            BTreeSecondary.Status status = null;
            if (this.m_secondary != null) {
                status = this.m_secondary.exec();
            }
            if (status != null && !status.m_treeModified && alreadyRemoved != null) {
                alreadyRemoved.add("alreadyRemoved");
            }
            return new NodeRemoveState(lastKeyRemoved, thisEmpty);
        }
        long dbk = ((BTreeNode)node).getNextLevelDbk(key);
        AllocatedNode subTree = this.nodeFromDbk(dbk, false);
        NodeRemoveState nodeState = this.remove(subTree, key, value, transactionNum, oldValue, alreadyRemoved);
        if (nodeState.m_empty || nodeState.m_lastKeyRemoved) {
            boolean thisEmpty;
            int nextLevelPosition = ((BTreeNode)node).getNextLevelPosition(key);
            boolean lastKeyRemoved = nextLevelPosition + 1 == node.getNumEntries();
            BTreeKeyBuffer.BufferKey nextLevelKey = ((BTreeNode)node).getKey(nextLevelPosition);
            AllocatedNode target = this.nodeFromDbk(node.m_dbk, true);
            ((BTreeNode)target.m_node).remove(nextLevelKey, true);
            boolean bl = thisEmpty = target.m_node.getNumEntries() == 0;
            if (thisEmpty && nodeState.m_empty) {
                this.releaseNode(target, transactionNum);
            } else {
                if (!nodeState.m_empty && nodeState.m_lastKeyRemoved) {
                    subTree = this.nodeFromDbk(dbk, false);
                    target.m_node.insert(subTree.m_node.getLastKey(), BTree.dbkToBytes(dbk), true);
                }
                target.m_buffer.m_cachedState = target.m_node;
                this.m_bufferSupply.doneUpdateBuffer(target.m_buffer, transactionNum);
            }
            return new NodeRemoveState(lastKeyRemoved, thisEmpty);
        }
        return new NodeRemoveState(false, false);
    }

    int countKeyEntries(byte[] key) throws IOException {
        BTreeIteratorState iterator = new BTreeIteratorState(this.m_rootDbk, key, false);
        int count = 0;
        while (true) {
            this.advance(iterator);
            if (iterator.getAfterLast()) {
                return count;
            }
            if (!BTreeKeyBuffer.keysEqual(key, iterator.getCurrentKey())) {
                return count;
            }
            ++count;
        }
    }

    byte[] getFirstKey() throws IOException {
        BTreeIteratorState iterator = new BTreeIteratorState(this.m_rootDbk, false);
        this.initIteratorForward(iterator);
        if (iterator.getAfterLast()) {
            throw new BTreeKeyNotFoundException();
        }
        return iterator.getCurrentKey();
    }

    byte[] getLastKey() throws IOException {
        BTreeIteratorState iterator = new BTreeIteratorState(this.m_rootDbk, true);
        this.initIteratorBackward(iterator);
        if (iterator.getAfterLast()) {
            throw new BTreeKeyNotFoundException();
        }
        return iterator.getCurrentKey();
    }

    private void releaseNode(AllocatedNode allocatedNode, long transactionNum) throws IOException {
        this.m_bufferSupply.releaseBuffer(allocatedNode.m_buffer, transactionNum);
    }

    private AllocatedNode nodeFromDbk(long dbk, boolean forUpdate) throws IOException {
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = this.m_bufferSupply.getBuffer(dbk, forUpdate);
        BTreeAbstractNode node = null;
        if (buffer.m_cachedState != null) {
            node = (BTreeAbstractNode)buffer.m_cachedState;
        } else {
            node = BTreeAbstractNode.createExistingNode(this.m_logger, buffer, this.m_secondary);
            buffer.m_cachedState = node;
            this.m_bufferSupply.setCachedState(buffer);
        }
        return new AllocatedNode(node, buffer);
    }

    private AllocatedNode allocateLeaf(long transactionNum, long useThisPage) throws IOException {
        return this.allocateNodeOrLeaf(true, transactionNum, useThisPage);
    }

    private AllocatedNode allocateNode(long transactionNum) throws IOException {
        return this.allocateNodeOrLeaf(false, transactionNum, 0L);
    }

    private AllocatedNode allocateNodeOrLeaf(boolean leaf, long transactionNum, long useThisPage) throws IOException {
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = this.m_bufferSupply.allocateBuffer(transactionNum, useThisPage);
        BTreeAbstractNode node = BTreeAbstractNode.createNewNode(this.m_logger, buffer, leaf, this.m_noDuplicates, this.m_secondary, true);
        return new AllocatedNode(node, buffer);
    }

    private void insert(BTreeKeyBuffer.BufferKey key, byte[] value, Object[] oldValue, long transactionNum, ArrayList alreadyExists) throws IOException {
        AllocatedNode newNode = this.insertValue(this.m_rootDbk, key, value, oldValue, transactionNum, alreadyExists);
        if (newNode != null) {
            BTreeAbstractNode readonlyRoot = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node;
            AllocatedNode rootReplacement = null;
            rootReplacement = readonlyRoot instanceof BTreeLeafNode ? this.allocateLeaf(transactionNum, 0L) : this.allocateNode(transactionNum);
            rootReplacement.m_node = readonlyRoot.copy(rootReplacement.m_node);
            BTreeKeyBuffer.BufferKey rootReplacementKey = rootReplacement.m_node.getLastKey();
            byte[] rootReplacementDbk = BTree.getAllocatedNodeDbk(rootReplacement);
            rootReplacement.m_buffer.m_cachedState = rootReplacement.m_node;
            this.m_bufferSupply.doneUpdateBuffer(rootReplacement.m_buffer, transactionNum);
            AllocatedNode root = this.nodeFromDbk(this.m_rootDbk, true);
            root.m_node = root.m_node.createEmptyNode(this.m_secondary, true);
            root.m_node.initializeRoot(rootReplacementKey, rootReplacementDbk, true);
            root.m_node.insert(newNode.m_node.getLastKey(), BTree.getAllocatedNodeDbk(newNode), true);
            root.m_buffer.m_cachedState = root.m_node;
            this.m_bufferSupply.doneUpdateBuffer(root.m_buffer, transactionNum);
        }
    }

    private AllocatedNode insertValue(long targetDbk, BTreeKeyBuffer.BufferKey key, byte[] value, Object[] oldValue, long transactionNum, ArrayList alreadyExists) throws IOException {
        BTreeAbstractNode targetTreeReadonly = this.nodeFromDbk((long)targetDbk, (boolean)false).m_node;
        oldValue[0] = null;
        if (targetTreeReadonly instanceof BTreeLeafNode) {
            int position = targetTreeReadonly.getKeyPosition(key);
            if (position == -1) {
                return this.insertInNode(targetDbk, key, value, transactionNum);
            }
            if (!this.m_noDuplicates) {
                return this.addValueInNode(targetDbk, key, position, value, transactionNum, alreadyExists);
            }
            AllocatedNode targetTree = this.nodeFromDbk(targetDbk, true);
            oldValue[0] = targetTree.m_node.replace(key, position, value);
            if (alreadyExists != null && BTreeKeyBuffer.keysEqual(value, (byte[])oldValue[0])) {
                alreadyExists.add("exists");
            }
            targetTree.m_buffer.m_cachedState = targetTree.m_node;
            this.m_bufferSupply.doneUpdateBuffer(targetTree.m_buffer, transactionNum);
            return null;
        }
        long subTreeDbk = ((BTreeNode)targetTreeReadonly).getNextLevelDbk(key);
        AllocatedNode newNode = this.insertValue(subTreeDbk, key, value, oldValue, transactionNum, alreadyExists);
        if (newNode != null) {
            return this.insertInNode(targetDbk, newNode.m_node.getLastKey(), BTree.getAllocatedNodeDbk(newNode), transactionNum);
        }
        return null;
    }

    private AllocatedNode addValueInNode(long targetDbk, BTreeKeyBuffer.BufferKey key, int position, byte[] value, long transactionNum, ArrayList alreadyExists) throws IOException {
        BTreeLeafNode targetTreeReadonly = (BTreeLeafNode)this.nodeFromDbk((long)targetDbk, (boolean)false).m_node;
        if (!targetTreeReadonly.canAddValue(position, value, alreadyExists)) {
            AllocatedNode allocatedNode = null;
            allocatedNode = targetTreeReadonly instanceof BTreeLeafNode ? this.allocateLeaf(transactionNum, 0L) : this.allocateNode(transactionNum);
            BTreeLeafNode newNode = (BTreeLeafNode)allocatedNode.m_node;
            AllocatedNode targetTree = this.nodeFromDbk(targetDbk, true);
            targetTree.m_node.split(newNode, true);
            int newNodePosition = newNode.getKeyPosition(key);
            if (newNodePosition == -1) {
                ((BTreeLeafNode)targetTree.m_node).addValue(key, value, true);
            } else {
                newNode.addValue(key, value, true);
            }
            targetTree.m_buffer.m_cachedState = targetTree.m_node;
            this.m_bufferSupply.doneUpdateBuffer(targetTree.m_buffer, transactionNum);
            long allocatedDbk = allocatedNode.m_buffer.m_dbk;
            allocatedNode.m_buffer.m_cachedState = allocatedNode.m_node;
            this.m_bufferSupply.doneUpdateBuffer(allocatedNode.m_buffer, transactionNum);
            return this.nodeFromDbk(allocatedDbk, false);
        }
        if (alreadyExists != null && !alreadyExists.isEmpty()) {
            return null;
        }
        AllocatedNode targetTree = this.nodeFromDbk(targetDbk, true);
        ((BTreeLeafNode)targetTree.m_node).addValue(key, value, true);
        targetTree.m_buffer.m_cachedState = targetTree.m_node;
        this.m_bufferSupply.doneUpdateBuffer(targetTree.m_buffer, transactionNum);
        BTreeSecondary.Status status = null;
        if (this.m_secondary != null) {
            status = this.m_secondary.exec();
        }
        if (status != null && status.m_treeCreated) {
            targetTree = this.nodeFromDbk(targetDbk, true);
            ((BTreeLeafNode)targetTree.m_node).setSecondaryTreeDBK(position, status.m_treeDBK, true);
            targetTree.m_buffer.m_cachedState = targetTree.m_node;
            this.m_bufferSupply.doneUpdateBuffer(targetTree.m_buffer, transactionNum);
        }
        return null;
    }

    private AllocatedNode insertInNode(long targetDbk, BTreeKeyBuffer.BufferKey key, byte[] value, long transactionNum) throws IOException {
        BTreeAbstractNode targetTreeReadonly = this.nodeFromDbk((long)targetDbk, (boolean)false).m_node;
        if (!targetTreeReadonly.canInsert(key, value)) {
            AllocatedNode allocatedNode = null;
            allocatedNode = targetTreeReadonly instanceof BTreeLeafNode ? this.allocateLeaf(transactionNum, 0L) : this.allocateNode(transactionNum);
            BTreeAbstractNode newNode = allocatedNode.m_node;
            AllocatedNode targetTree = this.nodeFromDbk(targetDbk, true);
            targetTree.m_node.split(newNode, true);
            if (BTreeAbstractNode.insertInNew(key, targetTree.m_node, newNode)) {
                newNode.insert(key, value, true);
            } else {
                targetTree.m_node.insert(key, value, true);
            }
            targetTree.m_buffer.m_cachedState = targetTree.m_node;
            this.m_bufferSupply.doneUpdateBuffer(targetTree.m_buffer, transactionNum);
            long allocatedDbk = allocatedNode.m_buffer.m_dbk;
            allocatedNode.m_buffer.m_cachedState = allocatedNode.m_node;
            this.m_bufferSupply.doneUpdateBuffer(allocatedNode.m_buffer, transactionNum);
            return this.nodeFromDbk(allocatedDbk, false);
        }
        AllocatedNode targetTree = this.nodeFromDbk(targetDbk, true);
        targetTree.m_node.insert(key, value, true);
        targetTree.m_buffer.m_cachedState = targetTree.m_node;
        this.m_bufferSupply.doneUpdateBuffer(targetTree.m_buffer, transactionNum);
        return null;
    }

    void delete(long transactionNum) throws IOException {
        BTreeAbstractNode rootreadOnly;
        if (this.m_secondary != null) {
            this.m_secondary.setTransNum(transactionNum);
        }
        if ((rootreadOnly = this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node) instanceof BTreeNode) {
            this.deleteNode((BTreeNode)rootreadOnly, transactionNum);
        } else {
            this.releaseNode(this.nodeFromDbk(this.m_rootDbk, true), transactionNum);
        }
    }

    private void deleteNode(BTreeNode tree, long transactionNum) throws IOException {
        int numEntries = tree.getNumEntries();
        for (int i = 0; i < numEntries; ++i) {
            long nodeDbk = tree.getNextLevelDbk(i);
            BTreeAbstractNode subTree = this.nodeFromDbk((long)nodeDbk, (boolean)false).m_node;
            if (subTree instanceof BTreeNode) {
                this.deleteNode((BTreeNode)subTree, transactionNum);
                continue;
            }
            this.releaseNode(this.nodeFromDbk(subTree.m_dbk, true), transactionNum);
        }
        this.releaseNode(this.nodeFromDbk(tree.m_dbk, true), transactionNum);
    }

    private static byte[] getAllocatedNodeDbk(AllocatedNode allocatedNode) {
        byte[] buffer = new byte[8];
        BitUtil.putLong(buffer, 0, allocatedNode.m_buffer.m_dbk);
        return buffer;
    }

    private static byte[] dbkToBytes(long dbk) {
        byte[] buffer = new byte[8];
        BitUtil.putLong(buffer, 0, dbk);
        return buffer;
    }

    long countTree() throws IOException {
        return this.countTree(this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node);
    }

    private long countTree(BTreeAbstractNode tree) throws IOException {
        if (tree instanceof BTreeLeafNode) {
            return this.countLeaf((BTreeLeafNode)tree);
        }
        long count = 0L;
        int numEntries = tree.getNumEntries();
        Object key = null;
        for (int i = 0; i < numEntries; ++i) {
            long nodeDbk = ((BTreeNode)tree).getNextLevelDbk(i);
            BTreeAbstractNode subTree = this.nodeFromDbk((long)nodeDbk, (boolean)false).m_node;
            count += this.countTree(subTree);
        }
        return count;
    }

    private int countLeaf(BTreeLeafNode leaf) {
        int numEntries = leaf.getNumEntries();
        if (numEntries == 0) {
            return 0;
        }
        BTreeKeyBuffer.BufferKey key = leaf.getKey(numEntries - 1);
        return key.m_isInfinite ? numEntries - 1 : numEntries;
    }

    private void printTreeDEBUG() throws IOException {
        this.printTreeDEBUG(this.nodeFromDbk((long)this.m_rootDbk, (boolean)false).m_node, 0);
    }

    private void printTreeDEBUG(BTreeAbstractNode tree, int level) throws IOException {
        String shift = BTree.getShiftDEBUG(level);
        if (tree instanceof BTreeLeafNode) {
            BTree.printLeafDEBUG((BTreeLeafNode)tree, level);
        } else {
            int numEntries = tree.getNumEntries();
            BTreeKeyBuffer.BufferKey prevKey = null;
            BTreeKeyBuffer.BufferKey key = null;
            for (int i = 0; i < numEntries; ++i) {
                key = tree.getKey(i);
                String keyVal = BTree.keyToStringDEBUG(key);
                byte[] value = tree.getValueDEBUG(i);
                long nodeDbk = BitUtil.getLong(value, 0);
                BTreeAbstractNode subTree = this.nodeFromDbk((long)nodeDbk, (boolean)false).m_node;
                System.out.println(shift + " node key: " + keyVal + " dbk: " + nodeDbk);
                if (prevKey != null) {
                    BTreeKeyBuffer.keyOrderSanityDEBUG(prevKey, key);
                }
                this.printTreeDEBUG(subTree, level + 1);
                prevKey = key;
            }
        }
    }

    static void printLeafDEBUG(BTreeLeafNode leaf, int level) throws IOException {
        int numEntries = leaf.getNumEntries();
        String shift = BTree.getShiftDEBUG(level);
        BTreeKeyBuffer.BufferKey prevKey = null;
        BTreeKeyBuffer.BufferKey key = null;
        System.out.println(shift + "Leaf node numEntries: " + numEntries);
        for (int i = 0; i < numEntries; ++i) {
            key = leaf.getKey(i);
            String keyVal = key.toString();
            byte[] value = leaf.getValueDEBUG(i);
            long longVal = 0L;
            if (value != null) {
                longVal = BitUtil.getLong(value, 0);
            }
            System.out.println(shift + "key: " + i + " " + keyVal + " value: " + (value != null ? new Long(longVal).toString() : "null"));
            if (prevKey != null) {
                BTreeKeyBuffer.keyOrderSanityDEBUG(prevKey, key);
            }
            prevKey = key;
        }
    }

    static String keyToStringDEBUG(BTreeKeyBuffer.BufferKey key) {
        String keyVal = "";
        keyVal = key.m_isNull ? null : (key.m_isInfinite ? "INFI" : new Integer(BitUtil.getInt(key.m_buffer, key.m_offset)).toString());
        return keyVal;
    }

    private static String getShiftDEBUG(int level) {
        String shift = "";
        for (int i = 0; i < level; ++i) {
            shift = shift + "  ";
        }
        return shift;
    }

    static class AllocatedNode {
        BTreeAbstractNode m_node;
        BTreeAbstractBufferSupply.AllocatedBuffer m_buffer;

        AllocatedNode(BTreeAbstractNode node, BTreeAbstractBufferSupply.AllocatedBuffer buffer) {
            this.m_node = node;
            this.m_buffer = buffer;
        }
    }

    private class NodeRemoveState {
        boolean m_lastKeyRemoved;
        boolean m_empty;

        NodeRemoveState(boolean lastKeyRemoved, boolean empty) {
            this.m_lastKeyRemoved = lastKeyRemoved;
            this.m_empty = empty;
        }
    }

    private class KeyLocation {
        int m_position;
        long m_dbk;

        KeyLocation(int position, long dbk) {
            this.m_position = position;
            this.m_dbk = dbk;
        }
    }
}

