/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.LogPageHeader;

public final class LogPage {
    public static final int PAGE_LENGTH = new Integer(System.getProperty("_PSELogPageSize", "8192"));
    static final long UNKNOWN_PAGE_NUM = -1L;
    private byte[] m_buffer = new byte[PAGE_LENGTH];
    private long m_pageNum;

    LogPage() {
        this.initValues();
    }

    LogPage(long pageNum) {
        this.initValues();
        this.m_pageNum = pageNum;
    }

    synchronized void copyTo(LogPage destinyPage) {
        destinyPage.setPageNum(this.m_pageNum);
        System.arraycopy(this.m_buffer, 0, destinyPage.getBuffer(), 0, PAGE_LENGTH);
    }

    void initValues() {
        this.m_pageNum = -1L;
    }

    byte[] getBuffer() {
        return this.m_buffer;
    }

    long getPageNum() {
        return this.m_pageNum;
    }

    void setPageNum(long pageNum) {
        this.m_pageNum = pageNum;
    }

    synchronized void storeNoteEndPointer(int offset) {
        LogPageHeader.storeNoteEndPointer(this, offset);
    }

    int getNoteEndPointer() {
        return LogPageHeader.getNoteEndPointer(this);
    }

    void setPageColor(boolean red) {
        LogPageHeader.setPageColor(this, red);
    }

    void setFileEmpty(boolean empty) {
        LogPageHeader.setFileEmpty(this, empty);
    }

    boolean pageIsRed() {
        return LogPageHeader.pageIsRed(this);
    }

    boolean fileIsEmpty() {
        return LogPageHeader.fileIsEmpty(this);
    }

    static {
        if (PAGE_LENGTH > 0xFFFFFF) {
            throw new IllegalArgumentException("The maximum log page size is 16777215");
        }
    }
}

