/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.Constants;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.MasterPage;
import com.sonicsw.mtstorage.impl.Page;
import com.sonicsw.mtstorage.impl.PageManager;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.impl.VirtualLogFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public final class Replicator {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger("pse");
    static String READ_WRITE = "rw";
    private static final int DATA_PAGE_BATCH_SIZE_DEFAULT = 100;
    private static final String BACKUP_IN_PROGRESS_FILE = "backup_in_progress";
    private Storage m_storage;
    private PageManager m_pageManager;
    private File m_replicatedDBDir;
    private int m_pageBatchSize;
    private Logger m_logger;
    private long m_oldestNoteNeeded;
    private long m_lastCheckpointID;
    private long m_latestNoteNeeded;
    private RandomAccessFile m_dataFile;
    private VirtualLogFile m_virtualLogFile;
    private long m_deepSyncLastNoteWrittenAfterPageReplication;
    private long m_deepSyncCheckpointID;
    private DiagnosticsDump m_diagnosticsDump;
    private long m_currentPageID;

    Replicator(File replicatedDBDir, long deepSyncCheckpointID) throws IOException {
        this.m_replicatedDBDir = replicatedDBDir;
        this.m_dataFile = new RandomAccessFile(new File(this.m_replicatedDBDir, "data"), READ_WRITE);
        this.m_deepSyncCheckpointID = deepSyncCheckpointID;
        this.m_diagnosticsDump = new DiagnosticsDump(this.m_replicatedDBDir);
        this.m_currentPageID = 0L;
    }

    long getDeepSyncCheckpointID() {
        return this.m_deepSyncCheckpointID;
    }

    long getDeepSyncLastNoteWrittenAfterPageReplication() {
        return this.m_deepSyncLastNoteWrittenAfterPageReplication;
    }

    void writePage(byte[] buffer, int dataOffset, int dataLength) throws IOException {
        this.m_dataFile.write(buffer, dataOffset, dataLength);
        this.m_diagnosticsDump.addPageInfo(this.m_currentPageID++, Page.getNoteID(buffer, dataOffset));
    }

    void endDataReplication(long deepSyncLastNoteWrittenAfterPageReplication) throws IOException {
        this.m_dataFile.close();
        this.m_diagnosticsDump.done(this.m_deepSyncCheckpointID, deepSyncLastNoteWrittenAfterPageReplication);
        this.m_deepSyncLastNoteWrittenAfterPageReplication = deepSyncLastNoteWrittenAfterPageReplication;
        this.m_virtualLogFile = new VirtualLogFile(this.m_replicatedDBDir);
    }

    void replicateLog(long startID, byte[] srcBuffer, int offset, int length, int firstPageEndNotePointer) throws IOException {
        this.m_virtualLogFile.replicateLog(startID, srcBuffer, offset, length, firstPageEndNotePointer);
    }

    void endLogReplication() throws IOException {
        this.m_virtualLogFile.endLogReplication();
    }

    Replicator(String backupDBPath, Storage storage, PageManager pageManager, Logger logger) {
        this.m_replicatedDBDir = new File(backupDBPath);
        this.m_storage = storage;
        this.m_pageManager = pageManager;
        this.m_logger = logger;
        this.m_pageBatchSize = 100;
        this.m_oldestNoteNeeded = -1L;
    }

    static boolean isBackupInProgress(File dbDir) {
        return new File(dbDir, BACKUP_IN_PROGRESS_FILE).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long prepareReplication() throws IOException {
        this.cleanupReplica();
        File backupInPrgrsFile = new File(this.m_replicatedDBDir, BACKUP_IN_PROGRESS_FILE);
        new FileOutputStream(backupInPrgrsFile).close();
        long highestPageNum = -1L;
        try {
            this.m_storage.m_accessSemaphore.sharedLock();
            highestPageNum = this.m_pageManager.getHighestAllocatedPageNum();
            this.m_oldestNoteNeeded = this.m_storage.getOldestNoteNeededAtLastCheckpoint();
            this.m_lastCheckpointID = this.m_storage.getLastCheckpointID();
            this.m_storage.pinDownNotes(this.m_oldestNoteNeeded);
        }
        finally {
            this.m_storage.m_accessSemaphore.releaseLock();
        }
        return highestPageNum;
    }

    private void replicateData(long highestPageNum) throws IOException {
        RandomAccessFile dataFile = new RandomAccessFile(new File(this.m_replicatedDBDir, "data"), READ_WRITE);
        long startPage = -1L;
        long endPage = -1L;
        while (endPage < highestPageNum && this.copyPages(startPage = endPage + 1L, endPage = Constants.MIN(highestPageNum, endPage + (long)this.m_pageBatchSize), dataFile, this.m_replicatedDBDir)) {
        }
        dataFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateLog() throws IOException {
        this.m_latestNoteNeeded = -1L;
        try {
            this.m_storage.m_accessSemaphore.sharedLock();
            this.m_latestNoteNeeded = this.m_logger.getLastWrittenNoteID();
        }
        finally {
            this.m_storage.m_accessSemaphore.releaseLock();
        }
        this.m_logger.replicateLog(this.m_replicatedDBDir, this.m_oldestNoteNeeded, this.m_latestNoteNeeded);
    }

    private void reconcileData() throws IOException {
        Storage backupStore = new Storage();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("_SONIC_BACKUP_CHECKPOINT_NOTE_ID", new Long(this.m_lastCheckpointID));
        parameters.put("_SONIC_BACKUP_LAST_NOTE_ID", new Long(this.m_latestNoteNeeded));
        backupStore.open(this.m_replicatedDBDir.getAbsolutePath(), false, parameters);
        backupStore.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replicate() throws IOException {
        try {
            long highestPageNum = this.prepareReplication();
            this.replicateData(highestPageNum);
            this.replicateLog();
            this.unPinDownNotes();
            this.reconcileData();
            new File(this.m_replicatedDBDir, BACKUP_IN_PROGRESS_FILE).delete();
        }
        finally {
            this.unPinDownNotes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unPinDownNotes() {
        try {
            this.m_storage.m_accessSemaphore.sharedLock();
            this.m_storage.unPinDownNotes();
        }
        finally {
            this.m_storage.m_accessSemaphore.releaseLock();
        }
    }

    static void replicateOffLine(File src, File target) throws IOException {
        target.mkdir();
        String[] kids = src.list();
        for (int i = 0; i < kids.length; ++i) {
            File crntSrc = new File(src, kids[i]);
            if (crntSrc.isDirectory()) {
                Replicator.replicateOffLine(crntSrc, new File(target, kids[i]));
                continue;
            }
            Replicator.copyFile(crntSrc, new File(target, kids[i]));
        }
    }

    private static void copyFile(File srcFile, File destFile) throws IOException {
        int numRead;
        byte[] buffer = new byte[Page.PAGE_LENGTH];
        RandomAccessFile src = new RandomAccessFile(srcFile, "r");
        RandomAccessFile dest = new RandomAccessFile(destFile, "rw");
        do {
            if ((numRead = src.read(buffer)) <= 0) continue;
            dest.write(buffer, 0, numRead);
        } while (numRead >= buffer.length);
        src.close();
        dest.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyPages(long startPage, long endPage, RandomAccessFile dataFile, File replicationDir) throws IOException {
        Page[] pageCopies = new Page[(int)(endPage - startPage) + 1];
        try {
            this.m_storage.m_accessSemaphore.sharedLock();
            for (long pageNum = startPage; pageNum <= endPage; ++pageNum) {
                Page srcPage = this.m_pageManager.getForRead(pageNum);
                if (srcPage == null) {
                    boolean bl = false;
                    return bl;
                }
                int copyIndex = (int)(pageNum - startPage);
                pageCopies[copyIndex] = new Page();
                pageCopies[copyIndex].copyBufferAndPageNum(srcPage);
                if (pageNum != 0L) continue;
                MasterPage master = new MasterPage();
                master.useSameBufferAndPageNum(pageCopies[copyIndex]);
                long dbTimestamp = System.currentTimeMillis();
                master.setDBTimestamp(dbTimestamp);
                String filename = replicationDir.getCanonicalPath();
                if (filename.indexOf("data.odb") <= 0) continue;
                filename = filename.substring(0, filename.indexOf("data.odb") - 1);
                LOGGER.log(Level.INFO, "Setting storage timestamp for " + filename + " to " + dbTimestamp);
            }
        }
        finally {
            this.m_storage.m_accessSemaphore.releaseLock();
        }
        for (int i = 0; i < pageCopies.length && pageCopies[i] != null; ++i) {
            pageCopies[i].storeCRC();
            dataFile.write(pageCopies[i].getBuffer());
        }
        return true;
    }

    private void cleanupReplica() throws IOException {
        this.cleanupDir(this.m_replicatedDBDir);
        this.m_replicatedDBDir.mkdir();
        this.m_storage.setPersistentReplicationState(this.m_replicatedDBDir.getAbsolutePath(), (short)2);
    }

    private void cleanupDir(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir.getCanonicalPath() + " is not a directory");
        }
        String[] backupOldFiles = dir.list();
        for (int i = 0; i < backupOldFiles.length; ++i) {
            this.verifyStorageFileName(backupOldFiles[i], dir);
            File crntFile = new File(dir, backupOldFiles[i]);
            if (crntFile.isDirectory()) {
                this.cleanupDir(crntFile);
                continue;
            }
            if (crntFile.delete()) continue;
            throw new IOException("Could not delete  the old backup storage file: " + crntFile.getCanonicalPath());
        }
        if (!dir.delete()) {
            throw new IOException("Could not delete the old backup storage directory  " + dir.getCanonicalPath());
        }
    }

    private void verifyStorageFileName(String name, File dir) throws IOException {
        if (name.startsWith("LOG")) {
            return;
        }
        if (name.equals("data")) {
            return;
        }
        if (name.equals("snapshot")) {
            return;
        }
        if (name.equals("lock")) {
            return;
        }
        if (name.equals("replication_state")) {
            return;
        }
        if (name.equals("replication_state_2")) {
            return;
        }
        if (name.equals("replication_diagnostics")) {
            return;
        }
        throw new IOException("Non PSE storage file found in backup directory " + dir.getCanonicalPath());
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    private class DiagnosticsDump {
        private static final String DIAGNOSTICS_DUMP_FILE_NAME = "replication_diagnostics";
        private static final int MAX_DIAGNOSTICS_BUFFER_SIZE = 100;
        private File m_dumpFile;
        private ArrayList m_pageInfoBuffer;

        DiagnosticsDump(File replicatedDBDir) {
            this.m_dumpFile = new File(replicatedDBDir, DIAGNOSTICS_DUMP_FILE_NAME);
            this.m_dumpFile.delete();
            this.m_pageInfoBuffer = new ArrayList();
        }

        void addPageInfo(long pageNum, long noteID) {
            String infoLine = pageNum + " ID " + noteID;
            this.m_pageInfoBuffer.add(infoLine);
            if (this.m_pageInfoBuffer.size() >= 100) {
                this.flushBuffer();
            }
        }

        void done(long deepSyncCheckpointID, long deepSyncLastNoteWrittenAfterPageReplication) {
            this.m_pageInfoBuffer.add("deepSyncCheckpointID " + deepSyncCheckpointID + " deepSyncLastNoteWrittenAfterPageReplication " + deepSyncLastNoteWrittenAfterPageReplication);
            this.flushBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushBuffer() {
            if (this.m_pageInfoBuffer.isEmpty()) {
                return;
            }
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new FileOutputStream(this.m_dumpFile, true));
                for (int i = 0; i < this.m_pageInfoBuffer.size(); ++i) {
                    writer.println(this.m_pageInfoBuffer.get(i));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.m_pageInfoBuffer = new ArrayList();
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

