/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.ClusterException;
import com.odi.ClusterNotFoundException;
import com.odi.DatabaseNotOpenException;
import com.odi.SegmentException;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;
import com.odi.imp.mtsonic.Cluster;
import com.odi.imp.mtsonic.Database;
import com.odi.imp.mtsonic.Server;
import com.odi.imp.mtsonic.Transaction;
import com.odi.util.BitSet;
import java.io.IOException;
import java.util.Properties;

public final class Segment
extends com.odi.imp.Segment {
    public static final int THE_SEGMENT_ID = 0;
    public Cluster theCluster;
    Server sv;

    @Override
    public final void serverDestroy() {
        throw new SegmentException("Destroying a segment is not supported in the Pro version.");
    }

    @Override
    public final long serverGetSizeInBytes() {
        return this.database.serverGetSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.odi.Cluster getDefaultCluster() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.om.assureTransactionCompatible(6);
            ((Database)this.database).assureRead("get default cluster");
            return this.theCluster;
        }
    }

    @Override
    protected int[] serverGetClusters() {
        ((Database)this.database).assureOpen("get clusters");
        int[] cluids = new int[]{0};
        return cluids;
    }

    @Override
    public int serverGetDefaultClusterId() {
        ((Database)this.database).assureOpen("get the default cluster");
        return 0;
    }

    @Override
    public void serverSetDefaultClusterId(int clusterId) {
        ((Database)this.database).assureOpen("set the default cluster");
        if (clusterId != 0) {
            throw new ClusterException("Using a non-default cluster is not supported in the Pro version.");
        }
    }

    @Override
    public com.odi.imp.Cluster serverCreateNewCluster() {
        throw new ClusterException("Creating a non-default cluster is not supported in the Pro version.");
    }

    @Override
    public com.odi.imp.Cluster serverCreateExistingCluster(int clusterId) {
        ((Database)this.database).assureOpen("create a cluster");
        if (clusterId != 0) {
            throw new ClusterException("Using a non-default cluster is not supported in the Pro version.");
        }
        return this.theCluster;
    }

    @Override
    public void serverCheckCluster(int clusterId) {
        ((Database)this.database).assureOpen("check a cluster");
        Transaction.assure("check a cluster");
        if (clusterId != 0) {
            throw new ClusterNotFoundException("Cluster " + clusterId + " was not found.");
        }
    }

    @Override
    public boolean serverClusterExists(int clusterId) {
        ((Database)this.database).assureOpen("check cluster exists");
        Transaction.assure("check cluster exists");
        return clusterId == 0;
    }

    @Override
    public final int serverGetObjects(byte[] buffer, com.odi.imp.Cluster ignored, ObjectReference last) {
        return this.serverGetObjects(buffer, last);
    }

    @Override
    public final int serverGetObjects(byte[] buffer, ObjectReference last) {
        Transaction.assure("get objects in segment");
        if (this.sv.currentDatabase == null) {
            throw new DatabaseNotOpenException("Attempt to get object in segment when database is not open.");
        }
        try {
            long lastOID = last == null ? -1L : last.getLocation();
            long nextOID = this.sv.objectTable.nextValidOid(lastOID);
            if (nextOID == -1L) {
                return 0;
            }
            ObjectReference objRef = this.sv.objectTable.getObjRef(nextOID, this.sv.currentDatabase.theSegment.theCluster, this.sv.om.objRefFactory.createMutating());
            this.om.objectAccess.encodeObjRef(buffer, 0, objRef);
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
        return 1;
    }

    @Override
    public final int serverGetObjects(byte[] buffer, com.odi.imp.Cluster ignored, ObjectReference last, BitSet AFTs, int[] sizes, boolean isArrayType) {
        return this.serverGetObjects(buffer, last, AFTs, sizes, isArrayType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int serverGetObjects(byte[] buffer, ObjectReference last, BitSet AFTs, int[] sizes, boolean isArrayType) {
        Transaction.assure("get objects in segment");
        if (this.sv.currentDatabase == null) {
            throw new DatabaseNotOpenException("Attempt to get object in segment when database is not open.");
        }
        try {
            int stringElementTypeCode = Utilities.arrayElementTypeCode(Utilities.getStringTypeCode());
            boolean isStringType = AFTs.get(stringElementTypeCode);
            boolean done = false;
            while (!done) {
                int AFTC;
                ObjectReference objRef;
                block13: {
                    long lastOID = last == null ? -1L : last.getLocation();
                    long nextOID = sizes == null || isArrayType || isStringType ? this.sv.objectTable.nextValidOid(lastOID) : this.sv.objectTable.nextValidOid(lastOID, sizes);
                    if (nextOID == -1L) {
                        return 0;
                    }
                    objRef = this.sv.objectTable.getObjRef(nextOID, this.sv.currentDatabase.theSegment.theCluster, this.sv.om.objRefFactory.createMutating());
                    AFTC = objRef.getAFTypeCode();
                    if (isStringType && Utilities.isStringTypeCode(AFTC)) {
                        if (!isArrayType) {
                            this.om.objectAccess.encodeObjRef(buffer, 0, objRef);
                            return 1;
                        }
                        last = objRef;
                        continue;
                    }
                    if (isArrayType) {
                        if (Utilities.isArrayTypeCode(AFTC)) {
                            AFTC = Utilities.arrayElementTypeCode(AFTC);
                            break block13;
                        } else {
                            last = objRef;
                            continue;
                        }
                    }
                    if (Utilities.isArrayTypeCode(AFTC)) {
                        last = objRef;
                        continue;
                    }
                }
                if (AFTC > AFTs.length()) {
                    last = objRef;
                    continue;
                }
                if (AFTs.get(AFTC)) {
                    this.om.objectAccess.encodeObjRef(buffer, 0, objRef);
                    return 1;
                }
                last = objRef;
            }
            return 1;
        }
        catch (IOException e) {
            this.sv.IOFailure(e);
        }
        return 1;
    }

    @Override
    public Properties serverGC(Properties GCProperties) {
        return this.database.GC(GCProperties);
    }

    @Override
    public final void serverAcquireLock(int lockType, int timeoutMillis) {
        if (this.sv.currentDatabase == null) {
            throw new DatabaseNotOpenException("Attempt to acquire a lock on a segment when database is not open.");
        }
        if (lockType == 7) {
            this.sv.currentDatabase.assureUpdate("acquire an update lock on a segment");
        } else {
            this.sv.currentDatabase.assureRead("acquire a lock on a segment");
        }
    }

    Segment(Server sv, Database database, int segmentId, ObjectManager om) {
        super(database, segmentId, om);
        this.sv = sv;
        this.theCluster = new Cluster(this, om);
    }

    @Override
    public final void getExportedObjectLocation(ObjectReference exportedObjectReference, long[] result) {
        throw new SegmentException("Exported objects are not supported in the Pro version.");
    }

    @Override
    public final int getExportedObjectId(ObjectReference exportedObjectReference) {
        throw new SegmentException("Exported objects are not supported in the Pro version.");
    }
}

