/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.VectorOfChildrenEvalNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public final class UnionEvalNode
extends VectorOfChildrenEvalNode {
    public UnionEvalNode(Vector children) {
        super(children);
    }

    @Override
    protected VectorOfChildrenEvalNode newCopy() {
        return new UnionEvalNode();
    }

    private UnionEvalNode() {
    }

    @Override
    String operatorImage() {
        return "union";
    }

    @Override
    protected boolean containsInternal(Object object) {
        if (!this.hasFastContainsInternal()) {
            Iterator iterator = this.iterator(true);
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                return true;
            }
            return false;
        }
        Enumeration childrenEnum = this.children.elements();
        while (childrenEnum.hasMoreElements()) {
            if (!((QueryEvalNode)childrenEnum.nextElement()).contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Iterator iteratorInternal(boolean allowDuplicates) {
        if (allowDuplicates) {
            return new NodeIterator();
        }
        return this.getSet(false).iterator();
    }

    @Override
    protected Set computeSet() {
        QueryEvalNode[] childArray = this.getIterationChildren();
        Set result = childArray[0].getSet(true);
        for (int i = 1; i < childArray.length; ++i) {
            QueryEvalNode child = childArray[i];
            Iterator childElements = child.iterator(true);
            while (childElements.hasNext()) {
                result.add(childElements.next());
            }
        }
        return result;
    }

    @Override
    protected void estimateSize() {
        this.minSize = 0;
        this.maxSize = 0;
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            QueryEvalNode child = (QueryEvalNode)this.children.elementAt(i);
            this.minSize = Math.max(this.minSize, child.getMinSize());
            this.maxSize += child.getMaxSize();
        }
    }

    QueryEvalNode[] getIterationChildren() {
        Object[] childArray = new QueryEvalNode[this.children.size()];
        this.children.copyInto(childArray);
        int start = 0;
        if (this.hasFastContainsInternal()) {
            int largestSize = 0;
            boolean foundSet = false;
            for (int i = 0; i < childArray.length; ++i) {
                Object child = childArray[i];
                int estSize = (((QueryEvalNode)child).getMinSize() + ((QueryEvalNode)child).getMaxSize()) / 2;
                if (((QueryEvalNode)child).isSetComputed()) {
                    if (foundSet && estSize <= largestSize) continue;
                    start = i;
                    foundSet = true;
                    largestSize = estSize;
                    continue;
                }
                if (foundSet || estSize <= largestSize) continue;
                start = i;
                largestSize = estSize;
            }
        } else {
            int slowSize = 0;
            for (int i = 0; i < childArray.length; ++i) {
                int estSize;
                Object child = childArray[i];
                if (((QueryEvalNode)child).hasFastContains() || (estSize = (((QueryEvalNode)child).getMinSize() + ((QueryEvalNode)child).getMaxSize()) / 2) <= slowSize) continue;
                start = i;
                slowSize = estSize;
            }
        }
        Object temp = childArray[start];
        childArray[start] = childArray[0];
        childArray[0] = temp;
        return childArray;
    }

    @Override
    public String toString() {
        return this.identityToString() + ": " + super.toString();
    }

    final class NodeIterator
    implements Iterator {
        private QueryEvalNode[] children;
        private Iterator childIterator;
        private int childIndex = 0;

        NodeIterator() {
            Vector childVector = UnionEvalNode.this.children;
            this.children = new QueryEvalNode[childVector.size()];
            childVector.copyInto(this.children);
            this.childIterator = this.children[0].iterator(true);
        }

        @Override
        public boolean hasNext() {
            while (!this.childIterator.hasNext()) {
                if (this.childIndex >= this.children.length - 1) {
                    return false;
                }
                this.childIterator = this.children[++this.childIndex].iterator(true);
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            return this.childIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove() method is not supported on this iterator.");
        }
    }
}

