/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketMultiConnectionSync
extends PDUPacket {
    private int count;
    private long[] flowIds;
    private long[] snos;

    private PDUPacketMultiConnectionSync(int n, long[] lArray, long[] lArray2) {
        super((short)13);
        this.setBody(n, lArray, lArray2);
    }

    private PDUPacketMultiConnectionSync(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 13) {
            throw new InternalError("MCONN SYNC packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketMultiConnectionSync(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 13) {
            throw new InternalError("MCONN SYNC packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeInt(this.count);
            for (int i = 0; i < this.count; ++i) {
                dataOutputStream.writeLong(this.flowIds[i]);
                dataOutputStream.writeLong(this.snos[i]);
            }
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < 4) throw new EIOInsufficientDataException(4 - dataInputStream.available());
            int n = dataInputStream.readInt();
            int n2 = n * 8 * 2;
            if (dataInputStream.available() < n2) throw new EIOInsufficientDataException(n2 - dataInputStream.available());
            long[] lArray = new long[n];
            long[] lArray2 = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = dataInputStream.readLong();
                lArray2[i] = dataInputStream.readLong();
            }
            this.setBody(n, lArray, lArray2);
            return;
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        int n;
        while ((n = (int)SysInteractive.ask("Flow count", printStream, bufferedReader, 0.0)) < 0) {
        }
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            do {
                lArray[i] = (int)SysInteractive.ask("Id for flow #" + (i + 1), printStream, bufferedReader, i + 1);
            } while (lArray[i] < 0L);
            do {
                lArray2[i] = (int)SysInteractive.ask("Sync sno for flow #" + (i + 1), printStream, bufferedReader, 1.0);
            } while (lArray2[i] <= 0L);
        }
        this.setBody(n, lArray, lArray2);
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
        long[] lArray = new long[this.count];
        System.arraycopy(this.flowIds, 0, lArray, 0, this.count);
        long[] lArray2 = new long[this.count];
        System.arraycopy(this.snos, 0, lArray2, 0, this.count);
        ((PDUPacketMultiConnectionSync)pDUPacket).setBody(this.count, lArray, lArray2);
    }

    @Override
    final int getBodyWireSize() {
        return 4 + this.count * 8 * 2;
    }

    @Override
    final String bodyToString() {
        String string = "[";
        string = string + this.count;
        for (int i = 0; i < this.count; ++i) {
            string = string + " {" + this.flowIds[i] + "," + this.snos[i] + "}";
        }
        string = string + "]";
        return string;
    }

    public static PDUPacketMultiConnectionSync create(int n, long[] lArray, long[] lArray2) {
        return new PDUPacketMultiConnectionSync(n, lArray, lArray2);
    }

    static PDUPacketMultiConnectionSync create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketMultiConnectionSync(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketMultiConnectionSync create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketMultiConnectionSync(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setBody(int n, long[] lArray, long[] lArray2) {
        this.count = n;
        this.flowIds = lArray;
        this.snos = lArray2;
    }

    public final int getCount() {
        return this.count;
    }

    public final long[] getFlowIds() {
        return this.flowIds;
    }

    public final long[] getSnos() {
        return this.snos;
    }
}

