/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class DsdataURLStreamHandler
extends URLStreamHandler {
    private ContainerImpl m_container;

    DsdataURLStreamHandler(ContainerImpl container) {
        this.m_container = container;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    public class Connection
    extends URLConnection {
        private Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            String dsdataUrl = this.url.getFile();
            int lastIndex = dsdataUrl.lastIndexOf(47);
            if (lastIndex > 0) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(dsdataUrl.substring(0, lastIndex + 1).toLowerCase());
                sbuf.append(dsdataUrl.substring(lastIndex + 1));
                dsdataUrl = sbuf.toString();
            }
            String delim = dsdataUrl.charAt(0) == '/' ? "" : "/";
            IElement element = DsdataURLStreamHandler.this.m_container.getConfiguration("/xqFiles" + delim + dsdataUrl);
            if (element == null) {
                throw new IOException(this.url.toExternalForm() + " does not exist");
            }
            IAttributeSet attrs = element.getAttributes();
            Object fileContents = attrs.getAttribute("file");
            if (fileContents == null) {
                throw new IOException(this.url.toExternalForm() + " has no contents");
            }
            if (fileContents instanceof String) {
                return new ByteArrayInputStream(((String)fileContents).getBytes());
            }
            if (fileContents instanceof byte[]) {
                return new ByteArrayInputStream((byte[])fileContents);
            }
            throw new IOException(this.url.toExternalForm() + " contains invalid contents type: " + fileContents.getClass().getName());
        }
    }
}

