/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeCopyNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 14;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    byte[] m_oldBuffer;
    int m_oldStart;
    int m_oldLength;
    byte[] m_newBuffer;
    int m_newStart;
    int m_newLength;
    int m_oldValueOffset;
    int m_newValueOffset;

    BTreeCopyNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)14);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        int currentLength = 9;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_oldStart);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_oldLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        writer.write(this.m_oldBuffer, this.m_oldStart, this.m_oldLength);
        currentLength += this.m_oldLength;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_newLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        writer.write(this.m_newBuffer, this.m_newStart, this.m_newLength);
        return currentLength += this.m_newLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_oldBuffer = buffer;
        this.m_newBuffer = buffer;
        int currentOffset = offset;
        this.m_pageNum = BitUtil.getLong(buffer, currentOffset);
        this.m_oldStart = BitUtil.getShort(buffer, currentOffset += 8);
        this.m_oldLength = BitUtil.getShort(buffer, currentOffset += 2);
        this.m_oldValueOffset = currentOffset += 2;
        this.m_newLength = BitUtil.getShort(buffer, currentOffset += this.m_oldLength);
        this.m_newValueOffset = currentOffset += 2;
        currentOffset += this.m_newLength;
    }

    void initNote(long pageNum, byte[] src, int srcStart, int srcLength, byte[] target, int targetStart, int targetLength) {
        this.m_pageNum = pageNum;
        this.m_newBuffer = src;
        this.m_newStart = srcStart;
        this.m_newLength = srcLength;
        this.m_oldBuffer = target;
        this.m_oldStart = targetStart;
        this.m_oldLength = targetLength;
    }
}

