/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.AbstractBTreeIterator;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;

public final class BTreeIteratorState
extends AbstractBTreeIterator {
    private long m_btreeDbk;
    private boolean m_reverse;
    private boolean m_nolock;
    private boolean m_hasInitialKey;
    private boolean m_notInitialized;
    private boolean m_afterLast;
    private byte[] m_currentKey;
    private byte[] m_initialKey;
    private byte[] m_currentValue;
    private byte[] m_savedKey;
    private byte[] m_savedValue;
    private boolean m_savedNotInitialized;
    private boolean m_savedAfterLast;
    private boolean m_savedReverse;
    private boolean m_savedHasInitialKey;
    private long m_savedBtreeDbk;
    boolean m_keyChanged;
    boolean m_valueChanged;
    BTreeKeyBuffer.BufferKey m_keyBuffer;

    public BTreeIteratorState(long btreeDbk, boolean reverse) {
        this.m_btreeDbk = btreeDbk;
        this.m_reverse = reverse;
        this.m_hasInitialKey = false;
        this.m_nolock = false;
        this.init();
    }

    public BTreeIteratorState(long btreeDbk, byte[] initialKey, boolean reverse) {
        this.m_btreeDbk = btreeDbk;
        this.m_reverse = reverse;
        this.m_hasInitialKey = true;
        this.m_initialKey = initialKey;
        this.m_nolock = false;
        this.init();
    }

    public BTreeIteratorState(long btreeDbk, byte[] initialKey, byte[] initialValue, boolean reverse) {
        this.m_btreeDbk = btreeDbk;
        this.m_reverse = reverse;
        this.m_hasInitialKey = true;
        this.m_initialKey = initialKey;
        this.m_currentKey = initialKey;
        this.m_currentValue = initialValue;
        this.m_nolock = false;
        this.init();
        this.m_notInitialized = false;
    }

    public BTreeIteratorState(long btreeDbk) {
        this.m_btreeDbk = btreeDbk;
        this.m_reverse = false;
        this.m_hasInitialKey = false;
        this.m_nolock = true;
        this.init();
    }

    private BTreeIteratorState() {
        this.init();
    }

    BTreeIteratorState replicate() {
        BTreeIteratorState replica = new BTreeIteratorState();
        replica.m_btreeDbk = this.m_btreeDbk;
        replica.m_reverse = this.m_reverse;
        replica.m_hasInitialKey = this.m_hasInitialKey;
        replica.m_notInitialized = this.m_notInitialized;
        replica.m_afterLast = this.m_afterLast;
        replica.m_currentKey = this.m_currentKey;
        replica.m_initialKey = this.m_initialKey;
        replica.m_currentValue = this.m_currentValue;
        replica.m_nolock = this.m_nolock;
        return replica;
    }

    private void init() {
        this.m_notInitialized = true;
        this.m_afterLast = false;
        this.m_keyBuffer = new BTreeKeyBuffer.BufferKey();
        this.m_keyChanged = false;
        this.m_valueChanged = false;
    }

    void setDbk(long btreeDbk) {
        this.m_btreeDbk = btreeDbk;
    }

    void setReverse(boolean reverse) {
        this.m_reverse = reverse;
    }

    byte[] getInitialKey() {
        return this.m_initialKey;
    }

    void setNotChanged() {
        this.m_keyChanged = false;
        this.m_valueChanged = false;
    }

    boolean currentChanged() {
        return this.m_keyChanged || this.m_valueChanged;
    }

    boolean getNolock() {
        return this.m_nolock;
    }

    void save() {
        this.m_keyChanged = false;
        this.m_valueChanged = false;
        this.m_savedKey = this.m_currentKey;
        this.m_savedValue = this.m_currentValue;
        this.m_savedNotInitialized = this.m_notInitialized;
        this.m_savedAfterLast = this.m_afterLast;
        this.m_savedBtreeDbk = this.m_btreeDbk;
        this.m_savedReverse = this.m_reverse;
        this.m_savedHasInitialKey = this.m_hasInitialKey;
    }

    void restore() {
        this.m_keyChanged = false;
        this.m_valueChanged = false;
        this.m_currentKey = this.m_savedKey;
        this.m_currentValue = this.m_savedValue;
        this.m_notInitialized = this.m_savedNotInitialized;
        this.m_afterLast = this.m_savedAfterLast;
        this.m_btreeDbk = this.m_savedBtreeDbk;
        this.m_reverse = this.m_savedReverse;
        this.m_hasInitialKey = this.m_savedHasInitialKey;
    }

    @Override
    public long getTreeDbk() {
        return this.m_btreeDbk;
    }

    @Override
    public byte[] getCurrentKey() {
        return this.m_currentKey;
    }

    @Override
    public byte[] getCurrentValue() {
        return this.m_currentValue;
    }

    void setAfterLast() {
        this.m_afterLast = true;
    }

    @Override
    public boolean getAfterLast() {
        return this.m_afterLast;
    }

    boolean hasInitialKey() {
        return this.m_hasInitialKey;
    }

    boolean isReverse() {
        return this.m_reverse;
    }

    boolean isInitialized() {
        return !this.m_notInitialized;
    }

    void setCurrentKey(byte[] key) {
        this.m_currentKey = key;
        this.m_keyChanged = true;
        this.m_notInitialized = false;
    }

    void setCurrentValue(byte[] value) {
        this.m_currentValue = value;
        this.m_valueChanged = true;
    }

    KeyValuePair getPosition() {
        return new KeyValuePair(this.m_currentKey, this.m_currentValue);
    }

    static int compareEntries(KeyValuePair p1, KeyValuePair p2) {
        int keyComparison = BTreeKeyBuffer.compareKeys(p1.m_key, p2.m_key);
        if (keyComparison != 0) {
            return keyComparison;
        }
        return BTreeKeyBuffer.compareKeys(p1.m_value, p2.m_value);
    }

    static KeyValuePair selectEntries(KeyValuePair p1, KeyValuePair p2, boolean reverse) {
        int smallerOrLarger;
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        int comparison = BTreeIteratorState.compareEntries(p1, p2);
        int n = smallerOrLarger = reverse ? 2 : -2;
        if (comparison == smallerOrLarger) {
            return p1;
        }
        return p2;
    }

    static class KeyValuePair {
        byte[] m_key;
        byte[] m_value;

        KeyValuePair(byte[] key, byte[] value) {
            this.m_key = key;
            this.m_value = value;
        }
    }
}

