/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

final class BufferedRandomAccessFile {
    private RandomAccessFile m_file;
    private byte[] m_buffer;
    long m_position;
    int m_bufferContentSize;
    long m_bufferPosition;

    public static void main(String[] args) throws Exception {
        int i;
        int BUF_SIZE = 10;
        byte[] buffer = new byte[BUF_SIZE];
        BufferedRandomAccessFile bFile = new BufferedRandomAccessFile(new File("log_test"), "rw", BUF_SIZE);
        for (i = 0; i < 30; ++i) {
            buffer[0] = (byte)i;
            if (i % 2 == 0) {
                bFile.write(buffer);
                bFile.seek(i * BUF_SIZE);
            }
            buffer[BUF_SIZE - 1] = (byte)i;
            bFile.write(buffer);
        }
        for (i = 29; i >= 0; --i) {
            bFile.seek(i * BUF_SIZE);
            bFile.read(buffer);
        }
        bFile.close();
    }

    BufferedRandomAccessFile(File raf, String mode, int bufferSize) throws FileNotFoundException, IOException {
        this.m_file = new RandomAccessFile(raf, mode);
        this.m_buffer = (byte[])(mode.equals("r") ? null : new byte[bufferSize]);
        this.m_bufferContentSize = 0;
        this.m_position = 0L;
        this.m_bufferPosition = this.m_file.length();
    }

    long length() throws IOException {
        return BufferedRandomAccessFile.MAX(this.m_file.length(), this.m_bufferPosition + (long)this.m_bufferContentSize);
    }

    void seek(long position) throws IOException {
        this.m_position = position;
        if (this.m_bufferContentSize == 0) {
            this.m_bufferPosition = this.m_position;
        }
    }

    void write(byte[] data) throws IOException {
        if (this.m_position < this.m_bufferPosition || this.m_position >= this.m_bufferPosition + (long)this.m_buffer.length) {
            this.writeBuffer();
        }
        int positionInBuffer = (int)(this.m_position - this.m_bufferPosition);
        System.arraycopy(data, 0, this.m_buffer, positionInBuffer, data.length);
        this.m_bufferContentSize = (int)BufferedRandomAccessFile.MAX(positionInBuffer + data.length, this.m_bufferContentSize);
        this.m_position += (long)data.length;
    }

    void read(byte[] data) throws IOException {
        if (this.m_position >= this.m_bufferPosition && this.m_position + (long)data.length <= this.m_bufferPosition + (long)this.m_bufferContentSize) {
            int positionInBuffer = (int)(this.m_position - this.m_bufferPosition);
            System.arraycopy(this.m_buffer, positionInBuffer, data, 0, data.length);
        } else {
            if (this.m_file.getFilePointer() != this.m_position) {
                this.m_file.seek(this.m_position);
            }
            this.m_file.read(data);
            this.m_position += (long)data.length;
        }
    }

    void close() throws IOException {
        this.writeBuffer();
        this.m_file.close();
        this.m_buffer = null;
    }

    void sync(boolean doSync) throws IOException {
        this.writeBuffer();
        if (doSync) {
            this.m_file.getFD().sync();
        }
    }

    private void writeBuffer() throws IOException {
        if (this.m_bufferContentSize > 0) {
            if (this.m_file.getFilePointer() != this.m_bufferPosition) {
                this.m_file.seek(this.m_bufferPosition);
            }
            this.m_file.write(this.m_buffer, 0, this.m_bufferContentSize);
            this.m_bufferContentSize = 0;
        }
        this.m_bufferPosition = this.m_position;
    }

    private static long MAX(long l1, long l2) {
        return l1 > l2 ? l1 : l2;
    }
}

