/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication.util;

public final class BitUtil {
    public static final int MAX_3BYTES_INT = 0xFFFFFF;

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char getChar(byte[] b, int off) {
        return (char)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static short getShort10Bits(byte[] b, int off) {
        return (short)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 3) << 8));
    }

    public static short getShort(byte[] b, int off) {
        return (short)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static int getInt(byte[] b, int off) {
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static int getInt3Bytes(byte[] b, int off) {
        return ((b[off + 2] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 0] & 0xFF) << 16);
    }

    public static long getLong(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static void putBoolean(byte[] b, int off, boolean val) {
        b[off] = (byte)(val ? 1 : 0);
    }

    public static void putChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
    }

    public static void putShort10Bits(byte[] b, int off, short val) {
        b[off + 1] = (byte)(val >>> 0);
        byte mostSigVal = (byte)(val >>> 8);
        if (mostSigVal > 3) {
            throw new Error(val + " is too large");
        }
        int n = off + 0;
        b[n] = (byte)(b[n] & 0xFFFFFFFC);
        int n2 = off + 0;
        b[n2] = (byte)(b[n2] | mostSigVal);
    }

    public static void putShort(byte[] b, int off, short val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
    }

    public static void putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)(val >>> 0);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 0] = (byte)(val >>> 24);
    }

    public static void putInt3Bytes(byte[] b, int off, int val) {
        if (val > 0xFFFFFF) {
            throw new IllegalArgumentException("The maximum 3 bytes integer is 16777215");
        }
        b[off + 2] = (byte)(val >>> 0);
        b[off + 1] = (byte)(val >>> 8);
        b[off + 0] = (byte)(val >>> 16);
    }

    public static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }
}

