/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.Placement;
import com.odi.Segment;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;

public final class MutatingObjRef
implements ObjectReference,
ObjectReference.Constants {
    public Placement place;
    public long location;
    public int AFTypeCode = 17;
    public int arrayElementCount = -1;
    short flags;
    private ObjectManager om;

    MutatingObjRef() {
    }

    MutatingObjRef(Placement place, long location, int AFTypeCode) {
        this.place = place;
        this.location = location;
        this.AFTypeCode = AFTypeCode;
        this.om = (ObjectManager)place.getSession();
    }

    MutatingObjRef(ObjectManager om, Placement place, long location, int AFTypeCode) {
        this.place = place;
        this.location = location;
        this.AFTypeCode = AFTypeCode;
        this.om = om;
    }

    MutatingObjRef(Placement place, long location, int AFTypeCode, int arrayElementCount) {
        this.place = place;
        this.location = location;
        this.AFTypeCode = AFTypeCode;
        this.arrayElementCount = arrayElementCount;
        this.om = (ObjectManager)place.getSession();
    }

    MutatingObjRef(ObjectReference objRef) {
        this.set(objRef);
    }

    @Override
    public int hashCode() {
        return (int)(this.location ^ (long)this.AFTypeCode);
    }

    @Override
    public boolean equals(Object obj) {
        ObjectReference objRef;
        try {
            objRef = (ObjectReference)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        return objRef.isEqual(this.place, this.location, this.AFTypeCode);
    }

    @Override
    public boolean isEqual(Placement place, long location, int AFTypeCode) {
        return this.place == place && this.location == location && this.AFTypeCode == AFTypeCode;
    }

    @Override
    public final Placement getPlacement() {
        return this.place;
    }

    @Override
    public final int getAFTypeCode() {
        return this.AFTypeCode;
    }

    @Override
    public final long getLocation() {
        return this.location;
    }

    @Override
    public final int getArrayDimensions() {
        return Utilities.arrayDimensions(this.AFTypeCode);
    }

    @Override
    public final int getArrayElementCount() {
        return this.arrayElementCount;
    }

    @Override
    public final short getFlags() {
        return this.flags;
    }

    @Override
    public short getTxnIndex() {
        throw new FatalInternalException("getTxnIndex called for MutatingObjectReference");
    }

    @Override
    public void setTxnIndex(short txnIndex) {
        throw new FatalInternalException("setTxnIndex called for MutatingObjectReference");
    }

    @Override
    public void saveElement0(Object object) {
        throw new FatalInternalException("saveElement0 called for MutatingObjectReference");
    }

    @Override
    public void restoreElement0(Object object) {
        throw new FatalInternalException("restoreElement0 called for MutatingObjectReference");
    }

    @Override
    public final void setFlags(short flags) {
        this.flags = flags;
    }

    public final void setObjectId(Placement place, long location) {
        this.place = place;
        this.location = location;
    }

    public final void set(ObjectReference objRef) {
        this.place = objRef.getPlacement();
        this.location = objRef.getLocation();
        this.AFTypeCode = objRef.getAFTypeCode();
        this.arrayElementCount = objRef.getArrayElementCount();
        this.flags = objRef.getFlags();
    }

    public final void setAttributes(byte[] buffer, int offset) {
        ObjectAccess objectAccess = this.om.objectAccess;
        this.setObjectId(this.om.getPlacement(objectAccess.decodeObjRefDatabaseId(buffer, offset), objectAccess.decodeObjRefSegmentId(buffer, offset), objectAccess.decodeObjRefClusterId(buffer, offset)), objectAccess.decodeObjRefLocation(buffer, offset));
        this.AFTypeCode = objectAccess.decodeObjRefTypeCode(buffer, offset);
        this.arrayElementCount = Utilities.arrayDimensions(this.AFTypeCode) > 0 ? objectAccess.decodeObjRefArrayElementCount(buffer, offset) : -1;
    }

    public final void setAttributes(int databaseId, int segmentId, int clusterId, long location, int AFTypeCode, int arrayElementCount) {
        if (AFTypeCode == 0) {
            this.place = null;
            this.location = 0L;
            this.AFTypeCode = 0;
            this.arrayElementCount = -1;
        } else {
            this.place = this.om.getPlacement(databaseId, segmentId, clusterId);
            this.location = location;
            this.AFTypeCode = AFTypeCode;
            this.arrayElementCount = arrayElementCount;
        }
    }

    public void setPlacement(Placement place) {
        this.place = place;
    }

    public void setLocation(long location) {
        this.location = location;
    }

    public void setAFTypeCode(int AFTypeCode) {
        this.AFTypeCode = AFTypeCode;
    }

    public void setFullLocation(int databaseID, int segmentID, int clusterID, long locationID) {
        Segment segment = this.om.getDatabase(databaseID).getSegment(segmentID);
        this.place = clusterID == -4 ? segment : ((com.odi.imp.Segment)segment).getClusterInternal(clusterID);
        this.location = locationID;
    }
}

