/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClusterNotFoundException;
import com.odi.ObjectNotFoundException;
import com.odi.SegmentNotFoundException;
import com.odi.StaleIteratorException;
import com.odi.imp.Cluster;
import com.odi.imp.Database;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Segment;
import com.odi.imp.Transaction;
import com.odi.imp.Utilities;
import com.odi.util.BitSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PersistentObjectIterator
implements Iterator,
Enumeration {
    private Segment segment;
    private Cluster cluster;
    private ObjectManager om;
    private Transaction txn;
    private long txnId;
    private byte[] buffer;
    private Object[] objects;
    private int position = -1;
    private int nObjects = 0;
    private ObjectReference last = null;
    private BitSet AFTs = null;
    private int[] sizes = null;
    private Class ofType = null;
    private boolean isUserDefinedType;
    private int schemaClassCount;

    PersistentObjectIterator(Segment segment) {
        this(segment, null, null);
    }

    PersistentObjectIterator(Segment segment, Class ofType) {
        this(segment, null, ofType);
    }

    PersistentObjectIterator(Cluster cluster) {
        this((Segment)cluster.getSegment(), cluster, null);
    }

    PersistentObjectIterator(Cluster cluster, Class ofType) {
        this((Segment)cluster.getSegment(), cluster, ofType);
    }

    PersistentObjectIterator(Segment segment, Cluster cluster, Class ofType) {
        Database db = (Database)segment.getDatabase();
        if (segment.isDestroyed()) {
            throw new SegmentNotFoundException(db, segment.getSegmentId());
        }
        if (cluster != null && cluster.isDestroyed()) {
            throw new ClusterNotFoundException(db, segment.getSegmentId(), cluster.getClusterId());
        }
        this.segment = segment;
        this.cluster = cluster;
        this.om = segment.om;
        this.om.checkCurrent();
        this.txn = (Transaction)Transaction.current();
        this.txnId = this.txn.getCurrentTransactionId();
        if (ofType != null) {
            this.ofType = ofType;
            this.isUserDefinedType = Utilities.isUserDefinedType(ofType);
            this.AFTs = this.om.schemaManager.getAFTSubClasses(ofType, db);
            this.schemaClassCount = db.serverGetSchemaClassCount();
            if (!ofType.isArray() && ofType != String.class) {
                this.sizes = this.om.schemaManager.getAFTSizes(this.AFTs);
            }
        }
        int bufferNObjects = segment.serverGetObjectsBufferSize();
        this.buffer = new byte[bufferNObjects * this.om.objectAccess.referenceSize];
        this.objects = new Object[bufferNObjects];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.checkTransaction();
            return this.hasMoreElementsInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        ObjectManager objectManager = this.om.checkCurrent();
        synchronized (objectManager) {
            this.checkTransaction();
            if (!this.hasMoreElementsInternal()) {
                throw new NoSuchElementException("No more objects.");
            }
            Object result = this.objects[this.position];
            this.last = this.om.findObjRef(result, true);
            this.advance();
            return result;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreElements();
    }

    public Object next() {
        return this.nextElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator.remove() on a PersistentObjectIterator is not supported");
    }

    private void checkTransaction() {
        Transaction current = (Transaction)Transaction.current();
        if (this.txn != current || this.txnId != current.getCurrentTransactionId()) {
            if (this.txn.isAborted()) {
                throw new StaleIteratorException("PersistentObjectIterator");
            }
            this.txn = current;
            this.txnId = current.getCurrentTransactionId();
            if (this.position >= 0) {
                this.position = -1;
                this.nObjects = 0;
                this.advance();
            }
        }
    }

    private boolean hasMoreElementsInternal() {
        if (this.position < 0) {
            this.advance();
        }
        if (this.segment.isDestroyedInternal()) {
            throw new SegmentNotFoundException(this.segment.getDatabase(), this.segment.getSegmentId());
        }
        if (this.cluster != null && this.cluster.isDestroyed()) {
            throw new ClusterNotFoundException(this.segment.getDatabase(), this.segment.getSegmentId(), this.cluster.getClusterId());
        }
        if (this.objects == null) {
            return false;
        }
        if (this.checkCurrent()) {
            return true;
        }
        this.advance();
        return this.objects != null;
    }

    private boolean checkCurrent() {
        try {
            this.om.findObjRef(this.objects[this.position], true);
            return true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return false;
        }
    }

    private void advance() {
        int i;
        Database db;
        int newSchemaClassCount;
        if (this.ofType != null && this.isUserDefinedType && this.schemaClassCount != (newSchemaClassCount = (db = (Database)this.segment.getDatabase()).serverGetSchemaClassCount())) {
            this.om.schemaManager.extendAFTSubClasses(this.ofType, this.AFTs, db);
            this.schemaClassCount = newSchemaClassCount;
            if (!this.ofType.isArray() && this.ofType != String.class) {
                this.sizes = this.om.schemaManager.getAFTSizes(this.AFTs);
            }
        }
        ++this.position;
        while (this.position < this.nObjects) {
            if (this.checkCurrent()) {
                return;
            }
            ++this.position;
        }
        this.nObjects = this.ofType == null ? (this.cluster == null ? this.segment.serverGetObjects(this.buffer, this.last) : this.segment.serverGetObjects(this.buffer, this.cluster, this.last)) : (this.cluster == null ? this.segment.serverGetObjects(this.buffer, this.last, this.AFTs, this.sizes, this.ofType.isArray()) : this.segment.serverGetObjects(this.buffer, this.cluster, this.last, this.AFTs, this.sizes, this.ofType.isArray()));
        if (this.nObjects == 0) {
            this.objects = null;
            return;
        }
        this.position = 0;
        byte refSize = this.om.objectAccess.referenceSize;
        int offset = 0;
        for (i = 0; i < this.nObjects; ++i) {
            this.objects[i] = this.om.getJavaReference(this.buffer, offset);
            offset += refSize;
        }
        for (i = this.nObjects; i < this.objects.length; ++i) {
            this.objects[i] = null;
        }
    }

    private boolean isUserDefinedType() {
        Class check;
        if (this.ofType == String.class) {
            return false;
        }
        Class clazz = check = !this.ofType.isArray() ? this.ofType : Utilities.getArrayClassElementType(this.ofType);
        if (check.isInterface()) {
            return true;
        }
        return Utilities.getPrimitiveOrWrapperTypeCode(check) == 0;
    }
}

