/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.GenericObject;
import com.odi.IPersistentHooks;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.Persistent;
import com.odi.ReferencedObjectNotFoundException;
import com.odi.imp.IPersistentCacheHooks;
import com.odi.imp.Primes;
import com.odi.util.EmptyIterator;
import com.odi.util.IndexIterator;
import com.odi.util.OSDictionary;
import com.odi.util.OSHashtableCollectionView;
import com.odi.util.OSHashtableEntry;
import com.odi.util.OSHashtableIterator;
import com.odi.util.OSHashtableSetView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class OSHashtable
extends OSDictionary
implements Cloneable,
Serializable,
IPersistentHooks,
IPersistentCacheHooks {
    static final long serialVersionUID = -4154870047818990379L;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    OSHashtableEntry[] table;
    private int nTableEntries;
    private int reorgThreshold;
    private OSDictionary altRep;
    private static final float loadFactorDefault = 10.0f;
    private static boolean lazyAllocationDefault = false;
    private static final ClassInfo OSHI = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSHashtable"));

    @Override
    public void initializeContents(GenericObject genObject) {
        this.table = (OSHashtableEntry[])genObject.getArrayField(1, OSHI);
        this.nTableEntries = genObject.getIntField(2, OSHI);
        this.reorgThreshold = genObject.getIntField(3, OSHI);
        this.altRep = (OSDictionary)genObject.getClassField(4, OSHI);
        super.initializeContents(genObject);
        if (this.table != null) {
            ObjectStore.fetch(this.table);
        }
    }

    int getTick() {
        return -1;
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setArrayField(1, this.table, OSHI);
        genObject.setIntField(2, this.nTableEntries, OSHI);
        genObject.setIntField(3, this.reorgThreshold, OSHI);
        genObject.setClassField(4, this.altRep, OSHI);
        super.flushContents(genObject);
    }

    @Override
    public void clearContents() {
        this.table = null;
        this.nTableEntries = 0;
        this.reorgThreshold = 0;
        this.altRep = null;
        super.clearContents();
    }

    public synchronized void destroy() {
        ObjectStore.destroy(this);
    }

    @Override
    public void preDestroyPersistent() {
        if (this.ref == null) {
            return;
        }
        this.fetch();
        if (this.table == null) {
            return;
        }
        for (int bkt = 0; bkt < this.table.length; ++bkt) {
            if (this.table[bkt] == null) continue;
            this.table[bkt].destroyChain();
        }
        ObjectStore.destroy(this.table);
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContentsToCache() {
    }

    @Override
    public void postInitializeContentsFromCache() {
        if (this.table != null) {
            ObjectStore.fetch(this.table);
        }
    }

    private float loadFactor() {
        int slots = this.table == null ? -this.nTableEntries : this.table.length;
        return (float)this.reorgThreshold / (float)slots;
    }

    private static int recommendedSlots(int capacity, float loadFactor) {
        int minSlots = (double)loadFactor < 1.0 ? 11 : 5;
        return Math.max(minSlots, Primes.nextPrime((int)((float)capacity / loadFactor)));
    }

    private void grow() {
        float loadFactor = this.loadFactor();
        int slots = OSHashtable.recommendedSlots(this.nTableEntries * 3 / 2, loadFactor);
        this.reorg(slots, false, loadFactor);
    }

    private void reorg(int newTableSlots, boolean rehash, float loadFactor) {
        this.dirty();
        this.reorgThreshold = (int)((float)newTableSlots * loadFactor);
        OSHashtableEntry[] newTable = new OSHashtableEntry[newTableSlots];
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                OSHashtableEntry e = this.table[i];
                while (e != null) {
                    OSHashtableEntry nextE = e.getNext();
                    if (rehash) {
                        e.rehash();
                    }
                    int slot = (e.hash & Integer.MAX_VALUE) % newTable.length;
                    e.setNext(newTable[slot]);
                    newTable[slot] = e;
                    e = nextE;
                }
            }
            ObjectStore.destroy(this.table);
        }
        this.table = newTable;
    }

    private void allocateLazyTable() {
        this.reorg(-this.nTableEntries, false, this.loadFactor());
        this.nTableEntries = 0;
    }

    private OSHashtableEntry findEntry(Object key) {
        int hash = key.hashCode();
        int slot = (hash & Integer.MAX_VALUE) % this.table.length;
        ObjectNotFoundException firstNotFound = null;
        OSHashtableEntry e = this.table[slot];
        while (e != null) {
            block5: {
                try {
                    if (this.matchEntry(e, key, hash)) {
                        return e;
                    }
                }
                catch (ObjectNotFoundException onfe) {
                    if (firstNotFound != null) break block5;
                    firstNotFound = onfe;
                }
            }
            e = e.next;
        }
        if (firstNotFound != null) {
            OSHashtable.throwReferencedObjectNotFoundException(firstNotFound, true);
        }
        return null;
    }

    private boolean matchEntry(OSHashtableEntry e, Object key, int keyHash) {
        if (this.ref != null) {
            ObjectStore.fetch(e);
        }
        return e.hash == keyHash && key.equals(e.key);
    }

    private static void checkNull(Object o, String arg, String method) {
        if (o == null) {
            throw new NullPointerException("The " + arg + " argument to OSHashtable." + method + " is null.");
        }
    }

    public OSHashtable(ClassInfo ignored) {
    }

    public OSHashtable(int initialCapacity) {
        this(initialCapacity, lazyAllocationDefault, 10.0f);
    }

    public OSHashtable(int initialCapacity, boolean lazy) {
        this(initialCapacity, lazy, 10.0f);
    }

    public OSHashtable(int initialCapacity, boolean lazy, float loadFactor) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("OSHashtable initialCapacity");
        }
        if ((double)loadFactor <= 0.0) {
            throw new IllegalArgumentException("OSHashtable loadFactor");
        }
        int initialTableSize = OSHashtable.recommendedSlots(initialCapacity, loadFactor);
        if (lazy) {
            this.nTableEntries = -initialTableSize;
            this.reorgThreshold = (int)((float)initialTableSize * loadFactor);
            return;
        }
        this.reorg(initialTableSize, false, loadFactor);
    }

    public OSHashtable() {
        this(50);
    }

    @Override
    public int size() {
        this.fetch();
        if (this.nTableEntries < 0) {
            return 0;
        }
        if (this.altRep != null) {
            return this.altRep.size();
        }
        return this.nTableEntries;
    }

    @Override
    public boolean isEmpty() {
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.isEmpty();
        }
        if (this.table == null) {
            return true;
        }
        return this.nTableEntries == 0;
    }

    @Override
    public synchronized IndexIterator keys() {
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.keys();
        }
        if (this.table == null) {
            return EmptyIterator.theEmptyIterator;
        }
        return new OSHashtableIterator(this, 0);
    }

    @Override
    public synchronized IndexIterator elements() {
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.elements();
        }
        if (this.table == null) {
            return EmptyIterator.theEmptyIterator;
        }
        return new OSHashtableIterator(this, 1);
    }

    @Override
    public synchronized boolean contains(Object value) {
        OSHashtable.checkNull(value, "value", "contains");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.contains(value);
        }
        if (this.table == null) {
            return false;
        }
        ObjectNotFoundException firstNotFound = null;
        for (int i = 0; i < this.table.length; ++i) {
            OSHashtableEntry e = this.table[i];
            while (e != null) {
                block9: {
                    if (this.ref != null) {
                        ObjectStore.fetch(e);
                    }
                    try {
                        if (e.element.equals(value)) {
                            return true;
                        }
                    }
                    catch (ObjectNotFoundException onfe) {
                        if (firstNotFound != null) break block9;
                        firstNotFound = onfe;
                    }
                }
                e = e.next;
            }
        }
        if (firstNotFound != null) {
            OSHashtable.throwReferencedObjectNotFoundException(firstNotFound, false);
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key, false);
    }

    public synchronized boolean containsKey(Object key, boolean noCache) {
        boolean ret;
        OSHashtable.checkNull(key, "key", "containsKey");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.containsKey(key);
        }
        if (this.table == null) {
            return false;
        }
        OSHashtableEntry e = this.findEntry(key);
        boolean bl = ret = e != null;
        if (noCache) {
            ObjectStore.evict(e, 2);
        }
        return ret;
    }

    @Override
    public Object get(Object key) {
        return this.get(key, false);
    }

    public synchronized Object get(Object key, boolean noCache) {
        OSHashtable.checkNull(key, "key", "get");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.get(key);
        }
        if (this.table == null) {
            return null;
        }
        OSHashtableEntry e = this.findEntry(key);
        if (e == null) {
            return null;
        }
        Object ret = e.element;
        if (noCache) {
            ObjectStore.evict(e, 2);
        }
        return ret;
    }

    @Override
    public Object getKey(Object key) {
        return this.getKey(key, false);
    }

    public synchronized Object getKey(Object key, boolean noCache) {
        OSHashtable.checkNull(key, "key", "getKey");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.getKey(key);
        }
        if (this.table == null) {
            return null;
        }
        OSHashtableEntry e = this.findEntry(key);
        if (e == null) {
            return null;
        }
        Object ret = e.key;
        if (noCache) {
            ObjectStore.evict(e, 2);
        }
        return ret;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        OSHashtable.checkNull(key, "key", "put");
        OSHashtable.checkNull(value, "value", "put");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.put(key, value);
        }
        if (this.table == null) {
            this.allocateLazyTable();
        }
        int hash = key.hashCode();
        int slot = (hash & Integer.MAX_VALUE) % this.table.length;
        OSHashtableEntry e = null;
        ObjectNotFoundException firstNotFound = null;
        e = this.table[slot];
        while (e != null) {
            boolean matches;
            block13: {
                matches = false;
                try {
                    matches = this.matchEntry(e, key, hash);
                }
                catch (ObjectNotFoundException onfe) {
                    if (firstNotFound != null) break block13;
                    firstNotFound = onfe;
                }
            }
            if (matches) {
                if (this.ref != null) {
                    ObjectStore.dirty(e);
                }
                Object old = e.element;
                e.element = value;
                return old;
            }
            e = e.next;
        }
        if (firstNotFound != null) {
            OSHashtable.throwReferencedObjectNotFoundException(firstNotFound, true);
        }
        if (this.nTableEntries >= this.reorgThreshold) {
            this.grow();
            slot = (hash & Integer.MAX_VALUE) % this.table.length;
        }
        this.dirty();
        ++this.nTableEntries;
        e = new OSHashtableEntry(key, value, hash);
        OSHashtableEntry head = this.table[slot];
        if (head != null) {
            if (this.ref != null) {
                ObjectStore.dirty(head);
            }
            e.next = head.next;
            head.next = e;
        } else {
            if (this.ref != null) {
                ObjectStore.dirty(this.table);
            }
            e.next = null;
            this.table[slot] = e;
        }
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        OSHashtable.checkNull(key, "key", "remove");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.remove(key);
        }
        if (this.table == null) {
            return null;
        }
        int hash = key.hashCode();
        int slot = (hash & Integer.MAX_VALUE) % this.table.length;
        ObjectNotFoundException firstNotFound = null;
        OSHashtableEntry previous = null;
        for (OSHashtableEntry e = this.table[slot]; e != null; e = e.getNext()) {
            boolean matches;
            block11: {
                matches = false;
                try {
                    matches = this.matchEntry(e, key, hash);
                }
                catch (ObjectNotFoundException onfe) {
                    if (firstNotFound != null) break block11;
                    firstNotFound = onfe;
                }
            }
            if (matches) {
                Object old = e.element;
                if (previous == null) {
                    if (this.ref != null) {
                        ObjectStore.dirty(this.table);
                    }
                    this.table[slot] = e.next;
                } else {
                    if (this.ref != null) {
                        ObjectStore.dirty(previous);
                    }
                    previous.next = e.next;
                }
                ObjectStore.destroy(e);
                this.dirty();
                --this.nTableEntries;
                return old;
            }
            previous = e;
        }
        if (firstNotFound != null) {
            OSHashtable.throwReferencedObjectNotFoundException(firstNotFound, true);
        }
        return null;
    }

    @Override
    public synchronized boolean removeValue(Object value) {
        OSHashtable.checkNull(value, "value", "removeValue");
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.removeValue(value);
        }
        if (this.table == null) {
            return false;
        }
        ObjectNotFoundException firstNotFound = null;
        for (int i = 0; i < this.table.length; ++i) {
            OSHashtableEntry previous = null;
            OSHashtableEntry e = this.table[i];
            while (e != null) {
                block13: {
                    if (this.ref != null) {
                        ObjectStore.fetch(e);
                    }
                    try {
                        if (e.element.equals(value)) {
                            Object old = e.element;
                            if (previous == null) {
                                if (this.ref != null) {
                                    ObjectStore.dirty(this.table);
                                }
                                this.table[i] = e.next;
                            } else {
                                if (this.ref != null) {
                                    ObjectStore.dirty(previous);
                                }
                                previous.next = e.next;
                            }
                            ObjectStore.destroy(e);
                            this.dirty();
                            --this.nTableEntries;
                            return true;
                        }
                    }
                    catch (ObjectNotFoundException onfe) {
                        if (firstNotFound != null) break block13;
                        firstNotFound = onfe;
                    }
                }
                previous = e;
                e = e.next;
            }
        }
        if (firstNotFound != null) {
            OSHashtable.throwReferencedObjectNotFoundException(firstNotFound, false);
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.dirty();
        if (this.altRep != null) {
            this.altRep.clear();
            return;
        }
        if (this.table == null) {
            return;
        }
        if (this.ref != null) {
            ObjectStore.dirty(this.table);
        }
        for (int slot = 0; slot < this.table.length; ++slot) {
            if (this.table[slot] != null) {
                this.table[slot].destroyChain();
            }
            this.table[slot] = null;
        }
        this.nTableEntries = 0;
    }

    @Override
    public synchronized void clearDestroyed() {
        this.fetch();
        if (this.table == null) {
            return;
        }
        for (int slot = 0; slot < this.table.length; ++slot) {
            OSHashtableEntry prevEntry = null;
            OSHashtableEntry nextEntry = null;
            OSHashtableEntry entry = this.table[slot];
            while (entry != null) {
                if (this.ref != null) {
                    ObjectStore.fetch(entry);
                }
                nextEntry = entry.next;
                if (this.objectIsDestroyed(entry.key) || this.objectIsDestroyed(entry.element)) {
                    if (prevEntry == null) {
                        if (this.ref != null) {
                            ObjectStore.dirty(this.table);
                        }
                        this.table[slot] = nextEntry;
                    } else {
                        prevEntry.setNext(nextEntry);
                    }
                    ObjectStore.destroy(entry);
                    this.dirty();
                    --this.nTableEntries;
                } else {
                    prevEntry = entry;
                }
                entry = nextEntry;
            }
        }
    }

    public synchronized void rehash() {
        this.fetch();
        if (this.table != null) {
            this.reorg(this.table.length, true, this.loadFactor());
        }
    }

    public synchronized void resize(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("negative newCapicity");
        }
        this.fetch();
        int newSize = OSHashtable.recommendedSlots(Math.max(newCapacity, this.size()), this.loadFactor());
        if (this.table == null) {
            this.nTableEntries = -newSize;
        } else if (newSize < this.table.length * 2 / 3 || newSize > this.table.length * 3 / 2) {
            this.reorg(newSize, false, this.loadFactor());
        }
    }

    public synchronized void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor <= 0");
        }
        this.fetch();
        if (this.table == null) {
            this.reorgThreshold = (int)((float)(-this.nTableEntries) * loadFactor);
        } else if (this.reorgThreshold != (int)((float)this.table.length * loadFactor)) {
            this.reorg(this.table.length, false, loadFactor);
        }
    }

    @Override
    public synchronized Object clone() {
        this.fetch();
        try {
            OSHashtable newHashtable = (OSHashtable)super.clone();
            if (this.altRep != null) {
                newHashtable.altRep = (OSDictionary)this.altRep.clone();
            } else {
                if (this.table == null) {
                    return newHashtable;
                }
                newHashtable.table = new OSHashtableEntry[this.table.length];
                for (int i = 0; i < this.table.length; ++i) {
                    if (this.table[i] == null) continue;
                    newHashtable.table[i] = (OSHashtableEntry)this.table[i].clone();
                }
            }
            return newHashtable;
        }
        catch (CloneNotSupportedException e) {
            throw new FatalInternalException("Attempt to clone OSHashtable failed");
        }
    }

    public synchronized String toString() {
        this.fetch();
        if (this.altRep != null) {
            return this.altRep.toString();
        }
        IndexIterator e = this.keys();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        while (e.hasNext()) {
            Object key = e.next();
            ObjectStore.fetch(key);
            Object element = this.get(key);
            ObjectStore.fetch(element);
            buf.append("[");
            buf.append(key.toString());
            buf.append(",");
            if (element == this) {
                buf.append("this");
            } else {
                buf.append(element.toString());
            }
            buf.append("]");
        }
        buf.append("]");
        return buf.toString();
    }

    private boolean objectIsDestroyed(Object object) {
        if (object != null) {
            try {
                ObjectStore.fetch(object);
                return false;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    private static void throwReferencedObjectNotFoundException(ObjectNotFoundException origException, boolean wasKey) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(stream);
        origException.printStackTrace(pw);
        pw.flush();
        String objKind = wasKey ? "key" : "value";
        throw new ReferencedObjectNotFoundException("A " + objKind + " object referenced by this OSHashtable was " + "was not found.  This object may have been destroyed by an " + "earlier operation.  You can use the clearDestroyed() method to " + "clear any entries from this OSHashtable which reference " + "destroyed objects.\n" + "Stack trace at point of original failure:\n" + "*****************************************\n" + stream + "*****************************************\n");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Persistent.hasReadBarrier(this)) {
            throw new ObjectStoreException("OSHashtable.writeObject() invoked without a preceding call to ObjectStore.deepFetch()");
        }
        out.writeInt(this.table != null ? this.table.length : 0);
        out.writeInt(this.nTableEntries);
        out.writeInt(this.reorgThreshold);
        out.writeObject(this.altRep);
        if (this.table == null) {
            return;
        }
        int entryCount = 0;
        for (int i = 0; i < this.table.length; ++i) {
            OSHashtableEntry e = this.table[i];
            while (e != null) {
                out.writeObject(e.key);
                out.writeObject(e.element);
                ++entryCount;
                e = e.next;
            }
        }
        if (entryCount != this.nTableEntries) {
            throw new ObjectStoreException("OSHashtable.writeObject() seems to have been invoked without a preceding call to ObjectStore.deepFetch(), since its cached element count (" + this.nTableEntries + ") != computed count (" + entryCount + ")");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        int nElements = in.readInt();
        this.reorgThreshold = in.readInt();
        this.altRep = (OSDictionary)in.readObject();
        if (nElements >= 0) {
            this.table = new OSHashtableEntry[length];
            this.nTableEntries = 0;
            for (int i = 0; i < nElements; ++i) {
                Object key = in.readObject();
                Object element = in.readObject();
                this.put(key, element);
            }
        } else {
            this.nTableEntries = nElements;
        }
    }

    public static void setLazyAllocationDefault(boolean lazyDefault) {
        lazyAllocationDefault = lazyDefault;
    }

    public static boolean getLazyAllocationDefault() {
        return lazyAllocationDefault;
    }

    public boolean isLazy() {
        return this.table == null;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public synchronized void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Set keySet() {
        if (this.altRep != null) {
            return this.altRep.keySet();
        }
        return new OSHashtableSetView(this, 0);
    }

    @Override
    public synchronized Collection values() {
        if (this.altRep != null) {
            return this.altRep.values();
        }
        return new OSHashtableCollectionView(this, 1);
    }

    @Override
    public synchronized Set entrySet() {
        if (this.altRep != null) {
            return this.altRep.entrySet();
        }
        return new OSHashtableSetView(this, 2);
    }

    public synchronized Set entries() {
        return this.entrySet();
    }
}

