/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.GenericObject;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.ReferencedObjectNotFoundException;
import com.odi.imp.IPersistentCacheHooks;
import com.odi.imp.Utilities;
import com.odi.util.FastContains;
import com.odi.util.OSAbstractSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OSSmallSet
extends OSAbstractSet
implements Serializable,
FastContains,
IPersistentCacheHooks {
    static final long serialVersionUID = -7382884312151318213L;
    protected Object[] table;
    protected int nEntries;
    private static final byte versionNumber = 1;
    private static final ClassInfo classInfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSSmallSet"));

    @Override
    public void initializeContents(GenericObject genObject) {
        this.table = (Object[])genObject.getArrayField(1, classInfo);
        this.nEntries = genObject.getIntField(2, classInfo);
        if (this.table != null) {
            ObjectStore.fetch(this.table);
        }
    }

    @Override
    public void flushContents(GenericObject genObject) {
        if (this.table != null && !this.hasWriteBarrier()) {
            ObjectStore.dirty(this.table);
        }
        genObject.setArrayField(1, this.table, classInfo);
        genObject.setIntField(2, this.nEntries, classInfo);
    }

    @Override
    public void clearContents() {
        this.table = null;
        this.nEntries = 0;
    }

    public OSSmallSet(ClassInfo ignored) {
    }

    private boolean hasReadBarrier() {
        return this.ODIObjectState < 0;
    }

    private boolean hasWriteBarrier() {
        return (this.ODIObjectState & 2) != 0;
    }

    private void fetch() {
        if (this.hasReadBarrier()) {
            ObjectStore.fetch(this);
        }
    }

    private void dirty() {
        if (this.hasWriteBarrier()) {
            ObjectStore.dirty(this);
        }
    }

    @Override
    public void preDestroyPersistent() {
        this.fetch();
        if (this.table != null && ObjectStore.isPersistent(this)) {
            ObjectStore.destroy(this.table);
        }
    }

    @Override
    public void preFlushContentsToCache() {
    }

    @Override
    public void postInitializeContentsFromCache() {
        if (this.table != null) {
            ObjectStore.fetch(this.table);
        }
    }

    protected boolean needsToGrow() {
        return this.nEntries >= (this.nSlots() * 3 + 1) / 4;
    }

    protected void grow() {
        int newSlots = this.nSlots() * 2 - 1;
        this.reorg(newSlots);
    }

    protected int recommendedSize(int capacity) {
        int size = capacity <= 4 ? 5 : (capacity * 4 + 1) / 3;
        return size % 2 == 1 ? size : size + 1;
    }

    protected void allocateLazyTable() {
        if (this.nEntries >= 0) {
            throw new FatalInternalException("Corrupt OSSmallSet.nEntries");
        }
        this.reorg(-this.nEntries);
        this.nEntries = 0;
    }

    private int nSlots() {
        return this.table == null ? 0 : this.table.length;
    }

    private int nextSlot(int slot) {
        return (slot + 1) % this.table.length;
    }

    private int findEntry(Object key) {
        return this.findEntry(key, false);
    }

    private int findEntry(Object key, boolean noThrow) {
        ObjectNotFoundException firstONFException = null;
        int slot = (key.hashCode() & Integer.MAX_VALUE) % this.table.length;
        Object k = this.table[slot];
        while (k != null) {
            block5: {
                try {
                    if (key.equals(k)) {
                        return slot;
                    }
                }
                catch (ObjectNotFoundException onfe) {
                    if (firstONFException != null) break block5;
                    firstONFException = onfe;
                }
            }
            slot = this.nextSlot(slot);
            k = this.table[slot];
        }
        if (firstONFException != null && !noThrow) {
            OSSmallSet.throwReferencedObjectNotFound(firstONFException);
        }
        return -slot - 1;
    }

    private void removeFromSlot(int objSlot) {
        this.dirty();
        --this.nEntries;
        this.table[objSlot] = null;
        int emptySlot = objSlot;
        int slot = this.nextSlot(emptySlot);
        while (this.table[slot] != null) {
            Object obj = this.table[slot];
            int findSlot = this.findEntry(obj, true);
            if (findSlot < 0) {
                if ((findSlot = -findSlot - 1) != emptySlot) {
                    throw new FatalInternalException("Corruption in OSSmallSet.remove");
                }
                this.table[emptySlot] = obj;
                this.table[slot] = null;
                emptySlot = slot;
            }
            slot = this.nextSlot(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorg(int newTableSlots) {
        this.dirty();
        Object[] oldTable = this.table;
        int oldNumEntries = this.nEntries;
        boolean done = false;
        this.table = new Object[newTableSlots];
        this.nEntries = 0;
        if (oldTable != null) {
            try {
                int end = oldTable.length;
                for (int i = 0; i < end; ++i) {
                    Object obj = oldTable[i];
                    if (obj == null) continue;
                    this.add(obj);
                }
                if (ObjectStore.isPersistent(this)) {
                    ObjectStore.destroy(oldTable);
                }
                done = true;
            }
            catch (ObjectNotFoundException e) {
                OSSmallSet.throwReferencedObjectNotFound(e);
            }
            finally {
                if (!done) {
                    this.table = oldTable;
                    this.nEntries = oldNumEntries;
                }
            }
        }
    }

    private static void throwReferencedObjectNotFound(ObjectNotFoundException origException) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(stream);
        origException.printStackTrace(pw);
        pw.flush();
        throw new ReferencedObjectNotFoundException("An object referenced by this OSSmallSet was not found.  This object may have been destroyed by an earlier operation.  You can use the clearDestroyed() method to clear any entries from this OSSmallSet which reference destroyed objects.\nStack trace at point of original failure:\n*****************************************\n" + stream + "*****************************************\n");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.hasReadBarrier()) {
            throw new ObjectStoreException("OSSmallSet.writeObject() invoked without a preceding call to ObjectStore.deepFetch()");
        }
        out.writeByte(1);
        out.writeInt(this.table == null ? 0 : this.table.length);
        out.writeInt(this.nEntries);
        if (this.table == null) {
            return;
        }
        int entryCount = 0;
        for (Object obj : this.table) {
            if (obj == null) continue;
            ++entryCount;
            out.writeObject(obj);
        }
        if (entryCount != this.nEntries) {
            throw new ObjectStoreException("OSSmallSet.writeObject() seems to have been invoked without a preceding call to ObjectStore.deepFetch(), since its cached element count (" + this.nEntries + ") != computed count (" + entryCount + ")");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte ver = in.readByte();
        if (ver != 1) {
            throw new IOException("Wrong version of OSSmallMap found.");
        }
        int length = in.readInt();
        int nElements = in.readInt();
        if (nElements < 0) {
            this.table = null;
            this.nEntries = nElements;
        } else {
            this.table = new Object[length];
            this.nEntries = 0;
            for (int i = 0; i < nElements; ++i) {
                Object obj = in.readObject();
                this.add(obj);
            }
        }
    }

    public OSSmallSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative initialCapacity");
        }
        this.nEntries = -this.recommendedSize(initialCapacity);
    }

    public OSSmallSet() {
        this(3);
    }

    public OSSmallSet(Collection c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public int size() {
        this.fetch();
        if (this.nEntries < 0) {
            return 0;
        }
        return this.nEntries;
    }

    @Override
    public boolean isEmpty() {
        this.fetch();
        return this.nEntries <= 0;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        this.fetch();
        return this.table != null && this.findEntry(obj) >= 0;
    }

    @Override
    public Iterator iterator() {
        return new SmallSetIterator();
    }

    @Override
    public boolean add(Object obj) {
        int objSlot;
        if (obj == null) {
            Utilities.throwNullArgumentException("OSSmallSet", "add", "obj");
        }
        if (obj == this) {
            throw new IllegalArgumentException("OSSmallSet: Set may not contain itself");
        }
        this.fetch();
        if (this.table == null) {
            this.allocateLazyTable();
        }
        if ((objSlot = this.findEntry(obj)) >= 0) {
            return false;
        }
        if (this.needsToGrow()) {
            this.grow();
            objSlot = this.findEntry(obj);
            if (objSlot >= 0) {
                throw new FatalInternalException("Unfound obj mysteriously found after growing the OSSmallSet");
            }
        }
        objSlot = -objSlot - 1;
        this.dirty();
        ++this.nEntries;
        this.table[objSlot] = obj;
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (obj == null) {
            Utilities.throwNullArgumentException("OSSmallSet", "remove", "obj");
        }
        this.fetch();
        if (this.table == null) {
            return false;
        }
        int objSlot = this.findEntry(obj);
        if (objSlot < 0) {
            return false;
        }
        this.removeFromSlot(objSlot);
        return true;
    }

    @Override
    public void clear() {
        this.fetch();
        if (this.table == null) {
            return;
        }
        this.dirty();
        if (ObjectStore.isPersistent(this)) {
            ObjectStore.destroy(this.table);
        }
        this.table = null;
        this.nEntries = -this.recommendedSize(3);
    }

    public void clearDestroyed() {
        this.fetch();
        if (this.table == null) {
            return;
        }
        boolean found = false;
        int end = this.table.length;
        for (int slot = 0; slot < end; ++slot) {
            if (!ObjectStore.isDestroyed(this.table[slot])) continue;
            found = true;
            this.dirty();
            --this.nEntries;
            this.table[slot] = null;
        }
        if (found) {
            this.reorg(this.recommendedSize(this.size()));
        }
    }

    public void rehash() {
        this.fetch();
        this.reorg(this.recommendedSize(this.size()));
    }

    public void resize(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("negative newCapicity");
        }
        this.fetch();
        int newSize = this.recommendedSize(Math.max(newCapacity, this.size()));
        if (newSize < this.nSlots() * 2 / 3 || newSize > this.nSlots() * 3 / 2) {
            this.reorg(newSize);
        }
    }

    protected class SmallSetIterator
    implements Iterator {
        protected int currSlot;
        protected int nextSlot;
        protected boolean currentRemoved;

        SmallSetIterator() {
            this.nextSlot = this.currSlot = -1;
            this.currentRemoved = false;
        }

        @Override
        public boolean hasNext() {
            OSSmallSet.this.fetch();
            if (OSSmallSet.this.table == null) {
                return false;
            }
            int end = OSSmallSet.this.table.length;
            if (this.nextSlot == this.currSlot) {
                if (!this.currentRemoved) {
                    ++this.nextSlot;
                }
                while (this.nextSlot < end && OSSmallSet.this.table[this.nextSlot] == null) {
                    ++this.nextSlot;
                }
            }
            return this.nextSlot < end;
        }

        public Object next() {
            Object obj = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException("OSSmallSet.Iterator has no next");
            }
            this.currSlot = this.nextSlot;
            this.currentRemoved = false;
            return OSSmallSet.this.table[this.currSlot];
        }

        @Override
        public void remove() {
            Object obj;
            OSSmallSet.this.fetch();
            Object object = obj = this.currSlot < 0 ? null : OSSmallSet.this.table[this.currSlot];
            if (obj == null || this.currentRemoved) {
                throw new IllegalStateException("OSSmallSet.Iterator");
            }
            OSSmallSet.this.removeFromSlot(this.currSlot);
            this.currentRemoved = true;
        }
    }
}

