/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.TypedMap;
import com.odi.util.TypedMapEntry;
import java.util.Enumeration;
import java.util.Iterator;

class TypedMapIterator
implements Iterator {
    private TypedMap map;
    private int iterateWhat;
    private Enumeration enumeration;
    private Object currentKey = this;

    TypedMapIterator(TypedMap m, int what) {
        this.map = m;
        this.enumeration = this.map.keys();
        this.iterateWhat = what;
        if (what != 0 && what != 1 && what != 2) {
            throw new IllegalArgumentException("unrecognized case in TypedMapIterator: " + what);
        }
    }

    @Override
    public boolean hasNext() {
        return this.enumeration.hasMoreElements();
    }

    public Object next() {
        this.currentKey = this.enumeration.nextElement();
        switch (this.iterateWhat) {
            case 0: {
                return this.currentKey;
            }
            case 1: {
                return this.map.get(this.currentKey);
            }
            case 2: {
                return new TypedMapEntry(this.currentKey, this.map.get(this.currentKey));
            }
        }
        return null;
    }

    @Override
    public void remove() {
        if (this.currentKey == this) {
            throw new IllegalStateException("iterator.remove() called with no current element");
        }
        this.map.remove(this.currentKey);
        this.currentKey = this;
    }
}

