/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.FatalInternalException;
import com.odi.ObjectStore;
import com.odi.StaleEnumeratorException;
import com.odi.Transaction;
import com.odi.util.query.FreeVariableBindings;
import com.odi.util.query.FreeVariables;
import com.odi.util.query.Methods;
import com.odi.util.query.MethodsGenerator;
import com.odi.util.query.QPT;
import com.odi.util.query.Query;
import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.QueryException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class QueryEvalTree {
    int indexLookups;
    int nonIndexLookups;
    private QueryEvalNode node;
    private Methods methods;
    private FreeVariables freeVariables;
    private boolean used = false;
    Collection collection;

    public QueryEvalTree(QPT qpt, QueryEvalNode topNode) {
        this.node = topNode;
        MethodsGenerator generator = new MethodsGenerator(qpt.freeVariables, qpt.elementType);
        this.node.computeMethods(generator);
        this.methods = generator.createInstance(qpt.elementType.getClassLoader());
        this.freeVariables = qpt.freeVariables;
        if (Query.debugLevel() >= 5) {
            System.err.println("\nQuery debugging -- unbound evaluation tree:");
            PrintWriter writer = new PrintWriter(System.err);
            this.print(writer);
            writer.flush();
        }
    }

    public QueryEvalTree bind(FreeVariableBindings freeVariableBindings, Collection collection) {
        return new QueryEvalTree(this, freeVariableBindings, collection);
    }

    public Object pick() {
        this.assertUnused();
        this.used = true;
        Object result = null;
        NoSuchElementException exception = null;
        try {
            result = this.node.pick();
        }
        catch (NoSuchElementException e) {
            exception = e;
        }
        this.maybePrintStatistics();
        if (Query.debugLevel() >= 5) {
            System.err.println("\nQuery debugging -- bound evaluation tree:");
            PrintWriter writer = new PrintWriter(System.err);
            this.print(writer);
            writer.flush();
        }
        if (exception == null) {
            return result;
        }
        throw exception;
    }

    public Set getSet() {
        this.assertUnused();
        this.used = true;
        Set result = this.node.getSet(true);
        this.maybePrintStatistics();
        if (Query.debugLevel() >= 5) {
            System.err.println("\nQuery debugging -- bound evaluation tree:");
            PrintWriter writer = new PrintWriter(System.err);
            this.print(writer);
            writer.flush();
        }
        return result;
    }

    public Iterator iterator() {
        this.assertUnused();
        this.used = true;
        return new NodeIterator();
    }

    public void print(PrintWriter out) {
        out.println(this + " {");
        out.println("  Free variables:");
        if (this.freeVariables.isEmpty()) {
            out.println("    None");
        } else {
            Enumeration enumerateVariables = this.freeVariables.keys();
            while (enumerateVariables.hasMoreElements()) {
                String name = (String)enumerateVariables.nextElement();
                Class type = (Class)this.freeVariables.get(name);
                out.println("    " + name + ": " + type);
            }
        }
        out.println("  Evaluation node:");
        this.node.print(out, 2);
        out.println("}");
    }

    private QueryEvalTree(QueryEvalTree unbound, FreeVariableBindings freeVariableBindings, Collection collection) {
        this.freeVariables = unbound.freeVariables;
        this.checkBindings(freeVariableBindings);
        this.methods = (Methods)unbound.methods.clone();
        this.methods.bind(freeVariableBindings);
        this.node = unbound.node.bind(freeVariableBindings, collection, this.methods);
        this.collection = collection;
    }

    private void assertUnused() {
        if (this.used) {
            throw new FatalInternalException("Attempt to perform a second collection operation on a query evaluation tree.");
        }
    }

    private void checkBindings(FreeVariableBindings freeVariableBindings) {
        String missing = null;
        Enumeration variables = this.freeVariables.keys();
        while (variables.hasMoreElements()) {
            String variableName = (String)variables.nextElement();
            if (freeVariableBindings.containsKey(variableName)) continue;
            missing = missing == null ? "" : missing + ", ";
            missing = missing + variableName;
        }
        String extra = null;
        String badValues = null;
        Enumeration bindings = freeVariableBindings.keys();
        while (bindings.hasMoreElements()) {
            Object value;
            String variableName = (String)bindings.nextElement();
            if (!this.freeVariables.containsKey(variableName)) {
                extra = extra == null ? "" : extra + ", ";
                extra = extra + variableName;
                continue;
            }
            Class variableType = (Class)this.freeVariables.get(variableName);
            if (this.goodVariableValue(variableType, value = freeVariableBindings.get(variableName))) continue;
            badValues = badValues == null ? "" : badValues + ", ";
            badValues = badValues + variableName;
        }
        if (missing != null || extra != null || badValues != null) {
            String message = "Problems detected in free variable bindings.";
            if (missing != null) {
                message = message + "\nNo values were specified for the following variables: " + missing;
            }
            if (extra != null) {
                message = message + "\nValues were specified for the following variables, which were not free variables for the query: " + extra;
            }
            if (badValues != null) {
                message = message + "\nValues with the wrong type were specified for the following variables: " + badValues;
            }
            throw new QueryException(message);
        }
    }

    private boolean goodVariableValue(Class type, Object value) {
        if (value == null) {
            return !type.isPrimitive();
        }
        Class<?> valueType = value.getClass();
        if (!type.isPrimitive()) {
            return type.isAssignableFrom(valueType);
        }
        if (type == Boolean.TYPE) {
            return valueType == Boolean.class;
        }
        if (type == Byte.TYPE) {
            return valueType == Byte.class;
        }
        if (type == Short.TYPE) {
            return valueType == Short.class;
        }
        if (type == Character.TYPE) {
            return valueType == Character.class;
        }
        if (type == Integer.TYPE) {
            return valueType == Integer.class;
        }
        if (type == Long.TYPE) {
            return valueType == Long.class;
        }
        if (type == Float.TYPE) {
            return valueType == Float.class;
        }
        if (type == Double.TYPE) {
            return valueType == Double.class;
        }
        throw new FatalInternalException("Unexpected type: " + type);
    }

    void collectStatistics() {
        this.node.collectStatistics(this);
    }

    void maybePrintStatistics() {
        if (Query.debugLevel() < 1) {
            return;
        }
        this.collectStatistics();
        System.err.println("\nQuery debugging -- index usage:");
        System.err.println("  Indexed lookups: " + this.indexLookups);
        System.err.println("  Non-indexed lookups: " + this.nonIndexLookups);
    }

    class NodeIterator
    implements Iterator {
        private Iterator nodeIterator;
        private Transaction lastTransaction;
        private boolean debugInfoDone;

        NodeIterator() {
            this.nodeIterator = QueryEvalTree.this.node.iterator(false);
            if (ObjectStore.isPersistent(QueryEvalTree.this.collection)) {
                this.lastTransaction = Transaction.current();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkStale();
            boolean result = this.nodeIterator.hasNext();
            if (!result && !this.debugInfoDone) {
                this.maybePrintDebugInfo();
            }
            return result;
        }

        public Object next() {
            this.checkStale();
            try {
                return this.nodeIterator.next();
            }
            catch (NoSuchElementException e) {
                if (!this.debugInfoDone) {
                    this.maybePrintDebugInfo();
                }
                throw e;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove() method is not supported on this iterator.");
        }

        private void checkStale() {
            if (this.lastTransaction == null) {
                return;
            }
            if (this.lastTransaction.isAborted()) {
                throw new StaleEnumeratorException("Query");
            }
            if (!this.lastTransaction.isActive()) {
                this.lastTransaction = Transaction.current();
                if (ObjectStore.isStale(QueryEvalTree.this.collection)) {
                    throw new StaleEnumeratorException("Query");
                }
            }
        }

        private void maybePrintDebugInfo() {
            QueryEvalTree.this.maybePrintStatistics();
            if (Query.debugLevel() >= 5) {
                System.err.println("\nQuery debugging -- bound evaluation tree:");
                PrintWriter writer = new PrintWriter(System.err);
                QueryEvalTree.this.print(writer);
                writer.flush();
            }
            this.debugInfoDone = true;
        }
    }
}

