/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsListElement;
import com.progress.blackbird.evs.nio.EvsListHead;
import com.progress.blackbird.evs.nio.EvsObject;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;

final class EvsChannelInterestHeap
extends EvsObject {
    private Selector selector;
    private InterestTable interestTable;
    private EvsListHead interestCloseQ;

    private EvsChannelInterestHeap(Selector selector) {
        this.selector = selector;
        this.interestTable = new InterestTable();
        this.interestCloseQ = EvsListHead.create();
    }

    static EvsChannelInterestHeap create(Selector selector) {
        return new EvsChannelInterestHeap(selector);
    }

    final void addInterest(SelectableChannel selectableChannel, EvsDispatcherEvent evsDispatcherEvent) {
        Interest interest;
        if (this.checked) {
            if (selectableChannel == null) {
                throw new IllegalArgumentException("Null channel");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (2 != evsDispatcherEvent.getClazz() && 3 != evsDispatcherEvent.getClazz() && 4 != evsDispatcherEvent.getClazz() && 5 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
        }
        if ((interest = (Interest)evsDispatcherEvent.getAttachment()) == null && (interest = (Interest)this.interestTable.table.get(selectableChannel)) == null) {
            interest = new Interest(selectableChannel);
        }
        if (this.checked && interest.getChannel() != selectableChannel) {
            throw new IllegalArgumentException("Provided event is associated with a different channel");
        }
        if (interest.key == null) {
            if (this.checked && interest.state != 0) {
                throw new InternalError("Internal error : Interest key is null for non-closed interest!");
            }
            try {
                interest.key = selectableChannel.register(this.selector, 0, interest);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to register channel with selector (Exception = " + exception + ")");
            }
        }
        switch (evsDispatcherEvent.getClazz()) {
            case 2: {
                if (this.checked && interest.acceptEvent != null) {
                    throw new RuntimeException("ACCEPT interest already recorded");
                }
                try {
                    interest.key.interestOps(interest.key.interestOps() | 0x10);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to add ACCEPT interest in selection key (Exception = " + exception + ")");
                }
                interest.acceptEvent = evsDispatcherEvent;
                break;
            }
            case 3: {
                if (this.checked && interest.connectEvent != null) {
                    throw new RuntimeException("CONNECT interest already recorded");
                }
                try {
                    interest.key.interestOps(interest.key.interestOps() | 8);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to add CONNECT interest in selection key (Exception = " + exception + ")");
                }
                interest.connectEvent = evsDispatcherEvent;
                break;
            }
            case 4: {
                if (this.checked && interest.readEvent != null) {
                    throw new RuntimeException("READ interest already recorded");
                }
                try {
                    interest.key.interestOps(interest.key.interestOps() | 1);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to add READ interest in selection key (Exception = " + exception + ")");
                }
                interest.readEvent = evsDispatcherEvent;
                break;
            }
            case 5: {
                if (this.checked && interest.writeEvent != null) {
                    throw new RuntimeException("WRITE interest already recorded");
                }
                try {
                    interest.key.interestOps(interest.key.interestOps() | 4);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to add WRITE interest in selection key (Exception = " + exception + ")");
                }
                interest.writeEvent = evsDispatcherEvent;
                break;
            }
            default: {
                throw new Error("Invalid dispatcher event class - " + evsDispatcherEvent.getClazz());
            }
        }
        if (interest.state == 0) {
            this.interestTable.table.put(interest.channel, interest);
        } else if (interest.state == 2) {
            interest.remove();
        }
        evsDispatcherEvent.setAttachment(interest);
        interest.state = 1;
    }

    final int getSize() {
        return this.interestTable.table.size();
    }

    final int getCloseQueueSize() {
        return this.interestCloseQ.getListSize();
    }

    final boolean removeInterest(SelectableChannel selectableChannel, EvsDispatcherEvent evsDispatcherEvent) {
        Interest interest;
        boolean bl = false;
        if (this.checked) {
            if (selectableChannel == null) {
                throw new IllegalArgumentException("Null channel");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (2 != evsDispatcherEvent.getClazz() && 3 != evsDispatcherEvent.getClazz() && 4 != evsDispatcherEvent.getClazz() && 5 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
        }
        if ((interest = (Interest)evsDispatcherEvent.getAttachment()) != null) {
            switch (evsDispatcherEvent.getClazz()) {
                case 2: {
                    if (interest.acceptEvent != evsDispatcherEvent) break;
                    try {
                        interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFEF);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to remove ACCEPT interest in selection key (Exception = " + exception + ")");
                    }
                    interest.acceptEvent = null;
                    bl = true;
                    break;
                }
                case 3: {
                    if (interest.connectEvent != evsDispatcherEvent) break;
                    try {
                        interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFF7);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to remove CONNECT interest in selection key (Exception = " + exception + ")");
                    }
                    interest.connectEvent = null;
                    bl = true;
                    break;
                }
                case 4: {
                    if (interest.readEvent != evsDispatcherEvent) break;
                    try {
                        interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFFE);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to remove READ interest in selection key (Exception = " + exception + ")");
                    }
                    interest.readEvent = null;
                    bl = true;
                    break;
                }
                case 5: {
                    if (interest.writeEvent != evsDispatcherEvent) break;
                    try {
                        interest.key.interestOps(interest.key.interestOps() & 0xFFFFFFFB);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to remove WRITE interest in selection key (Exception = " + exception + ")");
                    }
                    interest.writeEvent = null;
                    bl = true;
                    break;
                }
                default: {
                    throw new Error("Invalid dispatcher event class - " + evsDispatcherEvent.getClazz());
                }
            }
            if (bl) {
                if (interest.key.interestOps() == 0) {
                    if (this.checked && (interest.acceptEvent != null || interest.connectEvent != null || interest.readEvent != null || interest.writeEvent != null)) {
                        throw new InternalError("Internal error - interestOps is zero while one or more events are scheduled");
                    }
                    this.interestCloseQ.append(interest);
                    interest.state = 2;
                }
                return true;
            }
        }
        return false;
    }

    final void flushCloseQueue() {
        Interest interest;
        while ((interest = (Interest)this.interestCloseQ.getNext()) != null) {
            if (interest.state == 2 && this.interestTable.table.remove(interest.channel) == interest) {
                interest.state = 0;
                interest.remove();
                interest.key.cancel();
                interest.key = null;
                continue;
            }
            throw new InternalError("Internal error : Interest close queue and interest table out of sync!");
        }
    }

    class Interest
    extends EvsListElement {
        private int state;
        private SelectableChannel channel;
        private SelectionKey key;
        private EvsDispatcherEvent acceptEvent;
        private EvsDispatcherEvent connectEvent;
        private EvsDispatcherEvent readEvent;
        private EvsDispatcherEvent writeEvent;
        static final int STATE_CLOSED = 0;
        static final int STATE_OPEN = 1;
        static final int STATE_PENDING_CLOSE = 2;

        private Interest(SelectableChannel selectableChannel) {
            this.channel = selectableChannel;
            this.state = 0;
        }

        int getState() {
            return this.state;
        }

        SelectableChannel getChannel() {
            return this.channel;
        }

        EvsDispatcherEvent getAcceptEvent() {
            if (this.checked && (this.acceptEvent != null && (this.key == null || (this.key.interestOps() & 0x10) == 0) || this.acceptEvent == null && this.key != null && (this.key.interestOps() & 0x10) != 0)) {
                throw new InternalError("Internal error - interestOps is out of sync with stored events");
            }
            return this.acceptEvent;
        }

        boolean isAcceptReady() {
            return this.getAcceptEvent() != null && this.key.isAcceptable();
        }

        EvsDispatcherEvent getConnectEvent() {
            if (this.checked && (this.connectEvent != null && (this.key == null || (this.key.interestOps() & 8) == 0) || this.connectEvent == null && this.key != null && (this.key.interestOps() & 8) != 0)) {
                throw new InternalError("Internal error - interestOps is out of sync with stored events");
            }
            return this.connectEvent;
        }

        boolean isConnectReady() {
            return this.getConnectEvent() != null && this.key.isConnectable();
        }

        EvsDispatcherEvent getReadEvent() {
            if (this.checked && (this.readEvent != null && (this.key == null || (this.key.interestOps() & 1) == 0) || this.readEvent == null && this.key != null && (this.key.interestOps() & 1) != 0)) {
                throw new InternalError("Internal error - interestOps is out of sync with stored events");
            }
            return this.readEvent;
        }

        boolean isReadReady() {
            return this.getReadEvent() != null && this.key.isReadable();
        }

        EvsDispatcherEvent getWriteEvent() {
            if (this.checked && (this.writeEvent != null && (this.key == null || (this.key.interestOps() & 4) == 0) || this.writeEvent == null && this.key != null && (this.key.interestOps() & 4) != 0)) {
                throw new InternalError("Internal error - interestOps is out of sync with stored events");
            }
            return this.writeEvent;
        }

        boolean isWriteReady() {
            return this.getWriteEvent() != null && this.key.isWritable();
        }
    }

    private class InterestTable {
        HashMap table = new HashMap();

        InterestTable() {
        }
    }
}

