/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.nwlink.ssl;

import com.progress.blackbird.nwlink.ENwLinkException;
import com.progress.blackbird.nwlink.INwLink;
import com.progress.blackbird.nwlink.INwLinkStatistics;
import com.progress.blackbird.nwlink.NwLink;
import com.progress.blackbird.nwlink.NwLinkDescriptorParser;
import com.progress.blackbird.nwlink.tcp.TCPNwLink;
import com.progress.blackbird.sys.ESysIoctlException;
import com.progress.blackbird.sys.ISysIoctl;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysStatistics;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManagerFactory;

public final class SSLNwLink
extends NwLink
implements INwLink {
    private final NwLink.BooleanProperty authenticate = new NwLink.BooleanProperty("authenticate", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.authenticate", "true"));
    private final NwLink.StringProperty keyStoreFileName = new NwLink.StringProperty("keyStoreFilename", null);
    private final NwLink.StringProperty keyStorePassword = new NwLink.StringProperty("keyStorePassword", "");
    private final NwLink.StringProperty trustStoreFileName = new NwLink.StringProperty("trustStoreFilename", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.trustStoreFilename", null));
    private final NwLink.StringProperty trustStorePassword = new NwLink.StringProperty("trustStorePassword", null);
    private final NwLink.StringProperty protocols = new NwLink.StringProperty("protocols", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.protocols", null));
    private final NwLink.StringProperty cipherSuites = new NwLink.StringProperty("cipherSuites", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.cipherSuites", null));
    private final NwLink.BooleanProperty needClientAuth = new NwLink.BooleanProperty("needClientAuth", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.needClientAuth", "false"));
    private final NwLink.IntProperty handshakeTimeout = new NwLink.IntProperty("handshakeTimeout", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.handshakeTimeout", "20"));
    private final NwLink.IntProperty closeTimeout = new NwLink.IntProperty("closeTimeout", SysConfig.getConfigValue(SysConfig.getProperties(), "bb.nwlink.ssl.closeTimeout", "10"));
    private final INwLink tcpLink;
    private final SSLEngine sslEngine;
    private final ByteBuffer inNetBuffer;
    private final ByteBuffer outNetBuffer;
    private final ByteBuffer inAppBuffer;
    private final Statistics statistics;
    private WriteResumeContext writeResumeContext;
    private boolean flgSSLSessionOpen;
    private static final String AUTHENTICATE_PROPNAME = "authenticate";
    private static final String KEYSTORE_FILENAME_PROPNAME = "keyStoreFilename";
    private static final String KEYSTORE_PASSWORD_PROPNAME = "keyStorePassword";
    private static final String TRUSTSTORE_FILENAME_PROPNAME = "trustStoreFilename";
    private static final String TRUSTSTORE_PASSWORD_PROPNAME = "trustStorePassword";
    private static final String PROTOCOLS_PROPNAME = "protocols";
    private static final String CIPHER_SUITES_PROPNAME = "cipherSuites";
    private static final String NEED_CLIENT_AUTH_PROPNAME = "needClientAuth";
    private static final String HANDSHAKE_TIMEOUT_PROPNAME = "handshakeTimeout";
    private static final String CLOSE_TIMEOUT_PROPNAME = "closeTimeout";
    private final int HANDSHAKE_CONTINUE = 0;
    private final int HANDSHAKE_WAIT_READ = 1;
    private final int HANDSHAKE_WAIT_WRITE = 2;
    private final int HANDSHAKE_DONE = 3;

    private SSLNwLink(int n, INwLink iNwLink, Properties properties, boolean bl) throws ENwLinkException {
        this.tcpLink = iNwLink;
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.nwlink.ssl.trace");
        this.propertyTableToProps(properties);
        if (n == 1) {
            Object object;
            SSLContext sSLContext;
            TrustManagerFactory trustManagerFactory;
            KeyManagerFactory keyManagerFactory;
            this.trace.outln("Initializing key manager factory <store= '" + (this.keyStoreFileName.value == null ? "default" : this.keyStoreFileName.value) + "'>...", 4);
            try {
                keyManagerFactory = this.initKeyManagerFactory();
            }
            catch (ENwLinkException eNwLinkException) {
                this.trace.outln("Key manager factory initialization failed [" + eNwLinkException.getMessage() + "]", 1);
                throw eNwLinkException;
            }
            this.trace.outln("Initializing trust manager factory <store= '" + (this.trustStoreFileName.value == null ? "default" : this.trustStoreFileName.value) + "'>...", 4);
            try {
                trustManagerFactory = this.initTrustManagerFactory();
            }
            catch (ENwLinkException eNwLinkException) {
                this.trace.outln("Trust manager factory initialization failed [" + eNwLinkException.getMessage() + "]", 1);
                throw eNwLinkException;
            }
            this.trace.outln("Creating and initializing SSL Context...", 4);
            try {
                sSLContext = SSLContext.getInstance("ssl");
                sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ENwLinkException("SSL protocol not available in default JSSE provider implementation");
            }
            catch (KeyManagementException keyManagementException) {
                throw new ENwLinkException("Failed to initialize SSL context [" + keyManagementException.getMessage() + "]");
            }
            this.trace.outln("Creating and configuring SSL Engine...", 4);
            this.sslEngine = sSLContext.createSSLEngine();
            this.trace.outln("....mode = " + (bl ? "client" : "server"), 4);
            this.sslEngine.setUseClientMode(bl);
            this.trace.outln("....client auth = " + this.needClientAuth.value, 4);
            this.sslEngine.setNeedClientAuth(this.needClientAuth.value);
            if (this.protocols.value != null) {
                object = new StringTokenizer(this.protocols.value, ",");
                String[] stringArray = new String[((StringTokenizer)object).countTokens()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((StringTokenizer)object).nextToken();
                }
                try {
                    this.sslEngine.setEnabledProtocols(stringArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.trace.outln("One of the specified protocols is invalid in the provided protocols list [" + this.protocols.value + "]. Switching to default.", 2);
                }
            }
            if (!this.authenticate.value) {
                object = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
                this.sslEngine.setEnabledCipherSuites((String[])object);
            } else if (this.cipherSuites.value != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.cipherSuites.value, ",");
                object = new String[stringTokenizer.countTokens()];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = stringTokenizer.nextToken();
                }
                try {
                    this.sslEngine.setEnabledCipherSuites((String[])object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.trace.outln("One of the specified cipher suites is invalid in the provided cipher suite list [" + this.cipherSuites.value + "]. Switching to default.", 2);
                }
            }
            this.trace.outln("....enabled cipher suites", 4);
            if (this.sslEngine.getEnabledCipherSuites().length > 0) {
                for (int i = 0; i < this.sslEngine.getEnabledCipherSuites().length; ++i) {
                    this.trace.outln("........" + this.sslEngine.getEnabledCipherSuites()[i], 4);
                }
            } else {
                this.trace.outln("........none");
            }
            this.trace.outln("....enabled protocols", 4);
            if (this.sslEngine.getEnabledProtocols().length > 0) {
                for (int i = 0; i < this.sslEngine.getEnabledProtocols().length; ++i) {
                    this.trace.outln("........" + this.sslEngine.getEnabledProtocols()[i], 4);
                }
            } else {
                this.trace.outln("........none");
            }
            this.inNetBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
            this.outNetBuffer = (ByteBuffer)ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize()).limit(0);
            this.inAppBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
            this.statistics = new Statistics();
        } else {
            this.sslEngine = null;
            this.inAppBuffer = null;
            this.outNetBuffer = null;
            this.inNetBuffer = null;
            this.statistics = null;
        }
    }

    private KeyManagerFactory initKeyManagerFactory() throws ENwLinkException {
        Object object;
        KeyStore keyStore = null;
        char[] cArray = null;
        if (this.keyStoreFileName.value != null) {
            try {
                this.trace.outln("Using store type '" + KeyStore.getDefaultType() + "' for key store.", 4);
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            }
            catch (KeyStoreException keyStoreException) {
                throw new InternalError("Keystore creation for default keystore type failed!");
            }
            try {
                object = new FileInputStream(this.keyStoreFileName.value);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ENwLinkException("Invalid keystore file name '" + this.keyStoreFileName.value + "'");
            }
            catch (SecurityException securityException) {
                throw new ENwLinkException("Security exception while opening keystore '" + this.keyStoreFileName.value + "' [" + securityException.getMessage() + "]");
            }
            cArray = this.keyStorePassword.value.toCharArray();
            try {
                keyStore.load((InputStream)object, cArray);
            }
            catch (IOException iOException) {
                throw new ENwLinkException("Failure in loading keystore '" + this.keyStoreFileName.value + "' [" + iOException.getMessage() + "]");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ENwLinkException("Algorithm used to check the integrity of the keystore '" + this.keyStoreFileName.value + "' could not be found [" + noSuchAlgorithmException.getMessage() + "]");
            }
            catch (CertificateException certificateException) {
                throw new ENwLinkException("A certificate could not be loaded from keystore '" + this.keyStoreFileName.value + "' [" + certificateException.getMessage() + "]");
            }
            finally {
                try {
                    ((FileInputStream)object).close();
                }
                catch (IOException iOException) {
                    this.trace.outln("Failure in closing keystore '" + this.keyStoreFileName.value + "' [" + iOException.getMessage() + "]", 2);
                }
            }
        }
        try {
            this.trace.outln("Using key manager algorithm '" + KeyManagerFactory.getDefaultAlgorithm() + "'", 4);
            object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ((KeyManagerFactory)object).init(keyStore, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ENwLinkException("Failure in initializing key manager factory [" + keyStoreException.getMessage() + "]");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ENwLinkException("Specified algorithm not available for specified provider in initializing key manager factory [" + noSuchAlgorithmException.getMessage() + "]");
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new ENwLinkException("Invalid password specified for recovering keys from the specified key store [" + unrecoverableKeyException.getMessage() + "]");
        }
        return object;
    }

    private TrustManagerFactory initTrustManagerFactory() throws ENwLinkException {
        Object object;
        KeyStore keyStore = null;
        char[] cArray = null;
        if (this.trustStoreFileName.value != null) {
            try {
                this.trace.outln("Using store type '" + KeyStore.getDefaultType() + "' for trust store.", 4);
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            }
            catch (KeyStoreException keyStoreException) {
                throw new InternalError("Keystore creation for default keystore type failed!");
            }
            try {
                object = new FileInputStream(this.trustStoreFileName.value);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ENwLinkException("Invalid trust store '" + this.trustStoreFileName.value + "'");
            }
            catch (SecurityException securityException) {
                throw new ENwLinkException("Security exception while opening trust store '" + this.trustStoreFileName.value + "' [" + securityException.getMessage() + "]");
            }
            cArray = this.trustStorePassword.value == null ? null : this.trustStorePassword.value.toCharArray();
            try {
                keyStore.load((InputStream)object, cArray);
            }
            catch (IOException iOException) {
                throw new ENwLinkException("Failure in loading trust store '" + this.trustStoreFileName.value + "' [" + iOException.getMessage() + "]");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ENwLinkException("Algorithm used to check the integrity of the trust store '" + this.trustStoreFileName.value + "' could not be found [" + noSuchAlgorithmException.getMessage() + "]");
            }
            catch (CertificateException certificateException) {
                throw new ENwLinkException("A certificate could not be loaded from trust store '" + this.trustStoreFileName.value + "' [" + certificateException.getMessage() + "]");
            }
            finally {
                try {
                    ((FileInputStream)object).close();
                }
                catch (IOException iOException) {
                    this.trace.outln("Failure in closing trust store '" + this.trustStoreFileName.value + "' [" + iOException.getMessage() + "]", 2);
                }
            }
        }
        try {
            this.trace.outln("Using trust manager algorithm '" + TrustManagerFactory.getDefaultAlgorithm() + "'", 4);
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("Trust Manager Factory creation for default algorithm failed!");
        }
        catch (KeyStoreException keyStoreException) {
            throw new ENwLinkException("Failure in initializing trust manager factory [" + keyStoreException.getMessage() + "]");
        }
        return object;
    }

    private void propertyTableToProps(Properties properties) {
        this.authenticate.load(properties);
        this.keyStoreFileName.load(properties);
        this.keyStorePassword.load(properties);
        this.trustStoreFileName.load(properties);
        this.trustStorePassword.load(properties);
        this.protocols.load(properties);
        this.cipherSuites.load(properties);
        this.needClientAuth.load(properties);
        this.handshakeTimeout.load(properties);
        this.closeTimeout.load(properties);
    }

    private Properties propsToPropertyTable() {
        Properties properties = new Properties();
        this.authenticate.save(properties);
        this.keyStoreFileName.save(properties);
        this.keyStorePassword.save(properties);
        this.trustStoreFileName.save(properties);
        this.trustStorePassword.save(properties);
        this.protocols.save(properties);
        this.cipherSuites.save(properties);
        this.needClientAuth.save(properties);
        this.handshakeTimeout.save(properties);
        this.closeTimeout.save(properties);
        return properties;
    }

    private long write(ByteBuffer byteBuffer) throws ENwLinkException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
        INwLink.WriteBufferArray writeBufferArray = new INwLink.WriteBufferArray(byteBufferArray, 0);
        return this.tcpLink.write(writeBufferArray);
    }

    private int processSSLEngineClosedOnRead(int n) {
        if (this.trace.debug) {
            this.trace.debugln("Received SSL close from peer...");
        }
        if (n == 0) {
            if (this.trace.debug) {
                this.trace.debugln("No bytes copied to user buffer. Returning 'end of stream'...");
            }
            return -1;
        }
        if (this.trace.debug) {
            this.trace.debugln("Bytes have been copied to user buffer. 'End of stream' will be returning on a subsequent call to read()...");
        }
        return n;
    }

    private void dumpSSLSessionInfo() {
        this.trace.outln("Handshake completed successfully. SSL Session information...", 4);
        this.trace.outln("...Negotiated cipher suite [" + this.sslEngine.getSession().getCipherSuite() + "]", 4);
        if (this.sslEngine.getSession().getLocalPrincipal() != null) {
            this.trace.outln("...Local principal [" + this.sslEngine.getSession().getLocalPrincipal().getName() + "]", 4);
        } else {
            this.trace.outln("...Local principal [Local unverified during handshake]", 4);
        }
        try {
            this.trace.outln("...Peer principal [" + this.sslEngine.getSession().getPeerPrincipal().getName() + "]", 4);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            this.trace.outln("...Peer principal [Peer unverified during handshake]", 4);
        }
        this.trace.outln("...Local Certificates", 4);
        Certificate[] certificateArray = this.sslEngine.getSession().getLocalCertificates();
        if (certificateArray != null) {
            for (int i = 0; i < certificateArray.length; ++i) {
                this.trace.outln("......Certificate #" + i, 4);
                this.trace.outln(certificateArray[i].toString(), 4);
            }
        } else {
            this.trace.outln("......No local certificates sent to peer during handshake", 4);
        }
        this.trace.outln("...Peer Certificates", 4);
        try {
            Certificate[] certificateArray2 = this.sslEngine.getSession().getPeerCertificates();
            if (certificateArray2 != null) {
                for (int i = 0; i < certificateArray2.length; ++i) {
                    this.trace.outln("......Certificate #" + i, 4);
                    this.trace.outln(certificateArray2[i].toString(), 4);
                }
            } else {
                this.trace.outln("......No peer certificates sent to peer during handshake", 4);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            this.trace.outln("......Peer was unverified during handshake", 4);
        }
    }

    private int handleSSLEngineHandshakeStatus(SSLEngineResult.HandshakeStatus handshakeStatus) throws ENwLinkException {
        if (this.trace.debug) {
            this.trace.debugln("[SSL HANDSHAKE] state=" + (Object)((Object)handshakeStatus));
        }
        switch (handshakeStatus) {
            case NOT_HANDSHAKING: {
                try {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL HANDSHAKE] Beginning handshake...");
                    }
                    this.sslEngine.beginHandshake();
                    return 0;
                }
                catch (Exception exception) {
                    this.trace.outln("Failure to begin SSL handshake [" + exception.getMessage() + "].", 4);
                    throw new ENwLinkException(exception);
                }
            }
            case NEED_TASK: {
                try {
                    Runnable runnable;
                    while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Executing delegated task [" + runnable + "]...");
                        }
                        runnable.run();
                    }
                    return 0;
                }
                catch (Exception exception) {
                    this.trace.outln("Error in delegated task during SSL handshake [" + exception.getMessage() + "].", 4);
                    throw new ENwLinkException(exception);
                }
            }
            case NEED_UNWRAP: {
                try {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL HANDSHAKE] Reading data from link...");
                    }
                    int n = this.tcpLink.read(this.inNetBuffer);
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL HANDSHAKE] Bytes read = " + n + " [pos=" + this.inNetBuffer.position() + " limit=" + this.inNetBuffer.limit() + "]...");
                    }
                    if (n >= 0) {
                        this.inNetBuffer.flip();
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Handing data to engine for unwrap [FROM pos=" + this.inNetBuffer.position() + ", limit=" + this.inNetBuffer.limit() + "] [TO pos=" + this.inAppBuffer.position() + ", limit=" + this.inAppBuffer.limit() + "]...");
                        }
                        SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.inAppBuffer);
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Unwrap complete [status=" + (Object)((Object)sSLEngineResult.getStatus()) + "] [FROM pos=" + this.inNetBuffer.position() + ", limit=" + this.inNetBuffer.limit() + "] [TO pos=" + this.inAppBuffer.position() + ", limit=" + this.inAppBuffer.limit() + "]...");
                        }
                        this.inNetBuffer.compact();
                        switch (sSLEngineResult.getStatus()) {
                            case OK: {
                                return 0;
                            }
                            case BUFFER_UNDERFLOW: {
                                return 1;
                            }
                        }
                        throw new ENwLinkException("Failure in unwrapping handshake data [" + (Object)((Object)sSLEngineResult.getStatus()) + "]");
                    }
                    throw new ENwLinkException("Underlying link was closed before SSL handshake completed");
                }
                catch (Exception exception) {
                    this.trace.outln("Failure in read/unwrap during SSL handshake [" + exception.getMessage() + "].", 4);
                    if (exception instanceof ENwLinkException) {
                        throw (ENwLinkException)exception;
                    }
                    throw new ENwLinkException(exception);
                }
            }
            case NEED_WRAP: {
                try {
                    if (this.outNetBuffer.remaining() == 0) {
                        this.outNetBuffer.clear();
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Handing data to engine for wrap [TO pos=" + this.outNetBuffer.position() + ", limit=" + this.outNetBuffer.limit() + "]...");
                        }
                        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(ByteBuffer.allocate(0), this.outNetBuffer);
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Wrap complete [status=" + (Object)((Object)sSLEngineResult.getStatus()) + ", bytes=" + sSLEngineResult.bytesProduced() + "]");
                        }
                        switch (sSLEngineResult.getStatus()) {
                            case OK: {
                                break;
                            }
                            default: {
                                throw new ENwLinkException("Failure in wrapping handshake data [" + (Object)((Object)sSLEngineResult.getStatus()) + "]");
                            }
                        }
                        this.outNetBuffer.flip();
                    }
                    if (this.outNetBuffer.remaining() > 0) {
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Sending data [pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                        }
                        long l = this.write(this.outNetBuffer);
                        if (this.trace.debug) {
                            this.trace.debugln("[SSL HANDSHAKE] Bytes sent = " + l + " [pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                        }
                        if (this.outNetBuffer.remaining() > 0) {
                            return 2;
                        }
                    } else if (this.trace.debug) {
                        this.trace.debugln("[SSL HANDSHAKE] No data to send.");
                    }
                    return 0;
                }
                catch (Exception exception) {
                    this.trace.outln("Failure in write/wrap during SSL handshake [" + exception.getMessage() + "].", 4);
                    if (exception instanceof ENwLinkException) {
                        throw (ENwLinkException)exception;
                    }
                    throw new ENwLinkException(exception);
                }
            }
            case FINISHED: {
                return 3;
            }
        }
        throw new ENwLinkException("Illegal SSL handshake state");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSSLHandshake() throws ENwLinkException {
        SelectionKey selectionKey = null;
        try {
            int n;
            try {
                if (!this.tcpLink.getChannel().isBlocking()) {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL HANDSHAKE] Link is non-blocking. Registering link with selector...");
                    }
                    selectionKey = this.tcpLink.getChannel().register(Selector.open(), 0);
                } else if (this.trace.debug) {
                    this.trace.debugln("[SSL HANDSHAKE] Link is blocking.");
                }
            }
            catch (Exception exception) {
                this.trace.outln("Failure in switching link state for SSL handshake [" + exception.getMessage() + "].", 4);
                throw new ENwLinkException(exception);
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            long l = System.currentTimeMillis();
            block25: while ((n = this.handleSSLEngineHandshakeStatus(handshakeStatus)) != 3) {
                if (System.currentTimeMillis() - l >= (long)(this.handshakeTimeout.value * 1000)) {
                    throw new ENwLinkException("SSL handshake timed out");
                }
                switch (n) {
                    case 1: {
                        try {
                            if (this.trace.debug) {
                                this.trace.debugln("[SSL HANDSHAKE] Waiting in select for read to be ready...");
                            }
                            selectionKey.interestOps(1);
                            selectionKey.selector().select(1000L);
                            selectionKey.interestOps(0);
                            if (!this.trace.debug) continue block25;
                            this.trace.debugln("[SSL HANDSHAKE] Out of select.");
                            break;
                        }
                        catch (Exception exception) {
                            this.trace.outln("Failure in waiting to complete data read during for SSL handshake [" + exception.getMessage() + "].", 4);
                            throw new ENwLinkException(exception);
                        }
                    }
                    case 2: {
                        try {
                            if (this.trace.debug) {
                                this.trace.debugln("[SSL HANDSHAKE] Waiting in select for write to be ready...");
                            }
                            selectionKey.interestOps(4);
                            selectionKey.selector().select(1000L);
                            selectionKey.interestOps(0);
                            if (this.trace.debug) {
                                this.trace.debugln("[SSL HANDSHAKE] Out of select.");
                            }
                        }
                        catch (Exception exception) {
                            this.trace.outln("Failure in waiting to complete data write during for SSL handshake [" + exception.getMessage() + "].", 4);
                            throw new ENwLinkException(exception);
                        }
                    }
                    case 0: {
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                        handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
                    }
                }
            }
            if (this.trace.debug) {
                this.trace.debugln("[SSL POST HANDSHAKE] Handshake complete [INNET pos=" + this.inNetBuffer.position() + ", limit=" + this.inNetBuffer.limit() + "] [INAPP pos=" + this.inAppBuffer.position() + ", limit=" + this.inAppBuffer.limit() + "]...");
            }
            try {
                boolean bl = false;
                block26: while (this.inNetBuffer.position() > 0 && !bl) {
                    this.inNetBuffer.flip();
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL POST HANDSHAKE] Handing data to engine for unwrap [FROM pos=" + this.inNetBuffer.position() + ", limit=" + this.inNetBuffer.limit() + "] [TO pos=" + this.inAppBuffer.position() + ", limit=" + this.inAppBuffer.limit() + "]...");
                    }
                    SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.inAppBuffer);
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL POST HANDSHAKE] Unwrap complete [status=" + (Object)((Object)sSLEngineResult.getStatus()) + "] [FROM pos=" + this.inNetBuffer.position() + ", limit=" + this.inNetBuffer.limit() + "] [TO pos=" + this.inAppBuffer.position() + ", limit=" + this.inAppBuffer.limit() + "]...");
                    }
                    this.inNetBuffer.compact();
                    switch (sSLEngineResult.getStatus()) {
                        case OK: {
                            continue block26;
                        }
                        case BUFFER_UNDERFLOW: {
                            bl = true;
                            continue block26;
                        }
                        case CLOSED: {
                            if (this.trace.debug) {
                                this.trace.debugln("[SSL POST HANDSHAKE] Received SSL close from peer. Deferring to read()...");
                            }
                            bl = true;
                            continue block26;
                        }
                    }
                    throw new ENwLinkException("Failure in unwrapping post handshake data [" + (Object)((Object)sSLEngineResult.getStatus()) + "]");
                }
            }
            catch (Exception exception) {
                this.trace.outln("Failure in unwrap during post SSL handshake [" + exception.getMessage() + "].", 4);
                if (exception instanceof ENwLinkException) {
                    throw (ENwLinkException)exception;
                }
                throw new ENwLinkException(exception);
            }
            if (this.outNetBuffer.remaining() > 0) {
                throw new InternalError("Output network buffer remaining > 0 on SSL handshake completion [" + this.outNetBuffer.position() + "]");
            }
            this.inAppBuffer.flip();
            this.dumpSSLSessionInfo();
            this.trace.outln("...Application data received during handshake [" + this.inAppBuffer.remaining() + "]", 4);
            this.flgSSLSessionOpen = true;
        }
        finally {
            if (selectionKey != null) {
                try {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL HANDSHAKE] Closing selector...");
                    }
                    selectionKey.selector().close();
                }
                catch (Exception exception) {
                    this.trace.outln("Failure in closing internal selector on SSL handshake completion [" + exception.getMessage() + "]", 2);
                }
            }
        }
    }

    private boolean wrapNSendSSLCloseData() throws ENwLinkException {
        try {
            if (this.outNetBuffer.remaining() == 0) {
                this.outNetBuffer.clear();
                if (this.trace.debug) {
                    this.trace.debugln("[SSL CLOSE] Handing data to engine for wrap [TO pos=" + this.outNetBuffer.position() + ", limit=" + this.outNetBuffer.limit() + "]...");
                }
                SSLEngineResult sSLEngineResult = this.sslEngine.wrap(ByteBuffer.allocate(0), this.outNetBuffer);
                if (this.trace.debug) {
                    this.trace.debugln("[SSL CLOSE] Wrap complete [status=" + (Object)((Object)sSLEngineResult.getStatus()) + ", bytes=" + sSLEngineResult.bytesProduced() + "]");
                }
                switch (sSLEngineResult.getStatus()) {
                    case OK: {
                        break;
                    }
                    case CLOSED: {
                        break;
                    }
                    default: {
                        throw new ENwLinkException("Failure in wrapping close data [" + (Object)((Object)sSLEngineResult.getStatus()) + "]");
                    }
                }
                this.outNetBuffer.flip();
            }
            if (this.outNetBuffer.remaining() > 0) {
                if (this.trace.debug) {
                    this.trace.debugln("[SSL CLOSE] Sending data [pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                }
                long l = this.write(this.outNetBuffer);
                if (this.trace.debug) {
                    this.trace.debugln("[SSL CLOSE] Bytes sent = " + l + " [pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                }
                if (this.outNetBuffer.remaining() > 0) {
                    return false;
                }
            } else if (this.trace.debug) {
                this.trace.debugln("[SSL CLOSE] No data to send.");
            }
            return true;
        }
        catch (Exception exception) {
            this.trace.outln("Failure in write/wrap during SSL close [" + exception.getMessage() + "].", 4);
            if (exception instanceof ENwLinkException) {
                throw (ENwLinkException)exception;
            }
            throw new ENwLinkException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSSLClose() throws ENwLinkException {
        SelectionKey selectionKey = null;
        try {
            try {
                if (!this.tcpLink.getChannel().isBlocking()) {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL CLOSE] Link is non-blocking. Registering link with selector...");
                    }
                    selectionKey = this.tcpLink.getChannel().register(Selector.open(), 0);
                } else if (this.trace.debug) {
                    this.trace.debugln("[SSL CLOSE] Link is blocking.");
                }
            }
            catch (Exception exception) {
                this.trace.outln("Failure in switching link state for SSL close [" + exception + "].", 4);
                throw new ENwLinkException(exception);
            }
            this.outNetBuffer.clear().flip();
            this.sslEngine.closeOutbound();
            long l = System.currentTimeMillis();
            while (!this.sslEngine.isOutboundDone()) {
                if (System.currentTimeMillis() - l >= (long)(this.closeTimeout.value * 1000)) {
                    throw new ENwLinkException("SSL close timed out");
                }
                if (this.wrapNSendSSLCloseData()) continue;
                try {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL CLOSE] Waiting in select for write to be ready...");
                    }
                    selectionKey.interestOps(4);
                    selectionKey.selector().select(1000L);
                    selectionKey.interestOps(0);
                    if (!this.trace.debug) continue;
                    this.trace.debugln("[SSL CLOSE] Out of select.");
                }
                catch (Exception exception) {
                    this.trace.outln("Failure in waiting to complete data write during for SSL handshake [" + exception.getMessage() + "].", 4);
                    throw new ENwLinkException(exception);
                }
            }
            this.flgSSLSessionOpen = false;
        }
        finally {
            if (selectionKey != null) {
                try {
                    if (this.trace.debug) {
                        this.trace.debugln("[SSL CLOSE] Closing selector...");
                    }
                    selectionKey.selector().close();
                }
                catch (Exception exception) {
                    this.trace.outln("Failure in closing internal selector on SSL close completion [" + exception.getMessage() + "]", 2);
                }
            }
        }
    }

    public static INwLink create(Integer n, String string) throws ENwLinkException {
        INwLink iNwLink = TCPNwLink.create(n, string);
        return new SSLNwLink(n, iNwLink, NwLinkDescriptorParser.create(string).getProperties(), n == 1);
    }

    @Override
    public final int getType() {
        return this.tcpLink.getType();
    }

    @Override
    public final SelectableChannel getChannel() {
        return this.tcpLink.getChannel();
    }

    @Override
    public final SelectableChannel getServerChannel() {
        return this.tcpLink.getServerChannel();
    }

    @Override
    public final INwLinkStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public final boolean connect() throws ENwLinkException {
        if (!this.flgSSLSessionOpen) {
            if (this.tcpLink.connect()) {
                this.trace.outln("Successfully established underlying TCP link.", 4);
                try {
                    this.trace.outln("Starting SSL handshake...", 4);
                    this.performSSLHandshake();
                    this.trace.outln("SSL handshake successful.", 4);
                }
                catch (ENwLinkException eNwLinkException) {
                    this.trace.outln("SSL Handshake on established link failed [" + eNwLinkException.getMessage() + "]. Closing underlying link and failing connect.", 1);
                    try {
                        this.tcpLink.close();
                    }
                    catch (ENwLinkException eNwLinkException2) {
                        this.trace.outln("Failure in closing underlying TCP link on SSL handshake failure [" + eNwLinkException2.getMessage() + "]", 2);
                    }
                    throw eNwLinkException;
                }
                return true;
            }
            return false;
        }
        throw new ENwLinkException("link already connected");
    }

    @Override
    public final INwLink accept() throws ENwLinkException {
        INwLink iNwLink = this.tcpLink.accept();
        SSLNwLink sSLNwLink = null;
        if (iNwLink != null) {
            try {
                this.trace.outln("Successfully accepted underlying TCP link. Wrapping SSL link around it...", 4);
                sSLNwLink = new SSLNwLink(1, iNwLink, this.propsToPropertyTable(), false);
                this.trace.outln("Starting SSL handshake...", 4);
                sSLNwLink.performSSLHandshake();
                this.trace.outln("SSL handshake successful.", 4);
            }
            catch (ENwLinkException eNwLinkException) {
                block6: {
                    this.trace.outln("SSL Handshake on accepted link failed [" + eNwLinkException.getMessage() + "]. Closing accepted link.", 1);
                    try {
                        iNwLink.close();
                    }
                    catch (Exception exception) {
                        if (sSLNwLink == null) {
                            this.trace.outln("Failure in closing accepted underlying TCP link on SSL link creation failure [" + exception.getMessage() + "]", 2);
                            break block6;
                        }
                        this.trace.outln("Failure in closing accepted underlying TCP link on SSL handshake failure [" + exception.getMessage() + "]", 2);
                    }
                }
                sSLNwLink = null;
            }
        }
        return sSLNwLink;
    }

    @Override
    public final int read(ByteBuffer byteBuffer) throws ENwLinkException {
        if (this.flgSSLSessionOpen) {
            int n = 0;
            try {
                if (this.inAppBuffer.remaining() == 0) {
                    if (this.trace.debug) {
                        this.trace.debugln("Reading [pos=" + this.inNetBuffer.position() + " limit=" + this.inNetBuffer.limit() + "]...");
                    }
                    int n2 = this.tcpLink.read(this.inNetBuffer);
                    if (this.trace.debug) {
                        this.trace.debugln("Read [bytes=" + n2 + "]...");
                    }
                    if (n2 >= 0) {
                        boolean bl = true;
                        while (bl) {
                            this.inNetBuffer.flip();
                            if (this.trace.debug) {
                                this.trace.debugln("Unwrapping direct [FROM pos=" + this.inNetBuffer.position() + " limit=" + this.inNetBuffer.limit() + "] [TO pos=" + byteBuffer.position() + " limit=" + byteBuffer.limit() + "]...");
                            }
                            SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, byteBuffer);
                            if (this.trace.debug) {
                                this.trace.debugln("Unwrapped direct [status=" + (Object)((Object)sSLEngineResult.getStatus()) + " consumed=" + sSLEngineResult.bytesConsumed() + " produced=" + sSLEngineResult.bytesProduced() + "] [FROM pos=" + this.inNetBuffer.position() + " limit=" + this.inNetBuffer.limit() + "] [TO pos=" + byteBuffer.position() + " limit=" + byteBuffer.limit() + "]...");
                            }
                            switch (sSLEngineResult.getStatus()) {
                                case OK: {
                                    n += sSLEngineResult.bytesProduced();
                                    break;
                                }
                                case BUFFER_UNDERFLOW: {
                                    bl = false;
                                    break;
                                }
                                case BUFFER_OVERFLOW: {
                                    this.inAppBuffer.clear();
                                    if (this.trace.debug) {
                                        this.trace.debugln("Unwrapping indirect [FROM pos=" + this.inNetBuffer.position() + " limit=" + this.inNetBuffer.limit() + "] [TO pos=" + this.inAppBuffer.position() + " limit=" + this.inAppBuffer.limit() + "]...");
                                    }
                                    sSLEngineResult = this.sslEngine.unwrap(this.inNetBuffer, this.inAppBuffer);
                                    if (this.trace.debug) {
                                        this.trace.debugln("Unwrapped indirect [status=" + (Object)((Object)sSLEngineResult.getStatus()) + " consumed=" + sSLEngineResult.bytesConsumed() + " produced=" + sSLEngineResult.bytesProduced() + "] [FROM pos=" + this.inNetBuffer.position() + " limit=" + this.inNetBuffer.limit() + "] [TO pos=" + this.inAppBuffer.position() + " limit=" + this.inAppBuffer.limit() + "]...");
                                    }
                                    this.inAppBuffer.flip();
                                    switch (sSLEngineResult.getStatus()) {
                                        case OK: {
                                            if (this.inAppBuffer.remaining() <= 0) break;
                                            if (this.trace.debug) {
                                                this.trace.debugln("Produced bytes into excess buffer. Copying to user buffer");
                                            }
                                            n += this.read(byteBuffer);
                                            break;
                                        }
                                        case BUFFER_UNDERFLOW: {
                                            break;
                                        }
                                        case CLOSED: {
                                            n = this.processSSLEngineClosedOnRead(n);
                                            break;
                                        }
                                        default: {
                                            throw new InternalError("Unexpected SSL unwrap status [" + sSLEngineResult + "] in unwrapping to internal app buffer");
                                        }
                                    }
                                    bl = false;
                                    break;
                                }
                                case CLOSED: {
                                    n = this.processSSLEngineClosedOnRead(n);
                                    bl = false;
                                }
                            }
                            this.inNetBuffer.compact();
                        }
                    } else {
                        n = n2;
                        if (n < 0) {
                            if (this.trace.debug) {
                                this.trace.debugln("Peer has closed link. Closing SSL Engine inbound stream...");
                            }
                            try {
                                this.sslEngine.closeInbound();
                            }
                            catch (Exception exception) {
                                this.trace.outln("Peer has closed link but failure in closing SSL inbound stream [" + exception.getMessage() + "]", 2);
                            }
                        }
                    }
                } else {
                    n = Math.min(this.inAppBuffer.remaining(), byteBuffer.remaining());
                    if (this.trace.debug) {
                        this.trace.debugln("Excess buffer not empty [" + this.inAppBuffer.remaining() + " bytes]. Draining [bytes=" + n + "]...");
                    }
                    byteBuffer.put(this.inAppBuffer.array(), this.inAppBuffer.position(), n);
                    this.inAppBuffer.position(this.inAppBuffer.position() + n);
                }
            }
            catch (Exception exception) {
                this.trace.outln("Read failed [" + exception.getMessage() + "].", 1);
                if (exception instanceof ENwLinkException) {
                    throw (ENwLinkException)exception;
                }
                throw new ENwLinkException(exception);
            }
            if (this.trace.debug) {
                this.trace.debugln("Returning bytes read = " + n);
            }
            return n;
        }
        throw new ENwLinkException("link not connected");
    }

    @Override
    public final long write(INwLink.WriteBufferArray writeBufferArray) throws ENwLinkException {
        if (this.flgSSLSessionOpen) {
            long l;
            block36: {
                l = 0L;
                try {
                    if (this.writeResumeContext == null) {
                        if (this.trace.debug) {
                            this.trace.debugln("Fresh write. Writing each buffer independently...");
                        }
                        while (writeBufferArray.offset < writeBufferArray.array.length) {
                            ByteBuffer byteBuffer = writeBufferArray.array[writeBufferArray.offset];
                            int n = writeBufferArray.offset;
                            if (this.trace.debug) {
                                this.trace.debugln("Buffer #" + n + ": [remaining=" + byteBuffer.remaining() + "]...");
                            }
                            if (byteBuffer.remaining() > 0) {
                                boolean bl = true;
                                block6: while (bl) {
                                    byteBuffer.mark();
                                    this.outNetBuffer.clear();
                                    if (this.trace.debug) {
                                        this.trace.debugln("Buffer #" + n + ": Wrapping [FROM pos=" + byteBuffer.position() + " limit=" + byteBuffer.limit() + "] [TO pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                                    }
                                    SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.outNetBuffer);
                                    if (this.trace.debug) {
                                        this.trace.debugln("Buffer #" + n + ": Wrap complete [status=" + (Object)((Object)sSLEngineResult.getStatus()) + " consumed=" + sSLEngineResult.bytesConsumed() + " produced=" + sSLEngineResult.bytesProduced() + "] [FROM pos=" + byteBuffer.position() + " limit=" + byteBuffer.limit() + "] [TO pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                                    }
                                    this.outNetBuffer.flip();
                                    byteBuffer.reset();
                                    if (this.checked && this.outNetBuffer.remaining() != sSLEngineResult.bytesProduced()) {
                                        throw new InternalError("Count of bytes wrapped into buffer different from what reported by wrap [reported=" + sSLEngineResult.bytesProduced() + " actual=" + this.outNetBuffer.remaining() + "]!");
                                    }
                                    switch (sSLEngineResult.getStatus()) {
                                        case OK: {
                                            if (this.trace.debug) {
                                                this.trace.debugln("Buffer #" + writeBufferArray.offset + ": Writing output net buffer [pos=" + this.outNetBuffer.position() + " limit=" + this.outNetBuffer.limit() + "]...");
                                            }
                                            long l2 = this.write(this.outNetBuffer);
                                            if (this.trace.debug) {
                                                this.trace.debugln("Buffer #" + writeBufferArray.offset + ": Written output net buffer [bytes=" + l2 + "]");
                                            }
                                            if (this.outNetBuffer.remaining() == 0) {
                                                if (this.trace.debug) {
                                                    this.trace.debugln("Buffer #" + n + ": Output net buffer drained completely.");
                                                }
                                                l += (long)sSLEngineResult.bytesConsumed();
                                                byteBuffer.position(byteBuffer.position() + sSLEngineResult.bytesConsumed());
                                                if (byteBuffer.remaining() == 0) {
                                                    if (this.trace.debug) {
                                                        this.trace.debugln("Buffer #" + n + ": Buffer wrapped completely. Moving onto next buffer...");
                                                    }
                                                    bl = false;
                                                    continue block6;
                                                }
                                                if (!this.trace.debug) continue block6;
                                                this.trace.debugln("Buffer #" + n + ": Buffer not wrapped completely. Continuing....");
                                                continue block6;
                                            }
                                            if (this.trace.debug) {
                                                this.trace.debugln("Buffer #" + n + ": Output net buffer not drained completely. Returning");
                                            }
                                            this.writeResumeContext = new WriteResumeContext(byteBuffer, this.outNetBuffer, sSLEngineResult);
                                            bl = false;
                                            continue block6;
                                        }
                                    }
                                    throw new ENwLinkException("SSL wrap failure [status=" + (Object)((Object)sSLEngineResult.getStatus()) + "]");
                                }
                            }
                            if (this.writeResumeContext != null) {
                                if (this.trace.debug) {
                                    this.trace.debugln("Write resume context is non-null. Returning...");
                                }
                                break block36;
                            }
                            ++writeBufferArray.offset;
                        }
                        break block36;
                    }
                    if (this.trace.debug) {
                        this.trace.debugln("Resuming write. Writing output network buffer [pos=" + this.writeResumeContext.outNetBuffer.position() + " limit=" + this.writeResumeContext.outNetBuffer.limit() + "]...");
                    }
                    long l3 = this.write(this.writeResumeContext.outNetBuffer);
                    if (this.trace.debug) {
                        this.trace.debugln("Written output net buffer [bytes=" + l3 + "]");
                    }
                    if (this.writeResumeContext.outNetBuffer.remaining() == 0) {
                        if (this.trace.debug) {
                            this.trace.debugln("Output net buffer drained completely.");
                        }
                        if (this.writeResumeContext.buffer == writeBufferArray.array[writeBufferArray.offset]) {
                            if (this.trace.debug) {
                                this.trace.debugln("Buffer #" + writeBufferArray.offset + " is same as buffer last app buffer written. Updating with bytes consumed.");
                            }
                            l += (long)this.writeResumeContext.result.bytesConsumed();
                            this.writeResumeContext.buffer.position(this.writeResumeContext.buffer.position() + this.writeResumeContext.result.bytesConsumed());
                        } else if (this.trace.debug) {
                            this.trace.debugln("Buffer #" + writeBufferArray.offset + " is not same as last app buffer written. Ignoring.");
                        }
                        this.writeResumeContext = null;
                        l += this.write(writeBufferArray);
                    } else if (this.trace.debug) {
                        this.trace.debugln("Output net buffer still not drained completely. Returning.");
                    }
                }
                catch (Exception exception) {
                    this.trace.outln("Write failed [" + exception.getMessage() + "].", 1);
                    if (exception instanceof ENwLinkException) {
                        throw (ENwLinkException)exception;
                    }
                    throw new ENwLinkException(exception);
                }
            }
            if (this.trace.debug) {
                this.trace.debugln("Returning bytes written = " + l);
            }
            return l;
        }
        throw new ENwLinkException("link not connected");
    }

    @Override
    public final void close() throws ENwLinkException {
        if (this.flgSSLSessionOpen && this.getType() == 1) {
            try {
                this.performSSLClose();
            }
            catch (ENwLinkException eNwLinkException) {
                this.trace.outln("SSL close failed [" + eNwLinkException.getMessage() + "].", 2);
            }
        }
        this.tcpLink.close();
    }

    @Override
    public final Object ioctl(String string, Object object) throws ESysIoctlException, ENwLinkException {
        try {
            return ((ISysIoctl)((Object)this.tcpLink)).ioctl(string, object);
        }
        catch (Exception exception) {
            if (exception instanceof ENwLinkException) {
                throw (ENwLinkException)exception;
            }
            throw new ENwLinkException(exception);
        }
    }

    private class Statistics
    extends SysStatistics
    implements INwLinkStatistics {
        private NumberFormat format = NumberFormat.getInstance();
        private long startTime;
        private long deltaStartTime;

        private Statistics() {
            this.format.setMaximumFractionDigits(2);
        }

        @Override
        protected final void init() {
            this.startTime = this.deltaStartTime = System.currentTimeMillis();
        }

        @Override
        protected final void dump() {
            long l = System.currentTimeMillis();
            long l2 = l - this.startTime;
            long l3 = l - this.deltaStartTime;
            this.deltaStartTime = l;
            String string = "[SSL Link STATS] DT=" + l3 + "\n";
        }
    }

    private final class WriteResumeContext {
        final ByteBuffer buffer;
        final ByteBuffer outNetBuffer;
        final SSLEngineResult result;

        WriteResumeContext(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, SSLEngineResult sSLEngineResult) {
            this.buffer = byteBuffer;
            this.outNetBuffer = byteBuffer2;
            this.result = sSLEngineResult;
        }
    }
}

