/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.multi.IIOMultiConnectionPacketManager;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionAck;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionHandshakeReply;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionHandshakeRequest;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionNack;
import com.progress.blackbird.pdu.PDUPacketMultiConnectionSync;
import com.progress.blackbird.pdu.PDUPacketSubHeaderMultiConnection;

public final class PDUPacketMultiConnectionPacketManager
implements IIOMultiConnectionPacketManager {
    private PDUPacketMultiConnectionPacketManager() {
    }

    @Override
    public IIOPacket createHandshakeRequest(String string) {
        return PDUPacketMultiConnectionHandshakeRequest.create(string);
    }

    @Override
    public boolean isHandshakeRequest(IIOPacket iIOPacket) {
        return ((PDUPacket)iIOPacket).getHeader().getType() == 14;
    }

    @Override
    public String getHandshakeRequestId(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionHandshakeRequest)iIOPacket).getId();
    }

    @Override
    public IIOPacket createHandshakeReply(boolean bl, String string) {
        return PDUPacketMultiConnectionHandshakeReply.create(bl, string);
    }

    @Override
    public boolean isHandshakeReply(IIOPacket iIOPacket) {
        return ((PDUPacket)iIOPacket).getHeader().getType() == 15;
    }

    @Override
    public boolean getHandshakeReplyStatus(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionHandshakeReply)iIOPacket).getStatus();
    }

    @Override
    public String getHandshakeReplyDesc(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionHandshakeReply)iIOPacket).getDesc();
    }

    @Override
    public final long getDataFlowId(IIOPacket iIOPacket) {
        return ((PDUPacket)iIOPacket).getHeader().getFlow();
    }

    @Override
    public final void setDataSequenceNumber(IIOPacket iIOPacket, long l) {
        ((PDUPacket)iIOPacket).getHeader().setMultiConnectionSubHeader(new PDUPacketSubHeaderMultiConnection(l));
    }

    @Override
    public final long getDataSequenceNumber(IIOPacket iIOPacket) {
        PDUPacketSubHeaderMultiConnection pDUPacketSubHeaderMultiConnection = ((PDUPacket)iIOPacket).getHeader().getMultiConnectionSubHeader();
        return pDUPacketSubHeaderMultiConnection != null ? pDUPacketSubHeaderMultiConnection.getSequenceNumber() : 0L;
    }

    @Override
    public final IIOPacket createAck(int n, long[] lArray, long[] lArray2) {
        return PDUPacketMultiConnectionAck.create(n, lArray, lArray2);
    }

    @Override
    public final boolean isAck(IIOPacket iIOPacket) {
        return ((PDUPacket)iIOPacket).getHeader().getType() == 11;
    }

    @Override
    public final long[] getAckFlowIds(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionAck)iIOPacket).getFlowIds();
    }

    @Override
    public final long[] getAckSnos(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionAck)iIOPacket).getSnos();
    }

    @Override
    public final IIOPacket createNack(int n, long[] lArray, Object[] objectArray) {
        return PDUPacketMultiConnectionNack.create(n, lArray, objectArray);
    }

    @Override
    public final boolean isNack(IIOPacket iIOPacket) {
        return ((PDUPacket)iIOPacket).getHeader().getType() == 12;
    }

    @Override
    public final long[] getNackFlowIds(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionNack)iIOPacket).getFlowIds();
    }

    @Override
    public final Object[] getNackSnoSets(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionNack)iIOPacket).getSnoSets();
    }

    @Override
    public final IIOPacket createSync(int n, long[] lArray, long[] lArray2) {
        return PDUPacketMultiConnectionSync.create(n, lArray, lArray2);
    }

    @Override
    public final boolean isSync(IIOPacket iIOPacket) {
        return ((PDUPacket)iIOPacket).getHeader().getType() == 13;
    }

    @Override
    public final long[] getSyncFlowIds(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionSync)iIOPacket).getFlowIds();
    }

    @Override
    public final long[] getSyncSnos(IIOPacket iIOPacket) {
        return ((PDUPacketMultiConnectionSync)iIOPacket).getSnos();
    }

    public static IIOMultiConnectionPacketManager create() {
        return new PDUPacketMultiConnectionPacketManager();
    }
}

