/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.impl.ILockingRules;

class CRWLockingRules
implements ILockingRules {
    static final int LOCK_MODE_NONE = 0;
    static final int LOCK_MODE_S = 1;
    static final int LOCK_MODE_X = 2;
    static final int LOCK_MODE_PERMIT = 3;
    private static boolean[][] LOCK_COMPAT = new boolean[][]{{true, true, true, true}, {true, true, false, true}, {true, false, false, false}, {true, true, false, true}};
    private static int[][] MAX_LOCK_MODE = new int[][]{{0, 1, 2, 3}, {1, 1, 2, 1}, {2, 2, 2, 2}, {3, 1, 2, 3}};
    private static int[][] CONVERTED_LOCK_MODE = new int[][]{{0, 1, 2, 3}, {1, 1, 2, 1}, {2, 2, 2, 2}, {3, 1, 2, 3}};
    private static int[] DOWNGRADED_MODE = new int[]{0, 3, 3, 3};

    @Override
    public boolean isLockCompatible(int requestedMode, int grantedMode) {
        return LOCK_COMPAT[requestedMode][grantedMode];
    }

    @Override
    public int getMaxLockMode(int modeA, int modeB) {
        return MAX_LOCK_MODE[modeA][modeB];
    }

    @Override
    public int getConvertedLockMode(int requestedMode, int grantedMode) {
        return CONVERTED_LOCK_MODE[requestedMode][grantedMode];
    }

    @Override
    public boolean isPermit(int mode) {
        return mode == 3;
    }

    @Override
    public int getDowngradedMode(int currentMode) {
        return DOWNGRADED_MODE[currentMode];
    }

    @Override
    public int getInternalLockMode(int lockmode) throws IllegalArgumentException {
        int mode = 0;
        if (lockmode == 1) {
            mode = 1;
        } else if (lockmode == 2) {
            mode = 2;
        } else if (lockmode == 3) {
            mode = 3;
        } else {
            throw new IllegalArgumentException("Lock.getInternalLockMode(): Invalid lock mode " + lockmode);
        }
        return mode;
    }

    @Override
    public int getPublicLockMode(int lockmode) throws IllegalArgumentException {
        int mode = 0;
        if (lockmode == 1) {
            mode = 1;
        } else if (lockmode == 2) {
            mode = 2;
        } else if (lockmode == 3) {
            mode = 3;
        } else if (lockmode == 0) {
            mode = 0;
        } else {
            throw new IllegalArgumentException("Lock.getPublicLockMode(): Invalid lock mode " + lockmode);
        }
        return mode;
    }
}

