/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.DeadlockException;
import com.sonicsw.lm.ILockManager;
import com.sonicsw.lm.LockTimeoutException;
import com.sonicsw.lm.LockWaitInterruptedException;
import com.sonicsw.lm.impl.CRWLockingRules;
import com.sonicsw.lm.impl.DeadlockDetection;
import com.sonicsw.lm.impl.ILockingRules;
import com.sonicsw.lm.impl.Lock;
import com.sonicsw.lm.impl.LockRequest;
import com.sonicsw.lm.impl.RequestorLocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class LockManager
implements ILockManager {
    private static final String PARM_DEADLOCK_STRATEGY = "DEADLOCK_STRATEGY";
    private static final String STR_DEADLOCK_STRATEGY_PERIODIC = "PERIODIC";
    private static final String STR_DEADLOCK_STRATEGY_CONTINUOUS = "CONTINUOUS";
    private static final String STR_DEADLOCK_STRATEGY_TIMEOUT = "TIMEOUT";
    private static final String PARM_DEADLOCK_WAIT = "DEADLOCK_WAIT";
    private static final String PARM_DEBUG_LOCKS = "DEBUG_LOCKS";
    private ILockingRules m_lockingRules;
    private static final int DEADLOCK_STRATEGY_CONTINUOUS = 1;
    private static final int DEADLOCK_STRATEGY_PERIODIC = 2;
    private static final int DEADLOCK_STRATEGY_TIMEOUT = 3;
    private static final int DEADLOCK_STRATEGY_DEFAULT = 1;
    private int m_deadlockStrategy;
    private static final long DEADLOCK_WAIT_DEFAULT = 10000L;
    private long m_deadlockWait;
    private long m_deadlockDelay = 3000L;
    private String m_name;
    private HashMap m_locks = new HashMap();
    private HashMap m_clients = new HashMap();
    private DeadlockDetection m_deadlockDetection;
    private boolean DEBUG = false;

    public LockManager(String name) {
        this(name, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LockManager(String name, HashMap parms) {
        String deadlockStrategy;
        this.m_name = name;
        if (parms == null) {
            parms = new HashMap();
        }
        if ((deadlockStrategy = (String)parms.get(PARM_DEADLOCK_STRATEGY)) != null) {
            if (deadlockStrategy.equals(STR_DEADLOCK_STRATEGY_PERIODIC)) {
                this.m_deadlockStrategy = 2;
            } else if (deadlockStrategy.equals(STR_DEADLOCK_STRATEGY_CONTINUOUS)) {
                this.m_deadlockStrategy = 1;
            } else {
                if (!deadlockStrategy.equals(STR_DEADLOCK_STRATEGY_TIMEOUT)) throw new Error("Unrecognized deadlock strategy " + deadlockStrategy);
                this.m_deadlockStrategy = 3;
            }
        } else {
            this.m_deadlockStrategy = 1;
        }
        Long deadlockWait = (Long)parms.get(PARM_DEADLOCK_WAIT);
        this.m_deadlockWait = deadlockWait != null ? deadlockWait : 10000L;
        Boolean debugLock = (Boolean)parms.get(PARM_DEBUG_LOCKS);
        if (debugLock != null) {
            this.DEBUG = debugLock;
            if (this.DEBUG) {
                this.debug("Constructor; DEBUG_LOCKS set in db parameters; DEBUG= " + this.DEBUG);
            }
        }
        if (!this.DEBUG) {
            this.DEBUG = Boolean.getBoolean(PARM_DEBUG_LOCKS);
            if (this.DEBUG) {
                this.debug("Constructor; PARM_DEBUG_LOCKS property set; DEBUG= " + this.DEBUG);
            }
        }
        if (this.DEBUG) {
            String deadlockStrategyStr = null;
            if (this.m_deadlockStrategy == 1) {
                deadlockStrategyStr = "DEADLOCK_STRATEGY_CONTINUOUS";
            } else if (this.m_deadlockStrategy == 2) {
                deadlockStrategyStr = "DEADLOCK_STRATEGY_PERIODIC";
            } else if (this.m_deadlockStrategy == 3) {
                deadlockStrategyStr = "DEADLOCK_STRATEGY_TIMEOUT";
            }
            this.debug("Constructor; m_deadlockStrategy= " + deadlockStrategyStr + " m_deadlockWait= " + this.m_deadlockWait + " Db= " + name);
            this.debug("Constructor; DEBUG= " + this.DEBUG);
        }
        this.m_deadlockDetection = new DeadlockDetection(this);
        this.m_lockingRules = new CRWLockingRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateAndLock(Object lockId, int lockmode, Object requestor) {
        if (lockmode != 1) {
            throw new Error("validateAndLock: lock mode must be read");
        }
        int mode = this.m_lockingRules.getInternalLockMode(lockmode);
        LockManager lockManager = this;
        synchronized (lockManager) {
            Lock lock;
            if (this.DEBUG) {
                this.debug("validateAndLock: trying lockId= " + lockId + " requestor= " + requestor);
            }
            if ((lock = this.getLock(lockId)) == null) {
                return false;
            }
            RequestorLocks rLocks = this.getRequestorLocks(requestor);
            if (rLocks == null) {
                return false;
            }
            return lock.validateAndAcquireLock(mode, rLocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object lockId, int lockmode, long timeoutMillis, Object requestor, int objectType, String className) throws LockTimeoutException, LockWaitInterruptedException, DeadlockException {
        int mode = this.m_lockingRules.getInternalLockMode(lockmode);
        if (timeoutMillis < 0L && timeoutMillis != -1L) {
            throw new IllegalArgumentException("LockManager.Lock: incorrect timeout: " + timeoutMillis);
        }
        LockRequest waitReq = null;
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this.DEBUG) {
                this.debug("lock: trying to acquire lockId= " + lockId + " requestor= " + requestor + " " + Thread.currentThread().getName());
            }
            Lock lock = this.getLock(lockId, true, objectType, className);
            this.validateNoConcurrentLockRequests(lock, requestor);
            RequestorLocks rLocks = this.getRequestorLocks(requestor, true);
            waitReq = lock.acquire(mode, rLocks);
            if (waitReq != null) {
                ArrayList cycles;
                if (timeoutMillis == 0L) {
                    this.cancelWaitingReq(waitReq, 5);
                    throw new LockTimeoutException();
                }
                if (this.DEBUG) {
                    lock.printAllLockInfo();
                }
                if (this.m_deadlockStrategy == 1 && !(cycles = this.m_deadlockDetection.findCycles(rLocks, false)).isEmpty()) {
                    if (this.DEBUG) {
                        this.debug("lock: DEADLOCK_STRATEGY_CONTINUOUS  found a deadlock");
                        this.m_deadlockDetection.printCycle((ArrayList)cycles.get(0));
                    }
                    this.cancelWaitingReq(waitReq, 4);
                    throw new DeadlockException();
                }
                waitReq.setWaiter(Thread.currentThread());
            }
        }
        if (waitReq != null) {
            try {
                if (this.m_deadlockStrategy == 2 && (timeoutMillis == -1L || timeoutMillis > this.m_deadlockWait)) {
                    this.performLockWaitWithDeadlockDetection(waitReq, timeoutMillis);
                } else {
                    this.performLockWait(waitReq, timeoutMillis, true);
                }
            }
            finally {
                waitReq.setWaiter(null);
            }
        }
        if (this.DEBUG) {
            this.debug("lock: Locked lockId= " + lockId + " requestor= " + requestor + " mode= " + Lock.getStringMode(mode) + " numRequestors= " + this.getNumRequestors() + " numLocks= " + this.getNumLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performLockWait(LockRequest waitReq, long timeoutMillis, boolean excOnTimeout) throws LockTimeoutException, LockWaitInterruptedException, DeadlockException {
        boolean completed = false;
        boolean granted = false;
        try {
            if (this.DEBUG) {
                this.debug("performLockWait: Waiting for Lock: lockId= " + waitReq.getLock().getLockId() + " requestor= " + waitReq.getOwner() + " mode= " + Lock.getStringMode(waitReq.getRequestedMode()));
            }
            if (!(granted = waitReq.waitForLock(timeoutMillis)) && excOnTimeout) {
                throw new LockTimeoutException();
            }
            completed = true;
        }
        finally {
            if (!completed) {
                this.cancelWaitingReq(waitReq, 3);
            }
        }
        return granted;
    }

    private void performLockWaitWithDeadlockDetection(LockRequest waitReq, long timeoutMillis) throws LockTimeoutException, LockWaitInterruptedException, DeadlockException {
        boolean granted;
        long callerTimeToWait;
        if (this.DEBUG) {
            this.debug("performLockWaitWithDeadlockDetection: Waiting for Lock: lockId= " + waitReq.getLock().getLockId() + " requestor= " + waitReq.getOwner() + " mode= " + Lock.getStringMode(waitReq.getRequestedMode()));
        }
        if ((callerTimeToWait = timeoutMillis) != -1L && callerTimeToWait < this.m_deadlockWait + this.m_deadlockDelay) {
            callerTimeToWait = this.m_deadlockWait + this.m_deadlockDelay;
        }
        if (granted = this.performLockWait(waitReq, this.m_deadlockWait, false)) {
            return;
        }
        if (callerTimeToWait != -1L) {
            callerTimeToWait -= this.m_deadlockWait;
        }
        this.m_deadlockDetection.startDeadLockSearch();
        this.performLockWait(waitReq, callerTimeToWait, true);
    }

    @Override
    public synchronized void unlock(Object lockId, Object requestor) {
        Lock lock = this.getLock(lockId);
        this.validateNoConcurrentLockRequests(lock, requestor);
        if (this.DEBUG) {
            this.debug("Unlock:  starting; requestor= " + requestor + " lockId= " + lockId + " " + Thread.currentThread().getName());
        }
        if (lock == null) {
            return;
        }
        RequestorLocks rlocks = this.getRequestorLocks(requestor);
        if (rlocks != null) {
            lock.release(rlocks);
            if (lock.isFree()) {
                this.m_locks.remove(lockId);
            }
            if (rlocks.getCount() == 0) {
                this.m_clients.remove(requestor);
            }
        }
    }

    @Override
    public synchronized void markForRelease(Object lockId, Object requestor) {
        Lock lock = this.getLock(lockId);
        this.validateNoConcurrentLockRequests(lock, requestor);
        if (this.DEBUG) {
            this.debug("markForRelease:  starting; requestor= " + requestor + " lockId= " + lockId + " " + Thread.currentThread().getName());
        }
        if (lock == null) {
            return;
        }
        RequestorLocks rlocks = this.getRequestorLocks(requestor);
        if (rlocks != null) {
            lock.markForRelease(rlocks);
            if (lock.isFree()) {
                this.m_locks.remove(lockId);
            }
            if (rlocks.getCount() == 0) {
                this.m_clients.remove(requestor);
            }
        }
    }

    private synchronized void cancelWaitingReq(LockRequest req, int reason) {
        RequestorLocks rlocks;
        Lock lock = req.getLock();
        Object lockId = lock.getLockId();
        if ((lock = this.getLock(lockId)) == null) {
            return;
        }
        Object requestor = req.getOwner();
        if (this.DEBUG) {
            this.debug("cancelWaitingReq:  starting; requestor= " + requestor + " lockId= " + lockId);
        }
        if ((rlocks = this.getRequestorLocks(requestor)) != null) {
            lock.cancelWaitingReq(req, rlocks, reason);
            if (lock.isFree()) {
                this.m_locks.remove(lockId);
            }
            if (rlocks.getCount() == 0) {
                this.m_clients.remove(requestor);
            }
        }
    }

    @Override
    public void unlockAll(Object requestor) {
        this.unlockAll(requestor, false);
    }

    @Override
    public synchronized void unlockAll(Object requestor, boolean downgrade) {
        RequestorLocks rLocks = this.getRequestorLocks(requestor);
        if (rLocks == null) {
            return;
        }
        LinkedList list = (LinkedList)rLocks.getLocks().clone();
        int lockct = list.size();
        if (this.DEBUG) {
            this.debug("UnlockAll:  starting; requestor= " + requestor + " downgrade= " + downgrade + " countLocks= " + lockct + " " + Thread.currentThread().getName() + " numRequestors= " + this.getNumRequestors() + " numLocks= " + this.getNumLocks());
        }
        for (LockRequest req : list) {
            Lock lock = req.getLock();
            boolean dodowngrade = downgrade;
            if (req.getMarkedForRelease()) {
                dodowngrade = false;
            }
            lock.release(rLocks, dodowngrade);
            if (this.DEBUG) {
                this.debug("UnlockAll: requestor= " + requestor + " released " + lock.toString());
            }
            if (!lock.isFree()) continue;
            this.m_locks.remove(lock.getLockId());
        }
        if (rLocks.getCount() == 0) {
            this.m_clients.remove(requestor);
        }
        if (this.DEBUG) {
            this.debug("UnlockAll completed for requestor= " + requestor + "; numRequestors= " + this.getNumRequestors() + " numLocks= " + this.getNumLocks());
        }
    }

    synchronized void cancelAllWaitingReq(Object requestor) {
        RequestorLocks rLocks;
        if (this.DEBUG) {
            this.debug("cancelAllWaitingReq; requestor= " + requestor);
        }
        if ((rLocks = this.getRequestorLocks(requestor)) == null) {
            return;
        }
        ArrayList list = rLocks.getWaitingRequests();
        int waitingReq = list.size();
        if (this.DEBUG) {
            this.debug("cancelAllWaitingReq; requestor= " + requestor + " waitingReqCt= " + waitingReq + " numRequestors= " + this.getNumRequestors() + " numLocks= " + this.getNumLocks());
        }
        for (LockRequest req : list) {
            Lock lock = req.getLock();
            this.cancelWaitingReq(req, 4);
            if (!this.DEBUG) continue;
            this.debug("cancelAllWaitingReq requestor= " + requestor + " releasedReqFor " + lock.toString());
        }
    }

    void waitingRequestGranted(LockRequest req) {
        RequestorLocks rLocks = this.getRequestorLocks(req.getOwner(), false);
        if (rLocks != null) {
            rLocks.endWaitRequest(req);
        }
    }

    void grantedRequestReleased(LockRequest req) {
        RequestorLocks rLocks = this.getRequestorLocks(req.getOwner(), false);
        if (rLocks != null) {
            rLocks.removeRequest(req);
        }
        if (rLocks.getCount() == 0) {
            this.m_clients.remove(req.getOwner());
        }
    }

    @Override
    public synchronized int getNumLocks() {
        return this.m_locks.size();
    }

    @Override
    public synchronized int getNumRequestors() {
        return this.m_clients.size();
    }

    @Override
    public synchronized int getNumLocksForRequestor(Object requestor) {
        RequestorLocks rlocks = this.getRequestorLocks(requestor);
        if (rlocks == null) {
            return 0;
        }
        return rlocks.getCount();
    }

    @Override
    public synchronized int getNumWaiters(Object lockId) {
        Lock lock = this.getLock(lockId, false);
        if (lock == null) {
            return 0;
        }
        return lock.getCountWaiters();
    }

    @Override
    public synchronized int getNumGranted(Object lockId) {
        Lock lock = this.getLock(lockId, false);
        if (lock == null) {
            return 0;
        }
        return lock.getCountGranted();
    }

    @Override
    public synchronized int getLockMode(Object lockId, Object requestor) {
        Lock lock = this.getLock(lockId, false);
        if (lock == null) {
            return 0;
        }
        return this.m_lockingRules.getPublicLockMode(lock.getLockMode(requestor));
    }

    @Override
    public synchronized boolean hasLock(Object lockId, Object requestor, int lockmode) {
        Lock lock = this.getLock(lockId, false);
        if (lock == null) {
            return false;
        }
        return lock.hasLock(this.m_lockingRules.getInternalLockMode(lockmode), requestor);
    }

    private Lock getLock(Object lockId) {
        return this.getLock(lockId, false);
    }

    private synchronized Lock getLock(Object lockId, boolean create) {
        return this.getLock(lockId, create, 0, null);
    }

    private synchronized Lock getLock(Object lockId, boolean create, int objectType, String className) {
        Lock lock = (Lock)this.m_locks.get(lockId);
        if (lock == null && create) {
            lock = new Lock(lockId, this, objectType, className);
            this.m_locks.put(lockId, lock);
        }
        return lock;
    }

    synchronized Object[] getLockRequestors() {
        return this.m_clients.keySet().toArray();
    }

    private synchronized RequestorLocks getRequestorLocks(Object requestor, boolean create) {
        RequestorLocks rlocks = (RequestorLocks)this.m_clients.get(requestor);
        if (rlocks == null && create) {
            rlocks = new RequestorLocks(requestor);
            this.m_clients.put(requestor, rlocks);
        }
        return rlocks;
    }

    RequestorLocks getRequestorLocks(Object requestor) {
        return this.getRequestorLocks(requestor, false);
    }

    @Override
    public synchronized void printLocks() {
        this.debug("Printing all Locks: Number of Locks= " + this.m_locks.size());
        for (Object obj : this.m_locks.keySet()) {
            Lock lock = (Lock)this.m_locks.get(obj);
            lock.printAllLockInfo();
        }
    }

    @Override
    public synchronized void printRequestors() {
        this.debug("Printing all Clients: Number of clients= " + this.m_clients.size());
        for (Object obj : this.m_clients.keySet()) {
            RequestorLocks rlocks = (RequestorLocks)this.m_clients.get(obj);
            rlocks.printAllLocks();
        }
    }

    private void debug(String s) {
        System.out.println("LockManager: " + s);
    }

    private void validateNoConcurrentLockRequests(Lock lock, Object requestor) {
        LockRequest req = lock.findRequestFromRequestor(requestor);
        if (req != null && req.getWaiter() != null && req.getWaiter() != Thread.currentThread()) {
            throw new Error("Concurrent requests for the same Lock by threads in the same session are not supported");
        }
    }

    ILockingRules getLockingRules() {
        return this.m_lockingRules;
    }
}

