/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IBlobSource;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.framework.agent.LogicalFile;
import com.sonicsw.mf.framework.agent.cache.CacheException;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.cache.LatestVersionMissingException;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class LocalFileManager {
    private static final String SONIC_HOME_PROTOCOL = "sonichome:///";
    private static final int SONIC_HOME_PROTOCOL_LENGTH = "sonichome:///".length();
    private static final String SONIC_HOME_PROTOCOL_PREFIX = "sonichome:///".substring(0, SONIC_HOME_PROTOCOL_LENGTH - 1);
    private static final int SONIC_HOME_PROTOCOL_PREFIX_LENGTH = SONIC_HOME_PROTOCOL_PREFIX.length();
    private static final String SONICSW_HOME = System.getProperty("sonicsw.home");
    private IConfigCache m_configCache;
    private IConfigCacheView m_configCacheView;
    private IBlobSource m_blobSource;
    private ILogger m_logger;
    private String m_containerID;
    private int m_traceMask = 0;
    private boolean DEBUG = false;

    public LocalFileManager(IBlobSource blobSource, IConfigCache cache, ILogger logger, String containerID) throws CacheException {
        this.m_blobSource = blobSource;
        this.m_configCache = cache;
        this.m_configCacheView = cache.getCacheView();
        this.m_logger = logger;
        this.m_containerID = containerID;
    }

    void setBlobSource(IBlobSource blobSource) {
        this.m_blobSource = blobSource;
    }

    public File getLocalFile(String locations, String logicalName) throws MFException, CacheException {
        return this.getLocalFile(locations, logicalName, null);
    }

    public File getLocalFile(String locations, String logicalName, String[] dsLogicalPath) throws MFException, CacheException {
        File theFile = null;
        LogicalFile file = null;
        StringTokenizer locTokenizer = new StringTokenizer(locations, ";");
        while (locTokenizer.hasMoreElements()) {
            String location = locTokenizer.nextToken();
            if (this.DEBUG) {
                System.out.println("LocalFileManager.getLocalFile trying location == " + location + " logicalName == " + logicalName);
            }
            if ((file = this.localFileFromLocation(location, logicalName, false, dsLogicalPath)) == null) continue;
            if (this.DEBUG) {
                System.out.println("LocalFileManager.getLocalFile returning file " + file.getFileName() + " found at location " + location);
            }
            return new File(file.getFileName());
        }
        if (file == null) {
            try {
                if (this.DEBUG) {
                    System.out.println("LocalFileManager.getLocalFile about to call getAvailableFileByLogicalName for logicalName " + logicalName);
                }
                String useLogicalName = LocalFileManager.checkLogicalNameSlash(logicalName);
                theFile = this.m_configCacheView.getAvailableFileByLogicalName(useLogicalName);
                if (this.DEBUG) {
                    if (theFile == null) {
                        System.out.println("getAvailableFileByLogicalName in LocalFileManager.getLocalFile returned null");
                    } else {
                        System.out.println("getAvailableFileByLogicalName in LocalFileManager.getLocalFile returned " + theFile.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                if (this.DEBUG) {
                    System.out.println("LocalFileManager.getLocalFile caught exception, TRACE FOLLOWS");
                    e.printStackTrace();
                }
                throw new PersistentCacheException(e.toString());
            }
        }
        return theFile;
    }

    public LogicalFile localFileFromLocation(String location0, String logicalName0, boolean nativeFile, String[] dsLogicalPath) throws MFException, CacheException {
        IElement cachedFile;
        boolean isSonicFS;
        LogicalFile file = null;
        if (dsLogicalPath != null) {
            dsLogicalPath[0] = null;
        }
        String location = LocalFileManager.substituteSonicHome(location0);
        String logicalName = LocalFileManager.substituteSonicHome(logicalName0);
        if (this.DEBUG) {
            System.out.println("LocalFileManager.localFileFromLocation looking for logicalName " + logicalName + " location == " + location);
        }
        String sonicFS = "sonicfs:///".substring(0, "sonicfs:///".length() - 1);
        String testSonicFS = logicalName;
        if (location != null) {
            if (!location.endsWith("/") || location.endsWith("://")) {
                location = location + "/";
            }
            testSonicFS = location + logicalName;
        }
        String firstNCharacters = null;
        if (testSonicFS.length() >= sonicFS.length()) {
            firstNCharacters = testSonicFS.substring(0, sonicFS.length());
        }
        if (this.DEBUG) {
            System.out.println("LocalFileManager.localFileFromLocation comparing " + firstNCharacters + " to " + sonicFS);
        }
        boolean bl = isSonicFS = firstNCharacters != null && firstNCharacters.equals(sonicFS);
        if ((isSonicFS || location != null) && this.m_configCache.getCacheRootDirectory() == null) {
            throw new MFException("Component classpath cannot include Directory Service based archives as configuration cache is not enabled.");
        }
        if (location != null && !isSonicFS) {
            return this.getFileFromOtherURL(location, logicalName);
        }
        if (!(location != null || firstNCharacters != null && firstNCharacters.equals(sonicFS))) {
            if (this.DEBUG) {
                System.out.println("LocalFileManager.localFileFromLocation trying URL from logicalName, without caching " + logicalName);
            }
            try {
                URL url = new URL(logicalName);
                if (url.getProtocol().equals("file") && new File(url.getFile()).isDirectory() && !logicalName.endsWith("/")) {
                    logicalName = logicalName + '/';
                    url = new URL(logicalName);
                }
                file = new LogicalFile(logicalName, url);
            }
            catch (MalformedURLException e) {
                try {
                    File fileForUrl = new File(logicalName);
                    file = new LogicalFile(logicalName, fileForUrl.toURL());
                }
                catch (MalformedURLException e2) {
                    throw new MFException("Unable to create a URL for " + logicalName);
                }
            }
            return file;
        }
        String fileName = null;
        try {
            fileName = new URL("file" + testSonicFS.substring("sonicfs".length())).getFile();
        }
        catch (MalformedURLException urlEx) {
            throw new MFException("Invalid sonicfs URL: " + testSonicFS);
        }
        if (dsLogicalPath != null) {
            dsLogicalPath[0] = fileName;
        }
        File blobFile = null;
        try {
            if (this.DEBUG) {
                System.out.println("LocalFileManager.localFileFromLocation trying the cache for " + fileName);
            }
            blobFile = this.m_configCacheView.getFileByLogicalName(fileName, nativeFile);
        }
        catch (LatestVersionMissingException missingE) {
            if (this.DEBUG) {
                System.out.println("LocalFileManager.localFileFromLocation caught LatestVersionMissingException, trying from the DS ");
            }
            blobFile = this.getBlobFromDSAndCache(fileName, nativeFile, location != null);
        }
        if (blobFile != null && location != null && this.isNonDSFile(cachedFile = this.m_configCacheView.getElementByLogicalName(fileName))) {
            if (this.DEBUG) {
                System.out.println("LocalFileManager.localFileFromLocation switched sources to the DS, recaching the file ");
            }
            blobFile = this.getBlobFromDSAndCache(fileName, false, true);
        }
        if (blobFile != null) {
            try {
                return new LogicalFile(blobFile.getCanonicalPath(), blobFile.toURL());
            }
            catch (MalformedURLException ex) {
                throw new MFException("Unable to create URL for " + blobFile.toString());
            }
            catch (IOException e) {
                throw new MFException("Unable to get canonical path for " + blobFile.toString());
            }
        }
        return null;
    }

    private LogicalFile getFileFromOtherURL(String location, String logicalName) throws CacheException {
        boolean latestCopyInTheCache;
        Object file = null;
        if (this.DEBUG) {
            System.out.println("LocalFileManager.getFileFromOtherURL calling storeFile");
        }
        if (latestCopyInTheCache = this.m_configCache.storeFile(location, logicalName)) {
            if (this.DEBUG) {
                System.out.println("LocalFileManager.getFileFromOtherURL found something in the cache");
            }
            String useLogicalName = LocalFileManager.checkLogicalNameSlash(logicalName);
            File localFile = this.m_configCacheView.getFileByLogicalName(useLogicalName, false);
            try {
                return new LogicalFile(localFile.getCanonicalPath(), localFile.toURL());
            }
            catch (MalformedURLException ex) {
                throw new PersistentCacheException("Unable to create URL for " + useLogicalName);
            }
            catch (IOException e) {
                throw new PersistentCacheException("Unable to get canonical path for " + useLogicalName);
            }
        }
        if (this.DEBUG) {
            System.out.println("LocalFileManager.getFileFromOtherURL returning null");
        }
        return null;
    }

    private static String checkLogicalNameSlash(String logicalName) {
        String useLogicalName = logicalName;
        if (!useLogicalName.startsWith("/")) {
            useLogicalName = "/" + useLogicalName;
        }
        return useLogicalName;
    }

    public boolean isNonDSFile(IElement fileEnvElement) {
        IAttributeSet topSet = fileEnvElement.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttrs != null) {
            Boolean isNonDSFile = (Boolean)systemAttrs.getAttribute("NON_DSFILE");
            return isNonDSFile != null && isNonDSFile != false;
        }
        return false;
    }

    private File getBlobFromDSAndCache(String fileName, boolean nativeFile, boolean notFromCache) throws CacheException, VersionOutofSyncException, DirectoryServiceException {
        File blobFile = null;
        try {
            IDirElement blobEl;
            if (this.m_blobSource == null) {
                throw new InvokeTimeoutException("The Directory Service is not Available.");
            }
            IBlob blob = this.m_blobSource.getBlobByLogicalName(this.m_containerID, fileName);
            if (blob == null) {
                return null;
            }
            IDirElement el = blob.getElement();
            String archiveName = el.getArchiveName();
            if (this.DEBUG) {
                System.out.println("LocalFileManager.getBlobFromDSAndCache, archiveName == " + archiveName + " and it's logical? == " + blob.isLogicalName());
            }
            if (archiveName == null) {
                archiveName = fileName;
            }
            if (this.m_configCacheView.isDoNotCache((IElement)(blobEl = blob.getElement()))) {
                blobFile = this.m_configCache.storeBlobTemporarily(blob);
            } else {
                this.m_configCache.setBlobByLogicalName(archiveName, blob, nativeFile && archiveName == fileName);
                blobFile = this.m_configCacheView.getFileByLogicalName(fileName, nativeFile);
            }
            if (this.DEBUG) {
                System.out.println("LocalFileManager.getBlobFromDSAndCache returning " + blobFile.getAbsolutePath() + " for " + fileName);
            }
            if (this.m_logger != null && (this.m_traceMask & 0x200) > 0 && (this.m_traceMask & 1) > 0) {
                this.m_logger.logMessage("Configuration [" + blob.getElement().getIdentity().getName() + "] added to cache", 7);
            }
        }
        catch (InvokeTimeoutException timeoutE) {
            if (notFromCache) {
                return null;
            }
            blobFile = this.m_configCacheView.getAvailableFileByLogicalName(fileName);
            if (blobFile != null) {
                String filename = blobFile.getName();
                String version = filename.substring(0, filename.indexOf(46));
                filename = filename.substring(filename.indexOf(46) + 1);
                if (this.m_logger != null) {
                    this.m_logger.logMessage("Failed to retrieve the latest version for\"" + filename + "\" from local archive cache; most recently cached archive (version " + version + ") will be used instead", 2);
                }
            }
            throw timeoutE;
        }
        return blobFile;
    }

    public static String substituteSonicHome(String url) throws MFException {
        if (url == null) {
            return null;
        }
        if (url.length() >= SONIC_HOME_PROTOCOL_PREFIX_LENGTH && url.substring(0, SONIC_HOME_PROTOCOL_PREFIX_LENGTH).equalsIgnoreCase(SONIC_HOME_PROTOCOL_PREFIX)) {
            if (url.length() == SONIC_HOME_PROTOCOL_PREFIX_LENGTH || url.charAt(SONIC_HOME_PROTOCOL_PREFIX_LENGTH) != '/') {
                throw new MFException("Invalid URL: \"" + url + "\".");
            }
            if (SONICSW_HOME == null) {
                throw new MFException("Cannot resolve \"" + url + "\" - property \"" + "sonicsw.home" + "\" is not set.");
            }
            String relativePath = url.substring(SONIC_HOME_PROTOCOL_LENGTH);
            return new File(new File(SONICSW_HOME), relativePath).getAbsolutePath();
        }
        return url;
    }

    public int geTraceMask() {
        return this.m_traceMask;
    }

    public void setTraceMask(int mask) {
        this.m_traceMask = mask;
    }
}

