/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IPostCommitTrigger;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.IValidationConstants;
import com.sonicsw.mf.common.config.IValidationDSContext;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.IValidator;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceTriggerException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceValidationException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.directory.IDebuggingMasks;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.impl.ModificationItem;
import com.sonicsw.mf.framework.directory.impl.TriggerDSContext;
import com.sonicsw.mf.framework.directory.impl.ValidationDSContext;
import com.sonicsw.mx.util.IEmptyArray;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

final class TriggerValidator
implements IValidationConstants,
IDebuggingMasks {
    private static final String CONFIG_VERSION_101 = "101";
    private static final String CONFIG_VERSION_100 = "100";
    private static final String CONFIG_VERSION_99 = "99";
    private HashMap m_validationMethodsTable;
    private DirectoryService m_ds;
    private IValidator m_badValidator = null;

    TriggerValidator(DirectoryService ds) {
        this.m_ds = ds;
        this.m_validationMethodsTable = new HashMap();
        PluginInfo[] pluginList = this.getAllPlugins();
        for (int i = 0; i < pluginList.length; ++i) {
            IValidator validator = null;
            try {
                validator = this.createValidatorPlugin(pluginList[i].m_className, pluginList[i].m_classpath);
                String pluginReleaseVersion = validator.getReleaseVersion();
                if (pluginReleaseVersion == null || pluginReleaseVersion.length() == 0) {
                    throw new Exception("The validation plugin version is missing.");
                }
                if (!pluginReleaseVersion.equals(pluginList[i].m_releaseVersion)) {
                    throw new Exception("Plugin version mismatch - " + pluginReleaseVersion);
                }
            }
            catch (Exception e) {
                String upgradeFlag = System.getProperty("MQ_UPGRADE");
                String loadingValidators = System.getProperty("loading_validators");
                String trimmedClasspath = null;
                if (pluginList[i].m_classpath != null && pluginList[i].m_classpath.length() > 11) {
                    trimmedClasspath = pluginList[i].m_classpath.substring(11);
                }
                if (!(upgradeFlag != null && upgradeFlag.equals("true") || loadingValidators != null && trimmedClasspath != null && loadingValidators.indexOf(trimmedClasspath) != -1)) {
                    this.m_ds.logMessage("Could not load validator " + pluginList[i].m_className + " for release version " + pluginList[i].m_releaseVersion + ", trace follows...", e, 2);
                }
                if (this.m_badValidator != null) continue;
                this.m_badValidator = new BadValidator();
                this.m_validationMethodsTable.put("_MF_MISSING_VALIDATOR", this.m_badValidator);
                continue;
            }
            String[] elementTypes = validator.getElementTypesValidated();
            if (elementTypes == null) {
                elementTypes = IEmptyArray.EMPTY_STRING_ARRAY;
            }
            this.associateTypesWithValidator(elementTypes, pluginList[i].m_releaseVersion, validator);
            if (!pluginList[i].m_releaseVersion.equals(CONFIG_VERSION_101)) continue;
            this.associateTypesWithValidator(elementTypes, CONFIG_VERSION_100, validator);
            this.associateTypesWithValidator(elementTypes, CONFIG_VERSION_99, validator);
        }
    }

    private PluginInfo pluginFromElement(IElement pluginElement) {
        String validationClass = "";
        String releaseVersion = "";
        try {
            String classpath;
            IAttributeSet pluginAttributes = pluginElement.getAttributes();
            validationClass = (String)pluginAttributes.getAttribute("VALIDATION_CLASS");
            if (validationClass == null) {
                return null;
            }
            releaseVersion = (String)pluginAttributes.getAttribute("RELEASE_VERSION");
            if (releaseVersion == null) {
                this.m_ds.logMessage("Element " + pluginElement.getIdentity().getName() + " does not have a release version attribute", 2);
                releaseVersion = "?";
            }
            return new PluginInfo(validationClass, (classpath = DirectoryService.listToClasspath((IAttributeList)pluginAttributes.getAttribute("VALIDATOR_ARCHIVES"))).length() > 0 ? classpath : null, releaseVersion);
        }
        catch (Exception e) {
            String upgradeFlag = System.getProperty("MQ_UPGRADE");
            if (upgradeFlag == null || !upgradeFlag.equals("true")) {
                this.m_ds.logMessage("Could not load validator " + validationClass + " for release version " + releaseVersion + ", trace follows...", e, 2);
            }
            return null;
        }
    }

    private PluginInfo[] getAllPlugins() {
        IElementIdentity[] libraryElements = null;
        try {
            libraryElements = this.m_ds.listElements("/_MFLibrary/validators");
        }
        catch (DirectoryServiceException e) {
            return new PluginInfo[0];
        }
        ArrayList<PluginInfo> list = new ArrayList<PluginInfo>();
        for (int i = 0; i < libraryElements.length; ++i) {
            PluginInfo pluginInfo;
            IDirElement pluginElement = null;
            try {
                pluginElement = this.m_ds.getElement(libraryElements[i].getName(), false);
            }
            catch (DirectoryServiceException e) {
                throw new IllegalStateException(e.toString());
            }
            if (!libraryElements[i].getType().equals("MF_VALIDATOR") || (pluginInfo = this.pluginFromElement((IElement)pluginElement)) == null) continue;
            list.add(pluginInfo);
        }
        PluginInfo[] pluginList = new PluginInfo[list.size()];
        list.toArray(pluginList);
        return pluginList;
    }

    private void associateTypesWithValidator(String[] elementTypes, String releaseVersion, IValidator validator) {
        for (int j = 0; j < elementTypes.length; ++j) {
            ArrayList<IValidator> typeValidatorList = (ArrayList<IValidator>)this.m_validationMethodsTable.get(elementTypes[j] + releaseVersion);
            if (typeValidatorList == null) {
                typeValidatorList = new ArrayList<IValidator>();
            }
            typeValidatorList.add(validator);
            this.m_validationMethodsTable.put(elementTypes[j] + releaseVersion, typeValidatorList);
            this.m_ds.trace(512, "Validate: " + elementTypes[j] + "  version: " + releaseVersion + " by: " + validator.getClass().getName());
        }
    }

    void runOnCreateTriggers(ArrayList list) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList modValidators;
            ModificationItem modItem = (ModificationItem)list.get(i);
            if (modItem.getChangeType() != 0 || (modValidators = this.getModValidators(modItem, false)).isEmpty()) continue;
            this.prepareCreateTriggers(modItem, modValidators, validators, validationGroups);
        }
        for (String validatorID : validationGroups.keySet()) {
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            IValidator validator = (IValidator)validators.get(validatorID);
            IDirElement[] newImages = new IDirElement[vGroup.size()];
            vGroup.toArray(newImages);
            try {
                validator.onCreate((ITriggerDSContext)new TriggerDSContext(this.m_ds), newImages);
            }
            catch (Throwable t) {
                throw new DirectoryServiceTriggerException(validatorID, t);
            }
        }
    }

    void runAfterCreateTriggers(ArrayList list) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList modValidators;
            ModificationItem modItem = (ModificationItem)list.get(i);
            if (modItem.getChangeType() != 0 || (modValidators = this.getModValidators(modItem, true)).isEmpty()) continue;
            this.prepareCreateTriggers(modItem, modValidators, validators, validationGroups);
        }
        for (String validatorID : validationGroups.keySet()) {
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            IPostCommitTrigger validator = (IPostCommitTrigger)validators.get(validatorID);
            IDirElement[] newImages = new IDirElement[vGroup.size()];
            vGroup.toArray(newImages);
            try {
                validator.afterCreate((ITriggerDSContext)new TriggerDSContext(this.m_ds), newImages);
            }
            catch (Throwable t) {
                throw new DirectoryServiceTriggerException(validatorID, t);
            }
        }
    }

    void runOnUpdateTriggers(ArrayList list) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validationGroupsAfter = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList modValidators;
            ModificationItem modItem = (ModificationItem)list.get(i);
            if (modItem.getChangeType() != 1 || (modValidators = this.getModValidators(modItem, false)).isEmpty()) continue;
            this.prepareUpdateTriggers(modItem, modValidators, validators, validationGroups, validationGroupsAfter);
        }
        Iterator iterator = validationGroups.keySet().iterator();
        boolean iteratorIndex = false;
        while (iterator.hasNext()) {
            String validatorID = (String)iterator.next();
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            ArrayList afterGroup = (ArrayList)validationGroupsAfter.get(validatorID);
            IValidator validator = (IValidator)validators.get(validatorID);
            IDirElement[] beforeImages = new IDirElement[vGroup.size()];
            IDeltaElement[] afterImages = new IDeltaElement[afterGroup.size()];
            vGroup.toArray(beforeImages);
            afterGroup.toArray(afterImages);
            try {
                validator.onUpdate((ITriggerDSContext)new TriggerDSContext(this.m_ds), beforeImages, afterImages);
            }
            catch (Throwable t) {
                throw new DirectoryServiceTriggerException(validatorID, t);
            }
        }
    }

    void runAfterUpdateTriggers(ArrayList list) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validationGroupsAfter = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList modValidators;
            ModificationItem modItem = (ModificationItem)list.get(i);
            if (modItem.getChangeType() != 1 || (modValidators = this.getModValidators(modItem, true)).isEmpty()) continue;
            this.prepareUpdateTriggers(modItem, modValidators, validators, validationGroups, validationGroupsAfter);
        }
        Iterator iterator = validationGroups.keySet().iterator();
        boolean iteratorIndex = false;
        while (iterator.hasNext()) {
            String validatorID = (String)iterator.next();
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            ArrayList afterGroup = (ArrayList)validationGroupsAfter.get(validatorID);
            IPostCommitTrigger validator = (IPostCommitTrigger)validators.get(validatorID);
            IDirElement[] beforeImages = new IDirElement[vGroup.size()];
            IDeltaElement[] afterImages = new IDeltaElement[afterGroup.size()];
            vGroup.toArray(beforeImages);
            afterGroup.toArray(afterImages);
            try {
                validator.afterUpdate((ITriggerDSContext)new TriggerDSContext(this.m_ds), beforeImages, afterImages);
            }
            catch (Throwable t) {
                throw new DirectoryServiceTriggerException(validatorID, t);
            }
        }
    }

    void runOnDeleteTriggers(ArrayList list) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList modValidators;
            ModificationItem modItem = (ModificationItem)list.get(i);
            if (modItem.getChangeType() != 2 || (modValidators = this.getModValidators(modItem, false)).isEmpty()) continue;
            this.prepareDeleteTriggers(modItem, modValidators, validators, validationGroups);
        }
        for (String validatorID : validationGroups.keySet()) {
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            IValidator validator = (IValidator)validators.get(validatorID);
            IDirElement[] beforeImages = new IDirElement[vGroup.size()];
            vGroup.toArray(beforeImages);
            try {
                validator.onDelete((ITriggerDSContext)new TriggerDSContext(this.m_ds), beforeImages);
            }
            catch (Throwable t) {
                throw new DirectoryServiceTriggerException(validatorID, t);
            }
        }
    }

    void runAfterDeleteTriggers(ArrayList list) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList modValidators;
            ModificationItem modItem = (ModificationItem)list.get(i);
            if (modItem.getChangeType() != 2 || (modValidators = this.getModValidators(modItem, true)).isEmpty()) continue;
            this.prepareDeleteTriggers(modItem, modValidators, validators, validationGroups);
        }
        for (String validatorID : validationGroups.keySet()) {
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            IPostCommitTrigger validator = (IPostCommitTrigger)validators.get(validatorID);
            IDirElement[] beforeImages = new IDirElement[vGroup.size()];
            vGroup.toArray(beforeImages);
            try {
                validator.afterDelete((ITriggerDSContext)new TriggerDSContext(this.m_ds), beforeImages);
            }
            catch (Throwable t) {
                throw new DirectoryServiceTriggerException(validatorID, t);
            }
        }
    }

    private ArrayList getModValidators(ModificationItem modItem, boolean postCommitTriggersOnly) {
        ArrayList modValidators = new ArrayList();
        IElementIdentity modID = modItem.getModificationID();
        String validatorID = modID.getType() + modID.getReleaseVersion();
        this.modValidatorsAddValidatorsAL(modID, modValidators, validatorID);
        if (postCommitTriggersOnly) {
            Iterator iterator = modValidators.iterator();
            while (iterator.hasNext()) {
                IValidator validator = (IValidator)iterator.next();
                if (validator instanceof IPostCommitTrigger) continue;
                iterator.remove();
            }
        }
        return modValidators;
    }

    private void prepareDeleteTriggers(ModificationItem modItem, ArrayList modValidators, HashMap validators, HashMap validationGroups) {
        for (IValidator validator : modValidators) {
            String validatorID = this.constructValidatorID(validator);
            ArrayList vGroup = TriggerValidator.retrieveVGroup(validationGroups, validator, validatorID, validators);
            TriggerValidator.vGroupAddBeforeImage(modItem, vGroup);
        }
    }

    private void prepareCreateTriggers(ModificationItem modItem, ArrayList modValidators, HashMap validators, HashMap validationGroups) {
        for (IValidator validator : modValidators) {
            String validatorID = this.constructValidatorID(validator);
            ArrayList vGroup = TriggerValidator.retrieveVGroup(validationGroups, validator, validatorID, validators);
            IDirElement newImage = (IDirElement)modItem.getModification();
            if (newImage == null) continue;
            vGroup.add(newImage);
        }
    }

    private void prepareUpdateTriggers(ModificationItem modItem, ArrayList modValidators, HashMap validators, HashMap validationGroupsBefore, HashMap validationGroupAfter) {
        for (IValidator validator : modValidators) {
            String validatorID = this.constructValidatorID(validator);
            ArrayList vGroup = TriggerValidator.retrieveVGroup(validationGroupsBefore, validator, validatorID, validators);
            TriggerValidator.vGroupAddBeforeImage(modItem, vGroup);
            ArrayList after = TriggerValidator.retrieveVGroup(validationGroupAfter, validator, validatorID, validators);
            IBasicElement afterImage = modItem.getModification();
            if (afterImage == null) continue;
            after.add(afterImage);
        }
    }

    private static void vGroupAddBeforeImage(ModificationItem modItem, ArrayList vGroup) {
        IDirElement beforeImage = (IDirElement)modItem.getBeforeImage();
        if (beforeImage != null) {
            vGroup.add(beforeImage);
        }
    }

    void validate(ArrayList list, boolean isImportTransaction) throws DirectoryServiceException {
        HashMap validationGroups = new HashMap();
        HashMap validators = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            ModificationItem modItem = (ModificationItem)list.get(i);
            IElementIdentity modID = modItem.getModificationID();
            String validatorID = modID.getType() + modID.getReleaseVersion();
            ArrayList<IValidator> modValidators = new ArrayList<IValidator>();
            this.modValidatorsAddValidatorsAL(modID, modValidators, validatorID);
            if (modValidators.isEmpty()) {
                if (this.m_badValidator == null) continue;
                modValidators.add(this.m_badValidator);
            }
            for (IValidator validator : modValidators) {
                validatorID = this.constructValidatorID(validator);
                ArrayList vGroup = TriggerValidator.retrieveVGroup(validationGroups, validator, validatorID, validators);
                vGroup.add(modItem);
            }
        }
        for (String validatorID : validationGroups.keySet()) {
            ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
            IValidator validator = (IValidator)validators.get(validatorID);
            if (validator == null && (validator = this.m_badValidator) == null) {
                throw new DirectoryServiceValidationException(validatorID, (Throwable)new Exception("No validator is available."));
            }
            IValidationElementChange[] modifications = new ModificationItem[vGroup.size()];
            vGroup.toArray(modifications);
            try {
                validator.validate((IValidationDSContext)new ValidationDSContext(this.m_ds, isImportTransaction), modifications);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new DirectoryServiceValidationException(validatorID, t);
            }
        }
    }

    private void modValidatorsAddValidatorsAL(IElementIdentity modID, ArrayList modValidators, String validatorID) {
        ArrayList validatorsAL = (ArrayList)this.m_validationMethodsTable.get(validatorID);
        if (validatorsAL != null) {
            modValidators.addAll(validatorsAL);
        }
        if ((validatorsAL = (ArrayList)this.m_validationMethodsTable.get("**")) != null) {
            modValidators.addAll(validatorsAL);
        }
        if ((validatorsAL = (ArrayList)this.m_validationMethodsTable.get("*" + modID.getReleaseVersion())) != null) {
            modValidators.addAll(validatorsAL);
        }
        if ((validatorsAL = (ArrayList)this.m_validationMethodsTable.get(modID.getType() + "*")) != null) {
            modValidators.addAll(validatorsAL);
        }
    }

    private static ArrayList retrieveVGroup(HashMap validationGroups, IValidator validator, String validatorID, HashMap validators) {
        ArrayList vGroup = (ArrayList)validationGroups.get(validatorID);
        if (vGroup == null) {
            vGroup = new ArrayList();
            validationGroups.put(validatorID, vGroup);
            validators.put(validatorID, validator);
        }
        return vGroup;
    }

    private String constructValidatorID(IValidator validator) {
        String[] types = validator.getElementTypesValidated();
        String ID = "";
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                ID = ID + types[i];
            }
        }
        ID = ID + validator.getReleaseVersion();
        ID = ID + validator.getClass();
        return ID;
    }

    private IValidator createValidatorPlugin(String className, String classpath) throws Exception {
        Object validator;
        Class validatorClass = this.m_ds.loadClass(className, classpath);
        Constructor validatorContructor = null;
        try {
            validatorContructor = validatorClass.getConstructor(ITriggerDSContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Object t = validator = validatorContructor == null ? validatorClass.newInstance() : validatorContructor.newInstance(new TriggerDSContext(this.m_ds));
        if (!(validator instanceof IValidator)) {
            throw new Exception(className + " must implement the 'IValidator' interface.");
        }
        return (IValidator)validator;
    }

    static class BadValidator
    implements IValidator {
        BadValidator() {
        }

        public String getReleaseVersion() {
            return "0";
        }

        public void validate(IValidationDSContext dsContext, IValidationElementChange[] changes) throws Exception {
        }

        public String[] getElementTypesValidated() {
            return null;
        }

        public void onDelete(ITriggerDSContext dsContext, IDirElement[] changes) throws DirectoryServiceException {
        }

        public void onUpdate(ITriggerDSContext dsContext, IDirElement[] beforeImages, IDeltaElement[] afterImages) throws DirectoryServiceException {
        }

        public void onCreate(ITriggerDSContext dsContext, IDirElement[] afterImages) throws DirectoryServiceException {
        }
    }

    private static class PluginInfo {
        String m_className;
        String m_classpath;
        String m_releaseVersion;

        PluginInfo(String className, String classpath, String releaseVersion) {
            this.m_className = className;
            this.m_classpath = classpath;
            this.m_releaseVersion = releaseVersion;
        }
    }
}

