/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.storage.fs;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.impl.DirIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.directory.ILogger;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import com.sonicsw.mf.framework.directory.storage.PackedDirUtil;
import com.sonicsw.mf.framework.directory.storage.ParentDirDoesNotExistException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSTransactionManager;
import com.sonicsw.mf.framework.directory.storage.fs.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class FSStorage
implements IStorage {
    private File m_domainDir = null;
    private File m_dataDir = null;
    private FSTransactionManager m_trManager;
    private FileManager m_fileManager;
    private Mapper m_mapper;
    private ILogger m_logger;
    private static int COPY_CHUNK_SIZE = 1000000;
    public static final String TR_FILE_POSTFIX = "tr";

    public FSStorage(String hostDirName, String domainName, boolean doSync) throws StorageException {
        this.init(hostDirName, domainName, "data", null, doSync, true);
    }

    public FSStorage(String hostDirName, String domainName, String dataDirName, boolean doSync) throws StorageException {
        this.init(hostDirName, domainName, dataDirName, null, doSync, true);
    }

    public FSStorage(String hostDirName, String domainName, String dataDirName, String password, boolean doSync) throws StorageException {
        this.init(hostDirName, domainName, dataDirName, password, doSync, true);
    }

    public FSStorage(String hostDirName, String domainName, String dataDirName) throws StorageException {
        this.init(hostDirName, domainName, dataDirName, null, false, false);
    }

    @Override
    public void setLogger(ILogger logger) {
        this.m_logger = logger;
        if (this.m_fileManager != null) {
            this.m_fileManager.setLogger(logger);
        }
    }

    private void init(String hostDirName, String domainName, String dataDirName, String password, boolean doSync, boolean haveTrManager) throws StorageException {
        if (domainName == null || domainName.length() == 0) {
            throw new StorageException("A domain name is missing.");
        }
        if (hostDirName == null || hostDirName.length() == 0) {
            throw new StorageException("A host directory name is missing.");
        }
        File hostDir = new File(hostDirName);
        if (!hostDir.exists()) {
            throw new StorageException("Directory '" + hostDirName + ", does not exist.");
        }
        this.m_logger = null;
        this.m_domainDir = new File(hostDir, domainName);
        if (!this.m_domainDir.exists() && !this.m_domainDir.mkdir()) {
            throw new StorageException("Cannot create the root directory '" + this.m_domainDir.getPath() + "'.");
        }
        if (!this.m_domainDir.canWrite()) {
            throw new StorageException("No write permission in directory '" + this.m_domainDir.getPath() + "'.");
        }
        this.m_dataDir = new File(this.m_domainDir, dataDirName);
        if (!this.m_dataDir.exists() && !this.m_dataDir.mkdir()) {
            throw new StorageException("Cannot create the data directory '" + this.m_dataDir.getPath() + "'.");
        }
        this.m_mapper = new Mapper();
        File transactionsFile = null;
        transactionsFile = haveTrManager ? new File(this.m_domainDir, dataDirName + "." + TR_FILE_POSTFIX) : new File(this.m_domainDir, "_TR_FILE_DOES_NOT_EXIST");
        this.m_trManager = new FSTransactionManager(transactionsFile, this.m_dataDir, doSync);
        try {
            this.m_fileManager = new FileManager(password, this.m_trManager);
        }
        catch (Exception e) {
            throw new StorageException(e.getMessage(), e);
        }
    }

    @Override
    public String getDomain() {
        return this.m_domainDir.getName();
    }

    @Override
    public synchronized IDirElement getElement(EntityName elementName) throws StorageException {
        File elementFile = this.fileForName(elementName, true, this.m_mapper);
        if (!elementFile.exists() || elementFile.isDirectory()) {
            return null;
        }
        return this.m_fileManager.getElement(elementFile, elementName);
    }

    @Override
    public synchronized IDirElement[] getElements(EntityName elementName) throws StorageException {
        File elementFile = this.fileForName(elementName, true, this.m_mapper);
        if (!elementFile.exists() || elementFile.isDirectory()) {
            return new IDirElement[0];
        }
        return this.m_fileManager.getElements(elementFile);
    }

    @Override
    public IDirElement[] getAllElements(EntityName dirName) throws StorageException {
        File[] kids = this.listKids(dirName);
        ArrayList<IDirElement> elementObjects = new ArrayList<IDirElement>();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isFile()) continue;
            IDirElement[] elementsObj = this.m_fileManager.getElements(kids[i]);
            for (int j = 0; j < elementsObj.length; ++j) {
                elementObjects.add(elementsObj[j]);
            }
        }
        return elementObjects.toArray(new IDirElement[elementObjects.size()]);
    }

    @Override
    public IElementIdentity[] listElements(EntityName dirName) throws StorageException {
        File[] kids = this.listKids(dirName);
        ArrayList elementIds = new ArrayList();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isFile()) continue;
            this.addIds(kids, i, elementIds);
        }
        return elementIds.toArray(new IElementIdentity[elementIds.size()]);
    }

    @Override
    public IDirIdentity[] listDirectories(EntityName dirName) throws StorageException {
        File[] kids = this.listKids(dirName);
        ArrayList<IDirIdentity> dirIdObjects = new ArrayList<IDirIdentity>();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isDirectory()) continue;
            dirIdObjects.add(this.createDirID(dirName, kids[i].getName()));
        }
        IDirIdentity[] dirIds = new IDirIdentity[dirIdObjects.size()];
        for (int i = 0; i < dirIdObjects.size(); ++i) {
            dirIds[i] = (IDirIdentity)dirIdObjects.get(i);
        }
        return dirIds;
    }

    @Override
    public IIdentity[] listAll(EntityName dirName) throws StorageException {
        File[] kids = this.listKids(dirName);
        ArrayList<IDirIdentity> kidObjects = new ArrayList<IDirIdentity>();
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i].isDirectory()) {
                kidObjects.add(this.createDirID(dirName, kids[i].getName()));
                continue;
            }
            if (kids[i].isFile()) {
                this.addIds(kids, i, kidObjects);
                continue;
            }
            throw new StorageException("Unknown file type for '" + kids[i].getName() + "' in directory '" + dirName.getName() + "'.");
        }
        return kidObjects.toArray(new IIdentity[kidObjects.size()]);
    }

    private void addIds(File[] fileList, int i, ArrayList objects) throws StorageException {
        IElementIdentity[] ids = this.m_fileManager.getIds(fileList[i]);
        for (int j = 0; j < ids.length; ++j) {
            objects.add(ids[j]);
        }
    }

    @Override
    public synchronized IElementIdentity deleteElement(EntityName elementName) throws StorageException {
        return this.deleteElement(elementName, false);
    }

    @Override
    public synchronized IElementIdentity deleteElement(EntityName elementName, boolean force) throws StorageException {
        File elementFile = this.fileForName(elementName, true, this.m_mapper);
        try {
            return this.m_fileManager.deleteElement(elementFile, elementName);
        }
        catch (StorageException e) {
            if (force) {
                elementFile.delete();
                return null;
            }
            throw e;
        }
    }

    @Override
    public synchronized IElementIdentity[] deleteElements(EntityName[] elementNames) throws StorageException {
        if (elementNames.length == 0) {
            return new IElementIdentity[0];
        }
        HashMap groups = this.groupElementNames(elementNames);
        Iterator iterator = groups.keySet().iterator();
        ArrayList<IElementIdentity> allDeletedElements = new ArrayList<IElementIdentity>();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            ArrayList group = (ArrayList)groups.get(file);
            IElementIdentity[] deletedIDs = this.m_fileManager.deleteElements(file, group.toArray(new EntityName[group.size()]));
            for (int i = 0; i < deletedIDs.length; ++i) {
                allDeletedElements.add(deletedIDs[i]);
            }
        }
        IElementIdentity[] result = new IElementIdentity[allDeletedElements.size()];
        allDeletedElements.toArray(result);
        return result;
    }

    @Override
    public void createDirectory(EntityName dirName) throws StorageException {
        this.createDirectory(dirName, false);
    }

    private void createDirectory(EntityName dirName, boolean createParent) throws StorageException {
        FSStorage.createDirectory(this.m_dataDir, dirName, createParent, this.m_trManager);
    }

    @Override
    public boolean directoryExists(EntityName dirName) {
        return FSStorage.directoryExists(this.m_dataDir, dirName);
    }

    @Override
    public void deleteDirectory(EntityName dirName) throws StorageException {
        File dir = this.fileForName(dirName, true, null);
        if (!dir.exists()) {
            return;
        }
        this.m_trManager.deleteDirectory(dirName.getName());
        if (!dir.delete()) {
            File[] kids = this.listKids(dirName);
            if (kids.length > 0) {
                throw new StorageException("'" + dirName.getName() + "' is not empty - cannot be deleted.");
            }
            throw new StorageException("Cannot delete directory '" + dirName.getName() + "'.");
        }
    }

    @Override
    public synchronized void setElement(EntityName elementName, IDirElement element) throws StorageException {
        this.setElement(elementName, element, false);
    }

    @Override
    public synchronized void setElement(EntityName elementName, IDirElement element, boolean createPath) throws StorageException {
        File elementFile = null;
        try {
            elementFile = this.fileForName(elementName, true, this.m_mapper);
        }
        catch (StorageException pe) {
            if (!createPath || !(pe instanceof ParentDirDoesNotExistException)) {
                throw pe;
            }
            try {
                this.createDirectory(new EntityName(elementName.getParent()), true);
            }
            catch (ConfigException e) {
                throw new Error(e.toString(), e);
            }
            elementFile = this.fileForName(elementName, false, this.m_mapper);
        }
        this.m_fileManager.setElement(elementFile, element);
    }

    @Override
    public synchronized void setElements(IDirElement[] elements, boolean createPath) throws StorageException {
        if (elements.length == 0) {
            return;
        }
        EntityName checkName = this.getEntity(elements[0].getIdentity().getName());
        EntityName dirName = this.getEntity(checkName.getParent());
        if (!this.directoryExists(dirName)) {
            if (!createPath) {
                throw new StorageException(dirName + " doesn't exist.");
            }
            this.createDirectory(dirName, true);
        }
        HashMap groups = this.groupElements(checkName, elements);
        for (File file : groups.keySet()) {
            ArrayList group = (ArrayList)groups.get(file);
            this.m_fileManager.setElements(file, group.toArray(new IDirElement[group.size()]));
        }
    }

    @Override
    public void close() throws StorageException {
        if (this.m_trManager != null) {
            this.m_trManager.close();
        }
    }

    private File fileForName(EntityName entityName, boolean checkParent, Mapper mapper) throws StorageException {
        return FSStorage.fileForName(this.m_dataDir, entityName, checkParent, mapper);
    }

    private File[] listKids(EntityName dirName) throws StorageException {
        File dirFile = this.fileForName(dirName, false, null);
        if (!dirFile.exists()) {
            throw new StorageException("Directory '" + dirName.getName() + "' does not exist.");
        }
        if (!dirFile.isDirectory()) {
            throw new StorageException("'" + dirName.getName() + "' is not a directory.");
        }
        String[] kidNames = dirFile.list();
        File[] files = new File[kidNames.length];
        for (int i = 0; i < kidNames.length; ++i) {
            files[i] = new File(dirFile, kidNames[i]);
        }
        return files;
    }

    private IDirIdentity createDirID(EntityName parent, String name) throws StorageException {
        String parentName = parent.getName();
        String prefix = parentName.length() == 1 ? parentName : parentName + "/";
        return new DirIdentity(prefix + name);
    }

    @Override
    public void setBlob(EntityName blobName, byte[] blob) throws StorageException {
        File elementFile = this.retrieveFile(blobName);
        if (elementFile.exists()) {
            this.m_trManager.deleteElement(blobName);
        } else {
            this.m_trManager.newElement(blobName.getName());
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(elementFile);
            fileOut.write(blob);
            fileOut.close();
        }
        catch (IOException e) {
            throw new StorageException("Could not write binary attachment '" + blobName.getName() + "':" + e.toString(), e);
        }
    }

    @Override
    public void appendBlob(EntityName entityName, byte[] blobBytes, int from) throws StorageException {
        this.appendBlob(entityName, blobBytes, 0, blobBytes.length, from);
    }

    public void appendBlob(EntityName entityName, byte[] blobBytes, int blobOff, int blobLen, int from) throws StorageException {
        try {
            File blobFile = this.retrieveFile(entityName);
            if (from == 0 && blobFile.exists()) {
                this.deleteBlob(entityName);
            }
            if (from != 0 && blobFile.length() != (long)from) {
                throw new Error("Cannot append to a blob in the middle of a file");
            }
            FileOutputStream blobStream = new FileOutputStream(blobFile.getAbsolutePath(), true);
            blobStream.write(blobBytes, blobOff, blobLen);
            blobStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StorageException(e.toString(), e);
        }
    }

    private File retrieveFile(EntityName entityName) throws Error, StorageException {
        File blobFile = null;
        try {
            blobFile = this.fileForName(entityName, true, null);
        }
        catch (StorageException pe) {
            if (!(pe instanceof ParentDirDoesNotExistException)) {
                throw pe;
            }
            try {
                this.createDirectory(new EntityName(entityName.getParent()), true);
            }
            catch (ConfigException e) {
                throw new Error(e.toString(), e);
            }
            blobFile = this.fileForName(entityName, false, null);
        }
        return blobFile;
    }

    @Override
    public File blobToFile(EntityName blobName) {
        try {
            return this.fileForName(blobName, false, null);
        }
        catch (StorageException e) {
            throw new Error(e.toString(), e);
        }
    }

    @Override
    public long getBlobSize(EntityName blobName) throws StorageException {
        File blobFile = this.fileForName(blobName, false, null);
        if (blobFile != null) {
            return blobFile.length();
        }
        return 0L;
    }

    @Override
    public byte[] getBlob(EntityName blobName) throws StorageException {
        return this.getBlob(blobName, 0, COPY_CHUNK_SIZE);
    }

    @Override
    public byte[] getBlob(EntityName blobName, int offset, int length) throws StorageException {
        byte[] fileByteArray = null;
        try {
            File blobFile = this.blobToFile(blobName);
            if (!blobFile.exists()) {
                return null;
            }
            RandomAccessFile blobInputStream = new RandomAccessFile(blobFile, "r");
            fileByteArray = (long)(offset + length) >= blobFile.length() ? new byte[(int)(blobFile.length() - (long)offset)] : new byte[length];
            blobInputStream.seek(offset);
            if (fileByteArray.length != 0) {
                blobInputStream.read(fileByteArray, 0, fileByteArray.length);
            }
            blobInputStream.close();
            return fileByteArray;
        }
        catch (Exception e) {
            throw new StorageException(e.toString(), e);
        }
    }

    @Override
    public void deleteBlob(EntityName blobName) throws StorageException {
        try {
            File blobFile = this.fileForName(blobName, true, null);
            this.m_trManager.deleteElement(blobName);
            blobFile.delete();
        }
        catch (StorageException e) {
            throw new StorageException("Unable to delete blob '" + blobName.getName() + "', blob may be in use - " + e.toString(), e);
        }
    }

    @Override
    public void copyBlob(EntityName fromBlobName, EntityName toBlobName) throws StorageException {
        File blobFile = this.blobToFile(fromBlobName);
        if (blobFile.exists()) {
            try {
                byte[] blobPiece;
                FileInputStream inS = new FileInputStream(blobFile);
                int available = inS.available();
                inS.close();
                int src = 0;
                while (src + COPY_CHUNK_SIZE < available) {
                    blobPiece = this.getBlob(fromBlobName, src, COPY_CHUNK_SIZE);
                    this.appendBlob(toBlobName, blobPiece, src);
                    src += 1000000;
                }
                blobPiece = this.getBlob(fromBlobName, src, COPY_CHUNK_SIZE);
                this.appendBlob(toBlobName, blobPiece, src);
            }
            catch (IOException ioEx) {
                throw new StorageException(ioEx.toString(), ioEx);
            }
        }
    }

    @Override
    public void startTransaction() throws StorageException {
        this.m_trManager.startTransaction();
    }

    @Override
    public void commitTransaction() throws StorageException {
        this.m_trManager.commit();
    }

    @Override
    public void rollbackTransaction() throws StorageException {
        this.m_trManager.rollback();
    }

    @Override
    public void closeFiles() throws StorageException {
        this.m_trManager.closeFiles();
    }

    @Override
    public void openFiles() throws StorageException {
        this.m_trManager.openFiles();
    }

    static File fileForName(File dataDir, EntityName entityName, boolean checkParent, Mapper mapper) throws StorageException {
        if (checkParent) {
            File parentDir = null;
            try {
                parentDir = FSStorage.fileForName(dataDir, new EntityName(entityName.getParent()), false, null);
            }
            catch (ConfigException e) {
                throw new Error(e.toString(), e);
            }
            if (!parentDir.exists()) {
                throw new ParentDirDoesNotExistException("Directory '" + parentDir.getName() + "' does not exist.");
            }
        }
        if (mapper == null) {
            return new File(dataDir, entityName.getName().substring(1));
        }
        return mapper.getFile(dataDir, entityName);
    }

    static boolean directoryExists(File dataDir, EntityName dirName) {
        File dir = null;
        try {
            dir = FSStorage.fileForName(dataDir, dirName, false, null);
        }
        catch (StorageException e) {
            return false;
        }
        return dir.exists();
    }

    static void createDirectory(File dataDir, EntityName dirName, boolean createParent, FSTransactionManager trMngr) throws StorageException {
        File newDir = null;
        try {
            newDir = FSStorage.fileForName(dataDir, dirName, true, null);
        }
        catch (StorageException e) {
            if (!createParent) {
                throw e;
            }
            try {
                FSStorage.createDirectory(dataDir, new EntityName(dirName.getParent()), createParent, trMngr);
            }
            catch (ConfigException ce) {
                throw new Error(ce.toString(), ce);
            }
            newDir = FSStorage.fileForName(dataDir, dirName, false, null);
        }
        if (trMngr != null) {
            trMngr.newDirectory(dirName.getName());
        }
        if (!newDir.mkdir()) {
            throw new StorageException("Cannot create directory '" + dirName.getName() + "'.");
        }
    }

    private EntityName getEntity(String name) {
        EntityName entity = null;
        try {
            entity = new EntityName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity;
    }

    private HashMap groupElements(EntityName checkName, IDirElement[] elements) throws StorageException {
        HashMap groups = new HashMap();
        String parentName = checkName.getParent();
        for (int i = 0; i < elements.length; ++i) {
            ArrayList list = null;
            EntityName name = this.getEntity(elements[i].getIdentity().getName());
            if (!parentName.equals(name.getParent())) {
                throw new StorageException("All the elements must reside in the same directory.");
            }
            File file = this.m_mapper.getFile(this.m_dataDir, name);
            list = FSStorage.initList(file, groups);
            list.add(elements[i]);
        }
        return groups;
    }

    private HashMap groupElementNames(EntityName[] names) throws StorageException {
        if (names.length == 0) {
            return new HashMap();
        }
        EntityName checkName = names[0];
        HashMap groups = new HashMap();
        String parentName = checkName.getParent();
        for (int i = 0; i < names.length; ++i) {
            ArrayList list = null;
            if (!parentName.equals(names[i].getParent())) {
                throw new StorageException("All the elements must reside in the same directory.");
            }
            File file = this.m_mapper.getFile(this.m_dataDir, names[i]);
            list = FSStorage.initList(file, groups);
            list.add(names[i]);
        }
        return groups;
    }

    private static ArrayList initList(File file, HashMap groups) {
        ArrayList list = null;
        if (groups.containsKey(file)) {
            list = (ArrayList)groups.get(file);
        } else {
            list = new ArrayList();
            groups.put(file, list);
        }
        return list;
    }

    @Override
    public void closeTransactionManager() {
    }

    @Override
    public void backup(String backupDir) {
    }

    @Override
    public String[] collectionToStringArray(String collectionName) throws StorageException {
        throw new StorageException("Not Implemented");
    }

    @Override
    public void removeFromCollection(String collectionName, String item) throws StorageException {
        throw new StorageException("Not Implemented");
    }

    @Override
    public void removeFromCollection(String collectionName, String[] items) throws StorageException {
        throw new StorageException("Not Implemented");
    }

    @Override
    public void addToCollection(String collectionName, String item) throws StorageException {
        throw new StorageException("Not Implemented");
    }

    @Override
    public void createCollectionIfNotCreated(String collectionName) throws StorageException {
        throw new StorageException("Not Implemented");
    }

    private class Mapper {
        private int m_index = 64;

        Mapper() {
        }

        File getFile(File dataDir, EntityName entityName) {
            if (PackedDirUtil.underPackedDir(entityName)) {
                String path = entityName.getParentEntity().createChild(this.hashFunction(entityName.getBaseName())).getName();
                return new File(dataDir, path.substring(1));
            }
            return new File(dataDir, entityName.getName().substring(1));
        }

        private String hashFunction(String elementName) {
            int fileIndex = elementName.hashCode();
            if (fileIndex < 0) {
                fileIndex *= -1;
            }
            int a0 = fileIndex;
            int a1 = a0 / 256;
            int a2 = a1 / 256;
            int a3 = a2 / 256;
            fileIndex = (a0 & 0xFF ^ a1 & 0xFF ^ a2 & 0xFF ^ a3 & 0xFF) % this.m_index;
            return "_MF" + new Integer(fileIndex).toString();
        }
    }
}

