/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.BTreeValueNotFoundException;
import com.sonicsw.mtstorage.impl.BTreeAddValueNote;
import com.sonicsw.mtstorage.impl.BTreeBufferRange;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.BTreeSecondaryCreateNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INote;
import java.io.IOException;
import java.util.ArrayList;

final class BTreeKeyBuffer {
    static final int MAX_10BIT_VALUE = 1023;
    static final int MAX_VALUE_COUNT = 50;
    static final int NOT_FOUND = -1;
    static final int VALUE_LENGTH = 8;
    private static final int SINGLE_VAL_PREFIX_LENGTH = 2;
    private static final int MULTI_VAL_PREFIX_LENGTH = 4;
    private static final int MULTI_VAL_COUNT_OFFSET = 3;
    private static final int MULTI_VAL_FLAGS_OFFSET = 2;
    private static final int NUM_ENTRIES_LENGTH = 2;
    private static final int BUFFER_PREFIX_LENGTH = 2;
    static final int KEY_SMALLER = -2;
    static final int KEY_EQUAL_OR_SMALLER = -1;
    static final int KEY_GREATER = 2;
    static final int KEY_EQUAL_OR_GREATER = 1;
    static final int KEY_EQUAL = 0;
    private static final int NUM_ENTRIES_OFFSET = 0;
    private static final int ENTRIES_OFFSET = 2;
    private static final byte NULL_KEY = 4;
    private static final byte INFINITY_KEY = 16;
    private static final byte NULL_VALUE = 32;
    private static final byte SECONDARY_BTREE = 64;
    private byte[] m_buffer;
    private int[] m_entryOffsets;
    private int m_bufferStart;
    private int m_numEntries;
    private int m_bufferLength;
    private int m_used;
    private boolean m_singleVal;
    private BTreeSecondary m_secondary;
    private BTreeAddValueNote m_btreeAddValuetNote;
    private BTreeSecondaryCreateNote m_btreeSecondaryCreateNote;

    BTreeKeyBuffer(byte[] buffer, int start, int length, boolean singleVal, boolean createNew, BTreeSecondary secondary) {
        if (createNew) {
            BitUtil.putShort(buffer, start + 0, (short)0);
        }
        this.init(buffer, start, length, singleVal, secondary);
    }

    private void init(byte[] buffer, int start, int length, boolean singleVal, BTreeSecondary secondary) {
        this.m_buffer = buffer;
        this.m_bufferStart = start;
        this.m_bufferLength = length;
        this.m_singleVal = singleVal;
        this.m_secondary = secondary;
        this.m_numEntries = 0;
        this.m_used = 0;
        this.m_btreeAddValuetNote = new BTreeAddValueNote();
        this.m_btreeSecondaryCreateNote = new BTreeSecondaryCreateNote();
        this.initTransitState();
    }

    void split(BTreeKeyBuffer keyBuffer) {
        int newLowOfThisBuffer = this.m_numEntries / 2;
        int highOfNewBuffer = newLowOfThisBuffer - 1;
        int copyCount = this.m_entryOffsets[newLowOfThisBuffer] - this.m_bufferStart - 2;
        BitUtil.putShort(keyBuffer.m_buffer, keyBuffer.m_bufferStart + 0, (short)(highOfNewBuffer + 1));
        System.arraycopy(this.m_buffer, this.m_entryOffsets[0], keyBuffer.m_buffer, keyBuffer.m_bufferStart + 2, copyCount);
        keyBuffer.initTransitState();
        BitUtil.putShort(this.m_buffer, this.m_bufferStart + 0, (short)(this.m_numEntries - newLowOfThisBuffer));
        System.arraycopy(this.m_buffer, this.m_entryOffsets[newLowOfThisBuffer], this.m_buffer, this.m_bufferStart + 2, this.m_used - copyCount - 2);
        this.initTransitState();
    }

    int getNumEntries() {
        return this.m_numEntries;
    }

    byte[] getFirstValue(int entryPosition, byte[] valueBuffer) throws IOException {
        return this.getValue(entryPosition, valueBuffer);
    }

    private boolean isSecondaryBTreeEntry(int entryOffset) {
        return (this.m_buffer[entryOffset] & 0x40) != 0;
    }

    private boolean isSecondaryBTreeEntryByPosition(int entryPosition) {
        return (this.m_buffer[this.m_entryOffsets[entryPosition]] & 0x40) != 0;
    }

    void markSecondaryBTreeEntry(int entryPosition) {
        int n = this.m_entryOffsets[entryPosition];
        this.m_buffer[n] = (byte)(this.m_buffer[n] | 0x40);
    }

    byte[] getLastValue(int entryPosition, byte[] valueBuffer) throws IOException {
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            return this.m_secondary.last(this.getNodeDbk(entryPosition));
        }
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, true);
        if (numValues == 0) {
            throw new Error("Entry with no values");
        }
        return this.getValue(entryPosition, valueBuffer, numValues - 1);
    }

    byte[] getNextValue(int entryPosition, byte[] currentVal, byte[] valueBuffer) throws BTreeValueNotFoundException, IOException {
        if (this.m_singleVal) {
            throw new BTreeValueNotFoundException();
        }
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            return this.m_secondary.next(this.getNodeDbk(entryPosition), currentVal);
        }
        boolean hasNullValue = (this.m_buffer[entryOffset] & 0x20) != 0;
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, false);
        if (currentVal == null) {
            int valuePosition;
            int n = valuePosition = hasNullValue ? 1 : 0;
            if (numValues == 0) {
                throw new BTreeValueNotFoundException();
            }
            return this.getValue(entryPosition, valueBuffer, valuePosition);
        }
        int nextValueOffset = this.findNextValueOffset(entryOffset, currentVal, 0, currentVal.length);
        if (nextValueOffset == entryOffset + BitUtil.getShort10Bits(this.m_buffer, entryOffset)) {
            throw new BTreeValueNotFoundException();
        }
        System.arraycopy(this.m_buffer, nextValueOffset, valueBuffer, 0, 8);
        return valueBuffer;
    }

    byte[] getPrevValue(int entryPosition, byte[] currentVal, byte[] valueBuffer) throws BTreeValueNotFoundException, IOException {
        if (this.m_singleVal) {
            throw new BTreeValueNotFoundException();
        }
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            return this.m_secondary.prev(this.getNodeDbk(entryPosition), currentVal);
        }
        if (currentVal == null) {
            throw new BTreeValueNotFoundException();
        }
        boolean hasNullValue = (this.m_buffer[entryOffset] & 0x20) != 0;
        int prevValueOffset = this.findPrevValueOffset(entryOffset, currentVal, 0, currentVal.length);
        if (prevValueOffset == -1) {
            if (hasNullValue) {
                return null;
            }
            throw new BTreeValueNotFoundException();
        }
        System.arraycopy(this.m_buffer, prevValueOffset, valueBuffer, 0, 8);
        return valueBuffer;
    }

    static int getNumValues(byte[] buffer, boolean singleVal, int entryOffset, boolean withNull) {
        boolean hasNullValue;
        boolean bl = hasNullValue = (buffer[entryOffset] & 0x20) != 0;
        return singleVal ? 1 : buffer[entryOffset + 3] + (hasNullValue && withNull ? (byte)1 : 0);
    }

    BufferKey getFirstKey() {
        if (this.m_numEntries == 0) {
            return null;
        }
        BufferKey key = new BufferKey();
        this.getKey(0, key, false);
        return key;
    }

    BufferKey getLastKey() {
        if (this.m_numEntries == 0) {
            return null;
        }
        BufferKey key = new BufferKey();
        this.getKey(this.m_numEntries - 1, key, false);
        return key;
    }

    int find(byte[] key) {
        return this.find(BTreeKeyBuffer.keyToBufferKey(key));
    }

    int findGreater(byte[] key) {
        return this.findGreater(BTreeKeyBuffer.keyToBufferKey(key));
    }

    int findGreaterEqual(byte[] key) {
        return this.findGreaterEqual(BTreeKeyBuffer.keyToBufferKey(key));
    }

    int findSmaller(byte[] key) {
        return this.findSmaller(BTreeKeyBuffer.keyToBufferKey(key));
    }

    int findSmallerEqual(byte[] key) {
        return this.findSmallerEqual(BTreeKeyBuffer.keyToBufferKey(key));
    }

    int find(BufferKey key) {
        return this.search(key, 0);
    }

    int findGreater(BufferKey key) {
        return this.search(key, 2);
    }

    int findGreaterEqual(BufferKey key) {
        return this.search(key, 1);
    }

    int findSmaller(BufferKey key) {
        return this.search(key, -2);
    }

    int findSmallerEqual(BufferKey key) {
        return this.search(key, -1);
    }

    private static BufferKey keyToBufferKey(byte[] key) {
        if (key == null) {
            return new BufferKey(null, 0, 0, false, true);
        }
        return new BufferKey(key, 0, key.length, false, false);
    }

    private static int getValueOffset(byte[] buffer, boolean singleVal, int entryOffset, int valuePosition) {
        boolean hasNullValue;
        if (valuePosition > 0 && singleVal) {
            throw new Error("Single value buffer, cannot return offset for value position " + valuePosition);
        }
        boolean bl = hasNullValue = (buffer[entryOffset] & 0x20) != 0;
        if (valuePosition == 0 && hasNullValue) {
            return -1;
        }
        if (singleVal) {
            return entryOffset + BitUtil.getShort10Bits(buffer, entryOffset) - 8;
        }
        int numValues = BTreeKeyBuffer.getNumValues(buffer, singleVal, entryOffset, true);
        if (valuePosition >= numValues) {
            throw new Error("Not enough values in entry, cannot get value " + valuePosition);
        }
        int offsetFromEnd = (numValues - valuePosition) * 8;
        return entryOffset + BitUtil.getShort10Bits(buffer, entryOffset) - offsetFromEnd;
    }

    long getNodeDbk(int entryPosition) {
        int offset = this.m_entryOffsets[entryPosition];
        int valueOffset = BTreeKeyBuffer.getValueOffset(this.m_buffer, this.m_singleVal, offset, 0);
        return BitUtil.getLong(this.m_buffer, valueOffset);
    }

    void setSecondaryTreeDBK(int entryPosition, long treeDBK) {
        int offset = this.m_entryOffsets[entryPosition];
        int valueOffset = BTreeKeyBuffer.getValueOffset(this.m_buffer, this.m_singleVal, offset, 0);
        BitUtil.putLong(this.m_buffer, valueOffset, treeDBK);
    }

    byte[] getSecondaryTreeDBK(int entryPosition) {
        if (this.isSecondaryBTreeEntryByPosition(entryPosition)) {
            return this.getValue(entryPosition, new byte[8], 0);
        }
        return null;
    }

    byte[] getValue(int entryPosition, byte[] valueBuffer) throws IOException {
        if (this.isSecondaryBTreeEntryByPosition(entryPosition)) {
            return this.m_secondary.first(this.getNodeDbk(entryPosition));
        }
        return this.getValue(entryPosition, valueBuffer, 0);
    }

    byte[] getValue(int entryPosition, byte[] valueBuffer, int valuePosition) {
        int offset = this.m_entryOffsets[entryPosition];
        int valueOffset = BTreeKeyBuffer.getValueOffset(this.m_buffer, this.m_singleVal, offset, valuePosition);
        if (valueOffset == -1) {
            return null;
        }
        System.arraycopy(this.m_buffer, valueOffset, valueBuffer, 0, 8);
        return valueBuffer;
    }

    void delete(boolean onlyInThisNodeEntry, int entryPosition) {
        if (!onlyInThisNodeEntry && this.isSecondaryBTreeEntryByPosition(entryPosition)) {
            this.m_secondary.delete(this.getNodeDbk(entryPosition));
        }
        short entryLength = BitUtil.getShort10Bits(this.m_buffer, this.m_entryOffsets[entryPosition]);
        if (entryPosition + 1 < this.m_numEntries) {
            this.shiftEntries(entryPosition + 1, -entryLength);
        }
        --this.m_numEntries;
        BitUtil.putShort(this.m_buffer, this.m_bufferStart + 0, (short)this.m_numEntries);
        this.m_used -= entryLength;
    }

    boolean insert(int entryPosition, BufferKey key, byte[] value) {
        return this.insert(false, entryPosition, key.m_buffer, key.m_isNull, key.m_isInfinite, key.m_offset, key.m_length, value, 0, value != null ? value.length : 0);
    }

    boolean canInsert(int entryPosition, BufferKey key, byte[] value, int reservedSpace) {
        return this.insert(true, entryPosition, key.m_buffer, key.m_isNull, key.m_isInfinite, key.m_offset, key.m_length + reservedSpace, value, 0, value != null ? value.length : 0);
    }

    byte[] replace(int entryPosition, byte[] newValue, int newValueOffset, int newValueLength) {
        byte[] oldValue;
        if (!this.m_singleVal) {
            throw new Error("Replace is not supported in multi value nodes");
        }
        if (newValue != null && newValueLength != 8) {
            throw new Error("Only 8 byte references and dbkeys are supported");
        }
        int entryOffset = this.m_entryOffsets[entryPosition];
        int keyLength = BitUtil.getShort10Bits(this.m_buffer, entryOffset) - 8 - 2;
        int valueOffset = entryOffset + 2 + keyLength;
        byte[] byArray = oldValue = (this.m_buffer[entryOffset] & 0x20) != 0 ? null : new byte[8];
        if (oldValue != null) {
            System.arraycopy(this.m_buffer, valueOffset, oldValue, 0, 8);
        }
        if (newValue == null) {
            int n = entryOffset;
            this.m_buffer[n] = (byte)(this.m_buffer[n] | 0x20);
        } else {
            int n = entryOffset;
            this.m_buffer[n] = (byte)(this.m_buffer[n] & 0xFFFFFFDF);
        }
        if (newValue != null) {
            System.arraycopy(newValue, newValueOffset, this.m_buffer, valueOffset, 8);
        }
        return oldValue;
    }

    boolean containsValue(int entryPosition, byte[] value) throws IOException {
        if (this.isSecondaryBTreeEntryByPosition(entryPosition)) {
            return this.m_secondary.contains(this.getNodeDbk(entryPosition), value);
        }
        return this.containsValue(entryPosition, value, 0, value != null ? value.length : 0);
    }

    private boolean containsValue(int entryPosition, byte[] value, int valueOffset, int valueLength) throws IOException {
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            byte[] valBuffer = null;
            if (value != null) {
                valBuffer = new byte[valueLength];
                System.arraycopy(value, valueOffset, valBuffer, 0, valueLength);
            }
            return this.m_secondary.contains(this.getNodeDbk(entryPosition), valBuffer);
        }
        if (value == null) {
            return (this.m_buffer[entryOffset] & 0x20) != 0;
        }
        return this.findValue(entryOffset, value, valueOffset, valueLength) != -1;
    }

    private int findValue(int entryOffset, byte[] value, int valueOffset, int valueLength) {
        boolean hasNullValue = (this.m_buffer[entryOffset] & 0x20) != 0;
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, false);
        int currentValueOffset = entryOffset + BitUtil.getShort10Bits(this.m_buffer, entryOffset) - 8;
        int i = 0;
        while (i < numValues) {
            if (this.valuesEquals(value, valueOffset, valueLength, this.m_buffer, currentValueOffset, 8)) {
                return numValues - i - 1 + (hasNullValue ? 1 : 0);
            }
            ++i;
            currentValueOffset -= 8;
        }
        return -1;
    }

    private int findNextValueOffset(int entryOffset, byte[] value, int valueOffset, int valueLength) {
        if (this.m_singleVal) {
            throw new Error("findNextValueOffset should not be called when m_singleVal is true");
        }
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, false);
        int currentValueOffset = entryOffset + BitUtil.getShort10Bits(this.m_buffer, entryOffset) - 8 * numValues;
        int i = 0;
        while (i < numValues) {
            if (BTreeKeyBuffer.compareKeys(this.m_buffer, currentValueOffset, 8, value, valueOffset, valueLength) == 2) {
                return currentValueOffset;
            }
            ++i;
            currentValueOffset += 8;
        }
        return currentValueOffset;
    }

    private int findPrevValueOffset(int entryOffset, byte[] value, int valueOffset, int valueLength) {
        int firstValueOffset;
        if (this.m_singleVal) {
            throw new Error("findPrevValueOffset should not be called when m_singleVal is true");
        }
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, false);
        int currentValueOffset = firstValueOffset = entryOffset + BitUtil.getShort10Bits(this.m_buffer, entryOffset) - 8 * numValues;
        int i = 0;
        while (i < numValues) {
            int comparision = BTreeKeyBuffer.compareKeys(this.m_buffer, currentValueOffset, 8, value, valueOffset, valueLength);
            if (comparision == 0 || comparision == 2) {
                if (i == 0) {
                    return -1;
                }
                return currentValueOffset - 8;
            }
            ++i;
            currentValueOffset += 8;
        }
        if (numValues > 0) {
            return firstValueOffset;
        }
        return -1;
    }

    byte[] deleteAny(int entryPosition, Boolean[] noteType) throws IOException {
        byte[] val = this.getValue(entryPosition, new byte[8]);
        noteType[0] = this.delete(entryPosition, val);
        return val;
    }

    Boolean delete(int entryPosition, byte[] value) throws IOException {
        if (this.m_singleVal) {
            this.delete(false, entryPosition);
            return Boolean.FALSE;
        }
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            long secondaryDBK = this.getNodeDbk(entryPosition);
            if (this.m_secondary.containsSingleValue(secondaryDBK)) {
                this.delete(false, entryPosition);
                return Boolean.TRUE;
            }
            this.m_secondary.remove(secondaryDBK, value);
            return null;
        }
        short oldEntryLength = BitUtil.getShort10Bits(this.m_buffer, entryOffset);
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, true);
        if (numValues == 1) {
            this.delete(false, entryPosition);
            return Boolean.FALSE;
        }
        if (value == null) {
            int n = entryOffset;
            this.m_buffer[n] = (byte)(this.m_buffer[n] & 0xFFFFFFDF);
            return Boolean.FALSE;
        }
        int valuePosition = this.findValue(entryOffset, value, 0, value.length);
        int valueOffset = BTreeKeyBuffer.getValueOffset(this.m_buffer, this.m_singleVal, entryOffset, valuePosition);
        int shiftPoint = valueOffset + 8;
        int copyCount = this.m_bufferStart + this.m_used - shiftPoint;
        if (copyCount > 0) {
            System.arraycopy(this.m_buffer, shiftPoint, this.m_buffer, shiftPoint - 8, copyCount);
            if (entryPosition + 1 < this.m_numEntries) {
                this.shiftEntryOffsets(entryPosition + 1, -8, false);
            }
        }
        this.m_buffer[entryOffset + 3] = (byte)(this.m_buffer[entryOffset + 3] - 1);
        BitUtil.putShort10Bits(this.m_buffer, entryOffset, (short)(oldEntryLength - 8));
        this.m_used -= 8;
        return Boolean.FALSE;
    }

    boolean canAddValue(int entryPosition, byte[] value, ArrayList alreadyExists) throws IOException {
        int additionalLength;
        int valueLength;
        int valueOffset = 0;
        int n = valueLength = value != null ? value.length : 0;
        if (this.m_singleVal) {
            throw new Error("canAddValue is not supported in single value nodes");
        }
        if (value != null && valueLength != 8) {
            throw new Error("Only 8 byte references and dbkeys are supported");
        }
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            if (this.containsValue(entryPosition, value) && alreadyExists != null) {
                alreadyExists.add("exists");
            }
            return true;
        }
        if (this.containsValue(entryPosition, value, valueOffset, valueLength)) {
            if (alreadyExists != null) {
                alreadyExists.add("exists");
            }
            return true;
        }
        if (this.m_buffer[entryOffset + 3] == 50) {
            return true;
        }
        short oldEntryLength = BitUtil.getShort10Bits(this.m_buffer, entryOffset);
        int n2 = additionalLength = value != null ? 8 : 0;
        return this.m_bufferLength - this.m_used >= additionalLength;
    }

    INote addValue(long dbk, BufferKey key, int entryPosition, byte[] value, boolean doLog) throws IOException {
        int additionalLength;
        int valueLength;
        int valueOffset = 0;
        int n = valueLength = value != null ? value.length : 0;
        if (this.m_singleVal) {
            throw new Error("addValue is not supported in single value nodes");
        }
        if (value != null && valueLength != 8) {
            throw new Error("Only 8 byte references and dbkeys are supported");
        }
        int entryOffset = this.m_entryOffsets[entryPosition];
        if (this.isSecondaryBTreeEntry(entryOffset)) {
            this.m_secondary.add(this.getNodeDbk(entryPosition), value);
            return null;
        }
        short oldEntryLength = BitUtil.getShort10Bits(this.m_buffer, entryOffset);
        if (this.m_buffer[entryOffset + 3] == 50) {
            this.m_btreeSecondaryCreateNote.initNote(dbk, this.m_buffer, entryOffset, oldEntryLength);
            this.convertEntryToSecondary(entryPosition, entryOffset, value);
            int newEntryOffset = this.m_entryOffsets[entryPosition];
            short newEntryLength = BitUtil.getShort10Bits(this.m_buffer, newEntryOffset);
            this.m_btreeSecondaryCreateNote.setNewEntry(this.m_buffer, newEntryOffset, newEntryLength);
            return this.m_btreeSecondaryCreateNote;
        }
        int n2 = additionalLength = value != null ? 8 : 0;
        if (this.m_bufferLength - this.m_used < additionalLength) {
            throw new Error("No room to add a value.");
        }
        int newValueOffset = 0;
        if (additionalLength > 0) {
            newValueOffset = this.findNextValueOffset(entryOffset, value, valueOffset, valueLength);
            int copyCount = this.m_bufferStart + this.m_used - newValueOffset;
            if (copyCount > 0) {
                System.arraycopy(this.m_buffer, newValueOffset, this.m_buffer, newValueOffset + 8, copyCount);
            }
            if (entryPosition + 1 < this.m_numEntries) {
                this.shiftEntryOffsets(entryPosition + 1, 8, false);
            }
        }
        BitUtil.putShort10Bits(this.m_buffer, entryOffset, (short)(oldEntryLength + additionalLength));
        if (value == null) {
            int n3 = entryOffset;
            this.m_buffer[n3] = (byte)(this.m_buffer[n3] | 0x20);
        } else {
            System.arraycopy(value, valueOffset, this.m_buffer, newValueOffset, valueLength);
            this.m_buffer[entryOffset + 3] = (byte)(this.m_buffer[entryOffset + 3] + 1);
        }
        this.m_used += additionalLength;
        if (doLog) {
            this.m_btreeAddValuetNote.initNote(dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, value);
            return this.m_btreeAddValuetNote;
        }
        return null;
    }

    private boolean insert(boolean checkOnly, int entryPosition, byte[] key, boolean keyNull, boolean keyInifinite, int keyOffset, int keyLength, byte[] value, int valueOffset, int valueLength) {
        int keyCopyCount;
        if (value != null && valueLength != 8) {
            throw new Error("Only 8 byte references and dbkeys are supported");
        }
        int n = keyCopyCount = keyNull || keyInifinite ? 0 : keyLength;
        if (!checkOnly && keyCopyCount > 256) {
            throw new Error("The max encoded key length is 256, provided encoded key length is " + keyLength + " (key = " + new String(key, keyOffset, keyLength) + ")");
        }
        int entryLength = (this.m_singleVal ? 2 : 4) + keyCopyCount;
        if (this.m_singleVal || value != null) {
            entryLength += 8;
        }
        if (this.m_bufferLength - this.m_used < entryLength) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        int entryOffset = 0;
        this.ensureCapacity(this.m_numEntries + 1);
        if (entryPosition < this.m_numEntries) {
            entryOffset = this.m_entryOffsets[entryPosition];
            this.shiftEntries(entryPosition, entryLength);
        } else if (entryPosition == this.m_numEntries) {
            entryOffset = this.m_bufferStart + this.m_used;
        } else {
            throw new Error("wrong position " + entryPosition + " for insert");
        }
        this.m_buffer[entryOffset] = 0;
        BitUtil.putShort10Bits(this.m_buffer, entryOffset, (short)entryLength);
        if (keyNull) {
            int n2 = entryOffset;
            this.m_buffer[n2] = (byte)(this.m_buffer[n2] | 4);
        }
        if (keyInifinite) {
            if (keyNull) {
                throw new Error("A key cannot be infinite and null");
            }
            int n3 = entryOffset;
            this.m_buffer[n3] = (byte)(this.m_buffer[n3] | 0x10);
        }
        if (value == null) {
            int n4 = entryOffset;
            this.m_buffer[n4] = (byte)(this.m_buffer[n4] | 0x20);
        }
        if (!this.m_singleVal) {
            this.m_buffer[entryOffset + 2] = 0;
            this.m_buffer[entryOffset + 3] = value != null ? (byte)1 : 0;
        }
        int currentOffset = entryOffset + (this.m_singleVal ? 2 : 4);
        if (keyCopyCount > 0) {
            System.arraycopy(key, keyOffset, this.m_buffer, currentOffset, keyCopyCount);
        }
        currentOffset += keyCopyCount;
        if (value != null) {
            System.arraycopy(value, valueOffset, this.m_buffer, currentOffset, valueLength);
        }
        ++this.m_numEntries;
        BitUtil.putShort(this.m_buffer, this.m_bufferStart + 0, (short)this.m_numEntries);
        this.m_used += entryLength;
        this.m_entryOffsets[entryPosition] = entryOffset;
        return true;
    }

    public String toString() {
        String st = "entries: ";
        for (int i = 0; i < this.m_numEntries; ++i) {
            st = st + this.m_entryOffsets[i] + " ";
        }
        return "num entries: " + new Integer(this.m_numEntries).toString() + " used: " + new Integer(this.m_used).toString() + " " + st;
    }

    private void convertEntryToSecondary(int entryPosition, int entryOffset, byte[] newValue) {
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, true);
        for (int i = 0; i < numValues; ++i) {
            values.add(this.getValue(entryPosition, new byte[8], i));
        }
        values.add(newValue);
        this.m_secondary.create(values, entryPosition);
        BufferKey key = new BufferKey();
        this.getKey(entryPosition, key, true);
        this.delete(true, entryPosition);
        this.insert(entryPosition, key, new byte[8]);
        int n = this.m_entryOffsets[entryPosition];
        this.m_buffer[n] = (byte)(this.m_buffer[n] | 0x40);
    }

    private void initTransitState() {
        this.m_entryOffsets = new int[300];
        this.m_numEntries = BitUtil.getShort(this.m_buffer, this.m_bufferStart + 0);
        this.ensureCapacity(this.m_numEntries);
        int currentPointer = this.m_bufferStart + 2;
        for (int i = 0; i < this.m_numEntries; ++i) {
            this.m_entryOffsets[i] = currentPointer;
            currentPointer += BitUtil.getShort10Bits(this.m_buffer, currentPointer);
        }
        if (this.m_numEntries > 0) {
            int lastEntryOffset = this.m_entryOffsets[this.m_numEntries - 1];
            this.m_used = lastEntryOffset + BitUtil.getShort10Bits(this.m_buffer, lastEntryOffset) - this.m_bufferStart;
        } else {
            this.m_used = 2;
        }
    }

    void ensureCapacity(int minCapacity) {
        if (this.m_entryOffsets.length >= minCapacity) {
            return;
        }
        int newCapacity = this.m_entryOffsets.length + 200;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        int[] temp = this.m_entryOffsets;
        this.m_entryOffsets = new int[newCapacity];
        for (int i = 0; i < temp.length; ++i) {
            this.m_entryOffsets[i] = temp[i];
        }
    }

    static boolean keysEqual(byte[] key1, byte[] key2) {
        if (key1 == null || key2 == null) {
            return key1 == null && key2 == null;
        }
        return BTreeKeyBuffer.compareKeys(key1, 0, key1.length, key2, 0, key2.length) == 0;
    }

    static int compareKeys(BufferKey key1, BufferKey key2) {
        if (key1.m_isNull || key2.m_isNull) {
            if (key1.m_isNull && key2.m_isNull) {
                return 0;
            }
            return key1.m_isNull ? -2 : 2;
        }
        if (key1.m_isInfinite || key2.m_isInfinite) {
            if (key1.m_isInfinite && key2.m_isInfinite) {
                return 0;
            }
            return key1.m_isInfinite ? 2 : -2;
        }
        return BTreeKeyBuffer.compareKeys(key1.m_buffer, key1.m_offset, key1.m_length, key2.m_buffer, key2.m_offset, key2.m_length);
    }

    static int compareKeys(byte[] key1, byte[] key2) {
        if (key1 == null || key2 == null) {
            if (key1 == null && key2 == null) {
                return 0;
            }
            return key1 == null ? -2 : 2;
        }
        return BTreeKeyBuffer.compareKeys(key1, 0, key1.length, key2, 0, key2.length);
    }

    private static int compareKeys(byte[] key1, int offset1, int length1, byte[] key2, int offset2, int length2) {
        int max = length1 > length2 ? length1 : length2;
        for (int i = 0; i < max; ++i) {
            byte b2;
            byte b1 = i < length1 ? key1[offset1 + i] : (byte)0;
            byte by = b2 = i < length2 ? key2[offset2 + i] : (byte)0;
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF) < 0 ? -2 : 2;
        }
        return 0;
    }

    private boolean valuesEquals(byte[] value1, int valueOffset1, int valueLength1, byte[] value2, int valueOffset2, int valueLength2) {
        if (valueLength1 != valueLength2) {
            return false;
        }
        for (int i = 0; i < valueLength1; ++i) {
            if (value1[valueOffset1 + i] == value2[valueOffset2 + i]) continue;
            return false;
        }
        return true;
    }

    BufferKey getKey(int entryPosition) {
        BufferKey key = new BufferKey();
        this.getKey(entryPosition, key, true);
        return key;
    }

    private void getKey(int entryPosition, BufferKey key, boolean copyBuffer) {
        int entryOffset = this.m_entryOffsets[entryPosition];
        boolean bl = key.m_isNull = (this.m_buffer[entryOffset] & 4) != 0;
        if (key.m_isNull) {
            return;
        }
        boolean bl2 = key.m_isInfinite = (this.m_buffer[entryOffset] & 0x10) != 0;
        if (key.m_isInfinite) {
            return;
        }
        int prefixLength = this.m_singleVal ? 2 : 4;
        int keyOffset = entryOffset + prefixLength;
        int numValues = BTreeKeyBuffer.getNumValues(this.m_buffer, this.m_singleVal, entryOffset, false);
        key.m_length = BitUtil.getShort10Bits(this.m_buffer, entryOffset) - numValues * 8 - prefixLength;
        if (copyBuffer) {
            byte[] buffer = new byte[key.m_length];
            System.arraycopy(this.m_buffer, keyOffset, buffer, 0, key.m_length);
            key.m_offset = 0;
            key.m_buffer = buffer;
        } else {
            key.m_buffer = this.m_buffer;
            key.m_offset = keyOffset;
        }
    }

    static BufferKey extractKeyFromMultiValEntry(byte[] buffer, int entryOffset) {
        BufferKey key = new BufferKey();
        key.m_isInfinite = false;
        boolean bl = key.m_isNull = (buffer[entryOffset] & 4) != 0;
        if (key.m_isNull) {
            return key;
        }
        key.m_length = BitUtil.getShort10Bits(buffer, entryOffset) - 8 * buffer[entryOffset + 3] - 4;
        byte[] newBuf = new byte[key.m_length];
        System.arraycopy(buffer, entryOffset + 4, newBuf, 0, key.m_length);
        key.m_offset = 0;
        key.m_buffer = newBuf;
        return key;
    }

    static byte[] extractPointer(byte[] buffer, int entryOffset) {
        short entryLength = BitUtil.getShort10Bits(buffer, entryOffset);
        int pointerOffset = entryOffset + entryLength - 8;
        byte[] pointer = new byte[8];
        System.arraycopy(buffer, pointerOffset, pointer, 0, 8);
        return pointer;
    }

    static byte[] extractValue(byte[] buffer, int entryOffset, int valuePosition) {
        int valueOffset = BTreeKeyBuffer.getValueOffset(buffer, false, entryOffset, valuePosition);
        if (valueOffset == -1) {
            return null;
        }
        byte[] valueBuffer = new byte[8];
        System.arraycopy(buffer, valueOffset, valueBuffer, 0, 8);
        return valueBuffer;
    }

    private int search(BufferKey key, int op) {
        if (this.m_numEntries == 0) {
            return -1;
        }
        return this.search(key, 0, this.m_numEntries - 1, op, new BufferKey(), new BufferKey());
    }

    private int searchSeriallyGE(BufferKey key, int low, int high, int op, BufferKey scratch) {
        for (int i = low; i <= high; ++i) {
            this.getKey(i, scratch, false);
            int compareResult = BTreeKeyBuffer.compareKeys(scratch, key);
            if (compareResult == 0 && (op == 1 || op == 0)) {
                return i;
            }
            if (compareResult != 2) continue;
            if (op == 2 || op == 1) {
                return i;
            }
            if (op != 0) continue;
            return -1;
        }
        return -1;
    }

    private int searchSeriallySE(BufferKey key, int low, int high, int op, BufferKey scratch) {
        for (int i = high; i >= low; --i) {
            this.getKey(i, scratch, false);
            int compareResult = BTreeKeyBuffer.compareKeys(scratch, key);
            if (compareResult == 0 && (op == -1 || op == 0)) {
                return i;
            }
            if (compareResult != -2) continue;
            if (op == -2 || op == -1) {
                return i;
            }
            if (op != 0) continue;
            return -1;
        }
        return -1;
    }

    private int search(BufferKey key, int low, int high, int op, BufferKey scratch1, BufferKey scratch2) {
        if (high - low < 10) {
            if (op >= 0) {
                return this.searchSeriallyGE(key, low, high, op, scratch1);
            }
            return this.searchSeriallySE(key, low, high, op, scratch1);
        }
        int low1 = low;
        int high1 = low1 + (high - low) / 2;
        int low2 = high1 + 1;
        int high2 = high;
        switch (op) {
            case 0: {
                this.getKey(low2, scratch2, false);
                int comparison = BTreeKeyBuffer.compareKeys(scratch2, key);
                if (comparison == 0) {
                    return low2;
                }
                if (comparison == 2) {
                    return this.search(key, low1, high1, op, scratch1, scratch2);
                }
                return this.search(key, low2, high2, op, scratch1, scratch2);
            }
            case 2: {
                this.getKey(high1, scratch1, false);
                int comparison = BTreeKeyBuffer.compareKeys(scratch1, key);
                if (comparison == 0 || comparison == -2) {
                    return this.search(key, low2, high2, op, scratch1, scratch2);
                }
                return this.search(key, low1, high1, op, scratch1, scratch2);
            }
            case 1: {
                this.getKey(high1, scratch1, false);
                int comparison = BTreeKeyBuffer.compareKeys(scratch1, key);
                if (comparison == 0) {
                    return high1;
                }
                if (comparison == -2) {
                    return this.search(key, low2, high2, op, scratch1, scratch2);
                }
                return this.search(key, low1, high1, op, scratch1, scratch2);
            }
            case -2: {
                this.getKey(low2, scratch2, false);
                int comparison = BTreeKeyBuffer.compareKeys(scratch2, key);
                if (comparison == 0 || comparison == 2) {
                    return this.search(key, low1, high1, op, scratch1, scratch2);
                }
                return this.search(key, low2, high2, op, scratch1, scratch2);
            }
            case -1: {
                this.getKey(low2, scratch2, false);
                int comparison = BTreeKeyBuffer.compareKeys(scratch2, key);
                if (comparison == 0) {
                    return low2;
                }
                if (comparison == 2) {
                    return this.search(key, low1, high1, op, scratch1, scratch2);
                }
                return this.search(key, low2, high2, op, scratch1, scratch2);
            }
        }
        throw new Error("Unknown op " + op);
    }

    private void shiftEntryOffsets(int entryPosition, int length, boolean shiftData) {
        if (shiftData) {
            int shiftPoint = this.m_entryOffsets[entryPosition];
            System.arraycopy(this.m_buffer, shiftPoint, this.m_buffer, shiftPoint + length, this.m_bufferStart + this.m_used - shiftPoint);
        }
        int i = entryPosition;
        while (i < this.m_numEntries) {
            int n = i++;
            this.m_entryOffsets[n] = this.m_entryOffsets[n] + length;
        }
    }

    private void shiftEntries(int entryPosition, int entryLength) {
        int shiftPoint = this.m_entryOffsets[entryPosition];
        System.arraycopy(this.m_buffer, shiftPoint, this.m_buffer, shiftPoint + entryLength, this.m_bufferStart + this.m_used - shiftPoint);
        if (entryLength > 0) {
            for (int i = this.m_numEntries - 1; i >= entryPosition; --i) {
                this.m_entryOffsets[i + 1] = this.m_entryOffsets[i] + entryLength;
            }
        } else {
            for (int i = entryPosition; i < this.m_numEntries; ++i) {
                this.m_entryOffsets[i - 1] = this.m_entryOffsets[i] + entryLength;
            }
        }
    }

    BufferKey getKeyDEBUG(int position) {
        return this.getKey(position);
    }

    byte[] getValueDEBUG(int position) throws IOException {
        byte[] val = new byte[8];
        return this.getValue(position, val);
    }

    static void keyOrderSanityDEBUG(BufferKey key1, BufferKey key2) {
        if (BTreeKeyBuffer.compareKeys(key1, key2) != -2) {
            throw new Error("key in smaller position is not smaller");
        }
    }

    static class BufferKey
    extends BTreeBufferRange {
        boolean m_isInfinite;
        boolean m_isNull;

        BufferKey() {
        }

        BufferKey(byte[] buffer, int offset, int length, boolean isInfinite, boolean isNull) {
            super(buffer, offset, length);
            this.m_isInfinite = isInfinite;
            this.m_isNull = isNull;
        }

        @Override
        public String toString() {
            return super.toString() + " isNull " + this.m_isNull + " isInfinite  " + this.m_isInfinite;
        }
    }
}

