/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.BTreeValueNotFoundException;
import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeAbstractNode;
import com.sonicsw.mtstorage.impl.BTreeCreateLeafNote;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeKeyValueAbstractNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveSecondaryPointerNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveValueNote;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.BTreeSetSecondaryDbkNote;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;
import java.util.ArrayList;

final class BTreeLeafNode
extends BTreeAbstractNode {
    private static final int PREVIOUS_LEAF_OFFSET = 1;
    private static final int NEXT_LEAF_OFFSET = 9;
    private static final int KEY_BUFFER_OFFSET = 17;
    private BTreeRemoveValueNote m_btreeRemoveValuetNote = new BTreeRemoveValueNote();
    private BTreeSetSecondaryDbkNote m_btreeSetSecondaryDbkNote = new BTreeSetSecondaryDbkNote();
    private BTreeRemoveSecondaryPointerNote m_btreeRemoveSecondaryPointerNote = new BTreeRemoveSecondaryPointerNote();

    BTreeLeafNode(Logger logger, BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, boolean createNew, boolean uniqueIndex, BTreeSecondary secondary, boolean doLog) throws IOException {
        super(logger, allocatedBuffer, uniqueIndex, allocatedBuffer.m_offset + 17, allocatedBuffer.m_length - 17, false, createNew, secondary);
        if (createNew && doLog) {
            BTreeCreateLeafNote note = new BTreeCreateLeafNote();
            note.initNote(allocatedBuffer.m_dbk, uniqueIndex);
            long noteID = logger.writeNote(note);
            allocatedBuffer.m_page.setNoteID(noteID);
        }
    }

    void replacePointer(byte[] entry, int offset) throws IOException {
        BTreeKeyBuffer.BufferKey key = BTreeKeyBuffer.extractKeyFromMultiValEntry(entry, offset);
        byte[] value = BTreeKeyBuffer.extractPointer(entry, offset);
        this.removeInThisNode(key);
        this.insert(key, value, false);
        this.markSecondaryBTreeEntry(key);
    }

    void markSecondaryBTreeEntry(BTreeKeyBuffer.BufferKey key) {
        this.m_keyBuffer.markSecondaryBTreeEntry(this.m_keyBuffer.find(key));
    }

    void replaceMultiValues(byte[] entry, int offset) throws IOException {
        BTreeKeyBuffer.BufferKey key = BTreeKeyBuffer.extractKeyFromMultiValEntry(entry, offset);
        this.removeInThisNode(key);
        byte[] value = BTreeKeyBuffer.extractValue(entry, offset, 0);
        this.insert(key, value, false);
        int numValues = BTreeKeyBuffer.getNumValues(entry, false, offset, true);
        for (int i = 1; i < numValues; ++i) {
            this.addValue(key, BTreeKeyBuffer.extractValue(entry, offset, i), false);
        }
    }

    void removeInThisNode(BTreeKeyBuffer.BufferKey key, byte[] value) throws IOException {
        int position = this.m_keyBuffer.find(key);
        this.m_keyBuffer.delete(position, value);
    }

    byte[] remove(BTreeKeyBuffer.BufferKey key, int position) throws IOException {
        BTreeKeyValueAbstractNote note;
        byte[] secondaryPointer = this.m_keyBuffer.getSecondaryTreeDBK(position);
        Boolean[] noteType = new Boolean[1];
        byte[] oldValue = this.m_keyBuffer.deleteAny(position, noteType);
        if (noteType[0] == null) {
            note = null;
        } else if (noteType[0].booleanValue()) {
            this.m_btreeRemoveSecondaryPointerNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, secondaryPointer);
            note = this.m_btreeRemoveSecondaryPointerNote;
        } else {
            this.m_btreeRemoveValuetNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, oldValue);
            note = this.m_btreeRemoveValuetNote;
        }
        if (note != null) {
            long noteID = this.m_logger.writeNote(note);
            this.m_page.setNoteID(noteID);
        }
        return oldValue;
    }

    boolean remove(BTreeKeyBuffer.BufferKey key, int position, byte[] value) throws IOException {
        BTreeKeyValueAbstractNote note;
        if (!this.m_keyBuffer.containsValue(position, value)) {
            return false;
        }
        byte[] secondaryPointer = this.m_keyBuffer.getSecondaryTreeDBK(position);
        Boolean noteType = this.m_keyBuffer.delete(position, value);
        if (noteType == null) {
            note = null;
        } else if (noteType.booleanValue()) {
            this.m_btreeRemoveSecondaryPointerNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, secondaryPointer);
            note = this.m_btreeRemoveSecondaryPointerNote;
        } else {
            this.m_btreeRemoveValuetNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, value);
            note = this.m_btreeRemoveValuetNote;
        }
        if (note != null) {
            long noteID = this.m_logger.writeNote(note);
            this.m_page.setNoteID(noteID);
        }
        return true;
    }

    void addValue(BTreeKeyBuffer.BufferKey key, byte[] value, boolean doLog) throws IOException {
        int position = this.m_keyBuffer.find(key);
        if (position != -1) {
            this.addValue(key, position, value, doLog);
        } else {
            this.insert(key, value, doLog);
        }
    }

    void addValue(BTreeKeyBuffer.BufferKey key, int position, byte[] value, boolean doLog) throws IOException {
        INote note = this.m_keyBuffer.addValue(this.m_dbk, key, position, value, doLog);
        if (note != null) {
            long noteID = this.m_logger.writeNote(note);
            this.m_page.setNoteID(noteID);
        }
    }

    void setSecondaryTreeDBK(int entryPosition, long treeDBK, boolean doLog) throws IOException {
        if (doLog) {
            this.m_btreeSetSecondaryDbkNote.initNote(this.m_dbk, treeDBK, entryPosition);
            long noteID = this.m_logger.writeNote(this.m_btreeSetSecondaryDbkNote);
            this.m_page.setNoteID(noteID);
        }
        this.m_keyBuffer.setSecondaryTreeDBK(entryPosition, treeDBK);
    }

    boolean canAddValue(int position, byte[] value, ArrayList alreadyExists) throws IOException {
        return this.m_keyBuffer.canAddValue(position, value, alreadyExists);
    }

    boolean containsKey(byte[] key) {
        return this.m_keyBuffer.find(key) != -1;
    }

    boolean containsValue(byte[] key, byte[] value) throws IOException {
        int position = this.m_keyBuffer.find(key);
        if (position == -1) {
            return false;
        }
        return this.m_keyBuffer.containsValue(position, value);
    }

    byte[] getFirstEntryValue(int entryPosition, byte[] valueBuffer) throws IOException {
        return this.m_keyBuffer.getFirstValue(entryPosition, valueBuffer);
    }

    byte[] getLastEntryValue(int entryPosition, byte[] valueBuffer) throws IOException {
        return this.m_keyBuffer.getLastValue(entryPosition, valueBuffer);
    }

    byte[] getNextValue(int entryPosition, byte[] currentVal, byte[] valueBuffer) throws BTreeValueNotFoundException, IOException {
        return this.m_keyBuffer.getNextValue(entryPosition, currentVal, valueBuffer);
    }

    byte[] getPrevValue(int entryPosition, byte[] currentVal, byte[] valueBuffer) throws BTreeValueNotFoundException, IOException {
        return this.m_keyBuffer.getPrevValue(entryPosition, currentVal, valueBuffer);
    }
}

