/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeAbstractNode;
import com.sonicsw.mtstorage.impl.BTreeCreateNodeNote;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeRemoveKeyNote;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;

final class BTreeNode
extends BTreeAbstractNode {
    private static final int KEY_BUFFER_OFFSET = 1;
    private BTreeRemoveKeyNote m_btreeRemoveKeyNote = new BTreeRemoveKeyNote();

    BTreeNode(Logger logger, BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, boolean createNew, boolean uniqueIndex, BTreeSecondary secondary, boolean doLog) throws IOException {
        super(logger, allocatedBuffer, uniqueIndex, allocatedBuffer.m_offset + 1, allocatedBuffer.m_length - 1, true, createNew, secondary);
        if (createNew && doLog) {
            BTreeCreateNodeNote note = new BTreeCreateNodeNote();
            note.initNote(allocatedBuffer.m_dbk, uniqueIndex);
            long noteID = logger.writeNote(note);
            allocatedBuffer.m_page.setNoteID(noteID);
        }
    }

    void remove(BTreeKeyBuffer.BufferKey key, boolean doLog) throws IOException {
        int position = this.m_keyBuffer.find(key);
        if (doLog) {
            this.m_btreeRemoveKeyNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, this.m_keyBuffer.getValue(position, new byte[8]));
            long noteID = this.m_logger.writeNote(this.m_btreeRemoveKeyNote);
            this.m_page.setNoteID(noteID);
        }
        this.m_keyBuffer.delete(false, position);
    }

    long getFirstDbk() {
        return this.getNextLevelDbk(0);
    }

    long getLastDbk() {
        return this.getNextLevelDbk(this.m_keyBuffer.getNumEntries() - 1);
    }

    long getNextLevelDbk(byte[] key) {
        return this.getNextLevelDbk(this.m_keyBuffer.findGreaterEqual(key));
    }

    long getNextLevelDbk(BTreeKeyBuffer.BufferKey key) {
        return this.getNextLevelDbk(this.m_keyBuffer.findGreaterEqual(key));
    }

    int getNextLevelPosition(BTreeKeyBuffer.BufferKey key) {
        return this.m_keyBuffer.findGreaterEqual(key);
    }

    long getNextLevelDbk(int position) {
        return this.m_keyBuffer.getNodeDbk(position);
    }
}

