/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.IObjectInfo;
import com.sonicsw.mtstorage.impl.IAction;
import com.sonicsw.mtstorage.impl.Storage;
import java.io.IOException;

final class BTreePutAction
implements IAction {
    private long m_treeDbkey;
    private byte[] m_key;
    private byte[] m_value;
    private long m_transID;
    private boolean m_hasOldValue;
    private byte[] m_oldValue;
    private boolean m_valueAlreadyExisted;

    BTreePutAction() {
    }

    @Override
    public long getTransactionID() {
        return this.m_transID;
    }

    @Override
    public IObjectInfo getObject(byte[] destination, int offset) {
        throw new Error("No before image object");
    }

    @Override
    public IObjectInfo getObjectInfo() {
        throw new Error("No before image object");
    }

    void init(long transID, long treeDbkey, byte[] key, int keyOffset, int keyLength, byte[] value, int valueOffset, int valueLength, boolean hasOldValue, byte[] oldValue, int oldValueOffset, int oldValueLength, boolean valueAlreadyExisted) {
        this.m_transID = transID;
        this.m_treeDbkey = treeDbkey;
        this.m_hasOldValue = hasOldValue;
        this.m_valueAlreadyExisted = valueAlreadyExisted;
        if (key != null) {
            this.m_key = new byte[keyLength];
            System.arraycopy(key, keyOffset, this.m_key, 0, keyLength);
        } else {
            this.m_key = null;
        }
        if (value != null) {
            this.m_value = new byte[valueLength];
            System.arraycopy(value, valueOffset, this.m_value, 0, valueLength);
        } else {
            this.m_value = null;
        }
        if (oldValue != null && this.m_hasOldValue) {
            this.m_oldValue = new byte[oldValueLength];
            System.arraycopy(oldValue, oldValueOffset, this.m_oldValue, 0, oldValueLength);
        } else {
            this.m_oldValue = null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": tree dbk: " + this.m_treeDbkey + " value already existed " + this.m_valueAlreadyExisted + " key length: " + (this.m_key != null ? this.m_key.length : 0) + " has old value: " + this.m_hasOldValue + " value length: " + (this.m_value != null ? this.m_value.length : 0) + " old value length: " + (this.m_oldValue != null ? this.m_oldValue.length : 0);
    }

    @Override
    public void undoAction(Storage storage) throws IOException {
        if (this.m_valueAlreadyExisted) {
            return;
        }
        if (this.m_hasOldValue) {
            storage.getBTreeManager().put(new Long(this.m_transID), this.m_treeDbkey, this.m_key, this.m_oldValue, null, false);
        } else {
            storage.getBTreeManager().remove(new Long(this.m_transID), this.m_treeDbkey, this.m_key, this.m_value, null, false);
        }
    }
}

