/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeSetSecondaryDbkNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 25;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    long m_secondaryDbk;
    int m_entryPosition;

    BTreeSetSecondaryDbkNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    public long getSecondaryDbk() {
        return this.m_secondaryDbk;
    }

    public int getEntryPosition() {
        return this.m_entryPosition;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)25);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_secondaryDbk);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putInt(this.m_scratchBuffer, 0, this.m_entryPosition);
        writer.write(this.m_scratchBuffer, 0, 4);
        return 21;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_pageNum = BitUtil.getLong(buffer, offset);
        this.m_secondaryDbk = BitUtil.getLong(buffer, offset + 8);
        this.m_entryPosition = BitUtil.getInt(buffer, offset + 16);
    }

    void initNote(long pageNum, long secondaryDbk, int entryPosition) {
        this.m_pageNum = pageNum;
        this.m_secondaryDbk = secondaryDbk;
        this.m_entryPosition = entryPosition;
    }
}

