/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BufferedRandomAccessFile;
import com.sonicsw.mtstorage.impl.LogPage;
import com.sonicsw.mtstorage.impl.VirtualLogFile;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.SyncFailedException;

final class LogFile {
    private static int LOG_FILE_BUFFER_IN_LOG_PAGE_UNITS = 100;
    static long NO_FILE = -1L;
    private BufferedRandomAccessFile m_file;
    private long m_logNum;
    private File m_dbDir;
    private long m_currentPos;
    private boolean m_syncNeeded;
    private boolean m_pagesAreRed;

    LogFile(File dbDir) {
        this.m_dbDir = dbDir;
        this.m_file = null;
        this.m_logNum = NO_FILE;
        this.m_currentPos = 0L;
    }

    void create(long logNum, int fileMaxSize, boolean defaultIsRed) throws IOException {
        this.openInternal(logNum, VirtualLogFile.READ_WRITE_OPEN_MODE, fileMaxSize, true, defaultIsRed);
        this.m_currentPos = 0L;
    }

    void recycle(long newNum, int pagesPerLog) throws IOException {
        long oldNum = this.m_logNum;
        this.markEmptyOrReallocate(pagesPerLog);
        this.close();
        if (oldNum != newNum && !this.logNumToFile(oldNum).renameTo(this.logNumToFile(newNum))) {
            throw new IOException("Could not rename log file " + oldNum + " to log file " + newNum);
        }
    }

    void reallocateAll(int pagesPerLog, boolean isRed) throws IOException {
        LogPage page = new LogPage();
        this.m_pagesAreRed = isRed;
        this.setInitialPosition(0L);
        for (int i = 0; i < pagesPerLog; ++i) {
            this.writeNext(page, true, true);
        }
    }

    private void markEmptyOrReallocate(int pagesPerLog) throws IOException {
        LogPage page = new LogPage();
        this.read(page, 0L);
        boolean firstPageRed = page.pageIsRed();
        boolean needsRepainting = false;
        long lastPage = this.getCurrentPageNum() - 1L;
        if (lastPage + 1L < (long)pagesPerLog) {
            this.reallocateAll(pagesPerLog, firstPageRed);
            return;
        }
        if (lastPage > 0L) {
            this.read(page, lastPage);
            if (firstPageRed != page.pageIsRed()) {
                needsRepainting = true;
            }
        }
        if (needsRepainting) {
            this.reallocateAll(pagesPerLog, firstPageRed);
            return;
        }
        this.setInitialPosition(0L);
        this.m_pagesAreRed = firstPageRed;
        this.writeNext(page, true, true);
    }

    long getLogNum() {
        return this.m_logNum;
    }

    long getCurrentPageNum() {
        return this.m_currentPos / (long)LogPage.PAGE_LENGTH;
    }

    void open(long logNum, String mode, int fileMaxSize) throws IOException {
        this.openInternal(logNum, mode, fileMaxSize, false, false);
        this.m_currentPos = this.m_file.length();
    }

    void setInitialPosition(long pageNum) throws IOException {
        this.m_currentPos = pageNum * (long)LogPage.PAGE_LENGTH;
        this.m_file.seek(this.m_currentPos);
    }

    void writeNext(LogPage page, boolean finalWrite, boolean emptyFileFlag) throws IOException {
        page.setFileEmpty(emptyFileFlag);
        page.setPageColor(this.m_pagesAreRed);
        this.writeUnInterrupted(this.m_currentPos, page.getBuffer());
        if (finalWrite) {
            this.m_currentPos += (long)LogPage.PAGE_LENGTH;
        } else {
            this.m_file.seek(this.m_currentPos);
        }
    }

    private void writeUnInterrupted(long position, byte[] data) throws IOException {
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                this.m_file.write(data);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
                this.m_file.seek(position);
            }
        } while (interrupted);
    }

    private void readUnInterrupted(long position, byte[] buffer) throws IOException {
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                this.m_file.seek(position);
                this.m_file.read(buffer);
            }
            catch (InterruptedIOException e) {
                interrupted = true;
            }
        } while (interrupted);
    }

    void read(LogPage page, long pageNum) throws IOException {
        long position = pageNum * (long)LogPage.PAGE_LENGTH;
        this.readUnInterrupted(position, page.getBuffer());
        this.m_file.seek(this.m_currentPos);
    }

    void close() throws IOException {
        if (this.m_file == null) {
            return;
        }
        this.m_file.close();
        this.m_logNum = NO_FILE;
        this.m_currentPos = 0L;
        this.m_file = null;
    }

    boolean sync() throws IOException, SyncFailedException {
        this.m_file.sync(this.m_syncNeeded);
        return this.m_syncNeeded;
    }

    private File logNumToFile(long num) {
        return LogFile.logNumToFile(this.m_dbDir, num);
    }

    private static File logNumToFile(File dbDir, long num) {
        return new File(dbDir, "LOG" + num);
    }

    private void openInternal(long logNum, String mode, int fileMaxSize, boolean newLog, boolean defaultIsRed) throws IOException {
        File logFile = this.logNumToFile(logNum);
        this.m_logNum = logNum;
        if (!logFile.exists()) {
            mode = "rw";
        }
        boolean preAllocated = false;
        boolean rwdMode = mode.equals("rwd");
        this.m_syncNeeded = !rwdMode;
        this.m_file = new BufferedRandomAccessFile(logFile, mode, LogPage.PAGE_LENGTH * LOG_FILE_BUFFER_IN_LOG_PAGE_UNITS);
        LogPage page = new LogPage();
        long fileLength = this.m_file.length();
        if (fileLength > 0L) {
            this.read(page, 0L);
        }
        if (fileLength == (long)fileMaxSize) {
            preAllocated = true;
            if (!page.fileIsEmpty() && newLog) {
                throw new IOException("Tried to reuse the non empty log file " + logNum);
            }
            this.m_pagesAreRed = newLog ? !page.pageIsRed() : page.pageIsRed();
        } else {
            this.m_pagesAreRed = fileLength > 0L ? page.pageIsRed() : defaultIsRed;
        }
        if (rwdMode && !preAllocated) {
            this.m_file.close();
            this.m_file = new BufferedRandomAccessFile(this.logNumToFile(logNum), "rw", LogPage.PAGE_LENGTH * LOG_FILE_BUFFER_IN_LOG_PAGE_UNITS);
            this.m_syncNeeded = true;
        }
    }
}

