/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Constants;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.LogPage;
import com.sonicsw.mtstorage.impl.NoteFactory;
import com.sonicsw.mtstorage.impl.NoteWriter;
import com.sonicsw.mtstorage.impl.VirtualLogFile;
import java.io.IOException;

final class LogReader {
    private static final boolean ASSERT_MODE = false;
    private VirtualLogFile m_virtualLog;
    private NoteWriter m_noteWriter;
    private long m_nextNote;
    private LogPage m_currentPage;
    private byte[] m_scratchBuffer;
    private int m_offsetInCurrentBuffer;
    private Boolean m_positionedBefore;

    LogReader(NoteWriter noteWriter, long firstNoteID) {
        this.init(noteWriter);
        this.reposition(firstNoteID);
    }

    LogReader(NoteWriter noteWriter) {
        this.init(noteWriter);
    }

    LogReader createClone() {
        LogReader clone = new LogReader(this.m_noteWriter);
        clone.m_nextNote = this.m_nextNote;
        clone.m_currentPage = this.m_currentPage;
        clone.m_offsetInCurrentBuffer = this.m_offsetInCurrentBuffer;
        clone.m_positionedBefore = this.m_positionedBefore;
        return clone;
    }

    void init(NoteWriter noteWriter) {
        this.m_scratchBuffer = new byte[4];
        this.m_noteWriter = noteWriter;
        this.m_virtualLog = this.m_noteWriter.getVirtualLog();
    }

    void reposition(long firstNoteID) {
        this.m_nextNote = firstNoteID;
        this.m_currentPage = null;
        this.m_offsetInCurrentBuffer = 8;
        this.m_positionedBefore = null;
    }

    INote getNext() throws IOException {
        if (this.m_positionedBefore == null) {
            this.positionBefore(this.m_nextNote, true);
        } else if (!this.m_positionedBefore.booleanValue()) {
            this.positionBefore(VirtualLogFile.pageNumAndOffsetToNextNoteID(this.m_currentPage.getPageNum(), this.m_offsetInCurrentBuffer), true);
        }
        return this.readNoteForward();
    }

    INote getPrev() throws IOException {
        if (this.m_positionedBefore == null) {
            this.positionAfter(this.m_nextNote);
        } else if (this.m_positionedBefore.booleanValue()) {
            this.positionAfterPrevNote(VirtualLogFile.pageNumAndOffsetToNoteID(this.m_currentPage.getPageNum(), this.m_offsetInCurrentBuffer));
        }
        return this.readNoteBackward();
    }

    private INote readNoteForward() throws IOException {
        long nextNoteID = VirtualLogFile.pageNumAndOffsetToNoteID(this.m_currentPage.getPageNum(), this.m_offsetInCurrentBuffer);
        if (this.m_offsetInCurrentBuffer == LogPage.PAGE_LENGTH) {
            nextNoteID += 8L;
        }
        this.readForward(this.m_scratchBuffer, 0, 4);
        int noteLength = BitUtil.getInt(this.m_scratchBuffer, 0) - 8;
        byte[] noteBuffer = new byte[noteLength];
        this.readForward(noteBuffer, 0, noteLength);
        this.readForward(this.m_scratchBuffer, 0, 4);
        INote note = NoteFactory.createNote(noteBuffer[0], noteBuffer, 1);
        note.setNoteID(nextNoteID);
        return note;
    }

    private INote readNoteBackward() throws IOException {
        this.readBackward(this.m_scratchBuffer, 0, 4);
        int noteLength = BitUtil.getInt(this.m_scratchBuffer, 0) - 8;
        byte[] noteBuffer = new byte[noteLength];
        this.readBackward(noteBuffer, 0, noteLength);
        this.readBackward(this.m_scratchBuffer, 0, 4);
        return NoteFactory.createNote(noteBuffer[0], noteBuffer, 1);
    }

    private void positionAfterPrevNote(long noteID) throws IOException {
        this.m_positionedBefore = Boolean.FALSE;
        long prevID = VirtualLogFile.prevNoteID(noteID);
        long pageNum = VirtualLogFile.noteIDPageNum(prevID);
        this.m_offsetInCurrentBuffer = VirtualLogFile.noteIDOffestInPage(prevID);
        this.m_currentPage = this.m_virtualLog.getPageContent(pageNum);
    }

    private void positionBefore(long noteID, boolean setDirection) throws IOException {
        if (setDirection) {
            this.m_positionedBefore = Boolean.TRUE;
        }
        this.m_currentPage = this.m_virtualLog.getPageContent(VirtualLogFile.noteIDPageNum(noteID));
        this.m_offsetInCurrentBuffer = VirtualLogFile.noteIDOffestInPage(noteID);
    }

    private void positionAfter(long noteID) throws IOException {
        this.m_positionedBefore = Boolean.FALSE;
        this.positionBefore(noteID, false);
        this.readForward(this.m_scratchBuffer, 0, 4);
        int noteLength = BitUtil.getInt(this.m_scratchBuffer, 0);
        long noteEnd = VirtualLogFile.calcNoteIDOffset(noteID, noteLength - 1);
        this.positionBefore(noteEnd, false);
    }

    private void readForward(byte[] destinyBuffer, int offset, int length) throws IOException {
        int bytesNeeded = length;
        int destinyOffset = offset;
        byte[] currentBuffer = this.m_currentPage.getBuffer();
        while (bytesNeeded > 0) {
            if (this.m_offsetInCurrentBuffer == LogPage.PAGE_LENGTH) {
                this.m_currentPage = this.m_virtualLog.getPageContent(this.m_currentPage.getPageNum() + 1L);
                currentBuffer = this.m_currentPage.getBuffer();
                this.m_offsetInCurrentBuffer = 8;
            }
            int availableBufferBytes = LogPage.PAGE_LENGTH - this.m_offsetInCurrentBuffer;
            int byteCount = Constants.MIN(availableBufferBytes, bytesNeeded);
            System.arraycopy(currentBuffer, this.m_offsetInCurrentBuffer, destinyBuffer, destinyOffset, byteCount);
            this.m_offsetInCurrentBuffer += byteCount;
            bytesNeeded -= byteCount;
            destinyOffset += byteCount;
        }
    }

    private void readBackward(byte[] destinyBuffer, int offset, int length) throws IOException {
        int bytesNeeded = length;
        byte[] currentBuffer = this.m_currentPage.getBuffer();
        while (bytesNeeded > 0) {
            int bytesAvailable = this.m_offsetInCurrentBuffer + 1 - 8;
            int bytesCount = Constants.MIN(bytesNeeded, bytesAvailable);
            System.arraycopy(currentBuffer, this.m_offsetInCurrentBuffer - bytesCount + 1, destinyBuffer, offset + bytesNeeded - bytesCount, bytesCount);
            bytesNeeded -= bytesCount;
            this.m_offsetInCurrentBuffer -= bytesCount;
            if (this.m_offsetInCurrentBuffer - 8 >= 0) continue;
            long nextToRead = this.m_currentPage.getPageNum() - 1L;
            if (nextToRead >= 0L) {
                this.m_currentPage = this.m_virtualLog.getPageContent(this.m_currentPage.getPageNum() - 1L);
                currentBuffer = this.m_currentPage.getBuffer();
                this.m_offsetInCurrentBuffer = LogPage.PAGE_LENGTH - 1;
                continue;
            }
            if (bytesNeeded > 0) {
                throw new Error("Tried to read before the log's beginning.");
            }
            this.m_offsetInCurrentBuffer = 7;
        }
    }
}

