/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.ActionReader;
import com.sonicsw.mtstorage.impl.IAction;
import com.sonicsw.mtstorage.impl.ILogicalNote;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.LogReader;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.RecoveryInterruptException;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.impl.TransactionBeginNote;
import com.sonicsw.mtstorage.impl.TransactionManager;
import java.io.IOException;

final class LogicalRollback {
    private Storage m_storage;
    private Logger m_logger;
    private LogReader m_logReader;
    private TransactionManager m_transManager;
    private ActionReader m_actionReader;
    private long m_rollbackOnlyThis;
    private boolean m_interrupted;

    LogicalRollback(Storage storage, Logger logger, LogReader logReader, TransactionManager tManager) {
        this.init(storage, logger, logReader, tManager);
    }

    LogicalRollback(Storage storage, Logger logger, LogReader logReader, long transNum) {
        this.m_rollbackOnlyThis = transNum;
        this.init(storage, logger, logReader, null);
    }

    void init(Storage storage, Logger logger, LogReader logReader, TransactionManager tManager) {
        this.m_storage = storage;
        this.m_logger = logger;
        this.m_logReader = logReader;
        this.m_transManager = tManager;
        this.m_interrupted = false;
        this.m_actionReader = new ActionReader();
    }

    void interrupt() {
        this.m_interrupted = true;
    }

    void rollback() throws IOException {
        while (true) {
            IAction action;
            if (this.m_interrupted && this.m_transManager != null) {
                throw new RecoveryInterruptException();
            }
            if (this.m_transManager != null && !this.m_transManager.hasActiveUpdateTransaction()) break;
            INote note = this.m_logReader.getPrev();
            if (note instanceof TransactionBeginNote) {
                Long transactionNum = new Long(((TransactionBeginNote)note).getTransactionNum());
                if (this.m_transManager != null && this.m_transManager.activeUpdateTransaction(transactionNum)) {
                    this.m_storage.endTransaction(transactionNum, false);
                    continue;
                }
                if (this.m_transManager != null || transactionNum != this.m_rollbackOnlyThis) continue;
                this.m_storage.endTransaction(transactionNum, false);
                return;
            }
            if (!(note instanceof ILogicalNote)) continue;
            ILogicalNote logicalNote = (ILogicalNote)note;
            Long transactionNum = new Long(logicalNote.getTransactionNum());
            if (logicalNote.noteStart() || (this.m_transManager == null || !this.m_transManager.activeUpdateTransaction(transactionNum)) && (this.m_transManager != null || transactionNum != this.m_rollbackOnlyThis) || (action = this.m_actionReader.getAction(this.m_logReader, logicalNote, false)) == null) continue;
            action.undoAction(this.m_storage);
        }
    }
}

